// Created by cells_xtra.py from Lattice models

(* blackbox *) (* keep *)
module GSR(GSR);
    input GSR;
endmodule

(* blackbox *)
module PUR(PUR);
    parameter RST_PULSE = 1;
    input PUR;
endmodule

(* blackbox *) (* keep *)
module SGSR(GSR, CLK);
    input GSR;
    input CLK;
endmodule

(* blackbox *)
module PDPW16KD(DI35, DI34, DI33, DI32, DI31, DI30, DI29, DI28, DI27, DI26, DI25, DI24, DI23, DI22, DI21, DI20, DI19, DI18, DI17, DI16, DI15
, DI14, DI13, DI12, DI11, DI10, DI9, DI8, DI7, DI6, DI5, DI4, DI3, DI2, DI1, DI0, ADW8, ADW7, ADW6, ADW5, ADW4, ADW3
, ADW2, ADW1, ADW0, BE3, BE2, BE1, BE0, CEW, CLKW, CSW2, CSW1, CSW0, ADR13, ADR12, ADR11, ADR10, ADR9, ADR8, ADR7, ADR6, ADR5
, ADR4, ADR3, ADR2, ADR1, ADR0, CER, OCER, CLKR, CSR2, CSR1, CSR0, RST, DO35, DO34, DO33, DO32, DO31, DO30, DO29, DO28, DO27
, DO26, DO25, DO24, DO23, DO22, DO21, DO20, DO19, DO18, DO17, DO16, DO15, DO14, DO13, DO12, DO11, DO10, DO9, DO8, DO7, DO6
, DO5, DO4, DO3, DO2, DO1, DO0);
    parameter CLKRMUX = "CLKR";
    parameter CLKWMUX = "CLKW";
    parameter DATA_WIDTH_W = 36;
    parameter DATA_WIDTH_R = 36;
    parameter GSR = "ENABLED";
    parameter REGMODE = "NOREG";
    parameter RESETMODE = "SYNC";
    parameter ASYNC_RESET_RELEASE = "SYNC";
    parameter CSDECODE_W = "0b000";
    parameter CSDECODE_R = "0b000";
    parameter INITVAL_00 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_01 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_02 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_03 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_04 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_05 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_06 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_07 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_08 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_09 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_10 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_11 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_12 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_13 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_14 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_15 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_16 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_17 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_18 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_19 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_20 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_21 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_22 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_23 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_24 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_25 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_26 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_27 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_28 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_29 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_2A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_2B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_2C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_2D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_2E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_2F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_30 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_31 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_32 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_33 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_34 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_35 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_36 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_37 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_38 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_39 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_3A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_3B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_3C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_3D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_3E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_3F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_DATA = "STATIC";
    input DI35;
    input DI34;
    input DI33;
    input DI32;
    input DI31;
    input DI30;
    input DI29;
    input DI28;
    input DI27;
    input DI26;
    input DI25;
    input DI24;
    input DI23;
    input DI22;
    input DI21;
    input DI20;
    input DI19;
    input DI18;
    input DI17;
    input DI16;
    input DI15;
    input DI14;
    input DI13;
    input DI12;
    input DI11;
    input DI10;
    input DI9;
    input DI8;
    input DI7;
    input DI6;
    input DI5;
    input DI4;
    input DI3;
    input DI2;
    input DI1;
    input DI0;
    input ADW8;
    input ADW7;
    input ADW6;
    input ADW5;
    input ADW4;
    input ADW3;
    input ADW2;
    input ADW1;
    input ADW0;
    input BE3;
    input BE2;
    input BE1;
    input BE0;
    input CEW;
    input CLKW;
    input CSW2;
    input CSW1;
    input CSW0;
    input ADR13;
    input ADR12;
    input ADR11;
    input ADR10;
    input ADR9;
    input ADR8;
    input ADR7;
    input ADR6;
    input ADR5;
    input ADR4;
    input ADR3;
    input ADR2;
    input ADR1;
    input ADR0;
    input CER;
    input OCER;
    input CLKR;
    input CSR2;
    input CSR1;
    input CSR0;
    input RST;
    output DO35;
    output DO34;
    output DO33;
    output DO32;
    output DO31;
    output DO30;
    output DO29;
    output DO28;
    output DO27;
    output DO26;
    output DO25;
    output DO24;
    output DO23;
    output DO22;
    output DO21;
    output DO20;
    output DO19;
    output DO18;
    output DO17;
    output DO16;
    output DO15;
    output DO14;
    output DO13;
    output DO12;
    output DO11;
    output DO10;
    output DO9;
    output DO8;
    output DO7;
    output DO6;
    output DO5;
    output DO4;
    output DO3;
    output DO2;
    output DO1;
    output DO0;
endmodule

(* blackbox *)
module MULT18X18D(A17, A16, A15, A14, A13, A12, A11, A10, A9, A8, A7, A6, A5, A4, A3, A2, A1, A0, B17, B16, B15
, B14, B13, B12, B11, B10, B9, B8, B7, B6, B5, B4, B3, B2, B1, B0, C17, C16, C15, C14, C13, C12
, C11, C10, C9, C8, C7, C6, C5, C4, C3, C2, C1, C0, SIGNEDA, SIGNEDB, SOURCEA, SOURCEB, CLK3, CLK2, CLK1, CLK0, CE3
, CE2, CE1, CE0, RST3, RST2, RST1, RST0, SRIA17, SRIA16, SRIA15, SRIA14, SRIA13, SRIA12, SRIA11, SRIA10, SRIA9, SRIA8, SRIA7, SRIA6, SRIA5, SRIA4
, SRIA3, SRIA2, SRIA1, SRIA0, SRIB17, SRIB16, SRIB15, SRIB14, SRIB13, SRIB12, SRIB11, SRIB10, SRIB9, SRIB8, SRIB7, SRIB6, SRIB5, SRIB4, SRIB3, SRIB2, SRIB1
, SRIB0, SROA17, SROA16, SROA15, SROA14, SROA13, SROA12, SROA11, SROA10, SROA9, SROA8, SROA7, SROA6, SROA5, SROA4, SROA3, SROA2, SROA1, SROA0, SROB17, SROB16
, SROB15, SROB14, SROB13, SROB12, SROB11, SROB10, SROB9, SROB8, SROB7, SROB6, SROB5, SROB4, SROB3, SROB2, SROB1, SROB0, ROA17, ROA16, ROA15, ROA14, ROA13
, ROA12, ROA11, ROA10, ROA9, ROA8, ROA7, ROA6, ROA5, ROA4, ROA3, ROA2, ROA1, ROA0, ROB17, ROB16, ROB15, ROB14, ROB13, ROB12, ROB11, ROB10
, ROB9, ROB8, ROB7, ROB6, ROB5, ROB4, ROB3, ROB2, ROB1, ROB0, ROC17, ROC16, ROC15, ROC14, ROC13, ROC12, ROC11, ROC10, ROC9, ROC8, ROC7
, ROC6, ROC5, ROC4, ROC3, ROC2, ROC1, ROC0, P35, P34, P33, P32, P31, P30, P29, P28, P27, P26, P25, P24, P23, P22
, P21, P20, P19, P18, P17, P16, P15, P14, P13, P12, P11, P10, P9, P8, P7, P6, P5, P4, P3, P2, P1
, P0, SIGNEDP);
    parameter REG_INPUTA_CLK = "NONE";
    parameter REG_INPUTA_CE = "CE0";
    parameter REG_INPUTA_RST = "RST0";
    parameter REG_INPUTB_CLK = "NONE";
    parameter REG_INPUTB_CE = "CE0";
    parameter REG_INPUTB_RST = "RST0";
    parameter REG_INPUTC_CLK = "NONE";
    parameter REG_INPUTC_CE = "CE0";
    parameter REG_INPUTC_RST = "RST0";
    parameter REG_PIPELINE_CLK = "NONE";
    parameter REG_PIPELINE_CE = "CE0";
    parameter REG_PIPELINE_RST = "RST0";
    parameter REG_OUTPUT_CLK = "NONE";
    parameter REG_OUTPUT_CE = "CE0";
    parameter REG_OUTPUT_RST = "RST0";
    parameter CLK0_DIV = "ENABLED";
    parameter CLK1_DIV = "ENABLED";
    parameter CLK2_DIV = "ENABLED";
    parameter CLK3_DIV = "ENABLED";
    parameter HIGHSPEED_CLK = "NONE";
    parameter GSR = "ENABLED";
    parameter CAS_MATCH_REG = "FALSE";
    parameter SOURCEB_MODE = "B_SHIFT";
    parameter MULT_BYPASS = "DISABLED";
    parameter RESETMODE = "SYNC";
    input A17;
    input A16;
    input A15;
    input A14;
    input A13;
    input A12;
    input A11;
    input A10;
    input A9;
    input A8;
    input A7;
    input A6;
    input A5;
    input A4;
    input A3;
    input A2;
    input A1;
    input A0;
    input B17;
    input B16;
    input B15;
    input B14;
    input B13;
    input B12;
    input B11;
    input B10;
    input B9;
    input B8;
    input B7;
    input B6;
    input B5;
    input B4;
    input B3;
    input B2;
    input B1;
    input B0;
    input C17;
    input C16;
    input C15;
    input C14;
    input C13;
    input C12;
    input C11;
    input C10;
    input C9;
    input C8;
    input C7;
    input C6;
    input C5;
    input C4;
    input C3;
    input C2;
    input C1;
    input C0;
    input SIGNEDA;
    input SIGNEDB;
    input SOURCEA;
    input SOURCEB;
    input CLK3;
    input CLK2;
    input CLK1;
    input CLK0;
    input CE3;
    input CE2;
    input CE1;
    input CE0;
    input RST3;
    input RST2;
    input RST1;
    input RST0;
    input SRIA17;
    input SRIA16;
    input SRIA15;
    input SRIA14;
    input SRIA13;
    input SRIA12;
    input SRIA11;
    input SRIA10;
    input SRIA9;
    input SRIA8;
    input SRIA7;
    input SRIA6;
    input SRIA5;
    input SRIA4;
    input SRIA3;
    input SRIA2;
    input SRIA1;
    input SRIA0;
    input SRIB17;
    input SRIB16;
    input SRIB15;
    input SRIB14;
    input SRIB13;
    input SRIB12;
    input SRIB11;
    input SRIB10;
    input SRIB9;
    input SRIB8;
    input SRIB7;
    input SRIB6;
    input SRIB5;
    input SRIB4;
    input SRIB3;
    input SRIB2;
    input SRIB1;
    input SRIB0;
    output SROA17;
    output SROA16;
    output SROA15;
    output SROA14;
    output SROA13;
    output SROA12;
    output SROA11;
    output SROA10;
    output SROA9;
    output SROA8;
    output SROA7;
    output SROA6;
    output SROA5;
    output SROA4;
    output SROA3;
    output SROA2;
    output SROA1;
    output SROA0;
    output SROB17;
    output SROB16;
    output SROB15;
    output SROB14;
    output SROB13;
    output SROB12;
    output SROB11;
    output SROB10;
    output SROB9;
    output SROB8;
    output SROB7;
    output SROB6;
    output SROB5;
    output SROB4;
    output SROB3;
    output SROB2;
    output SROB1;
    output SROB0;
    output ROA17;
    output ROA16;
    output ROA15;
    output ROA14;
    output ROA13;
    output ROA12;
    output ROA11;
    output ROA10;
    output ROA9;
    output ROA8;
    output ROA7;
    output ROA6;
    output ROA5;
    output ROA4;
    output ROA3;
    output ROA2;
    output ROA1;
    output ROA0;
    output ROB17;
    output ROB16;
    output ROB15;
    output ROB14;
    output ROB13;
    output ROB12;
    output ROB11;
    output ROB10;
    output ROB9;
    output ROB8;
    output ROB7;
    output ROB6;
    output ROB5;
    output ROB4;
    output ROB3;
    output ROB2;
    output ROB1;
    output ROB0;
    output ROC17;
    output ROC16;
    output ROC15;
    output ROC14;
    output ROC13;
    output ROC12;
    output ROC11;
    output ROC10;
    output ROC9;
    output ROC8;
    output ROC7;
    output ROC6;
    output ROC5;
    output ROC4;
    output ROC3;
    output ROC2;
    output ROC1;
    output ROC0;
    output P35;
    output P34;
    output P33;
    output P32;
    output P31;
    output P30;
    output P29;
    output P28;
    output P27;
    output P26;
    output P25;
    output P24;
    output P23;
    output P22;
    output P21;
    output P20;
    output P19;
    output P18;
    output P17;
    output P16;
    output P15;
    output P14;
    output P13;
    output P12;
    output P11;
    output P10;
    output P9;
    output P8;
    output P7;
    output P6;
    output P5;
    output P4;
    output P3;
    output P2;
    output P1;
    output P0;
    output SIGNEDP;
endmodule

(* blackbox *)
module ALU54B(CE3, CE2, CE1, CE0, CLK3, CLK2, CLK1, CLK0, RST3, RST2, RST1, RST0, SIGNEDIA, SIGNEDIB, SIGNEDCIN, A35, A34, A33, A32, A31, A30
, A29, A28, A27, A26, A25, A24, A23, A22, A21, A20, A19, A18, A17, A16, A15, A14, A13, A12, A11, A10, A9
, A8, A7, A6, A5, A4, A3, A2, A1, A0, B35, B34, B33, B32, B31, B30, B29, B28, B27, B26, B25, B24
, B23, B22, B21, B20, B19, B18, B17, B16, B15, B14, B13, B12, B11, B10, B9, B8, B7, B6, B5, B4, B3
, B2, B1, B0, C53, C52, C51, C50, C49, C48, C47, C46, C45, C44, C43, C42, C41, C40, C39, C38, C37, C36
, C35, C34, C33, C32, C31, C30, C29, C28, C27, C26, C25, C24, C23, C22, C21, C20, C19, C18, C17, C16, C15
, C14, C13, C12, C11, C10, C9, C8, C7, C6, C5, C4, C3, C2, C1, C0, CFB53, CFB52, CFB51, CFB50, CFB49, CFB48
, CFB47, CFB46, CFB45, CFB44, CFB43, CFB42, CFB41, CFB40, CFB39, CFB38, CFB37, CFB36, CFB35, CFB34, CFB33, CFB32, CFB31, CFB30, CFB29, CFB28, CFB27
, CFB26, CFB25, CFB24, CFB23, CFB22, CFB21, CFB20, CFB19, CFB18, CFB17, CFB16, CFB15, CFB14, CFB13, CFB12, CFB11, CFB10, CFB9, CFB8, CFB7, CFB6
, CFB5, CFB4, CFB3, CFB2, CFB1, CFB0, MA35, MA34, MA33, MA32, MA31, MA30, MA29, MA28, MA27, MA26, MA25, MA24, MA23, MA22, MA21
, MA20, MA19, MA18, MA17, MA16, MA15, MA14, MA13, MA12, MA11, MA10, MA9, MA8, MA7, MA6, MA5, MA4, MA3, MA2, MA1, MA0
, MB35, MB34, MB33, MB32, MB31, MB30, MB29, MB28, MB27, MB26, MB25, MB24, MB23, MB22, MB21, MB20, MB19, MB18, MB17, MB16, MB15
, MB14, MB13, MB12, MB11, MB10, MB9, MB8, MB7, MB6, MB5, MB4, MB3, MB2, MB1, MB0, CIN53, CIN52, CIN51, CIN50, CIN49, CIN48
, CIN47, CIN46, CIN45, CIN44, CIN43, CIN42, CIN41, CIN40, CIN39, CIN38, CIN37, CIN36, CIN35, CIN34, CIN33, CIN32, CIN31, CIN30, CIN29, CIN28, CIN27
, CIN26, CIN25, CIN24, CIN23, CIN22, CIN21, CIN20, CIN19, CIN18, CIN17, CIN16, CIN15, CIN14, CIN13, CIN12, CIN11, CIN10, CIN9, CIN8, CIN7, CIN6
, CIN5, CIN4, CIN3, CIN2, CIN1, CIN0, OP10, OP9, OP8, OP7, OP6, OP5, OP4, OP3, OP2, OP1, OP0, R53, R52, R51, R50
, R49, R48, R47, R46, R45, R44, R43, R42, R41, R40, R39, R38, R37, R36, R35, R34, R33, R32, R31, R30, R29
, R28, R27, R26, R25, R24, R23, R22, R21, R20, R19, R18, R17, R16, R15, R14, R13, R12, R11, R10, R9, R8
, R7, R6, R5, R4, R3, R2, R1, R0, CO53, CO52, CO51, CO50, CO49, CO48, CO47, CO46, CO45, CO44, CO43, CO42, CO41
, CO40, CO39, CO38, CO37, CO36, CO35, CO34, CO33, CO32, CO31, CO30, CO29, CO28, CO27, CO26, CO25, CO24, CO23, CO22, CO21, CO20
, CO19, CO18, CO17, CO16, CO15, CO14, CO13, CO12, CO11, CO10, CO9, CO8, CO7, CO6, CO5, CO4, CO3, CO2, CO1, CO0, EQZ
, EQZM, EQOM, EQPAT, EQPATB, OVER, UNDER, OVERUNDER, SIGNEDR);
    parameter REG_INPUTC0_CLK = "NONE";
    parameter REG_INPUTC0_CE = "CE0";
    parameter REG_INPUTC0_RST = "RST0";
    parameter REG_INPUTC1_CLK = "NONE";
    parameter REG_INPUTC1_CE = "CE0";
    parameter REG_INPUTC1_RST = "RST0";
    parameter REG_OPCODEOP0_0_CLK = "NONE";
    parameter REG_OPCODEOP0_0_CE = "CE0";
    parameter REG_OPCODEOP0_0_RST = "RST0";
    parameter REG_OPCODEOP1_0_CLK = "NONE";
    parameter REG_OPCODEOP0_1_CLK = "NONE";
    parameter REG_OPCODEOP0_1_CE = "CE0";
    parameter REG_OPCODEOP0_1_RST = "RST0";
    parameter REG_OPCODEOP1_1_CLK = "NONE";
    parameter REG_OPCODEIN_0_CLK = "NONE";
    parameter REG_OPCODEIN_0_CE = "CE0";
    parameter REG_OPCODEIN_0_RST = "RST0";
    parameter REG_OPCODEIN_1_CLK = "NONE";
    parameter REG_OPCODEIN_1_CE = "CE0";
    parameter REG_OPCODEIN_1_RST = "RST0";
    parameter REG_OUTPUT0_CLK = "NONE";
    parameter REG_OUTPUT0_CE = "CE0";
    parameter REG_OUTPUT0_RST = "RST0";
    parameter REG_OUTPUT1_CLK = "NONE";
    parameter REG_OUTPUT1_CE = "CE0";
    parameter REG_OUTPUT1_RST = "RST0";
    parameter REG_FLAG_CLK = "NONE";
    parameter REG_FLAG_CE = "CE0";
    parameter REG_FLAG_RST = "RST0";
    parameter MCPAT_SOURCE = "STATIC";
    parameter MASKPAT_SOURCE = "STATIC";
    parameter MASK01 = "0x00000000000000";
    parameter REG_INPUTCFB_CLK = "NONE";
    parameter REG_INPUTCFB_CE = "CE0";
    parameter REG_INPUTCFB_RST = "RST0";
    parameter CLK0_DIV = "ENABLED";
    parameter CLK1_DIV = "ENABLED";
    parameter CLK2_DIV = "ENABLED";
    parameter CLK3_DIV = "ENABLED";
    parameter MCPAT = "0x00000000000000";
    parameter MASKPAT = "0x00000000000000";
    parameter RNDPAT = "0x00000000000000";
    parameter GSR = "ENABLED";
    parameter RESETMODE = "SYNC";
    parameter MULT9_MODE = "DISABLED";
    parameter FORCE_ZERO_BARREL_SHIFT = "DISABLED";
    parameter LEGACY = "DISABLED";
    input CE3;
    input CE2;
    input CE1;
    input CE0;
    input CLK3;
    input CLK2;
    input CLK1;
    input CLK0;
    input RST3;
    input RST2;
    input RST1;
    input RST0;
    input SIGNEDIA;
    input SIGNEDIB;
    input SIGNEDCIN;
    input A35;
    input A34;
    input A33;
    input A32;
    input A31;
    input A30;
    input A29;
    input A28;
    input A27;
    input A26;
    input A25;
    input A24;
    input A23;
    input A22;
    input A21;
    input A20;
    input A19;
    input A18;
    input A17;
    input A16;
    input A15;
    input A14;
    input A13;
    input A12;
    input A11;
    input A10;
    input A9;
    input A8;
    input A7;
    input A6;
    input A5;
    input A4;
    input A3;
    input A2;
    input A1;
    input A0;
    input B35;
    input B34;
    input B33;
    input B32;
    input B31;
    input B30;
    input B29;
    input B28;
    input B27;
    input B26;
    input B25;
    input B24;
    input B23;
    input B22;
    input B21;
    input B20;
    input B19;
    input B18;
    input B17;
    input B16;
    input B15;
    input B14;
    input B13;
    input B12;
    input B11;
    input B10;
    input B9;
    input B8;
    input B7;
    input B6;
    input B5;
    input B4;
    input B3;
    input B2;
    input B1;
    input B0;
    input C53;
    input C52;
    input C51;
    input C50;
    input C49;
    input C48;
    input C47;
    input C46;
    input C45;
    input C44;
    input C43;
    input C42;
    input C41;
    input C40;
    input C39;
    input C38;
    input C37;
    input C36;
    input C35;
    input C34;
    input C33;
    input C32;
    input C31;
    input C30;
    input C29;
    input C28;
    input C27;
    input C26;
    input C25;
    input C24;
    input C23;
    input C22;
    input C21;
    input C20;
    input C19;
    input C18;
    input C17;
    input C16;
    input C15;
    input C14;
    input C13;
    input C12;
    input C11;
    input C10;
    input C9;
    input C8;
    input C7;
    input C6;
    input C5;
    input C4;
    input C3;
    input C2;
    input C1;
    input C0;
    input CFB53;
    input CFB52;
    input CFB51;
    input CFB50;
    input CFB49;
    input CFB48;
    input CFB47;
    input CFB46;
    input CFB45;
    input CFB44;
    input CFB43;
    input CFB42;
    input CFB41;
    input CFB40;
    input CFB39;
    input CFB38;
    input CFB37;
    input CFB36;
    input CFB35;
    input CFB34;
    input CFB33;
    input CFB32;
    input CFB31;
    input CFB30;
    input CFB29;
    input CFB28;
    input CFB27;
    input CFB26;
    input CFB25;
    input CFB24;
    input CFB23;
    input CFB22;
    input CFB21;
    input CFB20;
    input CFB19;
    input CFB18;
    input CFB17;
    input CFB16;
    input CFB15;
    input CFB14;
    input CFB13;
    input CFB12;
    input CFB11;
    input CFB10;
    input CFB9;
    input CFB8;
    input CFB7;
    input CFB6;
    input CFB5;
    input CFB4;
    input CFB3;
    input CFB2;
    input CFB1;
    input CFB0;
    input MA35;
    input MA34;
    input MA33;
    input MA32;
    input MA31;
    input MA30;
    input MA29;
    input MA28;
    input MA27;
    input MA26;
    input MA25;
    input MA24;
    input MA23;
    input MA22;
    input MA21;
    input MA20;
    input MA19;
    input MA18;
    input MA17;
    input MA16;
    input MA15;
    input MA14;
    input MA13;
    input MA12;
    input MA11;
    input MA10;
    input MA9;
    input MA8;
    input MA7;
    input MA6;
    input MA5;
    input MA4;
    input MA3;
    input MA2;
    input MA1;
    input MA0;
    input MB35;
    input MB34;
    input MB33;
    input MB32;
    input MB31;
    input MB30;
    input MB29;
    input MB28;
    input MB27;
    input MB26;
    input MB25;
    input MB24;
    input MB23;
    input MB22;
    input MB21;
    input MB20;
    input MB19;
    input MB18;
    input MB17;
    input MB16;
    input MB15;
    input MB14;
    input MB13;
    input MB12;
    input MB11;
    input MB10;
    input MB9;
    input MB8;
    input MB7;
    input MB6;
    input MB5;
    input MB4;
    input MB3;
    input MB2;
    input MB1;
    input MB0;
    input CIN53;
    input CIN52;
    input CIN51;
    input CIN50;
    input CIN49;
    input CIN48;
    input CIN47;
    input CIN46;
    input CIN45;
    input CIN44;
    input CIN43;
    input CIN42;
    input CIN41;
    input CIN40;
    input CIN39;
    input CIN38;
    input CIN37;
    input CIN36;
    input CIN35;
    input CIN34;
    input CIN33;
    input CIN32;
    input CIN31;
    input CIN30;
    input CIN29;
    input CIN28;
    input CIN27;
    input CIN26;
    input CIN25;
    input CIN24;
    input CIN23;
    input CIN22;
    input CIN21;
    input CIN20;
    input CIN19;
    input CIN18;
    input CIN17;
    input CIN16;
    input CIN15;
    input CIN14;
    input CIN13;
    input CIN12;
    input CIN11;
    input CIN10;
    input CIN9;
    input CIN8;
    input CIN7;
    input CIN6;
    input CIN5;
    input CIN4;
    input CIN3;
    input CIN2;
    input CIN1;
    input CIN0;
    input OP10;
    input OP9;
    input OP8;
    input OP7;
    input OP6;
    input OP5;
    input OP4;
    input OP3;
    input OP2;
    input OP1;
    input OP0;
    output R53;
    output R52;
    output R51;
    output R50;
    output R49;
    output R48;
    output R47;
    output R46;
    output R45;
    output R44;
    output R43;
    output R42;
    output R41;
    output R40;
    output R39;
    output R38;
    output R37;
    output R36;
    output R35;
    output R34;
    output R33;
    output R32;
    output R31;
    output R30;
    output R29;
    output R28;
    output R27;
    output R26;
    output R25;
    output R24;
    output R23;
    output R22;
    output R21;
    output R20;
    output R19;
    output R18;
    output R17;
    output R16;
    output R15;
    output R14;
    output R13;
    output R12;
    output R11;
    output R10;
    output R9;
    output R8;
    output R7;
    output R6;
    output R5;
    output R4;
    output R3;
    output R2;
    output R1;
    output R0;
    output CO53;
    output CO52;
    output CO51;
    output CO50;
    output CO49;
    output CO48;
    output CO47;
    output CO46;
    output CO45;
    output CO44;
    output CO43;
    output CO42;
    output CO41;
    output CO40;
    output CO39;
    output CO38;
    output CO37;
    output CO36;
    output CO35;
    output CO34;
    output CO33;
    output CO32;
    output CO31;
    output CO30;
    output CO29;
    output CO28;
    output CO27;
    output CO26;
    output CO25;
    output CO24;
    output CO23;
    output CO22;
    output CO21;
    output CO20;
    output CO19;
    output CO18;
    output CO17;
    output CO16;
    output CO15;
    output CO14;
    output CO13;
    output CO12;
    output CO11;
    output CO10;
    output CO9;
    output CO8;
    output CO7;
    output CO6;
    output CO5;
    output CO4;
    output CO3;
    output CO2;
    output CO1;
    output CO0;
    output EQZ;
    output EQZM;
    output EQOM;
    output EQPAT;
    output EQPATB;
    output OVER;
    output UNDER;
    output OVERUNDER;
    output SIGNEDR;
endmodule

(* blackbox *)
module CLKDIVF(CLKI, RST, ALIGNWD, CDIVX);
    parameter GSR = "DISABLED";
    parameter DIV = "2.0";
    input CLKI;
    input RST;
    input ALIGNWD;
    output CDIVX;
endmodule

(* blackbox *)
module PCSCLKDIV(CLKI, RST, SEL2, SEL1, SEL0, CDIV1, CDIVX);
    parameter GSR = "DISABLED";
    input CLKI;
    input RST;
    input SEL2;
    input SEL1;
    input SEL0;
    output CDIV1;
    output CDIVX;
endmodule

(* blackbox *)
module DCSC(CLK1, CLK0, SEL1, SEL0, MODESEL, DCSOUT);
    parameter DCSMODE = "POS";
    input CLK1;
    input CLK0;
    input SEL1;
    input SEL0;
    input MODESEL;
    output DCSOUT;
endmodule

(* blackbox *)
module DCCA(CLKI, CE, CLKO);
    input CLKI;
    input CE;
    output CLKO;
endmodule

(* blackbox *)
module ECLKSYNCB(ECLKI, STOP, ECLKO);
    input ECLKI;
    input STOP;
    output ECLKO;
endmodule

(* blackbox *)
module ECLKBRIDGECS(CLK0, CLK1, SEL, ECSOUT);
    input CLK0;
    input CLK1;
    input SEL;
    output ECSOUT;
endmodule

(* blackbox *)
module DELAYF(A, LOADN, MOVE, DIRECTION, Z, CFLAG);
    parameter DEL_MODE = "USER_DEFINED";
    parameter DEL_VALUE = 0;
    input A;
    input LOADN;
    input MOVE;
    input DIRECTION;
    output Z;
    output CFLAG;
endmodule

(* blackbox *)
module DELAYG(A, Z);
    parameter DEL_MODE = "USER_DEFINED";
    parameter DEL_VALUE = 0;
    input A;
    output Z;
endmodule

(* blackbox *) (* keep *)
module USRMCLK(USRMCLKI, USRMCLKTS);
    input USRMCLKI;
    input USRMCLKTS;
endmodule

(* blackbox *)
module DQSBUFM(DQSI, READ1, READ0, READCLKSEL2, READCLKSEL1, READCLKSEL0, DDRDEL, ECLK, SCLK, RST, DYNDELAY7, DYNDELAY6, DYNDELAY5, DYNDELAY4, DYNDELAY3, DYNDELAY2, DYNDELAY1, DYNDELAY0, PAUSE, RDLOADN, RDMOVE
, RDDIRECTION, WRLOADN, WRMOVE, WRDIRECTION, DQSR90, DQSW, DQSW270, RDPNTR2, RDPNTR1, RDPNTR0, WRPNTR2, WRPNTR1, WRPNTR0, DATAVALID, BURSTDET, RDCFLAG, WRCFLAG);
    parameter DQS_LI_DEL_VAL = 4;
    parameter DQS_LI_DEL_ADJ = "FACTORYONLY";
    parameter DQS_LO_DEL_VAL = 0;
    parameter DQS_LO_DEL_ADJ = "FACTORYONLY";
    parameter GSR = "ENABLED";
    input DQSI;
    input READ1;
    input READ0;
    input READCLKSEL2;
    input READCLKSEL1;
    input READCLKSEL0;
    input DDRDEL;
    input ECLK;
    input SCLK;
    input RST;
    input DYNDELAY7;
    input DYNDELAY6;
    input DYNDELAY5;
    input DYNDELAY4;
    input DYNDELAY3;
    input DYNDELAY2;
    input DYNDELAY1;
    input DYNDELAY0;
    input PAUSE;
    input RDLOADN;
    input RDMOVE;
    input RDDIRECTION;
    input WRLOADN;
    input WRMOVE;
    input WRDIRECTION;
    output DQSR90;
    output DQSW;
    output DQSW270;
    output RDPNTR2;
    output RDPNTR1;
    output RDPNTR0;
    output WRPNTR2;
    output WRPNTR1;
    output WRPNTR0;
    output DATAVALID;
    output BURSTDET;
    output RDCFLAG;
    output WRCFLAG;
endmodule

(* blackbox *)
module DDRDLLA(CLK, RST, UDDCNTLN, FREEZE, DDRDEL, LOCK, DCNTL7, DCNTL6, DCNTL5, DCNTL4, DCNTL3, DCNTL2, DCNTL1, DCNTL0);
    parameter FORCE_MAX_DELAY = "NO";
    parameter GSR = "ENABLED";
    input CLK;
    input RST;
    input UDDCNTLN;
    input FREEZE;
    output DDRDEL;
    output LOCK;
    output DCNTL7;
    output DCNTL6;
    output DCNTL5;
    output DCNTL4;
    output DCNTL3;
    output DCNTL2;
    output DCNTL1;
    output DCNTL0;
endmodule

(* blackbox *)
module DLLDELD(A, DDRDEL, LOADN, MOVE, DIRECTION, Z, CFLAG);
    input A;
    input DDRDEL;
    input LOADN;
    input MOVE;
    input DIRECTION;
    output Z;
    output CFLAG;
endmodule

(* blackbox *)
module IDDRX1F(D, SCLK, RST, Q0, Q1);
    parameter GSR = "ENABLED";
    input D;
    input SCLK;
    input RST;
    output Q0;
    output Q1;
endmodule

(* blackbox *)
module IDDRX2F(D, SCLK, ECLK, RST, ALIGNWD, Q3, Q2, Q1, Q0);
    parameter GSR = "ENABLED";
    input D;
    input SCLK;
    input ECLK;
    input RST;
    input ALIGNWD;
    output Q3;
    output Q2;
    output Q1;
    output Q0;
endmodule

(* blackbox *)
module IDDR71B(D, SCLK, ECLK, RST, ALIGNWD, Q6, Q5, Q4, Q3, Q2, Q1, Q0);
    parameter GSR = "ENABLED";
    input D;
    input SCLK;
    input ECLK;
    input RST;
    input ALIGNWD;
    output Q6;
    output Q5;
    output Q4;
    output Q3;
    output Q2;
    output Q1;
    output Q0;
endmodule

(* blackbox *)
module IDDRX2DQA(SCLK, ECLK, DQSR90, D, RST, RDPNTR2, RDPNTR1, RDPNTR0, WRPNTR2, WRPNTR1, WRPNTR0, Q3, Q2, Q1, Q0, QWL);
    parameter GSR = "ENABLED";
    input SCLK;
    input ECLK;
    input DQSR90;
    input D;
    input RST;
    input RDPNTR2;
    input RDPNTR1;
    input RDPNTR0;
    input WRPNTR2;
    input WRPNTR1;
    input WRPNTR0;
    output Q3;
    output Q2;
    output Q1;
    output Q0;
    output QWL;
endmodule

(* blackbox *)
module ODDRX1F(SCLK, RST, D0, D1, Q);
    parameter GSR = "ENABLED";
    input SCLK;
    input RST;
    input D0;
    input D1;
    output Q;
endmodule

(* blackbox *)
module ODDRX2F(SCLK, ECLK, RST, D3, D2, D1, D0, Q);
    parameter GSR = "ENABLED";
    input SCLK;
    input ECLK;
    input RST;
    input D3;
    input D2;
    input D1;
    input D0;
    output Q;
endmodule

(* blackbox *)
module ODDR71B(SCLK, ECLK, RST, D6, D5, D4, D3, D2, D1, D0, Q);
    parameter GSR = "ENABLED";
    input SCLK;
    input ECLK;
    input RST;
    input D6;
    input D5;
    input D4;
    input D3;
    input D2;
    input D1;
    input D0;
    output Q;
endmodule

(* blackbox *)
module OSHX2A(D1, D0, SCLK, ECLK, RST, Q);
    parameter GSR = "ENABLED";
    input D1;
    input D0;
    input SCLK;
    input ECLK;
    input RST;
    output Q;
endmodule

(* blackbox *)
module TSHX2DQA(T1, T0, SCLK, ECLK, DQSW270, RST, Q);
    parameter GSR = "ENABLED";
    parameter REGSET = "SET";
    input T1;
    input T0;
    input SCLK;
    input ECLK;
    input DQSW270;
    input RST;
    output Q;
endmodule

(* blackbox *)
module TSHX2DQSA(T1, T0, SCLK, ECLK, DQSW, RST, Q);
    parameter GSR = "ENABLED";
    parameter REGSET = "SET";
    input T1;
    input T0;
    input SCLK;
    input ECLK;
    input DQSW;
    input RST;
    output Q;
endmodule

(* blackbox *)
module ODDRX2DQA(D3, D2, D1, D0, DQSW270, SCLK, ECLK, RST, Q);
    parameter GSR = "ENABLED";
    input D3;
    input D2;
    input D1;
    input D0;
    input DQSW270;
    input SCLK;
    input ECLK;
    input RST;
    output Q;
endmodule

(* blackbox *)
module ODDRX2DQSB(D3, D2, D1, D0, SCLK, ECLK, DQSW, RST, Q);
    parameter GSR = "ENABLED";
    input D3;
    input D2;
    input D1;
    input D0;
    input SCLK;
    input ECLK;
    input DQSW;
    input RST;
    output Q;
endmodule

(* blackbox *)
module EHXPLLL(CLKI, CLKFB, PHASESEL1, PHASESEL0, PHASEDIR, PHASESTEP, PHASELOADREG, STDBY, PLLWAKESYNC, RST, ENCLKOP, ENCLKOS, ENCLKOS2, ENCLKOS3, CLKOP, CLKOS, CLKOS2, CLKOS3, LOCK, INTLOCK, REFCLK
, CLKINTFB);
    parameter CLKI_DIV = 1;
    parameter CLKFB_DIV = 1;
    parameter CLKOP_DIV = 8;
    parameter CLKOS_DIV = 8;
    parameter CLKOS2_DIV = 8;
    parameter CLKOS3_DIV = 8;
    parameter CLKOP_ENABLE = "ENABLED";
    parameter CLKOS_ENABLE = "DISABLED";
    parameter CLKOS2_ENABLE = "DISABLED";
    parameter CLKOS3_ENABLE = "DISABLED";
    parameter CLKOP_CPHASE = 0;
    parameter CLKOS_CPHASE = 0;
    parameter CLKOS2_CPHASE = 0;
    parameter CLKOS3_CPHASE = 0;
    parameter CLKOP_FPHASE = 0;
    parameter CLKOS_FPHASE = 0;
    parameter CLKOS2_FPHASE = 0;
    parameter CLKOS3_FPHASE = 0;
    parameter FEEDBK_PATH = "CLKOP";
    parameter CLKOP_TRIM_POL = "RISING";
    parameter CLKOP_TRIM_DELAY = 0;
    parameter CLKOS_TRIM_POL = "RISING";
    parameter CLKOS_TRIM_DELAY = 0;
    parameter OUTDIVIDER_MUXA = "DIVA";
    parameter OUTDIVIDER_MUXB = "DIVB";
    parameter OUTDIVIDER_MUXC = "DIVC";
    parameter OUTDIVIDER_MUXD = "DIVD";
    parameter PLL_LOCK_MODE = 0;
    parameter PLL_LOCK_DELAY = 200;
    parameter STDBY_ENABLE = "DISABLED";
    parameter REFIN_RESET = "DISABLED";
    parameter SYNC_ENABLE = "DISABLED";
    parameter INT_LOCK_STICKY = "ENABLED";
    parameter DPHASE_SOURCE = "DISABLED";
    parameter PLLRST_ENA = "DISABLED";
    parameter INTFB_WAKE = "DISABLED";
    input CLKI;
    input CLKFB;
    input PHASESEL1;
    input PHASESEL0;
    input PHASEDIR;
    input PHASESTEP;
    input PHASELOADREG;
    input STDBY;
    input PLLWAKESYNC;
    input RST;
    input ENCLKOP;
    input ENCLKOS;
    input ENCLKOS2;
    input ENCLKOS3;
    output CLKOP;
    output CLKOS;
    output CLKOS2;
    output CLKOS3;
    output LOCK;
    output INTLOCK;
    output REFCLK;
    output CLKINTFB;
endmodule

(* blackbox *)
module DTR(STARTPULSE, DTROUT7, DTROUT6, DTROUT5, DTROUT4, DTROUT3, DTROUT2, DTROUT1, DTROUT0);
    parameter DTR_TEMP = 25;
    input STARTPULSE;
    output DTROUT7;
    output DTROUT6;
    output DTROUT5;
    output DTROUT4;
    output DTROUT3;
    output DTROUT2;
    output DTROUT1;
    output DTROUT0;
endmodule

(* blackbox *)
module OSCG(OSC);
    parameter DIV = 128;
    output OSC;
endmodule

(* blackbox *)
module EXTREFB(REFCLKP, REFCLKN, REFCLKO);
    parameter REFCK_PWDNB = "DONTCARE";
    parameter REFCK_RTERM = "DONTCARE";
    parameter REFCK_DCBIAS_EN = "DONTCARE";
    (* iopad_external_pin *)
    input REFCLKP;
    (* iopad_external_pin *)
    input REFCLKN;
    output REFCLKO;
endmodule

(* blackbox *) (* keep *)
module JTAGG(TCK, TMS, TDI, JTDO2, JTDO1, TDO, JTDI, JTCK, JRTI2, JRTI1, JSHIFT, JUPDATE, JRSTN, JCE2, JCE1);
    parameter ER1 = "ENABLED";
    parameter ER2 = "ENABLED";
    (* iopad_external_pin *)
    input TCK;
    (* iopad_external_pin *)
    input TMS;
    (* iopad_external_pin *)
    input TDI;
    input JTDO2;
    input JTDO1;
    (* iopad_external_pin *)
    output TDO;
    output JTDI;
    output JTCK;
    output JRTI2;
    output JRTI1;
    output JSHIFT;
    output JUPDATE;
    output JRSTN;
    output JCE2;
    output JCE1;
endmodule

(* blackbox *) (* keep *)
module DCUA(CH0_HDINP, CH1_HDINP, CH0_HDINN, CH1_HDINN, D_TXBIT_CLKP_FROM_ND, D_TXBIT_CLKN_FROM_ND, D_SYNC_ND, D_TXPLL_LOL_FROM_ND, CH0_RX_REFCLK, CH1_RX_REFCLK, CH0_FF_RXI_CLK, CH1_FF_RXI_CLK, CH0_FF_TXI_CLK, CH1_FF_TXI_CLK, CH0_FF_EBRD_CLK, CH1_FF_EBRD_CLK, CH0_FF_TX_D_0, CH1_FF_TX_D_0, CH0_FF_TX_D_1, CH1_FF_TX_D_1, CH0_FF_TX_D_2
, CH1_FF_TX_D_2, CH0_FF_TX_D_3, CH1_FF_TX_D_3, CH0_FF_TX_D_4, CH1_FF_TX_D_4, CH0_FF_TX_D_5, CH1_FF_TX_D_5, CH0_FF_TX_D_6, CH1_FF_TX_D_6, CH0_FF_TX_D_7, CH1_FF_TX_D_7, CH0_FF_TX_D_8, CH1_FF_TX_D_8, CH0_FF_TX_D_9, CH1_FF_TX_D_9, CH0_FF_TX_D_10, CH1_FF_TX_D_10, CH0_FF_TX_D_11, CH1_FF_TX_D_11, CH0_FF_TX_D_12, CH1_FF_TX_D_12
, CH0_FF_TX_D_13, CH1_FF_TX_D_13, CH0_FF_TX_D_14, CH1_FF_TX_D_14, CH0_FF_TX_D_15, CH1_FF_TX_D_15, CH0_FF_TX_D_16, CH1_FF_TX_D_16, CH0_FF_TX_D_17, CH1_FF_TX_D_17, CH0_FF_TX_D_18, CH1_FF_TX_D_18, CH0_FF_TX_D_19, CH1_FF_TX_D_19, CH0_FF_TX_D_20, CH1_FF_TX_D_20, CH0_FF_TX_D_21, CH1_FF_TX_D_21, CH0_FF_TX_D_22, CH1_FF_TX_D_22, CH0_FF_TX_D_23
, CH1_FF_TX_D_23, CH0_FFC_EI_EN, CH1_FFC_EI_EN, CH0_FFC_PCIE_DET_EN, CH1_FFC_PCIE_DET_EN, CH0_FFC_PCIE_CT, CH1_FFC_PCIE_CT, CH0_FFC_SB_INV_RX, CH1_FFC_SB_INV_RX, CH0_FFC_ENABLE_CGALIGN, CH1_FFC_ENABLE_CGALIGN, CH0_FFC_SIGNAL_DETECT, CH1_FFC_SIGNAL_DETECT, CH0_FFC_FB_LOOPBACK, CH1_FFC_FB_LOOPBACK, CH0_FFC_SB_PFIFO_LP, CH1_FFC_SB_PFIFO_LP, CH0_FFC_PFIFO_CLR, CH1_FFC_PFIFO_CLR, CH0_FFC_RATE_MODE_RX, CH1_FFC_RATE_MODE_RX
, CH0_FFC_RATE_MODE_TX, CH1_FFC_RATE_MODE_TX, CH0_FFC_DIV11_MODE_RX, CH1_FFC_DIV11_MODE_RX, CH0_FFC_RX_GEAR_MODE, CH1_FFC_RX_GEAR_MODE, CH0_FFC_TX_GEAR_MODE, CH1_FFC_TX_GEAR_MODE, CH0_FFC_DIV11_MODE_TX, CH1_FFC_DIV11_MODE_TX, CH0_FFC_LDR_CORE2TX_EN, CH1_FFC_LDR_CORE2TX_EN, CH0_FFC_LANE_TX_RST, CH1_FFC_LANE_TX_RST, CH0_FFC_LANE_RX_RST, CH1_FFC_LANE_RX_RST, CH0_FFC_RRST, CH1_FFC_RRST, CH0_FFC_TXPWDNB, CH1_FFC_TXPWDNB, CH0_FFC_RXPWDNB
, CH1_FFC_RXPWDNB, CH0_LDR_CORE2TX, CH1_LDR_CORE2TX, D_SCIWDATA0, D_SCIWDATA1, D_SCIWDATA2, D_SCIWDATA3, D_SCIWDATA4, D_SCIWDATA5, D_SCIWDATA6, D_SCIWDATA7, D_SCIADDR0, D_SCIADDR1, D_SCIADDR2, D_SCIADDR3, D_SCIADDR4, D_SCIADDR5, D_SCIENAUX, D_SCISELAUX, CH0_SCIEN, CH1_SCIEN
, CH0_SCISEL, CH1_SCISEL, D_SCIRD, D_SCIWSTN, D_CYAWSTN, D_FFC_SYNC_TOGGLE, D_FFC_DUAL_RST, D_FFC_MACRO_RST, D_FFC_MACROPDB, D_FFC_TRST, CH0_FFC_CDR_EN_BITSLIP, CH1_FFC_CDR_EN_BITSLIP, D_SCAN_ENABLE, D_SCAN_IN_0, D_SCAN_IN_1, D_SCAN_IN_2, D_SCAN_IN_3, D_SCAN_IN_4, D_SCAN_IN_5, D_SCAN_IN_6, D_SCAN_IN_7
, D_SCAN_MODE, D_SCAN_RESET, D_CIN0, D_CIN1, D_CIN2, D_CIN3, D_CIN4, D_CIN5, D_CIN6, D_CIN7, D_CIN8, D_CIN9, D_CIN10, D_CIN11, CH0_HDOUTP, CH1_HDOUTP, CH0_HDOUTN, CH1_HDOUTN, D_TXBIT_CLKP_TO_ND, D_TXBIT_CLKN_TO_ND, D_SYNC_PULSE2ND
, D_TXPLL_LOL_TO_ND, CH0_FF_RX_F_CLK, CH1_FF_RX_F_CLK, CH0_FF_RX_H_CLK, CH1_FF_RX_H_CLK, CH0_FF_TX_F_CLK, CH1_FF_TX_F_CLK, CH0_FF_TX_H_CLK, CH1_FF_TX_H_CLK, CH0_FF_RX_PCLK, CH1_FF_RX_PCLK, CH0_FF_TX_PCLK, CH1_FF_TX_PCLK, CH0_FF_RX_D_0, CH1_FF_RX_D_0, CH0_FF_RX_D_1, CH1_FF_RX_D_1, CH0_FF_RX_D_2, CH1_FF_RX_D_2, CH0_FF_RX_D_3, CH1_FF_RX_D_3
, CH0_FF_RX_D_4, CH1_FF_RX_D_4, CH0_FF_RX_D_5, CH1_FF_RX_D_5, CH0_FF_RX_D_6, CH1_FF_RX_D_6, CH0_FF_RX_D_7, CH1_FF_RX_D_7, CH0_FF_RX_D_8, CH1_FF_RX_D_8, CH0_FF_RX_D_9, CH1_FF_RX_D_9, CH0_FF_RX_D_10, CH1_FF_RX_D_10, CH0_FF_RX_D_11, CH1_FF_RX_D_11, CH0_FF_RX_D_12, CH1_FF_RX_D_12, CH0_FF_RX_D_13, CH1_FF_RX_D_13, CH0_FF_RX_D_14
, CH1_FF_RX_D_14, CH0_FF_RX_D_15, CH1_FF_RX_D_15, CH0_FF_RX_D_16, CH1_FF_RX_D_16, CH0_FF_RX_D_17, CH1_FF_RX_D_17, CH0_FF_RX_D_18, CH1_FF_RX_D_18, CH0_FF_RX_D_19, CH1_FF_RX_D_19, CH0_FF_RX_D_20, CH1_FF_RX_D_20, CH0_FF_RX_D_21, CH1_FF_RX_D_21, CH0_FF_RX_D_22, CH1_FF_RX_D_22, CH0_FF_RX_D_23, CH1_FF_RX_D_23, CH0_FFS_PCIE_DONE, CH1_FFS_PCIE_DONE
, CH0_FFS_PCIE_CON, CH1_FFS_PCIE_CON, CH0_FFS_RLOS, CH1_FFS_RLOS, CH0_FFS_LS_SYNC_STATUS, CH1_FFS_LS_SYNC_STATUS, CH0_FFS_CC_UNDERRUN, CH1_FFS_CC_UNDERRUN, CH0_FFS_CC_OVERRUN, CH1_FFS_CC_OVERRUN, CH0_FFS_RXFBFIFO_ERROR, CH1_FFS_RXFBFIFO_ERROR, CH0_FFS_TXFBFIFO_ERROR, CH1_FFS_TXFBFIFO_ERROR, CH0_FFS_RLOL, CH1_FFS_RLOL, CH0_FFS_SKP_ADDED, CH1_FFS_SKP_ADDED, CH0_FFS_SKP_DELETED, CH1_FFS_SKP_DELETED, CH0_LDR_RX2CORE
, CH1_LDR_RX2CORE, D_SCIRDATA0, D_SCIRDATA1, D_SCIRDATA2, D_SCIRDATA3, D_SCIRDATA4, D_SCIRDATA5, D_SCIRDATA6, D_SCIRDATA7, D_SCIINT, D_SCAN_OUT_0, D_SCAN_OUT_1, D_SCAN_OUT_2, D_SCAN_OUT_3, D_SCAN_OUT_4, D_SCAN_OUT_5, D_SCAN_OUT_6, D_SCAN_OUT_7, D_COUT0, D_COUT1, D_COUT2
, D_COUT3, D_COUT4, D_COUT5, D_COUT6, D_COUT7, D_COUT8, D_COUT9, D_COUT10, D_COUT11, D_COUT12, D_COUT13, D_COUT14, D_COUT15, D_COUT16, D_COUT17, D_COUT18, D_COUT19, D_REFCLKI, D_FFS_PLOL);
    parameter D_MACROPDB = "DONTCARE";
    parameter D_IB_PWDNB = "DONTCARE";
    parameter D_XGE_MODE = "DONTCARE";
    parameter D_LOW_MARK = "DONTCARE";
    parameter D_HIGH_MARK = "DONTCARE";
    parameter D_BUS8BIT_SEL = "DONTCARE";
    parameter D_CDR_LOL_SET = "DONTCARE";
    parameter D_BITCLK_LOCAL_EN = "DONTCARE";
    parameter D_BITCLK_ND_EN = "DONTCARE";
    parameter D_BITCLK_FROM_ND_EN = "DONTCARE";
    parameter D_SYNC_LOCAL_EN = "DONTCARE";
    parameter D_SYNC_ND_EN = "DONTCARE";
    parameter CH0_UC_MODE = "DONTCARE";
    parameter CH1_UC_MODE = "DONTCARE";
    parameter CH0_PCIE_MODE = "DONTCARE";
    parameter CH1_PCIE_MODE = "DONTCARE";
    parameter CH0_RIO_MODE = "DONTCARE";
    parameter CH1_RIO_MODE = "DONTCARE";
    parameter CH0_WA_MODE = "DONTCARE";
    parameter CH1_WA_MODE = "DONTCARE";
    parameter CH0_INVERT_RX = "DONTCARE";
    parameter CH1_INVERT_RX = "DONTCARE";
    parameter CH0_INVERT_TX = "DONTCARE";
    parameter CH1_INVERT_TX = "DONTCARE";
    parameter CH0_PRBS_SELECTION = "DONTCARE";
    parameter CH1_PRBS_SELECTION = "DONTCARE";
    parameter CH0_GE_AN_ENABLE = "DONTCARE";
    parameter CH1_GE_AN_ENABLE = "DONTCARE";
    parameter CH0_PRBS_LOCK = "DONTCARE";
    parameter CH1_PRBS_LOCK = "DONTCARE";
    parameter CH0_PRBS_ENABLE = "DONTCARE";
    parameter CH1_PRBS_ENABLE = "DONTCARE";
    parameter CH0_ENABLE_CG_ALIGN = "DONTCARE";
    parameter CH1_ENABLE_CG_ALIGN = "DONTCARE";
    parameter CH0_TX_GEAR_MODE = "DONTCARE";
    parameter CH1_TX_GEAR_MODE = "DONTCARE";
    parameter CH0_RX_GEAR_MODE = "DONTCARE";
    parameter CH1_RX_GEAR_MODE = "DONTCARE";
    parameter CH0_PCS_DET_TIME_SEL = "DONTCARE";
    parameter CH1_PCS_DET_TIME_SEL = "DONTCARE";
    parameter CH0_PCIE_EI_EN = "DONTCARE";
    parameter CH1_PCIE_EI_EN = "DONTCARE";
    parameter CH0_TX_GEAR_BYPASS = "DONTCARE";
    parameter CH1_TX_GEAR_BYPASS = "DONTCARE";
    parameter CH0_ENC_BYPASS = "DONTCARE";
    parameter CH1_ENC_BYPASS = "DONTCARE";
    parameter CH0_SB_BYPASS = "DONTCARE";
    parameter CH1_SB_BYPASS = "DONTCARE";
    parameter CH0_RX_SB_BYPASS = "DONTCARE";
    parameter CH1_RX_SB_BYPASS = "DONTCARE";
    parameter CH0_WA_BYPASS = "DONTCARE";
    parameter CH1_WA_BYPASS = "DONTCARE";
    parameter CH0_DEC_BYPASS = "DONTCARE";
    parameter CH1_DEC_BYPASS = "DONTCARE";
    parameter CH0_CTC_BYPASS = "DONTCARE";
    parameter CH1_CTC_BYPASS = "DONTCARE";
    parameter CH0_RX_GEAR_BYPASS = "DONTCARE";
    parameter CH1_RX_GEAR_BYPASS = "DONTCARE";
    parameter CH0_LSM_DISABLE = "DONTCARE";
    parameter CH1_LSM_DISABLE = "DONTCARE";
    parameter CH0_MATCH_2_ENABLE = "DONTCARE";
    parameter CH1_MATCH_2_ENABLE = "DONTCARE";
    parameter CH0_MATCH_4_ENABLE = "DONTCARE";
    parameter CH1_MATCH_4_ENABLE = "DONTCARE";
    parameter CH0_MIN_IPG_CNT = "DONTCARE";
    parameter CH1_MIN_IPG_CNT = "DONTCARE";
    parameter CH0_CC_MATCH_1 = "DONTCARE";
    parameter CH1_CC_MATCH_1 = "DONTCARE";
    parameter CH0_CC_MATCH_2 = "DONTCARE";
    parameter CH1_CC_MATCH_2 = "DONTCARE";
    parameter CH0_CC_MATCH_3 = "DONTCARE";
    parameter CH1_CC_MATCH_3 = "DONTCARE";
    parameter CH0_CC_MATCH_4 = "DONTCARE";
    parameter CH1_CC_MATCH_4 = "DONTCARE";
    parameter CH0_UDF_COMMA_MASK = "DONTCARE";
    parameter CH1_UDF_COMMA_MASK = "DONTCARE";
    parameter CH0_UDF_COMMA_A = "DONTCARE";
    parameter CH1_UDF_COMMA_A = "DONTCARE";
    parameter CH0_UDF_COMMA_B = "DONTCARE";
    parameter CH1_UDF_COMMA_B = "DONTCARE";
    parameter CH0_RX_DCO_CK_DIV = "DONTCARE";
    parameter CH1_RX_DCO_CK_DIV = "DONTCARE";
    parameter CH0_RCV_DCC_EN = "DONTCARE";
    parameter CH1_RCV_DCC_EN = "DONTCARE";
    parameter CH0_REQ_LVL_SET = "DONTCARE";
    parameter CH1_REQ_LVL_SET = "DONTCARE";
    parameter CH0_REQ_EN = "DONTCARE";
    parameter CH1_REQ_EN = "DONTCARE";
    parameter CH0_RTERM_RX = "DONTCARE";
    parameter CH1_RTERM_RX = "DONTCARE";
    parameter CH0_PDEN_SEL = "DONTCARE";
    parameter CH1_PDEN_SEL = "DONTCARE";
    parameter CH0_LDR_RX2CORE_SEL = "DONTCARE";
    parameter CH1_LDR_RX2CORE_SEL = "DONTCARE";
    parameter CH0_LDR_CORE2TX_SEL = "DONTCARE";
    parameter CH1_LDR_CORE2TX_SEL = "DONTCARE";
    parameter CH0_TPWDNB = "DONTCARE";
    parameter CH1_TPWDNB = "DONTCARE";
    parameter CH0_RATE_MODE_TX = "DONTCARE";
    parameter CH1_RATE_MODE_TX = "DONTCARE";
    parameter CH0_RTERM_TX = "DONTCARE";
    parameter CH1_RTERM_TX = "DONTCARE";
    parameter CH0_TX_CM_SEL = "DONTCARE";
    parameter CH1_TX_CM_SEL = "DONTCARE";
    parameter CH0_TDRV_PRE_EN = "DONTCARE";
    parameter CH1_TDRV_PRE_EN = "DONTCARE";
    parameter CH0_TDRV_SLICE0_SEL = "DONTCARE";
    parameter CH1_TDRV_SLICE0_SEL = "DONTCARE";
    parameter CH0_TDRV_SLICE1_SEL = "DONTCARE";
    parameter CH1_TDRV_SLICE1_SEL = "DONTCARE";
    parameter CH0_TDRV_SLICE2_SEL = "DONTCARE";
    parameter CH1_TDRV_SLICE2_SEL = "DONTCARE";
    parameter CH0_TDRV_SLICE3_SEL = "DONTCARE";
    parameter CH1_TDRV_SLICE3_SEL = "DONTCARE";
    parameter CH0_TDRV_SLICE4_SEL = "DONTCARE";
    parameter CH1_TDRV_SLICE4_SEL = "DONTCARE";
    parameter CH0_TDRV_SLICE5_SEL = "DONTCARE";
    parameter CH1_TDRV_SLICE5_SEL = "DONTCARE";
    parameter CH0_TDRV_SLICE0_CUR = "DONTCARE";
    parameter CH1_TDRV_SLICE0_CUR = "DONTCARE";
    parameter CH0_TDRV_SLICE1_CUR = "DONTCARE";
    parameter CH1_TDRV_SLICE1_CUR = "DONTCARE";
    parameter CH0_TDRV_SLICE2_CUR = "DONTCARE";
    parameter CH1_TDRV_SLICE2_CUR = "DONTCARE";
    parameter CH0_TDRV_SLICE3_CUR = "DONTCARE";
    parameter CH1_TDRV_SLICE3_CUR = "DONTCARE";
    parameter CH0_TDRV_SLICE4_CUR = "DONTCARE";
    parameter CH1_TDRV_SLICE4_CUR = "DONTCARE";
    parameter CH0_TDRV_SLICE5_CUR = "DONTCARE";
    parameter CH1_TDRV_SLICE5_CUR = "DONTCARE";
    parameter CH0_TDRV_DAT_SEL = "DONTCARE";
    parameter CH1_TDRV_DAT_SEL = "DONTCARE";
    parameter CH0_TX_DIV11_SEL = "DONTCARE";
    parameter CH1_TX_DIV11_SEL = "DONTCARE";
    parameter CH0_RPWDNB = "DONTCARE";
    parameter CH1_RPWDNB = "DONTCARE";
    parameter CH0_RATE_MODE_RX = "DONTCARE";
    parameter CH1_RATE_MODE_RX = "DONTCARE";
    parameter CH0_RLOS_SEL = "DONTCARE";
    parameter CH1_RLOS_SEL = "DONTCARE";
    parameter CH0_RX_LOS_LVL = "DONTCARE";
    parameter CH1_RX_LOS_LVL = "DONTCARE";
    parameter CH0_RX_LOS_CEQ = "DONTCARE";
    parameter CH1_RX_LOS_CEQ = "DONTCARE";
    parameter CH0_RX_LOS_HYST_EN = "DONTCARE";
    parameter CH1_RX_LOS_HYST_EN = "DONTCARE";
    parameter CH0_RX_LOS_EN = "DONTCARE";
    parameter CH1_RX_LOS_EN = "DONTCARE";
    parameter CH0_RX_DIV11_SEL = "DONTCARE";
    parameter CH1_RX_DIV11_SEL = "DONTCARE";
    parameter CH0_SEL_SD_RX_CLK = "DONTCARE";
    parameter CH1_SEL_SD_RX_CLK = "DONTCARE";
    parameter CH0_FF_RX_H_CLK_EN = "DONTCARE";
    parameter CH1_FF_RX_H_CLK_EN = "DONTCARE";
    parameter CH0_FF_RX_F_CLK_DIS = "DONTCARE";
    parameter CH1_FF_RX_F_CLK_DIS = "DONTCARE";
    parameter CH0_FF_TX_H_CLK_EN = "DONTCARE";
    parameter CH1_FF_TX_H_CLK_EN = "DONTCARE";
    parameter CH0_FF_TX_F_CLK_DIS = "DONTCARE";
    parameter CH1_FF_TX_F_CLK_DIS = "DONTCARE";
    parameter CH0_RX_RATE_SEL = "DONTCARE";
    parameter CH1_RX_RATE_SEL = "DONTCARE";
    parameter CH0_TDRV_POST_EN = "DONTCARE";
    parameter CH1_TDRV_POST_EN = "DONTCARE";
    parameter CH0_TX_POST_SIGN = "DONTCARE";
    parameter CH1_TX_POST_SIGN = "DONTCARE";
    parameter CH0_TX_PRE_SIGN = "DONTCARE";
    parameter CH1_TX_PRE_SIGN = "DONTCARE";
    parameter CH0_RXTERM_CM = "DONTCARE";
    parameter CH1_RXTERM_CM = "DONTCARE";
    parameter CH0_RXIN_CM = "DONTCARE";
    parameter CH1_RXIN_CM = "DONTCARE";
    parameter CH0_LEQ_OFFSET_SEL = "DONTCARE";
    parameter CH1_LEQ_OFFSET_SEL = "DONTCARE";
    parameter CH0_LEQ_OFFSET_TRIM = "DONTCARE";
    parameter CH1_LEQ_OFFSET_TRIM = "DONTCARE";
    parameter D_TX_MAX_RATE = "DONTCARE";
    parameter CH0_CDR_MAX_RATE = "DONTCARE";
    parameter CH1_CDR_MAX_RATE = "DONTCARE";
    parameter CH0_TXAMPLITUDE = "DONTCARE";
    parameter CH1_TXAMPLITUDE = "DONTCARE";
    parameter CH0_TXDEPRE = "DONTCARE";
    parameter CH1_TXDEPRE = "DONTCARE";
    parameter CH0_TXDEPOST = "DONTCARE";
    parameter CH1_TXDEPOST = "DONTCARE";
    parameter CH0_PROTOCOL = "DONTCARE";
    parameter CH1_PROTOCOL = "DONTCARE";
    parameter D_ISETLOS = "DONTCARE";
    parameter D_SETIRPOLY_AUX = "DONTCARE";
    parameter D_SETICONST_AUX = "DONTCARE";
    parameter D_SETIRPOLY_CH = "DONTCARE";
    parameter D_SETICONST_CH = "DONTCARE";
    parameter D_REQ_ISET = "DONTCARE";
    parameter D_PD_ISET = "DONTCARE";
    parameter D_DCO_CALIB_TIME_SEL = "DONTCARE";
    parameter CH0_DCOCTLGI = "DONTCARE";
    parameter CH1_DCOCTLGI = "DONTCARE";
    parameter CH0_DCOATDDLY = "DONTCARE";
    parameter CH1_DCOATDDLY = "DONTCARE";
    parameter CH0_DCOATDCFG = "DONTCARE";
    parameter CH1_DCOATDCFG = "DONTCARE";
    parameter CH0_DCOBYPSATD = "DONTCARE";
    parameter CH1_DCOBYPSATD = "DONTCARE";
    parameter CH0_DCOSCALEI = "DONTCARE";
    parameter CH1_DCOSCALEI = "DONTCARE";
    parameter CH0_DCOITUNE4LSB = "DONTCARE";
    parameter CH1_DCOITUNE4LSB = "DONTCARE";
    parameter CH0_DCOIOSTUNE = "DONTCARE";
    parameter CH1_DCOIOSTUNE = "DONTCARE";
    parameter CH0_DCODISBDAVOID = "DONTCARE";
    parameter CH1_DCODISBDAVOID = "DONTCARE";
    parameter CH0_DCOCALDIV = "DONTCARE";
    parameter CH1_DCOCALDIV = "DONTCARE";
    parameter CH0_DCONUOFLSB = "DONTCARE";
    parameter CH1_DCONUOFLSB = "DONTCARE";
    parameter CH0_DCOIUPDNX2 = "DONTCARE";
    parameter CH1_DCOIUPDNX2 = "DONTCARE";
    parameter CH0_DCOSTEP = "DONTCARE";
    parameter CH1_DCOSTEP = "DONTCARE";
    parameter CH0_DCOSTARTVAL = "DONTCARE";
    parameter CH1_DCOSTARTVAL = "DONTCARE";
    parameter CH0_DCOFLTDAC = "DONTCARE";
    parameter CH1_DCOFLTDAC = "DONTCARE";
    parameter CH0_DCOITUNE = "DONTCARE";
    parameter CH1_DCOITUNE = "DONTCARE";
    parameter CH0_DCOFTNRG = "DONTCARE";
    parameter CH1_DCOFTNRG = "DONTCARE";
    parameter CH0_CDR_CNT4SEL = "DONTCARE";
    parameter CH1_CDR_CNT4SEL = "DONTCARE";
    parameter CH0_CDR_CNT8SEL = "DONTCARE";
    parameter CH1_CDR_CNT8SEL = "DONTCARE";
    parameter CH0_BAND_THRESHOLD = "DONTCARE";
    parameter CH1_BAND_THRESHOLD = "DONTCARE";
    parameter CH0_AUTO_FACQ_EN = "DONTCARE";
    parameter CH1_AUTO_FACQ_EN = "DONTCARE";
    parameter CH0_AUTO_CALIB_EN = "DONTCARE";
    parameter CH1_AUTO_CALIB_EN = "DONTCARE";
    parameter CH0_CALIB_CK_MODE = "DONTCARE";
    parameter CH1_CALIB_CK_MODE = "DONTCARE";
    parameter CH0_REG_BAND_OFFSET = "DONTCARE";
    parameter CH1_REG_BAND_OFFSET = "DONTCARE";
    parameter CH0_REG_BAND_SEL = "DONTCARE";
    parameter CH1_REG_BAND_SEL = "DONTCARE";
    parameter CH0_REG_IDAC_SEL = "DONTCARE";
    parameter CH1_REG_IDAC_SEL = "DONTCARE";
    parameter CH0_REG_IDAC_EN = "DONTCARE";
    parameter CH1_REG_IDAC_EN = "DONTCARE";
    parameter D_TXPLL_PWDNB = "DONTCARE";
    parameter D_SETPLLRC = "DONTCARE";
    parameter D_REFCK_MODE = "DONTCARE";
    parameter D_TX_VCO_CK_DIV = "DONTCARE";
    parameter D_PLL_LOL_SET = "DONTCARE";
    parameter D_RG_EN = "DONTCARE";
    parameter D_RG_SET = "DONTCARE";
    parameter D_CMUSETISCL4VCO = "DONTCARE";
    parameter D_CMUSETI4VCO = "DONTCARE";
    parameter D_CMUSETINITVCT = "DONTCARE";
    parameter D_CMUSETZGM = "DONTCARE";
    parameter D_CMUSETP2AGM = "DONTCARE";
    parameter D_CMUSETP1GM = "DONTCARE";
    parameter D_CMUSETI4CPZ = "DONTCARE";
    parameter D_CMUSETI4CPP = "DONTCARE";
    parameter D_CMUSETICP4Z = "DONTCARE";
    parameter D_CMUSETICP4P = "DONTCARE";
    parameter D_CMUSETBIASI = "DONTCARE";
    (* iopad_external_pin *)
    (* iopad_external_pin *)
    input CH0_HDINP;
    (* iopad_external_pin *)
    input CH1_HDINP;
    (* iopad_external_pin *)
    input CH0_HDINN;
    (* iopad_external_pin *)
    input CH1_HDINN;
    input D_TXBIT_CLKP_FROM_ND;
    input D_TXBIT_CLKN_FROM_ND;
    input D_SYNC_ND;
    input D_TXPLL_LOL_FROM_ND;
    input CH0_RX_REFCLK;
    input CH1_RX_REFCLK;
    input CH0_FF_RXI_CLK;
    input CH1_FF_RXI_CLK;
    input CH0_FF_TXI_CLK;
    input CH1_FF_TXI_CLK;
    input CH0_FF_EBRD_CLK;
    input CH1_FF_EBRD_CLK;
    input CH0_FF_TX_D_0;
    input CH1_FF_TX_D_0;
    input CH0_FF_TX_D_1;
    input CH1_FF_TX_D_1;
    input CH0_FF_TX_D_2;
    input CH1_FF_TX_D_2;
    input CH0_FF_TX_D_3;
    input CH1_FF_TX_D_3;
    input CH0_FF_TX_D_4;
    input CH1_FF_TX_D_4;
    input CH0_FF_TX_D_5;
    input CH1_FF_TX_D_5;
    input CH0_FF_TX_D_6;
    input CH1_FF_TX_D_6;
    input CH0_FF_TX_D_7;
    input CH1_FF_TX_D_7;
    input CH0_FF_TX_D_8;
    input CH1_FF_TX_D_8;
    input CH0_FF_TX_D_9;
    input CH1_FF_TX_D_9;
    input CH0_FF_TX_D_10;
    input CH1_FF_TX_D_10;
    input CH0_FF_TX_D_11;
    input CH1_FF_TX_D_11;
    input CH0_FF_TX_D_12;
    input CH1_FF_TX_D_12;
    input CH0_FF_TX_D_13;
    input CH1_FF_TX_D_13;
    input CH0_FF_TX_D_14;
    input CH1_FF_TX_D_14;
    input CH0_FF_TX_D_15;
    input CH1_FF_TX_D_15;
    input CH0_FF_TX_D_16;
    input CH1_FF_TX_D_16;
    input CH0_FF_TX_D_17;
    input CH1_FF_TX_D_17;
    input CH0_FF_TX_D_18;
    input CH1_FF_TX_D_18;
    input CH0_FF_TX_D_19;
    input CH1_FF_TX_D_19;
    input CH0_FF_TX_D_20;
    input CH1_FF_TX_D_20;
    input CH0_FF_TX_D_21;
    input CH1_FF_TX_D_21;
    input CH0_FF_TX_D_22;
    input CH1_FF_TX_D_22;
    input CH0_FF_TX_D_23;
    input CH1_FF_TX_D_23;
    input CH0_FFC_EI_EN;
    input CH1_FFC_EI_EN;
    input CH0_FFC_PCIE_DET_EN;
    input CH1_FFC_PCIE_DET_EN;
    input CH0_FFC_PCIE_CT;
    input CH1_FFC_PCIE_CT;
    input CH0_FFC_SB_INV_RX;
    input CH1_FFC_SB_INV_RX;
    input CH0_FFC_ENABLE_CGALIGN;
    input CH1_FFC_ENABLE_CGALIGN;
    input CH0_FFC_SIGNAL_DETECT;
    input CH1_FFC_SIGNAL_DETECT;
    input CH0_FFC_FB_LOOPBACK;
    input CH1_FFC_FB_LOOPBACK;
    input CH0_FFC_SB_PFIFO_LP;
    input CH1_FFC_SB_PFIFO_LP;
    input CH0_FFC_PFIFO_CLR;
    input CH1_FFC_PFIFO_CLR;
    input CH0_FFC_RATE_MODE_RX;
    input CH1_FFC_RATE_MODE_RX;
    input CH0_FFC_RATE_MODE_TX;
    input CH1_FFC_RATE_MODE_TX;
    input CH0_FFC_DIV11_MODE_RX;
    input CH1_FFC_DIV11_MODE_RX;
    input CH0_FFC_RX_GEAR_MODE;
    input CH1_FFC_RX_GEAR_MODE;
    input CH0_FFC_TX_GEAR_MODE;
    input CH1_FFC_TX_GEAR_MODE;
    input CH0_FFC_DIV11_MODE_TX;
    input CH1_FFC_DIV11_MODE_TX;
    input CH0_FFC_LDR_CORE2TX_EN;
    input CH1_FFC_LDR_CORE2TX_EN;
    input CH0_FFC_LANE_TX_RST;
    input CH1_FFC_LANE_TX_RST;
    input CH0_FFC_LANE_RX_RST;
    input CH1_FFC_LANE_RX_RST;
    input CH0_FFC_RRST;
    input CH1_FFC_RRST;
    input CH0_FFC_TXPWDNB;
    input CH1_FFC_TXPWDNB;
    input CH0_FFC_RXPWDNB;
    input CH1_FFC_RXPWDNB;
    input CH0_LDR_CORE2TX;
    input CH1_LDR_CORE2TX;
    input D_SCIWDATA0;
    input D_SCIWDATA1;
    input D_SCIWDATA2;
    input D_SCIWDATA3;
    input D_SCIWDATA4;
    input D_SCIWDATA5;
    input D_SCIWDATA6;
    input D_SCIWDATA7;
    input D_SCIADDR0;
    input D_SCIADDR1;
    input D_SCIADDR2;
    input D_SCIADDR3;
    input D_SCIADDR4;
    input D_SCIADDR5;
    input D_SCIENAUX;
    input D_SCISELAUX;
    input CH0_SCIEN;
    input CH1_SCIEN;
    input CH0_SCISEL;
    input CH1_SCISEL;
    input D_SCIRD;
    input D_SCIWSTN;
    input D_CYAWSTN;
    input D_FFC_SYNC_TOGGLE;
    input D_FFC_DUAL_RST;
    input D_FFC_MACRO_RST;
    input D_FFC_MACROPDB;
    input D_FFC_TRST;
    input CH0_FFC_CDR_EN_BITSLIP;
    input CH1_FFC_CDR_EN_BITSLIP;
    input D_SCAN_ENABLE;
    input D_SCAN_IN_0;
    input D_SCAN_IN_1;
    input D_SCAN_IN_2;
    input D_SCAN_IN_3;
    input D_SCAN_IN_4;
    input D_SCAN_IN_5;
    input D_SCAN_IN_6;
    input D_SCAN_IN_7;
    input D_SCAN_MODE;
    input D_SCAN_RESET;
    input D_CIN0;
    input D_CIN1;
    input D_CIN2;
    input D_CIN3;
    input D_CIN4;
    input D_CIN5;
    input D_CIN6;
    input D_CIN7;
    input D_CIN8;
    input D_CIN9;
    input D_CIN10;
    input D_CIN11;
    output CH0_HDOUTP;
    output CH1_HDOUTP;
    output CH0_HDOUTN;
    output CH1_HDOUTN;
    output D_TXBIT_CLKP_TO_ND;
    output D_TXBIT_CLKN_TO_ND;
    output D_SYNC_PULSE2ND;
    output D_TXPLL_LOL_TO_ND;
    output CH0_FF_RX_F_CLK;
    output CH1_FF_RX_F_CLK;
    output CH0_FF_RX_H_CLK;
    output CH1_FF_RX_H_CLK;
    output CH0_FF_TX_F_CLK;
    output CH1_FF_TX_F_CLK;
    output CH0_FF_TX_H_CLK;
    output CH1_FF_TX_H_CLK;
    output CH0_FF_RX_PCLK;
    output CH1_FF_RX_PCLK;
    output CH0_FF_TX_PCLK;
    output CH1_FF_TX_PCLK;
    output CH0_FF_RX_D_0;
    output CH1_FF_RX_D_0;
    output CH0_FF_RX_D_1;
    output CH1_FF_RX_D_1;
    output CH0_FF_RX_D_2;
    output CH1_FF_RX_D_2;
    output CH0_FF_RX_D_3;
    output CH1_FF_RX_D_3;
    output CH0_FF_RX_D_4;
    output CH1_FF_RX_D_4;
    output CH0_FF_RX_D_5;
    output CH1_FF_RX_D_5;
    output CH0_FF_RX_D_6;
    output CH1_FF_RX_D_6;
    output CH0_FF_RX_D_7;
    output CH1_FF_RX_D_7;
    output CH0_FF_RX_D_8;
    output CH1_FF_RX_D_8;
    output CH0_FF_RX_D_9;
    output CH1_FF_RX_D_9;
    output CH0_FF_RX_D_10;
    output CH1_FF_RX_D_10;
    output CH0_FF_RX_D_11;
    output CH1_FF_RX_D_11;
    output CH0_FF_RX_D_12;
    output CH1_FF_RX_D_12;
    output CH0_FF_RX_D_13;
    output CH1_FF_RX_D_13;
    output CH0_FF_RX_D_14;
    output CH1_FF_RX_D_14;
    output CH0_FF_RX_D_15;
    output CH1_FF_RX_D_15;
    output CH0_FF_RX_D_16;
    output CH1_FF_RX_D_16;
    output CH0_FF_RX_D_17;
    output CH1_FF_RX_D_17;
    output CH0_FF_RX_D_18;
    output CH1_FF_RX_D_18;
    output CH0_FF_RX_D_19;
    output CH1_FF_RX_D_19;
    output CH0_FF_RX_D_20;
    output CH1_FF_RX_D_20;
    output CH0_FF_RX_D_21;
    output CH1_FF_RX_D_21;
    output CH0_FF_RX_D_22;
    output CH1_FF_RX_D_22;
    output CH0_FF_RX_D_23;
    output CH1_FF_RX_D_23;
    output CH0_FFS_PCIE_DONE;
    output CH1_FFS_PCIE_DONE;
    output CH0_FFS_PCIE_CON;
    output CH1_FFS_PCIE_CON;
    output CH0_FFS_RLOS;
    output CH1_FFS_RLOS;
    output CH0_FFS_LS_SYNC_STATUS;
    output CH1_FFS_LS_SYNC_STATUS;
    output CH0_FFS_CC_UNDERRUN;
    output CH1_FFS_CC_UNDERRUN;
    output CH0_FFS_CC_OVERRUN;
    output CH1_FFS_CC_OVERRUN;
    output CH0_FFS_RXFBFIFO_ERROR;
    output CH1_FFS_RXFBFIFO_ERROR;
    output CH0_FFS_TXFBFIFO_ERROR;
    output CH1_FFS_TXFBFIFO_ERROR;
    output CH0_FFS_RLOL;
    output CH1_FFS_RLOL;
    output CH0_FFS_SKP_ADDED;
    output CH1_FFS_SKP_ADDED;
    output CH0_FFS_SKP_DELETED;
    output CH1_FFS_SKP_DELETED;
    output CH0_LDR_RX2CORE;
    output CH1_LDR_RX2CORE;
    output D_SCIRDATA0;
    output D_SCIRDATA1;
    output D_SCIRDATA2;
    output D_SCIRDATA3;
    output D_SCIRDATA4;
    output D_SCIRDATA5;
    output D_SCIRDATA6;
    output D_SCIRDATA7;
    output D_SCIINT;
    output D_SCAN_OUT_0;
    output D_SCAN_OUT_1;
    output D_SCAN_OUT_2;
    output D_SCAN_OUT_3;
    output D_SCAN_OUT_4;
    output D_SCAN_OUT_5;
    output D_SCAN_OUT_6;
    output D_SCAN_OUT_7;
    output D_COUT0;
    output D_COUT1;
    output D_COUT2;
    output D_COUT3;
    output D_COUT4;
    output D_COUT5;
    output D_COUT6;
    output D_COUT7;
    output D_COUT8;
    output D_COUT9;
    output D_COUT10;
    output D_COUT11;
    output D_COUT12;
    output D_COUT13;
    output D_COUT14;
    output D_COUT15;
    output D_COUT16;
    output D_COUT17;
    output D_COUT18;
    output D_COUT19;
    input D_REFCLKI;
    output D_FFS_PLOL;
endmodule

