
use builtin;
use str;

set edit:completion:arg-completer[zola] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'zola'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'zola'= {
            cand -r 'Directory to use as root of project'
            cand --root 'Directory to use as root of project'
            cand -c 'Path to a config file other than zola.toml or config.toml in the root of project'
            cand --config 'Path to a config file other than zola.toml or config.toml in the root of project'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand init 'Create a new Zola project'
            cand build 'Deletes the output directory if there is one and builds the site'
            cand serve 'Serve the site. Rebuild and reload on change automatically'
            cand check 'Try to build the project without rendering it. Checks links'
            cand completion 'Generate shell completion'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'zola;init'= {
            cand -f 'Force creation of project even if directory is non-empty'
            cand --force 'Force creation of project even if directory is non-empty'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'zola;build'= {
            cand -u 'Force the base URL to be that value (defaults to the one in the config file)'
            cand --base-url 'Force the base URL to be that value (defaults to the one in the config file)'
            cand -o 'Outputs the generated site in the given path (by default ''public'' dir in project root)'
            cand --output-dir 'Outputs the generated site in the given path (by default ''public'' dir in project root)'
            cand -f 'Force building the site even if output directory is non-empty'
            cand --force 'Force building the site even if output directory is non-empty'
            cand --drafts 'Include drafts when loading the site'
            cand --minify 'Minify generated HTML files'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'zola;serve'= {
            cand -i 'Interface to bind on'
            cand --interface 'Interface to bind on'
            cand -p 'Which port to use'
            cand --port 'Which port to use'
            cand -o 'Outputs assets of the generated site in the given path (by default ''public'' dir in project root). HTML/XML will be stored in memory'
            cand --output-dir 'Outputs assets of the generated site in the given path (by default ''public'' dir in project root). HTML/XML will be stored in memory'
            cand -u 'Changes the base_url'
            cand --base-url 'Changes the base_url'
            cand --extra-watch-path 'Extra path to watch for changes, relative to the project root'
            cand -d 'Debounce time in milliseconds for the file watcher (at least 1ms)'
            cand --debounce 'Debounce time in milliseconds for the file watcher (at least 1ms)'
            cand --force 'Force use of the directory for serving the site even if output directory is non-empty'
            cand --drafts 'Include drafts when loading the site'
            cand -O 'Open site in the default browser'
            cand --open 'Open site in the default browser'
            cand --store-html 'Also store HTML in the public/ folder (by default HTML is only stored in-memory)'
            cand -f 'Only rebuild the minimum on change - useful when working on a specific page/section'
            cand --fast 'Only rebuild the minimum on change - useful when working on a specific page/section'
            cand --no-port-append 'Default append port to the base url'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'zola;check'= {
            cand --drafts 'Include drafts when loading the site'
            cand --skip-external-links 'Skip external links'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'zola;completion'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'zola;help'= {
            cand init 'Create a new Zola project'
            cand build 'Deletes the output directory if there is one and builds the site'
            cand serve 'Serve the site. Rebuild and reload on change automatically'
            cand check 'Try to build the project without rendering it. Checks links'
            cand completion 'Generate shell completion'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'zola;help;init'= {
        }
        &'zola;help;build'= {
        }
        &'zola;help;serve'= {
        }
        &'zola;help;check'= {
        }
        &'zola;help;completion'= {
        }
        &'zola;help;help'= {
        }
    ]
    $completions[$command]
}
