%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.2
%% Purpose: Encoding and decoding of the types in CryptographicMessageSyntax-2009.

-module('CryptographicMessageSyntax-2009').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("CryptographicMessageSyntax-2009.hrl").
-asn1_info([{vsn,'5.4.2'},
            {module,'CryptographicMessageSyntax-2009'},
            {options,[{i,"/home/builder/.termux-build/erlang/src/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/home/builder/.termux-build/erlang/src/lib/public_key/asn1"},
 {outdir,"/home/builder/.termux-build/erlang/src/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/home/builder/.termux-build/erlang/src/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_ContentType/2,
enc_ContentInfo/2,
enc_SignedData/2,
enc_SignerInfos/2,
enc_EncapsulatedContentInfo/2,
enc_SignerInfo/2,
enc_SignedAttributes/2,
enc_SignerIdentifier/2,
enc_SignatureValue/2,
enc_EnvelopedData/2,
enc_OriginatorInfo/2,
enc_RecipientInfos/2,
enc_EncryptedContentInfo/2,
enc_RecipientInfo/2,
enc_EncryptedKey/2,
enc_KeyTransRecipientInfo/2,
enc_RecipientIdentifier/2,
enc_KeyAgreeRecipientInfo/2,
enc_OriginatorIdentifierOrKey/2,
enc_OriginatorPublicKey/2,
enc_RecipientEncryptedKeys/2,
enc_RecipientEncryptedKey/2,
enc_KeyAgreeRecipientIdentifier/2,
enc_RecipientKeyIdentifier/2,
enc_SubjectKeyIdentifier/2,
enc_KEKRecipientInfo/2,
enc_KEKIdentifier/2,
enc_PasswordRecipientInfo/2,
enc_OtherRecipientInfo/2,
enc_DigestedData/2,
enc_Digest/2,
enc_EncryptedData/2,
enc_AuthenticatedData/2,
enc_AuthAttributes/2,
enc_MessageAuthenticationCode/2,
enc_UnauthAttributes/2,
enc_DigestAlgorithmIdentifier/2,
enc_SignatureAlgorithmIdentifier/2,
enc_KeyEncryptionAlgorithmIdentifier/2,
enc_ContentEncryptionAlgorithmIdentifier/2,
enc_MessageAuthenticationCodeAlgorithm/2,
enc_KeyDerivationAlgorithmIdentifier/2,
enc_RevocationInfoChoices/2,
enc_RevocationInfoChoice/2,
enc_OtherRevocationInfoFormat/2,
enc_CertificateChoices/2,
enc_AttributeCertificateV2/2,
enc_OtherCertificateFormat/2,
enc_CertificateSet/2,
enc_IssuerAndSerialNumber/2,
enc_CMSVersion/2,
enc_UserKeyingMaterial/2,
enc_OtherKeyAttribute/2,
enc_MessageDigest/2,
enc_SigningTime/2,
enc_Time/2,
enc_Countersignature/2,
enc_ExtendedCertificateOrCertificate/2,
enc_ExtendedCertificate/2,
enc_ExtendedCertificateInfo/2,
enc_Signature/2
]).

-export([
dec_ContentType/2,
dec_ContentInfo/2,
dec_SignedData/2,
dec_SignerInfos/2,
dec_EncapsulatedContentInfo/2,
dec_SignerInfo/2,
dec_SignedAttributes/2,
dec_SignerIdentifier/2,
dec_SignatureValue/2,
dec_EnvelopedData/2,
dec_OriginatorInfo/2,
dec_RecipientInfos/2,
dec_EncryptedContentInfo/2,
dec_RecipientInfo/2,
dec_EncryptedKey/2,
dec_KeyTransRecipientInfo/2,
dec_RecipientIdentifier/2,
dec_KeyAgreeRecipientInfo/2,
dec_OriginatorIdentifierOrKey/2,
dec_OriginatorPublicKey/2,
dec_RecipientEncryptedKeys/2,
dec_RecipientEncryptedKey/2,
dec_KeyAgreeRecipientIdentifier/2,
dec_RecipientKeyIdentifier/2,
dec_SubjectKeyIdentifier/2,
dec_KEKRecipientInfo/2,
dec_KEKIdentifier/2,
dec_PasswordRecipientInfo/2,
dec_OtherRecipientInfo/2,
dec_DigestedData/2,
dec_Digest/2,
dec_EncryptedData/2,
dec_AuthenticatedData/2,
dec_AuthAttributes/2,
dec_MessageAuthenticationCode/2,
dec_UnauthAttributes/2,
dec_DigestAlgorithmIdentifier/2,
dec_SignatureAlgorithmIdentifier/2,
dec_KeyEncryptionAlgorithmIdentifier/2,
dec_ContentEncryptionAlgorithmIdentifier/2,
dec_MessageAuthenticationCodeAlgorithm/2,
dec_KeyDerivationAlgorithmIdentifier/2,
dec_RevocationInfoChoices/2,
dec_RevocationInfoChoice/2,
dec_OtherRevocationInfoFormat/2,
dec_CertificateChoices/2,
dec_AttributeCertificateV2/2,
dec_OtherCertificateFormat/2,
dec_CertificateSet/2,
dec_IssuerAndSerialNumber/2,
dec_CMSVersion/2,
dec_UserKeyingMaterial/2,
dec_OtherKeyAttribute/2,
dec_MessageDigest/2,
dec_SigningTime/2,
dec_Time/2,
dec_Countersignature/2,
dec_ExtendedCertificateOrCertificate/2,
dec_ExtendedCertificate/2,
dec_ExtendedCertificateInfo/2,
dec_Signature/2
]).

-export([
'enc_ct-Data'/3,
'enc_ct-SignedData'/3,
'enc_ct-EnvelopedData'/3,
'enc_ct-DigestedData'/3,
'enc_ct-EncryptedData'/3,
'enc_ct-AuthenticatedData'/3,
'enc_aa-contentType'/3,
'enc_aa-messageDigest'/3,
'enc_aa-signingTime'/3,
'enc_aa-countersignature'/3
]).

-export([
'dec_ct-Data'/3,
'dec_ct-SignedData'/3,
'dec_ct-EnvelopedData'/3,
'dec_ct-DigestedData'/3,
'dec_ct-EncryptedData'/3,
'dec_ct-AuthenticatedData'/3,
'dec_aa-contentType'/3,
'dec_aa-messageDigest'/3,
'dec_aa-signingTime'/3,
'dec_aa-countersignature'/3
]).

-export([
getenc_ContentSet/1,
getenc_SignedAttributesSet/1,
getenc_UnsignedAttributes/1,
getenc_UnprotectedAttributes/1,
getenc_KeyTransportAlgorithmSet/1,
getenc_KeyAgreementAlgorithmSet/1,
getenc_OriginatorKeySet/1,
getenc_SupportedOtherRecipInfo/1,
getenc_AuthAttributeSet/1,
getenc_UnauthAttributeSet/1,
getenc_DigestAlgorithmSet/1,
getenc_SignatureAlgorithmSet/1,
getenc_KeyEncryptionAlgorithmSet/1,
getenc_ContentEncryptionAlgorithmSet/1,
getenc_MessageAuthenticationCodeAlgorithmSet/1,
getenc_SupportedOtherRevokInfo/1,
getenc_SupportedCertFormats/1,
getenc_SupportedKeyAttributes/1,
getenc_internal_object_set_argument_51/1,
getenc_internal_object_set_argument_50/1,
getenc_internal_object_set_argument_2/1,
getenc_internal_object_set_argument_38/1,
getenc_internal_object_set_argument_36/1,
getenc_internal_object_set_argument_34/1,
getenc_internal_object_set_argument_32/1,
getenc_internal_object_set_argument_31/1,
getenc_internal_object_set_argument_30/1,
getenc_internal_object_set_argument_48/1,
getenc_internal_object_set_argument_47/1,
getenc_internal_object_set_argument_46/1,
getenc_internal_object_set_argument_45/1,
getenc_internal_object_set_argument_44/1,
getenc_internal_object_set_argument_42/1,
getenc_internal_object_set_argument_40/1,
getenc_internal_object_set_argument_13/1,
getenc_internal_object_set_argument_11/1,
getenc_internal_object_set_argument_29/1
]).

-export([
getdec_ContentSet/1,
getdec_SignedAttributesSet/1,
getdec_UnsignedAttributes/1,
getdec_UnprotectedAttributes/1,
getdec_KeyTransportAlgorithmSet/1,
getdec_KeyAgreementAlgorithmSet/1,
getdec_OriginatorKeySet/1,
getdec_SupportedOtherRecipInfo/1,
getdec_AuthAttributeSet/1,
getdec_UnauthAttributeSet/1,
getdec_DigestAlgorithmSet/1,
getdec_SignatureAlgorithmSet/1,
getdec_KeyEncryptionAlgorithmSet/1,
getdec_ContentEncryptionAlgorithmSet/1,
getdec_MessageAuthenticationCodeAlgorithmSet/1,
getdec_SupportedOtherRevokInfo/1,
getdec_SupportedCertFormats/1,
getdec_SupportedKeyAttributes/1,
getdec_internal_object_set_argument_51/1,
getdec_internal_object_set_argument_50/1,
getdec_internal_object_set_argument_2/1,
getdec_internal_object_set_argument_38/1,
getdec_internal_object_set_argument_36/1,
getdec_internal_object_set_argument_34/1,
getdec_internal_object_set_argument_32/1,
getdec_internal_object_set_argument_31/1,
getdec_internal_object_set_argument_30/1,
getdec_internal_object_set_argument_48/1,
getdec_internal_object_set_argument_47/1,
getdec_internal_object_set_argument_46/1,
getdec_internal_object_set_argument_45/1,
getdec_internal_object_set_argument_44/1,
getdec_internal_object_set_argument_42/1,
getdec_internal_object_set_argument_40/1,
getdec_internal_object_set_argument_13/1,
getdec_internal_object_set_argument_11/1,
getdec_internal_object_set_argument_29/1
]).

-export([
'id-ct-contentInfo'/0,
'id-data'/0,
'id-signedData'/0,
'id-envelopedData'/0,
'id-digestedData'/0,
'id-encryptedData'/0,
'id-ct-authData'/0,
'id-contentType'/0,
'id-messageDigest'/0,
'id-signingTime'/0,
'id-countersignature'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('ContentType', Data) -> enc_ContentType(Data);
encode_disp('ContentInfo', Data) -> enc_ContentInfo(Data);
encode_disp('SignedData', Data) -> enc_SignedData(Data);
encode_disp('SignerInfos', Data) -> enc_SignerInfos(Data);
encode_disp('EncapsulatedContentInfo', Data) -> enc_EncapsulatedContentInfo(Data);
encode_disp('SignerInfo', Data) -> enc_SignerInfo(Data);
encode_disp('SignedAttributes', Data) -> enc_SignedAttributes(Data);
encode_disp('SignerIdentifier', Data) -> enc_SignerIdentifier(Data);
encode_disp('SignatureValue', Data) -> enc_SignatureValue(Data);
encode_disp('EnvelopedData', Data) -> enc_EnvelopedData(Data);
encode_disp('OriginatorInfo', Data) -> enc_OriginatorInfo(Data);
encode_disp('RecipientInfos', Data) -> enc_RecipientInfos(Data);
encode_disp('EncryptedContentInfo', Data) -> enc_EncryptedContentInfo(Data);
encode_disp('RecipientInfo', Data) -> enc_RecipientInfo(Data);
encode_disp('EncryptedKey', Data) -> enc_EncryptedKey(Data);
encode_disp('KeyTransRecipientInfo', Data) -> enc_KeyTransRecipientInfo(Data);
encode_disp('RecipientIdentifier', Data) -> enc_RecipientIdentifier(Data);
encode_disp('KeyAgreeRecipientInfo', Data) -> enc_KeyAgreeRecipientInfo(Data);
encode_disp('OriginatorIdentifierOrKey', Data) -> enc_OriginatorIdentifierOrKey(Data);
encode_disp('OriginatorPublicKey', Data) -> enc_OriginatorPublicKey(Data);
encode_disp('RecipientEncryptedKeys', Data) -> enc_RecipientEncryptedKeys(Data);
encode_disp('RecipientEncryptedKey', Data) -> enc_RecipientEncryptedKey(Data);
encode_disp('KeyAgreeRecipientIdentifier', Data) -> enc_KeyAgreeRecipientIdentifier(Data);
encode_disp('RecipientKeyIdentifier', Data) -> enc_RecipientKeyIdentifier(Data);
encode_disp('SubjectKeyIdentifier', Data) -> enc_SubjectKeyIdentifier(Data);
encode_disp('KEKRecipientInfo', Data) -> enc_KEKRecipientInfo(Data);
encode_disp('KEKIdentifier', Data) -> enc_KEKIdentifier(Data);
encode_disp('PasswordRecipientInfo', Data) -> enc_PasswordRecipientInfo(Data);
encode_disp('OtherRecipientInfo', Data) -> enc_OtherRecipientInfo(Data);
encode_disp('DigestedData', Data) -> enc_DigestedData(Data);
encode_disp('Digest', Data) -> enc_Digest(Data);
encode_disp('EncryptedData', Data) -> enc_EncryptedData(Data);
encode_disp('AuthenticatedData', Data) -> enc_AuthenticatedData(Data);
encode_disp('AuthAttributes', Data) -> enc_AuthAttributes(Data);
encode_disp('MessageAuthenticationCode', Data) -> enc_MessageAuthenticationCode(Data);
encode_disp('UnauthAttributes', Data) -> enc_UnauthAttributes(Data);
encode_disp('DigestAlgorithmIdentifier', Data) -> enc_DigestAlgorithmIdentifier(Data);
encode_disp('SignatureAlgorithmIdentifier', Data) -> enc_SignatureAlgorithmIdentifier(Data);
encode_disp('KeyEncryptionAlgorithmIdentifier', Data) -> enc_KeyEncryptionAlgorithmIdentifier(Data);
encode_disp('ContentEncryptionAlgorithmIdentifier', Data) -> enc_ContentEncryptionAlgorithmIdentifier(Data);
encode_disp('MessageAuthenticationCodeAlgorithm', Data) -> enc_MessageAuthenticationCodeAlgorithm(Data);
encode_disp('KeyDerivationAlgorithmIdentifier', Data) -> enc_KeyDerivationAlgorithmIdentifier(Data);
encode_disp('RevocationInfoChoices', Data) -> enc_RevocationInfoChoices(Data);
encode_disp('RevocationInfoChoice', Data) -> enc_RevocationInfoChoice(Data);
encode_disp('OtherRevocationInfoFormat', Data) -> enc_OtherRevocationInfoFormat(Data);
encode_disp('CertificateChoices', Data) -> enc_CertificateChoices(Data);
encode_disp('AttributeCertificateV2', Data) -> enc_AttributeCertificateV2(Data);
encode_disp('OtherCertificateFormat', Data) -> enc_OtherCertificateFormat(Data);
encode_disp('CertificateSet', Data) -> enc_CertificateSet(Data);
encode_disp('IssuerAndSerialNumber', Data) -> enc_IssuerAndSerialNumber(Data);
encode_disp('CMSVersion', Data) -> enc_CMSVersion(Data);
encode_disp('UserKeyingMaterial', Data) -> enc_UserKeyingMaterial(Data);
encode_disp('OtherKeyAttribute', Data) -> enc_OtherKeyAttribute(Data);
encode_disp('MessageDigest', Data) -> enc_MessageDigest(Data);
encode_disp('SigningTime', Data) -> enc_SigningTime(Data);
encode_disp('Time', Data) -> enc_Time(Data);
encode_disp('Countersignature', Data) -> enc_Countersignature(Data);
encode_disp('ExtendedCertificateOrCertificate', Data) -> enc_ExtendedCertificateOrCertificate(Data);
encode_disp('ExtendedCertificate', Data) -> enc_ExtendedCertificate(Data);
encode_disp('ExtendedCertificateInfo', Data) -> enc_ExtendedCertificateInfo(Data);
encode_disp('Signature', Data) -> enc_Signature(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('ContentType', Data) -> dec_ContentType(Data);
decode_disp('ContentInfo', Data) -> dec_ContentInfo(Data);
decode_disp('SignedData', Data) -> dec_SignedData(Data);
decode_disp('SignerInfos', Data) -> dec_SignerInfos(Data);
decode_disp('EncapsulatedContentInfo', Data) -> dec_EncapsulatedContentInfo(Data);
decode_disp('SignerInfo', Data) -> dec_SignerInfo(Data);
decode_disp('SignedAttributes', Data) -> dec_SignedAttributes(Data);
decode_disp('SignerIdentifier', Data) -> dec_SignerIdentifier(Data);
decode_disp('SignatureValue', Data) -> dec_SignatureValue(Data);
decode_disp('EnvelopedData', Data) -> dec_EnvelopedData(Data);
decode_disp('OriginatorInfo', Data) -> dec_OriginatorInfo(Data);
decode_disp('RecipientInfos', Data) -> dec_RecipientInfos(Data);
decode_disp('EncryptedContentInfo', Data) -> dec_EncryptedContentInfo(Data);
decode_disp('RecipientInfo', Data) -> dec_RecipientInfo(Data);
decode_disp('EncryptedKey', Data) -> dec_EncryptedKey(Data);
decode_disp('KeyTransRecipientInfo', Data) -> dec_KeyTransRecipientInfo(Data);
decode_disp('RecipientIdentifier', Data) -> dec_RecipientIdentifier(Data);
decode_disp('KeyAgreeRecipientInfo', Data) -> dec_KeyAgreeRecipientInfo(Data);
decode_disp('OriginatorIdentifierOrKey', Data) -> dec_OriginatorIdentifierOrKey(Data);
decode_disp('OriginatorPublicKey', Data) -> dec_OriginatorPublicKey(Data);
decode_disp('RecipientEncryptedKeys', Data) -> dec_RecipientEncryptedKeys(Data);
decode_disp('RecipientEncryptedKey', Data) -> dec_RecipientEncryptedKey(Data);
decode_disp('KeyAgreeRecipientIdentifier', Data) -> dec_KeyAgreeRecipientIdentifier(Data);
decode_disp('RecipientKeyIdentifier', Data) -> dec_RecipientKeyIdentifier(Data);
decode_disp('SubjectKeyIdentifier', Data) -> dec_SubjectKeyIdentifier(Data);
decode_disp('KEKRecipientInfo', Data) -> dec_KEKRecipientInfo(Data);
decode_disp('KEKIdentifier', Data) -> dec_KEKIdentifier(Data);
decode_disp('PasswordRecipientInfo', Data) -> dec_PasswordRecipientInfo(Data);
decode_disp('OtherRecipientInfo', Data) -> dec_OtherRecipientInfo(Data);
decode_disp('DigestedData', Data) -> dec_DigestedData(Data);
decode_disp('Digest', Data) -> dec_Digest(Data);
decode_disp('EncryptedData', Data) -> dec_EncryptedData(Data);
decode_disp('AuthenticatedData', Data) -> dec_AuthenticatedData(Data);
decode_disp('AuthAttributes', Data) -> dec_AuthAttributes(Data);
decode_disp('MessageAuthenticationCode', Data) -> dec_MessageAuthenticationCode(Data);
decode_disp('UnauthAttributes', Data) -> dec_UnauthAttributes(Data);
decode_disp('DigestAlgorithmIdentifier', Data) -> dec_DigestAlgorithmIdentifier(Data);
decode_disp('SignatureAlgorithmIdentifier', Data) -> dec_SignatureAlgorithmIdentifier(Data);
decode_disp('KeyEncryptionAlgorithmIdentifier', Data) -> dec_KeyEncryptionAlgorithmIdentifier(Data);
decode_disp('ContentEncryptionAlgorithmIdentifier', Data) -> dec_ContentEncryptionAlgorithmIdentifier(Data);
decode_disp('MessageAuthenticationCodeAlgorithm', Data) -> dec_MessageAuthenticationCodeAlgorithm(Data);
decode_disp('KeyDerivationAlgorithmIdentifier', Data) -> dec_KeyDerivationAlgorithmIdentifier(Data);
decode_disp('RevocationInfoChoices', Data) -> dec_RevocationInfoChoices(Data);
decode_disp('RevocationInfoChoice', Data) -> dec_RevocationInfoChoice(Data);
decode_disp('OtherRevocationInfoFormat', Data) -> dec_OtherRevocationInfoFormat(Data);
decode_disp('CertificateChoices', Data) -> dec_CertificateChoices(Data);
decode_disp('AttributeCertificateV2', Data) -> dec_AttributeCertificateV2(Data);
decode_disp('OtherCertificateFormat', Data) -> dec_OtherCertificateFormat(Data);
decode_disp('CertificateSet', Data) -> dec_CertificateSet(Data);
decode_disp('IssuerAndSerialNumber', Data) -> dec_IssuerAndSerialNumber(Data);
decode_disp('CMSVersion', Data) -> dec_CMSVersion(Data);
decode_disp('UserKeyingMaterial', Data) -> dec_UserKeyingMaterial(Data);
decode_disp('OtherKeyAttribute', Data) -> dec_OtherKeyAttribute(Data);
decode_disp('MessageDigest', Data) -> dec_MessageDigest(Data);
decode_disp('SigningTime', Data) -> dec_SigningTime(Data);
decode_disp('Time', Data) -> dec_Time(Data);
decode_disp('Countersignature', Data) -> dec_Countersignature(Data);
decode_disp('ExtendedCertificateOrCertificate', Data) -> dec_ExtendedCertificateOrCertificate(Data);
decode_disp('ExtendedCertificate', Data) -> dec_ExtendedCertificate(Data);
decode_disp('ExtendedCertificateInfo', Data) -> dec_ExtendedCertificateInfo(Data);
decode_disp('Signature', Data) -> dec_Signature(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  ContentType
%%================================
enc_ContentType(Val) ->
    enc_ContentType(Val, [<<6>>]).

enc_ContentType(Val, TagIn) ->
encode_object_identifier(Val, TagIn).


dec_ContentType(Tlv) ->
   dec_ContentType(Tlv, [6]).

dec_ContentType(Tlv, TagIn) ->
decode_object_identifier(Tlv, TagIn).



%%================================
%%  ContentInfo
%%================================
enc_ContentInfo(Val) ->
    enc_ContentInfo(Val, [<<48>>]).

enc_ContentInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
ObjcontentType = 
   'CryptographicMessageSyntax-2009':'getenc_ContentSet'(                                   Cindex1),

%%-------------------------------------------------
%% attribute contentType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute content(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = ObjcontentType('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [<<160>>])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ContentInfo(Tlv) ->
   dec_ContentInfo(Tlv, [16]).

dec_ContentInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute contentType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute content(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, [131072]),

DecObjcontentTypeTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_ContentSet'(Term1),
Term2 = 
   case (catch DecObjcontentTypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ContentInfo',Term1,Term2},
Res1.


%%================================
%%  SignedData
%%================================
enc_SignedData(Val) ->
    enc_SignedData(Val, [<<48>>]).

enc_SignedData(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}], [<<2>>]),

%%-------------------------------------------------
%% attribute digestAlgorithms(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SignedData_digestAlgorithms'(Cindex2, [<<49>>]),

%%-------------------------------------------------
%% attribute encapContentInfo(3)   External CryptographicMessageSyntax-2009:EncapsulatedContentInfo
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_EncapsulatedContentInfo'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute certificates(4)   External CryptographicMessageSyntax-2009:CertificateSet OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CertificateSet'(Cindex4, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute crls(5)   External CryptographicMessageSyntax-2009:RevocationInfoChoices OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_RevocationInfoChoices'(Cindex5, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute signerInfos(6)   External CryptographicMessageSyntax-2009:SignerInfos
%%-------------------------------------------------
   {EncBytes6,EncLen6} = 'enc_SignerInfos'(Cindex6, [<<49>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SignedData_digestAlgorithms
%%================================
enc_SignedData_digestAlgorithms(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SignedData_digestAlgorithms_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignedData_digestAlgorithms_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SignedData_digestAlgorithms_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_DigestAlgorithmIdentifier'(H, [<<48>>]),
   'enc_SignedData_digestAlgorithms_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_SignedData(Tlv) ->
   dec_SignedData(Tlv, [16]).

dec_SignedData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}])
end
,

%%-------------------------------------------------
%% attribute digestAlgorithms(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SignedData_digestAlgorithms'(V2, [17]),

%%-------------------------------------------------
%% attribute encapContentInfo(3)   External CryptographicMessageSyntax-2009:EncapsulatedContentInfo
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_EncapsulatedContentInfo'(V3, [16]),

%%-------------------------------------------------
%% attribute certificates(4)   External CryptographicMessageSyntax-2009:CertificateSet OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131072,V4}|TempTlv5] ->
    {'dec_CertificateSet'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute crls(5)   External CryptographicMessageSyntax-2009:RevocationInfoChoices OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131073,V5}|TempTlv6] ->
    {'dec_RevocationInfoChoices'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute signerInfos(6)   External CryptographicMessageSyntax-2009:SignerInfos
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = 'dec_SignerInfos'(V6, [17]),

case Tlv7 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv7}}}) % extra fields not allowed
end,
Res1 = {'SignedData',Term1,Term2,Term3,Term4,Term5,Term6},
Res1.
'dec_SignedData_digestAlgorithms'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_DigestAlgorithmIdentifier'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  SignerInfos
%%================================
enc_SignerInfos(Val) ->
    enc_SignerInfos(Val, [<<49>>]).

enc_SignerInfos(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_SignerInfos_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignerInfos_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SignerInfos_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SignerInfo'(H, [<<48>>]),
   'enc_SignerInfos_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_SignerInfos(Tlv) ->
   dec_SignerInfos(Tlv, [17]).

dec_SignerInfos(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SignerInfo'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  EncapsulatedContentInfo
%%================================
enc_EncapsulatedContentInfo(Val) ->
    enc_EncapsulatedContentInfo(Val, [<<48>>]).

enc_EncapsulatedContentInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute eContentType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute eContent(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<4>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_EncapsulatedContentInfo(Tlv) ->
   dec_EncapsulatedContentInfo(Tlv, [16]).

dec_EncapsulatedContentInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute eContentType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute eContent(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {decode_octet_string(V2, [4]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'EncapsulatedContentInfo',Term1,Term2},
Res1.


%%================================
%%  SignerInfo
%%================================
enc_SignerInfo(Val) ->
    enc_SignerInfo(Val, [<<48>>]).

enc_SignerInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}], [<<2>>]),

%%-------------------------------------------------
%% attribute sid(2)   External CryptographicMessageSyntax-2009:SignerIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SignerIdentifier'(Cindex2, []),

%%-------------------------------------------------
%% attribute digestAlgorithm(3)   External CryptographicMessageSyntax-2009:DigestAlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_DigestAlgorithmIdentifier'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute signedAttrs(4)   External CryptographicMessageSyntax-2009:SignedAttributes OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SignedAttributes'(Cindex4, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute signatureAlgorithm(5)   External CryptographicMessageSyntax-2009:SignatureAlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes5,EncLen5} = 'enc_SignatureAlgorithmIdentifier'(Cindex5, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(6) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes6,EncLen6} = encode_restricted_string(Cindex6, [<<4>>]),

%%-------------------------------------------------
%% attribute unsignedAttrs(7) with type SET OF OPTIONAL
%%-------------------------------------------------
   {EncBytes7,EncLen7} =  case Cindex7 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SignerInfo_unsignedAttrs'(Cindex7, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SignerInfo_unsignedAttrs
%%================================
enc_SignerInfo_unsignedAttrs(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SignerInfo_unsignedAttrs_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignerInfo_unsignedAttrs_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SignerInfo_unsignedAttrs_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SignerInfo_unsignedAttrs_Attribute'(H, [<<48>>]),
   'enc_SignerInfo_unsignedAttrs_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  SignerInfo_unsignedAttrs_Attribute
%%================================
enc_SignerInfo_unsignedAttrs_Attribute(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
ObjattrType = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_32'(                                   Cindex1),

%%-------------------------------------------------
%% attribute attrType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute attrValues(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SignerInfo_unsignedAttrs_Attribute_attrValues'(Cindex2, [<<49>>], ObjattrType),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SignerInfo_unsignedAttrs_Attribute_attrValues
%%================================
enc_SignerInfo_unsignedAttrs_Attribute_attrValues(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_SignerInfo_unsignedAttrs_Attribute_attrValues_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignerInfo_unsignedAttrs_Attribute_attrValues_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SignerInfo_unsignedAttrs_Attribute_attrValues_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_SignerInfo_unsignedAttrs_Attribute_attrValues_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_SignerInfo(Tlv) ->
   dec_SignerInfo(Tlv, [16]).

dec_SignerInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}])
end
,

%%-------------------------------------------------
%% attribute sid(2)   External CryptographicMessageSyntax-2009:SignerIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SignerIdentifier'(V2, []),

%%-------------------------------------------------
%% attribute digestAlgorithm(3)   External CryptographicMessageSyntax-2009:DigestAlgorithmIdentifier
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_DigestAlgorithmIdentifier'(V3, [16]),

%%-------------------------------------------------
%% attribute signedAttrs(4)   External CryptographicMessageSyntax-2009:SignedAttributes OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131072,V4}|TempTlv5] ->
    {'dec_SignedAttributes'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute signatureAlgorithm(5)   External CryptographicMessageSyntax-2009:SignatureAlgorithmIdentifier
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = 'dec_SignatureAlgorithmIdentifier'(V5, [16]),

%%-------------------------------------------------
%% attribute signature(6) with type OCTET STRING
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = decode_octet_string(V6, [4]),

%%-------------------------------------------------
%% attribute unsignedAttrs(7) with type SET OF OPTIONAL
%%-------------------------------------------------
{Term7,Tlv8} = case Tlv7 of
[{131073,V7}|TempTlv8] ->
    {'dec_SignerInfo_unsignedAttrs'(V7, []), TempTlv8};
    _ ->
        { asn1_NOVALUE, Tlv7}
end,

case Tlv8 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv8}}}) % extra fields not allowed
end,
Res1 = {'SignerInfo',Term1,Term2,Term3,Term4,Term5,Term6,Term7},
Res1.
'dec_SignerInfo_unsignedAttrs'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SignerInfo_unsignedAttrs_Attribute'(V1, [16]) || V1 <- Tlv1].


'dec_SignerInfo_unsignedAttrs_Attribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute attrType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_32'(Term1),

%%-------------------------------------------------
%% attribute attrValues(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SignerInfo_unsignedAttrs_Attribute_attrValues'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Attribute',Term1,Term2},
Res1.
'dec_SignerInfo_unsignedAttrs_Attribute_attrValues'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].




%%================================
%%  SignedAttributes
%%================================
enc_SignedAttributes(Val) ->
    enc_SignedAttributes(Val, [<<49>>]).

enc_SignedAttributes(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_SignedAttributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignedAttributes_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SignedAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SignedAttributes_Attribute'(H, [<<48>>]),
   'enc_SignedAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  SignedAttributes_Attribute
%%================================
enc_SignedAttributes_Attribute(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
ObjattrType = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_30'(                                   Cindex1),

%%-------------------------------------------------
%% attribute attrType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute attrValues(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SignedAttributes_Attribute_attrValues'(Cindex2, [<<49>>], ObjattrType),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SignedAttributes_Attribute_attrValues
%%================================
enc_SignedAttributes_Attribute_attrValues(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_SignedAttributes_Attribute_attrValues_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignedAttributes_Attribute_attrValues_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SignedAttributes_Attribute_attrValues_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_SignedAttributes_Attribute_attrValues_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_SignedAttributes(Tlv) ->
   dec_SignedAttributes(Tlv, [17]).

dec_SignedAttributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SignedAttributes_Attribute'(V1, [16]) || V1 <- Tlv1].


'dec_SignedAttributes_Attribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute attrType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_30'(Term1),

%%-------------------------------------------------
%% attribute attrValues(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SignedAttributes_Attribute_attrValues'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Attribute',Term1,Term2},
Res1.
'dec_SignedAttributes_Attribute_attrValues'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].




%%================================
%%  SignerIdentifier
%%================================
enc_SignerIdentifier(Val) ->
    enc_SignerIdentifier(Val, []).

enc_SignerIdentifier(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      issuerAndSerialNumber ->
         'enc_IssuerAndSerialNumber'(element(2,Val), [<<48>>]);
      subjectKeyIdentifier ->
         encode_restricted_string(element(2,Val), [<<128>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_SignerIdentifier(Tlv) ->
   dec_SignerIdentifier(Tlv, []).

dec_SignerIdentifier(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'issuerAndSerialNumber'
    {16, V1} -> 
        {issuerAndSerialNumber, 'dec_IssuerAndSerialNumber'(V1, [])};


%% 'subjectKeyIdentifier'
    {131072, V1} -> 
        {subjectKeyIdentifier, decode_octet_string(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  SignatureValue
%%================================
enc_SignatureValue(Val) ->
    enc_SignatureValue(Val, [<<4>>]).

enc_SignatureValue(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_SignatureValue(Tlv) ->
   dec_SignatureValue(Tlv, [4]).

dec_SignatureValue(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  EnvelopedData
%%================================
enc_EnvelopedData(Val) ->
    enc_EnvelopedData(Val, [<<48>>]).

enc_EnvelopedData(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}], [<<2>>]),

%%-------------------------------------------------
%% attribute originatorInfo(2)   External CryptographicMessageSyntax-2009:OriginatorInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OriginatorInfo'(Cindex2, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute recipientInfos(3)   External CryptographicMessageSyntax-2009:RecipientInfos
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_RecipientInfos'(Cindex3, [<<49>>]),

%%-------------------------------------------------
%% attribute encryptedContentInfo(4)   External CryptographicMessageSyntax-2009:EncryptedContentInfo
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_EncryptedContentInfo'(Cindex4, [<<48>>]),

%%-------------------------------------------------
%% attribute unprotectedAttrs(5) with type SET OF OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_EnvelopedData_unprotectedAttrs'(Cindex5, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EnvelopedData_unprotectedAttrs
%%================================
enc_EnvelopedData_unprotectedAttrs(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_EnvelopedData_unprotectedAttrs_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_EnvelopedData_unprotectedAttrs_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_EnvelopedData_unprotectedAttrs_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_EnvelopedData_unprotectedAttrs_Attribute'(H, [<<48>>]),
   'enc_EnvelopedData_unprotectedAttrs_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  EnvelopedData_unprotectedAttrs_Attribute
%%================================
enc_EnvelopedData_unprotectedAttrs_Attribute(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
ObjattrType = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_46'(                                   Cindex1),

%%-------------------------------------------------
%% attribute attrType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute attrValues(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_EnvelopedData_unprotectedAttrs_Attribute_attrValues'(Cindex2, [<<49>>], ObjattrType),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EnvelopedData_unprotectedAttrs_Attribute_attrValues
%%================================
enc_EnvelopedData_unprotectedAttrs_Attribute_attrValues(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_EnvelopedData_unprotectedAttrs_Attribute_attrValues_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_EnvelopedData_unprotectedAttrs_Attribute_attrValues_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_EnvelopedData_unprotectedAttrs_Attribute_attrValues_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_EnvelopedData_unprotectedAttrs_Attribute_attrValues_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_EnvelopedData(Tlv) ->
   dec_EnvelopedData(Tlv, [16]).

dec_EnvelopedData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}])
end
,

%%-------------------------------------------------
%% attribute originatorInfo(2)   External CryptographicMessageSyntax-2009:OriginatorInfo OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_OriginatorInfo'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute recipientInfos(3)   External CryptographicMessageSyntax-2009:RecipientInfos
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_RecipientInfos'(V3, [17]),

%%-------------------------------------------------
%% attribute encryptedContentInfo(4)   External CryptographicMessageSyntax-2009:EncryptedContentInfo
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_EncryptedContentInfo'(V4, [16]),

%%-------------------------------------------------
%% attribute unprotectedAttrs(5) with type SET OF OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131073,V5}|TempTlv6] ->
    {'dec_EnvelopedData_unprotectedAttrs'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'EnvelopedData',Term1,Term2,Term3,Term4,Term5},
Res1.
'dec_EnvelopedData_unprotectedAttrs'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_EnvelopedData_unprotectedAttrs_Attribute'(V1, [16]) || V1 <- Tlv1].


'dec_EnvelopedData_unprotectedAttrs_Attribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute attrType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_46'(Term1),

%%-------------------------------------------------
%% attribute attrValues(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_EnvelopedData_unprotectedAttrs_Attribute_attrValues'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Attribute',Term1,Term2},
Res1.
'dec_EnvelopedData_unprotectedAttrs_Attribute_attrValues'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].




%%================================
%%  OriginatorInfo
%%================================
enc_OriginatorInfo(Val) ->
    enc_OriginatorInfo(Val, [<<48>>]).

enc_OriginatorInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute certs(1)   External CryptographicMessageSyntax-2009:CertificateSet OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CertificateSet'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute crls(2)   External CryptographicMessageSyntax-2009:RevocationInfoChoices OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_RevocationInfoChoices'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OriginatorInfo(Tlv) ->
   dec_OriginatorInfo(Tlv, [16]).

dec_OriginatorInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certs(1)   External CryptographicMessageSyntax-2009:CertificateSet OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_CertificateSet'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute crls(2)   External CryptographicMessageSyntax-2009:RevocationInfoChoices OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_RevocationInfoChoices'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OriginatorInfo',Term1,Term2},
Res1.


%%================================
%%  RecipientInfos
%%================================
enc_RecipientInfos(Val) ->
    enc_RecipientInfos(Val, [<<49>>]).

enc_RecipientInfos(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_RecipientInfos_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RecipientInfos_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_RecipientInfos_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_RecipientInfo'(H, []),
   'enc_RecipientInfos_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_RecipientInfos(Tlv) ->
   dec_RecipientInfos(Tlv, [17]).

dec_RecipientInfos(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_RecipientInfo'(V1, []) || V1 <- Tlv1].




%%================================
%%  EncryptedContentInfo
%%================================
enc_EncryptedContentInfo(Val) ->
    enc_EncryptedContentInfo(Val, [<<48>>]).

enc_EncryptedContentInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute contentType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute contentEncryptionAlgorithm(2)   External CryptographicMessageSyntax-2009:ContentEncryptionAlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_ContentEncryptionAlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute encryptedContent(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<128>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_EncryptedContentInfo(Tlv) ->
   dec_EncryptedContentInfo(Tlv, [16]).

dec_EncryptedContentInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute contentType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute contentEncryptionAlgorithm(2)   External CryptographicMessageSyntax-2009:ContentEncryptionAlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_ContentEncryptionAlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute encryptedContent(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131072,V3}|TempTlv4] ->
    {decode_octet_string(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'EncryptedContentInfo',Term1,Term2,Term3},
Res1.


%%================================
%%  RecipientInfo
%%================================
enc_RecipientInfo(Val) ->
    enc_RecipientInfo(Val, []).

enc_RecipientInfo(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      ktri ->
         'enc_KeyTransRecipientInfo'(element(2,Val), [<<48>>]);
      kari ->
         'enc_KeyAgreeRecipientInfo'(element(2,Val), [<<161>>]);
      kekri ->
         'enc_KEKRecipientInfo'(element(2,Val), [<<162>>]);
      pwri ->
         'enc_PasswordRecipientInfo'(element(2,Val), [<<163>>]);
      ori ->
         'enc_OtherRecipientInfo'(element(2,Val), [<<164>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_RecipientInfo(Tlv) ->
   dec_RecipientInfo(Tlv, []).

dec_RecipientInfo(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'ktri'
    {16, V1} -> 
        {ktri, 'dec_KeyTransRecipientInfo'(V1, [])};


%% 'kari'
    {131073, V1} -> 
        {kari, 'dec_KeyAgreeRecipientInfo'(V1, [])};


%% 'kekri'
    {131074, V1} -> 
        {kekri, 'dec_KEKRecipientInfo'(V1, [])};


%% 'pwri'
    {131075, V1} -> 
        {pwri, 'dec_PasswordRecipientInfo'(V1, [])};


%% 'ori'
    {131076, V1} -> 
        {ori, 'dec_OtherRecipientInfo'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  EncryptedKey
%%================================
enc_EncryptedKey(Val) ->
    enc_EncryptedKey(Val, [<<4>>]).

enc_EncryptedKey(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_EncryptedKey(Tlv) ->
   dec_EncryptedKey(Tlv, [4]).

dec_EncryptedKey(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  KeyTransRecipientInfo
%%================================
enc_KeyTransRecipientInfo(Val) ->
    enc_KeyTransRecipientInfo(Val, [<<48>>]).

enc_KeyTransRecipientInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}], [<<2>>]),

%%-------------------------------------------------
%% attribute rid(2)   External CryptographicMessageSyntax-2009:RecipientIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_RecipientIdentifier'(Cindex2, []),

%%-------------------------------------------------
%% attribute keyEncryptionAlgorithm(3) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_KeyTransRecipientInfo_keyEncryptionAlgorithm'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute encryptedKey(4) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_restricted_string(Cindex4, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  KeyTransRecipientInfo_keyEncryptionAlgorithm
%%================================
enc_KeyTransRecipientInfo_keyEncryptionAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_34'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_KeyTransRecipientInfo(Tlv) ->
   dec_KeyTransRecipientInfo(Tlv, [16]).

dec_KeyTransRecipientInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}])
end
,

%%-------------------------------------------------
%% attribute rid(2)   External CryptographicMessageSyntax-2009:RecipientIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_RecipientIdentifier'(V2, []),

%%-------------------------------------------------
%% attribute keyEncryptionAlgorithm(3) with type SEQUENCE
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_KeyTransRecipientInfo_keyEncryptionAlgorithm'(V3, [16]),

%%-------------------------------------------------
%% attribute encryptedKey(4) with type OCTET STRING
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_octet_string(V4, [4]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'KeyTransRecipientInfo',Term1,Term2,Term3,Term4},
Res1.
'dec_KeyTransRecipientInfo_keyEncryptionAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_34'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'KeyTransRecipientInfo_keyEncryptionAlgorithm',Term1,Term2},
Res1.


%%================================
%%  RecipientIdentifier
%%================================
enc_RecipientIdentifier(Val) ->
    enc_RecipientIdentifier(Val, []).

enc_RecipientIdentifier(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      issuerAndSerialNumber ->
         'enc_IssuerAndSerialNumber'(element(2,Val), [<<48>>]);
      subjectKeyIdentifier ->
         encode_restricted_string(element(2,Val), [<<128>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_RecipientIdentifier(Tlv) ->
   dec_RecipientIdentifier(Tlv, []).

dec_RecipientIdentifier(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'issuerAndSerialNumber'
    {16, V1} -> 
        {issuerAndSerialNumber, 'dec_IssuerAndSerialNumber'(V1, [])};


%% 'subjectKeyIdentifier'
    {131072, V1} -> 
        {subjectKeyIdentifier, decode_octet_string(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  KeyAgreeRecipientInfo
%%================================
enc_KeyAgreeRecipientInfo(Val) ->
    enc_KeyAgreeRecipientInfo(Val, [<<48>>]).

enc_KeyAgreeRecipientInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}], [<<2>>]),

%%-------------------------------------------------
%% attribute originator(2)   External CryptographicMessageSyntax-2009:OriginatorIdentifierOrKey
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_OriginatorIdentifierOrKey'(Cindex2, [<<160>>]),

%%-------------------------------------------------
%% attribute ukm(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<4>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute keyEncryptionAlgorithm(4) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_KeyAgreeRecipientInfo_keyEncryptionAlgorithm'(Cindex4, [<<48>>]),

%%-------------------------------------------------
%% attribute recipientEncryptedKeys(5)   External CryptographicMessageSyntax-2009:RecipientEncryptedKeys
%%-------------------------------------------------
   {EncBytes5,EncLen5} = 'enc_RecipientEncryptedKeys'(Cindex5, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  KeyAgreeRecipientInfo_keyEncryptionAlgorithm
%%================================
enc_KeyAgreeRecipientInfo_keyEncryptionAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_38'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_KeyAgreeRecipientInfo(Tlv) ->
   dec_KeyAgreeRecipientInfo(Tlv, [16]).

dec_KeyAgreeRecipientInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}])
end
,

%%-------------------------------------------------
%% attribute originator(2)   External CryptographicMessageSyntax-2009:OriginatorIdentifierOrKey
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_OriginatorIdentifierOrKey'(V2, [131072]),

%%-------------------------------------------------
%% attribute ukm(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {decode_octet_string(V3, [4]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute keyEncryptionAlgorithm(4) with type SEQUENCE
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_KeyAgreeRecipientInfo_keyEncryptionAlgorithm'(V4, [16]),

%%-------------------------------------------------
%% attribute recipientEncryptedKeys(5)   External CryptographicMessageSyntax-2009:RecipientEncryptedKeys
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = 'dec_RecipientEncryptedKeys'(V5, [16]),

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'KeyAgreeRecipientInfo',Term1,Term2,Term3,Term4,Term5},
Res1.
'dec_KeyAgreeRecipientInfo_keyEncryptionAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_38'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'KeyAgreeRecipientInfo_keyEncryptionAlgorithm',Term1,Term2},
Res1.


%%================================
%%  OriginatorIdentifierOrKey
%%================================
enc_OriginatorIdentifierOrKey(Val) ->
    enc_OriginatorIdentifierOrKey(Val, []).

enc_OriginatorIdentifierOrKey(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      issuerAndSerialNumber ->
         'enc_IssuerAndSerialNumber'(element(2,Val), [<<48>>]);
      subjectKeyIdentifier ->
         encode_restricted_string(element(2,Val), [<<128>>]);
      originatorKey ->
         'enc_OriginatorPublicKey'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_OriginatorIdentifierOrKey(Tlv) ->
   dec_OriginatorIdentifierOrKey(Tlv, []).

dec_OriginatorIdentifierOrKey(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'issuerAndSerialNumber'
    {16, V1} -> 
        {issuerAndSerialNumber, 'dec_IssuerAndSerialNumber'(V1, [])};


%% 'subjectKeyIdentifier'
    {131072, V1} -> 
        {subjectKeyIdentifier, decode_octet_string(V1, [])};


%% 'originatorKey'
    {131073, V1} -> 
        {originatorKey, 'dec_OriginatorPublicKey'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  OriginatorPublicKey
%%================================
enc_OriginatorPublicKey(Val) ->
    enc_OriginatorPublicKey(Val, [<<48>>]).

enc_OriginatorPublicKey(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute algorithm(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_OriginatorPublicKey_algorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute publicKey(2) with type BIT STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_unnamed_bit_string(Cindex2, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  OriginatorPublicKey_algorithm
%%================================
enc_OriginatorPublicKey_algorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_36'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OriginatorPublicKey(Tlv) ->
   dec_OriginatorPublicKey(Tlv, [16]).

dec_OriginatorPublicKey(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_OriginatorPublicKey_algorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute publicKey(2) with type BIT STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_native_bit_string(V2, [3]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OriginatorPublicKey',Term1,Term2},
Res1.
'dec_OriginatorPublicKey_algorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_36'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OriginatorPublicKey_algorithm',Term1,Term2},
Res1.


%%================================
%%  RecipientEncryptedKeys
%%================================
enc_RecipientEncryptedKeys(Val) ->
    enc_RecipientEncryptedKeys(Val, [<<48>>]).

enc_RecipientEncryptedKeys(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_RecipientEncryptedKeys_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RecipientEncryptedKeys_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_RecipientEncryptedKeys_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_RecipientEncryptedKey'(H, [<<48>>]),
   'enc_RecipientEncryptedKeys_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_RecipientEncryptedKeys(Tlv) ->
   dec_RecipientEncryptedKeys(Tlv, [16]).

dec_RecipientEncryptedKeys(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_RecipientEncryptedKey'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  RecipientEncryptedKey
%%================================
enc_RecipientEncryptedKey(Val) ->
    enc_RecipientEncryptedKey(Val, [<<48>>]).

enc_RecipientEncryptedKey(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute rid(1)   External CryptographicMessageSyntax-2009:KeyAgreeRecipientIdentifier
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_KeyAgreeRecipientIdentifier'(Cindex1, []),

%%-------------------------------------------------
%% attribute encryptedKey(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RecipientEncryptedKey(Tlv) ->
   dec_RecipientEncryptedKey(Tlv, [16]).

dec_RecipientEncryptedKey(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute rid(1)   External CryptographicMessageSyntax-2009:KeyAgreeRecipientIdentifier
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_KeyAgreeRecipientIdentifier'(V1, []),

%%-------------------------------------------------
%% attribute encryptedKey(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RecipientEncryptedKey',Term1,Term2},
Res1.


%%================================
%%  KeyAgreeRecipientIdentifier
%%================================
enc_KeyAgreeRecipientIdentifier(Val) ->
    enc_KeyAgreeRecipientIdentifier(Val, []).

enc_KeyAgreeRecipientIdentifier(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      issuerAndSerialNumber ->
         'enc_IssuerAndSerialNumber'(element(2,Val), [<<48>>]);
      rKeyId ->
         'enc_RecipientKeyIdentifier'(element(2,Val), [<<160>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_KeyAgreeRecipientIdentifier(Tlv) ->
   dec_KeyAgreeRecipientIdentifier(Tlv, []).

dec_KeyAgreeRecipientIdentifier(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'issuerAndSerialNumber'
    {16, V1} -> 
        {issuerAndSerialNumber, 'dec_IssuerAndSerialNumber'(V1, [])};


%% 'rKeyId'
    {131072, V1} -> 
        {rKeyId, 'dec_RecipientKeyIdentifier'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  RecipientKeyIdentifier
%%================================
enc_RecipientKeyIdentifier(Val) ->
    enc_RecipientKeyIdentifier(Val, [<<48>>]).

enc_RecipientKeyIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute subjectKeyIdentifier(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute date(2) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<24>>])
       end,

%%-------------------------------------------------
%% attribute other(3)   External CryptographicMessageSyntax-2009:OtherKeyAttribute OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OtherKeyAttribute'(Cindex3, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RecipientKeyIdentifier(Tlv) ->
   dec_RecipientKeyIdentifier(Tlv, [16]).

dec_RecipientKeyIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute subjectKeyIdentifier(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_octet_string(V1, [4]),

%%-------------------------------------------------
%% attribute date(2) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{24,V2}|TempTlv3] ->
    {begin
binary_to_list(decode_restricted_string(V2, []))
end
, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute other(3)   External CryptographicMessageSyntax-2009:OtherKeyAttribute OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_OtherKeyAttribute'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'RecipientKeyIdentifier',Term1,Term2,Term3},
Res1.


%%================================
%%  SubjectKeyIdentifier
%%================================
enc_SubjectKeyIdentifier(Val) ->
    enc_SubjectKeyIdentifier(Val, [<<4>>]).

enc_SubjectKeyIdentifier(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_SubjectKeyIdentifier(Tlv) ->
   dec_SubjectKeyIdentifier(Tlv, [4]).

dec_SubjectKeyIdentifier(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  KEKRecipientInfo
%%================================
enc_KEKRecipientInfo(Val) ->
    enc_KEKRecipientInfo(Val, [<<48>>]).

enc_KEKRecipientInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}], [<<2>>]),

%%-------------------------------------------------
%% attribute kekid(2)   External CryptographicMessageSyntax-2009:KEKIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_KEKIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute keyEncryptionAlgorithm(3)   External CryptographicMessageSyntax-2009:KeyEncryptionAlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_KeyEncryptionAlgorithmIdentifier'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute encryptedKey(4) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_restricted_string(Cindex4, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_KEKRecipientInfo(Tlv) ->
   dec_KEKRecipientInfo(Tlv, [16]).

dec_KEKRecipientInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}])
end
,

%%-------------------------------------------------
%% attribute kekid(2)   External CryptographicMessageSyntax-2009:KEKIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_KEKIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute keyEncryptionAlgorithm(3)   External CryptographicMessageSyntax-2009:KeyEncryptionAlgorithmIdentifier
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_KeyEncryptionAlgorithmIdentifier'(V3, [16]),

%%-------------------------------------------------
%% attribute encryptedKey(4) with type OCTET STRING
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_octet_string(V4, [4]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'KEKRecipientInfo',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  KEKIdentifier
%%================================
enc_KEKIdentifier(Val) ->
    enc_KEKIdentifier(Val, [<<48>>]).

enc_KEKIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute keyIdentifier(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute date(2) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<24>>])
       end,

%%-------------------------------------------------
%% attribute other(3)   External CryptographicMessageSyntax-2009:OtherKeyAttribute OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OtherKeyAttribute'(Cindex3, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_KEKIdentifier(Tlv) ->
   dec_KEKIdentifier(Tlv, [16]).

dec_KEKIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute keyIdentifier(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_octet_string(V1, [4]),

%%-------------------------------------------------
%% attribute date(2) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{24,V2}|TempTlv3] ->
    {begin
binary_to_list(decode_restricted_string(V2, []))
end
, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute other(3)   External CryptographicMessageSyntax-2009:OtherKeyAttribute OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_OtherKeyAttribute'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'KEKIdentifier',Term1,Term2,Term3},
Res1.


%%================================
%%  PasswordRecipientInfo
%%================================
enc_PasswordRecipientInfo(Val) ->
    enc_PasswordRecipientInfo(Val, [<<48>>]).

enc_PasswordRecipientInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}], [<<2>>]),

%%-------------------------------------------------
%% attribute keyDerivationAlgorithm(2)   External CryptographicMessageSyntax-2009:KeyDerivationAlgorithmIdentifier OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_KeyDerivationAlgorithmIdentifier'(Cindex2, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute keyEncryptionAlgorithm(3)   External CryptographicMessageSyntax-2009:KeyEncryptionAlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_KeyEncryptionAlgorithmIdentifier'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute encryptedKey(4) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_restricted_string(Cindex4, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PasswordRecipientInfo(Tlv) ->
   dec_PasswordRecipientInfo(Tlv, [16]).

dec_PasswordRecipientInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}])
end
,

%%-------------------------------------------------
%% attribute keyDerivationAlgorithm(2)   External CryptographicMessageSyntax-2009:KeyDerivationAlgorithmIdentifier OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_KeyDerivationAlgorithmIdentifier'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute keyEncryptionAlgorithm(3)   External CryptographicMessageSyntax-2009:KeyEncryptionAlgorithmIdentifier
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_KeyEncryptionAlgorithmIdentifier'(V3, [16]),

%%-------------------------------------------------
%% attribute encryptedKey(4) with type OCTET STRING
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_octet_string(V4, [4]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'PasswordRecipientInfo',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  OtherRecipientInfo
%%================================
enc_OtherRecipientInfo(Val) ->
    enc_OtherRecipientInfo(Val, [<<48>>]).

enc_OtherRecipientInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
ObjoriType = 
   'CryptographicMessageSyntax-2009':'getenc_SupportedOtherRecipInfo'(                                   Cindex1),

%%-------------------------------------------------
%% attribute oriType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute oriValue(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = ObjoriType('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OtherRecipientInfo(Tlv) ->
   dec_OtherRecipientInfo(Tlv, [16]).

dec_OtherRecipientInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute oriType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute oriValue(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjoriTypeTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_SupportedOtherRecipInfo'(Term1),
Term2 = 
   case (catch DecObjoriTypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OtherRecipientInfo',Term1,Term2},
Res1.


%%================================
%%  DigestedData
%%================================
enc_DigestedData(Val) ->
    enc_DigestedData(Val, [<<48>>]).

enc_DigestedData(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}], [<<2>>]),

%%-------------------------------------------------
%% attribute digestAlgorithm(2)   External CryptographicMessageSyntax-2009:DigestAlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_DigestAlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute encapContentInfo(3)   External CryptographicMessageSyntax-2009:EncapsulatedContentInfo
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_EncapsulatedContentInfo'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute digest(4) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_restricted_string(Cindex4, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DigestedData(Tlv) ->
   dec_DigestedData(Tlv, [16]).

dec_DigestedData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}])
end
,

%%-------------------------------------------------
%% attribute digestAlgorithm(2)   External CryptographicMessageSyntax-2009:DigestAlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_DigestAlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute encapContentInfo(3)   External CryptographicMessageSyntax-2009:EncapsulatedContentInfo
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_EncapsulatedContentInfo'(V3, [16]),

%%-------------------------------------------------
%% attribute digest(4) with type OCTET STRING
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_octet_string(V4, [4]),

case Tlv5 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'DigestedData',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  Digest
%%================================
enc_Digest(Val) ->
    enc_Digest(Val, [<<4>>]).

enc_Digest(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_Digest(Tlv) ->
   dec_Digest(Tlv, [4]).

dec_Digest(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  EncryptedData
%%================================
enc_EncryptedData(Val) ->
    enc_EncryptedData(Val, [<<48>>]).

enc_EncryptedData(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}], [<<2>>]),

%%-------------------------------------------------
%% attribute encryptedContentInfo(2)   External CryptographicMessageSyntax-2009:EncryptedContentInfo
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_EncryptedContentInfo'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute unprotectedAttrs(3) with type SET OF OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_EncryptedData_unprotectedAttrs'(Cindex3, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EncryptedData_unprotectedAttrs
%%================================
enc_EncryptedData_unprotectedAttrs(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_EncryptedData_unprotectedAttrs_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_EncryptedData_unprotectedAttrs_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_EncryptedData_unprotectedAttrs_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_EncryptedData_unprotectedAttrs_Attribute'(H, [<<48>>]),
   'enc_EncryptedData_unprotectedAttrs_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  EncryptedData_unprotectedAttrs_Attribute
%%================================
enc_EncryptedData_unprotectedAttrs_Attribute(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
ObjattrType = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_48'(                                   Cindex1),

%%-------------------------------------------------
%% attribute attrType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute attrValues(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_EncryptedData_unprotectedAttrs_Attribute_attrValues'(Cindex2, [<<49>>], ObjattrType),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EncryptedData_unprotectedAttrs_Attribute_attrValues
%%================================
enc_EncryptedData_unprotectedAttrs_Attribute_attrValues(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_EncryptedData_unprotectedAttrs_Attribute_attrValues_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_EncryptedData_unprotectedAttrs_Attribute_attrValues_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_EncryptedData_unprotectedAttrs_Attribute_attrValues_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_EncryptedData_unprotectedAttrs_Attribute_attrValues_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_EncryptedData(Tlv) ->
   dec_EncryptedData(Tlv, [16]).

dec_EncryptedData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}])
end
,

%%-------------------------------------------------
%% attribute encryptedContentInfo(2)   External CryptographicMessageSyntax-2009:EncryptedContentInfo
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_EncryptedContentInfo'(V2, [16]),

%%-------------------------------------------------
%% attribute unprotectedAttrs(3) with type SET OF OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {'dec_EncryptedData_unprotectedAttrs'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'EncryptedData',Term1,Term2,Term3},
Res1.
'dec_EncryptedData_unprotectedAttrs'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_EncryptedData_unprotectedAttrs_Attribute'(V1, [16]) || V1 <- Tlv1].


'dec_EncryptedData_unprotectedAttrs_Attribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute attrType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_48'(Term1),

%%-------------------------------------------------
%% attribute attrValues(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_EncryptedData_unprotectedAttrs_Attribute_attrValues'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Attribute',Term1,Term2},
Res1.
'dec_EncryptedData_unprotectedAttrs_Attribute_attrValues'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].




%%================================
%%  AuthenticatedData
%%================================
enc_AuthenticatedData(Val) ->
    enc_AuthenticatedData(Val, [<<48>>]).

enc_AuthenticatedData(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}], [<<2>>]),

%%-------------------------------------------------
%% attribute originatorInfo(2)   External CryptographicMessageSyntax-2009:OriginatorInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OriginatorInfo'(Cindex2, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute recipientInfos(3)   External CryptographicMessageSyntax-2009:RecipientInfos
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_RecipientInfos'(Cindex3, [<<49>>]),

%%-------------------------------------------------
%% attribute macAlgorithm(4)   External CryptographicMessageSyntax-2009:MessageAuthenticationCodeAlgorithm
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_MessageAuthenticationCodeAlgorithm'(Cindex4, [<<48>>]),

%%-------------------------------------------------
%% attribute digestAlgorithm(5)   External CryptographicMessageSyntax-2009:DigestAlgorithmIdentifier OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_DigestAlgorithmIdentifier'(Cindex5, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute encapContentInfo(6)   External CryptographicMessageSyntax-2009:EncapsulatedContentInfo
%%-------------------------------------------------
   {EncBytes6,EncLen6} = 'enc_EncapsulatedContentInfo'(Cindex6, [<<48>>]),

%%-------------------------------------------------
%% attribute authAttrs(7)   External CryptographicMessageSyntax-2009:AuthAttributes OPTIONAL
%%-------------------------------------------------
   {EncBytes7,EncLen7} =  case Cindex7 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AuthAttributes'(Cindex7, [<<162>>])
       end,

%%-------------------------------------------------
%% attribute mac(8) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes8,EncLen8} = encode_restricted_string(Cindex8, [<<4>>]),

%%-------------------------------------------------
%% attribute unauthAttrs(9)   External CryptographicMessageSyntax-2009:UnauthAttributes OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_UnauthAttributes'(Cindex9, [<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AuthenticatedData(Tlv) ->
   dec_AuthenticatedData(Tlv, [16]).

dec_AuthenticatedData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}])
end
,

%%-------------------------------------------------
%% attribute originatorInfo(2)   External CryptographicMessageSyntax-2009:OriginatorInfo OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_OriginatorInfo'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute recipientInfos(3)   External CryptographicMessageSyntax-2009:RecipientInfos
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_RecipientInfos'(V3, [17]),

%%-------------------------------------------------
%% attribute macAlgorithm(4)   External CryptographicMessageSyntax-2009:MessageAuthenticationCodeAlgorithm
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_MessageAuthenticationCodeAlgorithm'(V4, [16]),

%%-------------------------------------------------
%% attribute digestAlgorithm(5)   External CryptographicMessageSyntax-2009:DigestAlgorithmIdentifier OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131073,V5}|TempTlv6] ->
    {'dec_DigestAlgorithmIdentifier'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute encapContentInfo(6)   External CryptographicMessageSyntax-2009:EncapsulatedContentInfo
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = 'dec_EncapsulatedContentInfo'(V6, [16]),

%%-------------------------------------------------
%% attribute authAttrs(7)   External CryptographicMessageSyntax-2009:AuthAttributes OPTIONAL
%%-------------------------------------------------
{Term7,Tlv8} = case Tlv7 of
[{131074,V7}|TempTlv8] ->
    {'dec_AuthAttributes'(V7, []), TempTlv8};
    _ ->
        { asn1_NOVALUE, Tlv7}
end,

%%-------------------------------------------------
%% attribute mac(8) with type OCTET STRING
%%-------------------------------------------------
[V8|Tlv9] = Tlv8, 
Term8 = decode_octet_string(V8, [4]),

%%-------------------------------------------------
%% attribute unauthAttrs(9)   External CryptographicMessageSyntax-2009:UnauthAttributes OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{131075,V9}|TempTlv10] ->
    {'dec_UnauthAttributes'(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

case Tlv10 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv10}}}) % extra fields not allowed
end,
Res1 = {'AuthenticatedData',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9},
Res1.


%%================================
%%  AuthAttributes
%%================================
enc_AuthAttributes(Val) ->
    enc_AuthAttributes(Val, [<<49>>]).

enc_AuthAttributes(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_AuthAttributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AuthAttributes_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_AuthAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AuthAttributes_Attribute'(H, [<<48>>]),
   'enc_AuthAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  AuthAttributes_Attribute
%%================================
enc_AuthAttributes_Attribute(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
ObjattrType = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_51'(                                   Cindex1),

%%-------------------------------------------------
%% attribute attrType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute attrValues(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AuthAttributes_Attribute_attrValues'(Cindex2, [<<49>>], ObjattrType),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AuthAttributes_Attribute_attrValues
%%================================
enc_AuthAttributes_Attribute_attrValues(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_AuthAttributes_Attribute_attrValues_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AuthAttributes_Attribute_attrValues_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_AuthAttributes_Attribute_attrValues_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_AuthAttributes_Attribute_attrValues_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_AuthAttributes(Tlv) ->
   dec_AuthAttributes(Tlv, [17]).

dec_AuthAttributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AuthAttributes_Attribute'(V1, [16]) || V1 <- Tlv1].


'dec_AuthAttributes_Attribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute attrType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_51'(Term1),

%%-------------------------------------------------
%% attribute attrValues(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AuthAttributes_Attribute_attrValues'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Attribute',Term1,Term2},
Res1.
'dec_AuthAttributes_Attribute_attrValues'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].




%%================================
%%  MessageAuthenticationCode
%%================================
enc_MessageAuthenticationCode(Val) ->
    enc_MessageAuthenticationCode(Val, [<<4>>]).

enc_MessageAuthenticationCode(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_MessageAuthenticationCode(Tlv) ->
   dec_MessageAuthenticationCode(Tlv, [4]).

dec_MessageAuthenticationCode(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  UnauthAttributes
%%================================
enc_UnauthAttributes(Val) ->
    enc_UnauthAttributes(Val, [<<49>>]).

enc_UnauthAttributes(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_UnauthAttributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_UnauthAttributes_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_UnauthAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_UnauthAttributes_Attribute'(H, [<<48>>]),
   'enc_UnauthAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  UnauthAttributes_Attribute
%%================================
enc_UnauthAttributes_Attribute(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
ObjattrType = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_11'(                                   Cindex1),

%%-------------------------------------------------
%% attribute attrType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute attrValues(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_UnauthAttributes_Attribute_attrValues'(Cindex2, [<<49>>], ObjattrType),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  UnauthAttributes_Attribute_attrValues
%%================================
enc_UnauthAttributes_Attribute_attrValues(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_UnauthAttributes_Attribute_attrValues_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_UnauthAttributes_Attribute_attrValues_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_UnauthAttributes_Attribute_attrValues_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_UnauthAttributes_Attribute_attrValues_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_UnauthAttributes(Tlv) ->
   dec_UnauthAttributes(Tlv, [17]).

dec_UnauthAttributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_UnauthAttributes_Attribute'(V1, [16]) || V1 <- Tlv1].


'dec_UnauthAttributes_Attribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute attrType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_11'(Term1),

%%-------------------------------------------------
%% attribute attrValues(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_UnauthAttributes_Attribute_attrValues'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Attribute',Term1,Term2},
Res1.
'dec_UnauthAttributes_Attribute_attrValues'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].




%%================================
%%  DigestAlgorithmIdentifier
%%================================
enc_DigestAlgorithmIdentifier(Val) ->
    enc_DigestAlgorithmIdentifier(Val, [<<48>>]).

enc_DigestAlgorithmIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_2'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DigestAlgorithmIdentifier(Tlv) ->
   dec_DigestAlgorithmIdentifier(Tlv, [16]).

dec_DigestAlgorithmIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_2'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'DigestAlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  SignatureAlgorithmIdentifier
%%================================
enc_SignatureAlgorithmIdentifier(Val) ->
    enc_SignatureAlgorithmIdentifier(Val, [<<48>>]).

enc_SignatureAlgorithmIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_13'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_SignatureAlgorithmIdentifier(Tlv) ->
   dec_SignatureAlgorithmIdentifier(Tlv, [16]).

dec_SignatureAlgorithmIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_13'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SignatureAlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  KeyEncryptionAlgorithmIdentifier
%%================================
enc_KeyEncryptionAlgorithmIdentifier(Val) ->
    enc_KeyEncryptionAlgorithmIdentifier(Val, [<<48>>]).

enc_KeyEncryptionAlgorithmIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_40'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_KeyEncryptionAlgorithmIdentifier(Tlv) ->
   dec_KeyEncryptionAlgorithmIdentifier(Tlv, [16]).

dec_KeyEncryptionAlgorithmIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_40'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'KeyEncryptionAlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  ContentEncryptionAlgorithmIdentifier
%%================================
enc_ContentEncryptionAlgorithmIdentifier(Val) ->
    enc_ContentEncryptionAlgorithmIdentifier(Val, [<<48>>]).

enc_ContentEncryptionAlgorithmIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_44'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ContentEncryptionAlgorithmIdentifier(Tlv) ->
   dec_ContentEncryptionAlgorithmIdentifier(Tlv, [16]).

dec_ContentEncryptionAlgorithmIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_44'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ContentEncryptionAlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  MessageAuthenticationCodeAlgorithm
%%================================
enc_MessageAuthenticationCodeAlgorithm(Val) ->
    enc_MessageAuthenticationCodeAlgorithm(Val, [<<48>>]).

enc_MessageAuthenticationCodeAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_50'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_MessageAuthenticationCodeAlgorithm(Tlv) ->
   dec_MessageAuthenticationCodeAlgorithm(Tlv, [16]).

dec_MessageAuthenticationCodeAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_50'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'MessageAuthenticationCodeAlgorithm',Term1,Term2},
Res1.


%%================================
%%  KeyDerivationAlgorithmIdentifier
%%================================
enc_KeyDerivationAlgorithmIdentifier(Val) ->
    enc_KeyDerivationAlgorithmIdentifier(Val, [<<48>>]).

enc_KeyDerivationAlgorithmIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'CryptographicMessageSyntax-2009':'getenc_internal_object_set_argument_42'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_KeyDerivationAlgorithmIdentifier(Tlv) ->
   dec_KeyDerivationAlgorithmIdentifier(Tlv, [16]).

dec_KeyDerivationAlgorithmIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_internal_object_set_argument_42'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'KeyDerivationAlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  RevocationInfoChoices
%%================================
enc_RevocationInfoChoices(Val) ->
    enc_RevocationInfoChoices(Val, [<<49>>]).

enc_RevocationInfoChoices(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_RevocationInfoChoices_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RevocationInfoChoices_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_RevocationInfoChoices_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_RevocationInfoChoice'(H, []),
   'enc_RevocationInfoChoices_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_RevocationInfoChoices(Tlv) ->
   dec_RevocationInfoChoices(Tlv, [17]).

dec_RevocationInfoChoices(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_RevocationInfoChoice'(V1, []) || V1 <- Tlv1].




%%================================
%%  RevocationInfoChoice
%%================================
enc_RevocationInfoChoice(Val) ->
    enc_RevocationInfoChoice(Val, []).

enc_RevocationInfoChoice(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      crl ->
         'PKIX1Explicit-2009':'enc_CertificateList'(element(2,Val), [<<48>>]);
      other ->
         'enc_OtherRevocationInfoFormat'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_RevocationInfoChoice(Tlv) ->
   dec_RevocationInfoChoice(Tlv, []).

dec_RevocationInfoChoice(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'crl'
    {16, V1} -> 
        {crl, 'PKIX1Explicit-2009':'dec_CertificateList'(V1, [])};


%% 'other'
    {131073, V1} -> 
        {other, 'dec_OtherRevocationInfoFormat'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  OtherRevocationInfoFormat
%%================================
enc_OtherRevocationInfoFormat(Val) ->
    enc_OtherRevocationInfoFormat(Val, [<<48>>]).

enc_OtherRevocationInfoFormat(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
ObjotherRevInfoFormat = 
   'CryptographicMessageSyntax-2009':'getenc_SupportedOtherRevokInfo'(                                   Cindex1),

%%-------------------------------------------------
%% attribute otherRevInfoFormat(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute otherRevInfo(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = ObjotherRevInfoFormat('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OtherRevocationInfoFormat(Tlv) ->
   dec_OtherRevocationInfoFormat(Tlv, [16]).

dec_OtherRevocationInfoFormat(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute otherRevInfoFormat(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute otherRevInfo(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjotherRevInfoFormatTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_SupportedOtherRevokInfo'(Term1),
Term2 = 
   case (catch DecObjotherRevInfoFormatTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OtherRevocationInfoFormat',Term1,Term2},
Res1.


%%================================
%%  CertificateChoices
%%================================
enc_CertificateChoices(Val) ->
    enc_CertificateChoices(Val, []).

enc_CertificateChoices(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      certificate ->
         'PKIX1Explicit-2009':'enc_Certificate'(element(2,Val), [<<48>>]);
      extendedCertificate ->
         'enc_ExtendedCertificate'(element(2,Val), [<<160>>]);
      v1AttrCert ->
         'AttributeCertificateVersion1-2009':'enc_AttributeCertificateV1'(element(2,Val), [<<161>>]);
      v2AttrCert ->
         'enc_AttributeCertificateV2'(element(2,Val), [<<162>>]);
      other ->
         'enc_OtherCertificateFormat'(element(2,Val), [<<163>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_CertificateChoices(Tlv) ->
   dec_CertificateChoices(Tlv, []).

dec_CertificateChoices(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'certificate'
    {16, V1} -> 
        {certificate, 'PKIX1Explicit-2009':'dec_Certificate'(V1, [])};


%% 'extendedCertificate'
    {131072, V1} -> 
        {extendedCertificate, 'dec_ExtendedCertificate'(V1, [])};


%% 'v1AttrCert'
    {131073, V1} -> 
        {v1AttrCert, 'AttributeCertificateVersion1-2009':'dec_AttributeCertificateV1'(V1, [])};


%% 'v2AttrCert'
    {131074, V1} -> 
        {v2AttrCert, 'dec_AttributeCertificateV2'(V1, [])};


%% 'other'
    {131075, V1} -> 
        {other, 'dec_OtherCertificateFormat'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  AttributeCertificateV2
%%================================
enc_AttributeCertificateV2(Val) ->
    enc_AttributeCertificateV2(Val, [<<48>>]).

enc_AttributeCertificateV2(Val, TagIn) ->
   'PKIXAttributeCertificate-2009':enc_AttributeCertificate(Val, TagIn).


dec_AttributeCertificateV2(Tlv) ->
   dec_AttributeCertificateV2(Tlv, [16]).

dec_AttributeCertificateV2(Tlv, TagIn) ->
'PKIXAttributeCertificate-2009':'dec_AttributeCertificate'(Tlv, TagIn).



%%================================
%%  OtherCertificateFormat
%%================================
enc_OtherCertificateFormat(Val) ->
    enc_OtherCertificateFormat(Val, [<<48>>]).

enc_OtherCertificateFormat(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
ObjotherCertFormat = 
   'CryptographicMessageSyntax-2009':'getenc_SupportedCertFormats'(                                   Cindex1),

%%-------------------------------------------------
%% attribute otherCertFormat(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute otherCert(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = ObjotherCertFormat('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OtherCertificateFormat(Tlv) ->
   dec_OtherCertificateFormat(Tlv, [16]).

dec_OtherCertificateFormat(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute otherCertFormat(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute otherCert(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjotherCertFormatTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_SupportedCertFormats'(Term1),
Term2 = 
   case (catch DecObjotherCertFormatTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OtherCertificateFormat',Term1,Term2},
Res1.


%%================================
%%  CertificateSet
%%================================
enc_CertificateSet(Val) ->
    enc_CertificateSet(Val, [<<49>>]).

enc_CertificateSet(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_CertificateSet_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertificateSet_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_CertificateSet_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CertificateChoices'(H, []),
   'enc_CertificateSet_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_CertificateSet(Tlv) ->
   dec_CertificateSet(Tlv, [17]).

dec_CertificateSet(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CertificateChoices'(V1, []) || V1 <- Tlv1].




%%================================
%%  IssuerAndSerialNumber
%%================================
enc_IssuerAndSerialNumber(Val) ->
    enc_IssuerAndSerialNumber(Val, [<<48>>]).

enc_IssuerAndSerialNumber(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute issuer(1)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIX1Explicit-2009':'enc_Name'(Cindex1, []),

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_IssuerAndSerialNumber(Tlv) ->
   dec_IssuerAndSerialNumber(Tlv, [16]).

dec_IssuerAndSerialNumber(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuer(1)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIX1Explicit-2009':'dec_Name'(V1, []),

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'IssuerAndSerialNumber',Term1,Term2},
Res1.


%%================================
%%  CMSVersion
%%================================
enc_CMSVersion(Val) ->
    enc_CMSVersion(Val, [<<2>>]).

enc_CMSVersion(Val, TagIn) ->
encode_integer(Val, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}], TagIn).


dec_CMSVersion(Tlv) ->
   dec_CMSVersion(Tlv, [2]).

dec_CMSVersion(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}])
end
.



%%================================
%%  UserKeyingMaterial
%%================================
enc_UserKeyingMaterial(Val) ->
    enc_UserKeyingMaterial(Val, [<<4>>]).

enc_UserKeyingMaterial(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_UserKeyingMaterial(Tlv) ->
   dec_UserKeyingMaterial(Tlv, [4]).

dec_UserKeyingMaterial(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  OtherKeyAttribute
%%================================
enc_OtherKeyAttribute(Val) ->
    enc_OtherKeyAttribute(Val, [<<48>>]).

enc_OtherKeyAttribute(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
ObjkeyAttrId = 
   'CryptographicMessageSyntax-2009':'getenc_SupportedKeyAttributes'(                                   Cindex1),

%%-------------------------------------------------
%% attribute keyAttrId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute keyAttr(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = ObjkeyAttrId('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OtherKeyAttribute(Tlv) ->
   dec_OtherKeyAttribute(Tlv, [16]).

dec_OtherKeyAttribute(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute keyAttrId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute keyAttr(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjkeyAttrIdTerm1 =
   'CryptographicMessageSyntax-2009':'getdec_SupportedKeyAttributes'(Term1),
Term2 = 
   case (catch DecObjkeyAttrIdTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OtherKeyAttribute',Term1,Term2},
Res1.


%%================================
%%  MessageDigest
%%================================
enc_MessageDigest(Val) ->
    enc_MessageDigest(Val, [<<4>>]).

enc_MessageDigest(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_MessageDigest(Tlv) ->
   dec_MessageDigest(Tlv, [4]).

dec_MessageDigest(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  SigningTime
%%================================
enc_SigningTime(Val) ->
    enc_SigningTime(Val, []).

enc_SigningTime(Val, TagIn) ->
   enc_Time(Val, TagIn).


dec_SigningTime(Tlv) ->
   dec_SigningTime(Tlv, []).

dec_SigningTime(Tlv, TagIn) ->
'dec_Time'(Tlv, TagIn).



%%================================
%%  Time
%%================================
enc_Time(Val) ->
    enc_Time(Val, []).

enc_Time(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      utcTime ->
         encode_restricted_string(element(2,Val), [<<23>>]);
      generalTime ->
         encode_restricted_string(element(2,Val), [<<24>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_Time(Tlv) ->
   dec_Time(Tlv, []).

dec_Time(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'utcTime'
    {23, V1} -> 
        {utcTime, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'generalTime'
    {24, V1} -> 
        {generalTime, begin
binary_to_list(decode_restricted_string(V1, []))
end
};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  Countersignature
%%================================
enc_Countersignature(Val) ->
    enc_Countersignature(Val, [<<48>>]).

enc_Countersignature(Val, TagIn) ->
   enc_SignerInfo(Val, TagIn).


dec_Countersignature(Tlv) ->
   dec_Countersignature(Tlv, [16]).

dec_Countersignature(Tlv, TagIn) ->
'dec_SignerInfo'(Tlv, TagIn).



%%================================
%%  ExtendedCertificateOrCertificate
%%================================
enc_ExtendedCertificateOrCertificate(Val) ->
    enc_ExtendedCertificateOrCertificate(Val, []).

enc_ExtendedCertificateOrCertificate(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      certificate ->
         'PKIX1Explicit-2009':'enc_Certificate'(element(2,Val), [<<48>>]);
      extendedCertificate ->
         'enc_ExtendedCertificate'(element(2,Val), [<<160>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_ExtendedCertificateOrCertificate(Tlv) ->
   dec_ExtendedCertificateOrCertificate(Tlv, []).

dec_ExtendedCertificateOrCertificate(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'certificate'
    {16, V1} -> 
        {certificate, 'PKIX1Explicit-2009':'dec_Certificate'(V1, [])};


%% 'extendedCertificate'
    {131072, V1} -> 
        {extendedCertificate, 'dec_ExtendedCertificate'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  ExtendedCertificate
%%================================
enc_ExtendedCertificate(Val) ->
    enc_ExtendedCertificate(Val, [<<48>>]).

enc_ExtendedCertificate(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extendedCertificateInfo(1)   External CryptographicMessageSyntax-2009:ExtendedCertificateInfo
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_ExtendedCertificateInfo'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External CryptographicMessageSyntax-2009:SignatureAlgorithmIdentifier
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SignatureAlgorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ExtendedCertificate(Tlv) ->
   dec_ExtendedCertificate(Tlv, [16]).

dec_ExtendedCertificate(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extendedCertificateInfo(1)   External CryptographicMessageSyntax-2009:ExtendedCertificateInfo
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_ExtendedCertificateInfo'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2)   External CryptographicMessageSyntax-2009:SignatureAlgorithmIdentifier
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SignatureAlgorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'ExtendedCertificate',Term1,Term2,Term3},
Res1.


%%================================
%%  ExtendedCertificateInfo
%%================================
enc_ExtendedCertificateInfo(Val) ->
    enc_ExtendedCertificateInfo(Val, [<<48>>]).

enc_ExtendedCertificateInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}], [<<2>>]),

%%-------------------------------------------------
%% attribute certificate(2)   External PKIX1Explicit-2009:Certificate
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'PKIX1Explicit-2009':'enc_Certificate'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute attributes(3)   External CryptographicMessageSyntax-2009:UnauthAttributes
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_UnauthAttributes'(Cindex3, [<<49>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ExtendedCertificateInfo(Tlv) ->
   dec_ExtendedCertificateInfo(Tlv, [16]).

dec_ExtendedCertificateInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v0,0},{v1,1},{v2,2},{v3,3},{v4,4},{v5,5}])
end
,

%%-------------------------------------------------
%% attribute certificate(2)   External PKIX1Explicit-2009:Certificate
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'PKIX1Explicit-2009':'dec_Certificate'(V2, [16]),

%%-------------------------------------------------
%% attribute attributes(3)   External CryptographicMessageSyntax-2009:UnauthAttributes
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_UnauthAttributes'(V3, [17]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'ExtendedCertificateInfo',Term1,Term2,Term3},
Res1.


%%================================
%%  Signature
%%================================
enc_Signature(Val) ->
    enc_Signature(Val, [<<3>>]).

enc_Signature(Val, TagIn) ->
encode_unnamed_bit_string(Val, TagIn).


dec_Signature(Tlv) ->
   dec_Signature(Tlv, [3]).

dec_Signature(Tlv, TagIn) ->
decode_native_bit_string(Tlv, TagIn).

'id-ct-contentInfo'() ->
{1,2,840,113549,1,9,16,1,6}.

'id-data'() ->
{1,2,840,113549,1,7,1}.

'id-signedData'() ->
{1,2,840,113549,1,7,2}.

'id-envelopedData'() ->
{1,2,840,113549,1,7,3}.

'id-digestedData'() ->
{1,2,840,113549,1,7,5}.

'id-encryptedData'() ->
{1,2,840,113549,1,7,6}.

'id-ct-authData'() ->
{1,2,840,113549,1,9,16,1,2}.

'id-contentType'() ->
{1,2,840,113549,1,9,3}.

'id-messageDigest'() ->
{1,2,840,113549,1,9,4}.

'id-signingTime'() ->
{1,2,840,113549,1,9,5}.

'id-countersignature'() ->
{1,2,840,113549,1,9,6}.




%%================================
%%  ct-Data
%%================================
'enc_ct-Data'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<4>>]).


'dec_ct-Data'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_octet_string(Tlv, [4]).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  ct-SignedData
%%================================
'enc_ct-SignedData'('Type', Val, _RestPrimFieldName) ->
   enc_SignedData(Val, [<<48>>]).


'dec_ct-SignedData'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SignedData(Tlv, [16]).




%%================================
%%  ct-EnvelopedData
%%================================
'enc_ct-EnvelopedData'('Type', Val, _RestPrimFieldName) ->
   enc_EnvelopedData(Val, [<<48>>]).


'dec_ct-EnvelopedData'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_EnvelopedData(Tlv, [16]).




%%================================
%%  ct-DigestedData
%%================================
'enc_ct-DigestedData'('Type', Val, _RestPrimFieldName) ->
   enc_DigestedData(Val, [<<48>>]).


'dec_ct-DigestedData'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DigestedData(Tlv, [16]).




%%================================
%%  ct-EncryptedData
%%================================
'enc_ct-EncryptedData'('Type', Val, _RestPrimFieldName) ->
   enc_EncryptedData(Val, [<<48>>]).


'dec_ct-EncryptedData'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_EncryptedData(Tlv, [16]).




%%================================
%%  ct-AuthenticatedData
%%================================
'enc_ct-AuthenticatedData'('Type', Val, _RestPrimFieldName) ->
   enc_AuthenticatedData(Val, [<<48>>]).


'dec_ct-AuthenticatedData'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_AuthenticatedData(Tlv, [16]).




%%================================
%%  aa-contentType
%%================================
'enc_aa-contentType'('Type', Val, _RestPrimFieldName) ->
   enc_ContentType(Val, [<<6>>]);
'enc_aa-contentType'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_aa-contentType'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ContentType(Tlv, [6]);
'dec_aa-contentType'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  aa-messageDigest
%%================================
'enc_aa-messageDigest'('Type', Val, _RestPrimFieldName) ->
   enc_MessageDigest(Val, [<<4>>]);
'enc_aa-messageDigest'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_aa-messageDigest'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_MessageDigest(Tlv, [4]);
'dec_aa-messageDigest'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  aa-signingTime
%%================================
'enc_aa-signingTime'('Type', Val, _RestPrimFieldName) ->
   enc_SigningTime(Val, []);
'enc_aa-signingTime'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_aa-signingTime'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SigningTime(Tlv, []);
'dec_aa-signingTime'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  aa-countersignature
%%================================
'enc_aa-countersignature'('Type', Val, _RestPrimFieldName) ->
   enc_Countersignature(Val, [<<48>>]);
'enc_aa-countersignature'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_aa-countersignature'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_Countersignature(Tlv, [16]);
'dec_aa-countersignature'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  ContentSet
%%================================
getenc_ContentSet(Id) when Id =:= {1,2,840,113549,1,7,1} ->
    fun 'enc_ct-Data'/3;
getenc_ContentSet(Id) when Id =:= {1,2,840,113549,1,7,2} ->
    fun 'enc_ct-SignedData'/3;
getenc_ContentSet(Id) when Id =:= {1,2,840,113549,1,7,3} ->
    fun 'enc_ct-EnvelopedData'/3;
getenc_ContentSet(Id) when Id =:= {1,2,840,113549,1,7,5} ->
    fun 'enc_ct-DigestedData'/3;
getenc_ContentSet(Id) when Id =:= {1,2,840,113549,1,7,6} ->
    fun 'enc_ct-EncryptedData'/3;
getenc_ContentSet(Id) when Id =:= {1,2,840,113549,1,9,16,1,2} ->
    fun 'enc_ct-AuthenticatedData'/3;
getenc_ContentSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_ContentSet(Id) when Id =:= {1,2,840,113549,1,7,1} ->
    fun 'dec_ct-Data'/3;
getdec_ContentSet(Id) when Id =:= {1,2,840,113549,1,7,2} ->
    fun 'dec_ct-SignedData'/3;
getdec_ContentSet(Id) when Id =:= {1,2,840,113549,1,7,3} ->
    fun 'dec_ct-EnvelopedData'/3;
getdec_ContentSet(Id) when Id =:= {1,2,840,113549,1,7,5} ->
    fun 'dec_ct-DigestedData'/3;
getdec_ContentSet(Id) when Id =:= {1,2,840,113549,1,7,6} ->
    fun 'dec_ct-EncryptedData'/3;
getdec_ContentSet(Id) when Id =:= {1,2,840,113549,1,9,16,1,2} ->
    fun 'dec_ct-AuthenticatedData'/3;
getdec_ContentSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SignedAttributesSet
%%================================
getenc_SignedAttributesSet(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'enc_aa-contentType'/3;
getenc_SignedAttributesSet(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'enc_aa-messageDigest'/3;
getenc_SignedAttributesSet(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun 'enc_aa-signingTime'/3;
getenc_SignedAttributesSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SignedAttributesSet(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'dec_aa-contentType'/3;
getdec_SignedAttributesSet(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'dec_aa-messageDigest'/3;
getdec_SignedAttributesSet(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun 'dec_aa-signingTime'/3;
getdec_SignedAttributesSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  UnsignedAttributes
%%================================
getenc_UnsignedAttributes(Id) when Id =:= {1,2,840,113549,1,9,6} ->
    fun 'enc_aa-countersignature'/3;
getenc_UnsignedAttributes(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_UnsignedAttributes(Id) when Id =:= {1,2,840,113549,1,9,6} ->
    fun 'dec_aa-countersignature'/3;
getdec_UnsignedAttributes(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  UnprotectedAttributes
%%================================
getenc_UnprotectedAttributes(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_UnprotectedAttributes(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  KeyTransportAlgorithmSet
%%================================
getenc_KeyTransportAlgorithmSet(Id) when Id =:= {1,2,840,113549,1,1,1} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_kt-rsa'(T,V,O) end;
getenc_KeyTransportAlgorithmSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_KeyTransportAlgorithmSet(Id) when Id =:= {1,2,840,113549,1,1,1} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_kt-rsa'(T,V,O) end;
getdec_KeyTransportAlgorithmSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  KeyAgreementAlgorithmSet
%%================================
getenc_KeyAgreementAlgorithmSet(Id) when Id =:= {1,2,840,113549,1,9,16,3,5} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_kaa-esdh'(T,V,O) end;
getenc_KeyAgreementAlgorithmSet(Id) when Id =:= {1,2,840,113549,1,9,16,3,10} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_kaa-ssdh'(T,V,O) end;
getenc_KeyAgreementAlgorithmSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_KeyAgreementAlgorithmSet(Id) when Id =:= {1,2,840,113549,1,9,16,3,5} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_kaa-esdh'(T,V,O) end;
getdec_KeyAgreementAlgorithmSet(Id) when Id =:= {1,2,840,113549,1,9,16,3,10} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_kaa-ssdh'(T,V,O) end;
getdec_KeyAgreementAlgorithmSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  OriginatorKeySet
%%================================
getenc_OriginatorKeySet(Id) when Id =:= {1,2,840,10046,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-dh'(T,V,O) end;
getenc_OriginatorKeySet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_OriginatorKeySet(Id) when Id =:= {1,2,840,10046,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-dh'(T,V,O) end;
getdec_OriginatorKeySet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SupportedOtherRecipInfo
%%================================
getenc_SupportedOtherRecipInfo(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SupportedOtherRecipInfo(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  AuthAttributeSet
%%================================
getenc_AuthAttributeSet(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'enc_aa-contentType'/3;
getenc_AuthAttributeSet(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'enc_aa-messageDigest'/3;
getenc_AuthAttributeSet(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun 'enc_aa-signingTime'/3;
getenc_AuthAttributeSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_AuthAttributeSet(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'dec_aa-contentType'/3;
getdec_AuthAttributeSet(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'dec_aa-messageDigest'/3;
getdec_AuthAttributeSet(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun 'dec_aa-signingTime'/3;
getdec_AuthAttributeSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  UnauthAttributeSet
%%================================
getenc_UnauthAttributeSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_UnauthAttributeSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  DigestAlgorithmSet
%%================================
getenc_DigestAlgorithmSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_DigestAlgorithmSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SignatureAlgorithmSet
%%================================
getenc_SignatureAlgorithmSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SignatureAlgorithmSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  KeyEncryptionAlgorithmSet
%%================================
getenc_KeyEncryptionAlgorithmSet(Id) when Id =:= {1,2,840,113549,1,9,16,3,6} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_kwa-3DESWrap'(T,V,O) end;
getenc_KeyEncryptionAlgorithmSet(Id) when Id =:= {1,2,840,113549,1,9,16,3,7} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_kwa-RC2Wrap'(T,V,O) end;
getenc_KeyEncryptionAlgorithmSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_KeyEncryptionAlgorithmSet(Id) when Id =:= {1,2,840,113549,1,9,16,3,6} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_kwa-3DESWrap'(T,V,O) end;
getdec_KeyEncryptionAlgorithmSet(Id) when Id =:= {1,2,840,113549,1,9,16,3,7} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_kwa-RC2Wrap'(T,V,O) end;
getdec_KeyEncryptionAlgorithmSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  ContentEncryptionAlgorithmSet
%%================================
getenc_ContentEncryptionAlgorithmSet(Id) when Id =:= {1,2,840,113549,3,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_cea-RC2-cbc'(T,V,O) end;
getenc_ContentEncryptionAlgorithmSet(Id) when Id =:= {1,2,840,113549,3,7} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_cea-3DES-cbc'(T,V,O) end;
getenc_ContentEncryptionAlgorithmSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_ContentEncryptionAlgorithmSet(Id) when Id =:= {1,2,840,113549,3,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_cea-RC2-cbc'(T,V,O) end;
getdec_ContentEncryptionAlgorithmSet(Id) when Id =:= {1,2,840,113549,3,7} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_cea-3DES-cbc'(T,V,O) end;
getdec_ContentEncryptionAlgorithmSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  MessageAuthenticationCodeAlgorithmSet
%%================================
getenc_MessageAuthenticationCodeAlgorithmSet(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_maca-hMAC-SHA1'(T,V,O) end;
getenc_MessageAuthenticationCodeAlgorithmSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_MessageAuthenticationCodeAlgorithmSet(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_maca-hMAC-SHA1'(T,V,O) end;
getdec_MessageAuthenticationCodeAlgorithmSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SupportedOtherRevokInfo
%%================================
getenc_SupportedOtherRevokInfo(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SupportedOtherRevokInfo(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SupportedCertFormats
%%================================
getenc_SupportedCertFormats(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SupportedCertFormats(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SupportedKeyAttributes
%%================================
getenc_SupportedKeyAttributes(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SupportedKeyAttributes(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_51
%%================================
getenc_internal_object_set_argument_51(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'enc_aa-contentType'/3;
getenc_internal_object_set_argument_51(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'enc_aa-messageDigest'/3;
getenc_internal_object_set_argument_51(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun 'enc_aa-signingTime'/3;
getenc_internal_object_set_argument_51(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_51(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'dec_aa-contentType'/3;
getdec_internal_object_set_argument_51(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'dec_aa-messageDigest'/3;
getdec_internal_object_set_argument_51(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun 'dec_aa-signingTime'/3;
getdec_internal_object_set_argument_51(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_50
%%================================
getenc_internal_object_set_argument_50(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_maca-hMAC-SHA1'(T,V,O) end;
getenc_internal_object_set_argument_50(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_50(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_maca-hMAC-SHA1'(T,V,O) end;
getdec_internal_object_set_argument_50(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_2(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_38
%%================================
getenc_internal_object_set_argument_38(Id) when Id =:= {1,2,840,113549,1,9,16,3,5} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_kaa-esdh'(T,V,O) end;
getenc_internal_object_set_argument_38(Id) when Id =:= {1,2,840,113549,1,9,16,3,10} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_kaa-ssdh'(T,V,O) end;
getenc_internal_object_set_argument_38(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_38(Id) when Id =:= {1,2,840,113549,1,9,16,3,5} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_kaa-esdh'(T,V,O) end;
getdec_internal_object_set_argument_38(Id) when Id =:= {1,2,840,113549,1,9,16,3,10} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_kaa-ssdh'(T,V,O) end;
getdec_internal_object_set_argument_38(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_36
%%================================
getenc_internal_object_set_argument_36(Id) when Id =:= {1,2,840,10046,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-dh'(T,V,O) end;
getenc_internal_object_set_argument_36(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_36(Id) when Id =:= {1,2,840,10046,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-dh'(T,V,O) end;
getdec_internal_object_set_argument_36(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_34
%%================================
getenc_internal_object_set_argument_34(Id) when Id =:= {1,2,840,113549,1,1,1} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_kt-rsa'(T,V,O) end;
getenc_internal_object_set_argument_34(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_34(Id) when Id =:= {1,2,840,113549,1,1,1} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_kt-rsa'(T,V,O) end;
getdec_internal_object_set_argument_34(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_32
%%================================
getenc_internal_object_set_argument_32(Id) when Id =:= {1,2,840,113549,1,9,6} ->
    fun 'enc_aa-countersignature'/3;
getenc_internal_object_set_argument_32(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_32(Id) when Id =:= {1,2,840,113549,1,9,6} ->
    fun 'dec_aa-countersignature'/3;
getdec_internal_object_set_argument_32(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_31
%%================================
getenc_internal_object_set_argument_31(Id) when Id =:= {1,2,840,113549,1,9,6} ->
    fun 'enc_aa-countersignature'/3;
getenc_internal_object_set_argument_31(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_31(Id) when Id =:= {1,2,840,113549,1,9,6} ->
    fun 'dec_aa-countersignature'/3;
getdec_internal_object_set_argument_31(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_30
%%================================
getenc_internal_object_set_argument_30(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'enc_aa-contentType'/3;
getenc_internal_object_set_argument_30(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'enc_aa-messageDigest'/3;
getenc_internal_object_set_argument_30(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun 'enc_aa-signingTime'/3;
getenc_internal_object_set_argument_30(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_30(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'dec_aa-contentType'/3;
getdec_internal_object_set_argument_30(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'dec_aa-messageDigest'/3;
getdec_internal_object_set_argument_30(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun 'dec_aa-signingTime'/3;
getdec_internal_object_set_argument_30(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_48
%%================================
getenc_internal_object_set_argument_48(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_48(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_47
%%================================
getenc_internal_object_set_argument_47(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_47(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_46
%%================================
getenc_internal_object_set_argument_46(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_46(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_45
%%================================
getenc_internal_object_set_argument_45(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_45(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_44
%%================================
getenc_internal_object_set_argument_44(Id) when Id =:= {1,2,840,113549,3,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_cea-RC2-cbc'(T,V,O) end;
getenc_internal_object_set_argument_44(Id) when Id =:= {1,2,840,113549,3,7} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_cea-3DES-cbc'(T,V,O) end;
getenc_internal_object_set_argument_44(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_44(Id) when Id =:= {1,2,840,113549,3,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_cea-RC2-cbc'(T,V,O) end;
getdec_internal_object_set_argument_44(Id) when Id =:= {1,2,840,113549,3,7} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_cea-3DES-cbc'(T,V,O) end;
getdec_internal_object_set_argument_44(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_42
%%================================
getenc_internal_object_set_argument_42(Id) when Id =:= {1,2,840,113549,1,5,12} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_kda-PBKDF2'(T,V,O) end;
getenc_internal_object_set_argument_42(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_42(Id) when Id =:= {1,2,840,113549,1,5,12} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_kda-PBKDF2'(T,V,O) end;
getdec_internal_object_set_argument_42(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_40
%%================================
getenc_internal_object_set_argument_40(Id) when Id =:= {1,2,840,113549,1,9,16,3,6} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_kwa-3DESWrap'(T,V,O) end;
getenc_internal_object_set_argument_40(Id) when Id =:= {1,2,840,113549,1,9,16,3,7} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_kwa-RC2Wrap'(T,V,O) end;
getenc_internal_object_set_argument_40(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_40(Id) when Id =:= {1,2,840,113549,1,9,16,3,6} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_kwa-3DESWrap'(T,V,O) end;
getdec_internal_object_set_argument_40(Id) when Id =:= {1,2,840,113549,1,9,16,3,7} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_kwa-RC2Wrap'(T,V,O) end;
getdec_internal_object_set_argument_40(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_13
%%================================
getenc_internal_object_set_argument_13(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_13(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_11
%%================================
getenc_internal_object_set_argument_11(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_11(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_29
%%================================
getenc_internal_object_set_argument_29(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'enc_aa-contentType'/3;
getenc_internal_object_set_argument_29(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'enc_aa-messageDigest'/3;
getenc_internal_object_set_argument_29(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun 'enc_aa-signingTime'/3;
getenc_internal_object_set_argument_29(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_29(Id) when Id =:= {1,2,840,113549,1,9,3} ->
    fun 'dec_aa-contentType'/3;
getdec_internal_object_set_argument_29(Id) when Id =:= {1,2,840,113549,1,9,4} ->
    fun 'dec_aa-messageDigest'/3;
getdec_internal_object_set_argument_29(Id) when Id =:= {1,2,840,113549,1,9,5} ->
    fun 'dec_aa-signingTime'/3;
getdec_internal_object_set_argument_29(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_native_bit_string(Buffer, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            <<>>;
        <<Unused,Bits/binary>> ->
            Size = bit_size(Bits) - Unused,
            <<Val:Size/bitstring,_:Unused/bitstring>> = Bits,
            Val
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

decode_restricted_string(Tlv, TagsIn) ->
    match_and_collect(Tlv, TagsIn).

dynamicsort_SETOF(ListOfEncVal) ->
    BinL =
        lists:map(fun(L) when is_list(L) ->
                         list_to_binary(L);
                     (B) ->
                         B
                  end,
                  ListOfEncVal),
    lists:sort(BinL).

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, NamedNumberList, Tag) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedNumberList) of
        {_, NewVal} ->
            encode_tags(Tag, encode_integer(NewVal));
        _ ->
            exit({error, {asn1, {encode_integer_namednumber, Val}}})
    end;
encode_integer(Val, _NamedNumberList, Tag) ->
    encode_tags(Tag, encode_integer(Val)).

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

encode_unnamed_bit_string(Bits, TagIn) ->
    Unused = (8 - bit_size(Bits) band 7) band 7,
    Bin = <<Unused,Bits/bitstring,0:Unused>>,
    encode_tags(TagIn, Bin, byte_size(Bin)).

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

number2name(Int, NamedNumberList) ->
    case lists:keyfind(Int, 2, NamedNumberList) of
        {NamedVal, _} ->
            NamedVal;
        _ ->
            Int
    end.
