%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.2
%% Purpose: Encoding and decoding of the types in EnrollmentMessageSyntax-2009.

-module('EnrollmentMessageSyntax-2009').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("EnrollmentMessageSyntax-2009.hrl").
-asn1_info([{vsn,'5.4.2'},
            {module,'EnrollmentMessageSyntax-2009'},
            {options,[{i,"/home/builder/.termux-build/erlang/src/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/home/builder/.termux-build/erlang/src/lib/public_key/asn1"},
 {outdir,"/home/builder/.termux-build/erlang/src/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/home/builder/.termux-build/erlang/src/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_PKIData/2,
enc_BodyPartID/2,
enc_TaggedAttribute/2,
enc_TaggedRequest/2,
enc_TaggedCertificationRequest/2,
enc_CertificationRequest/2,
enc_TaggedContentInfo/2,
enc_OtherMsg/2,
enc_ResponseBody/2,
enc_PKIResponse/2,
enc_CMCStatusInfo/2,
enc_PendInfo/2,
enc_CMCStatus/2,
enc_CMCFailInfo/2,
enc_AddExtensions/2,
enc_EncryptedPOP/2,
enc_DecryptedPOP/2,
enc_LraPopWitness/2,
enc_GetCert/2,
enc_GetCRL/2,
enc_RevokeRequest/2,
enc_CMCCertId/2,
enc_ExtensionReq/2,
enc_NoSignatureValue/2,
enc_CMCUnsignedData/2,
enc_CMCStatusInfoV2/2,
enc_BodyPartReference/2,
enc_BodyPartPath/2,
enc_PublishTrustAnchors/2,
enc_AuthPublish/2,
enc_BodyPartList/2,
enc_CMCPublicationInfo/2,
enc_ModCertTemplate/2,
enc_ControlsProcessed/2,
enc_IdentityProofV2/2,
enc_PopLinkWitnessV2/2
]).

-export([
dec_PKIData/2,
dec_BodyPartID/2,
dec_TaggedAttribute/2,
dec_TaggedRequest/2,
dec_TaggedCertificationRequest/2,
dec_CertificationRequest/2,
dec_TaggedContentInfo/2,
dec_OtherMsg/2,
dec_ResponseBody/2,
dec_PKIResponse/2,
dec_CMCStatusInfo/2,
dec_PendInfo/2,
dec_CMCStatus/2,
dec_CMCFailInfo/2,
dec_AddExtensions/2,
dec_EncryptedPOP/2,
dec_DecryptedPOP/2,
dec_LraPopWitness/2,
dec_GetCert/2,
dec_GetCRL/2,
dec_RevokeRequest/2,
dec_CMCCertId/2,
dec_ExtensionReq/2,
dec_NoSignatureValue/2,
dec_CMCUnsignedData/2,
dec_CMCStatusInfoV2/2,
dec_BodyPartReference/2,
dec_BodyPartPath/2,
dec_PublishTrustAnchors/2,
dec_AuthPublish/2,
dec_BodyPartList/2,
dec_CMCPublicationInfo/2,
dec_ModCertTemplate/2,
dec_ControlsProcessed/2,
dec_IdentityProofV2/2,
dec_PopLinkWitnessV2/2
]).

-export([
'enc_ct-PKIData'/3,
'enc_ct-PKIResponse'/3,
'enc_cmc-identityProof'/3,
'enc_cmc-dataReturn'/3,
'enc_cmc-regInfo'/3,
'enc_cmc-responseInfo'/3,
'enc_cmc-queryPending'/3,
'enc_cmc-popLinkRandom'/3,
'enc_cmc-popLinkWitness'/3,
'enc_cmc-identification'/3,
'enc_cmc-transactionId'/3,
'enc_cmc-senderNonce'/3,
'enc_cmc-recipientNonce'/3,
'enc_cmc-statusInfo'/3,
'enc_cmc-addExtensions'/3,
'enc_cmc-encryptedPOP'/3,
'enc_cmc-decryptedPOP'/3,
'enc_cmc-lraPOPWitness'/3,
'enc_cmc-getCert'/3,
'enc_cmc-getCRL'/3,
'enc_cmc-revokeRequest'/3,
'enc_cmc-confirmCertAcceptance'/3,
'enc_at-extension-req'/3,
'enc_sa-noSignature'/3,
'enc_aa-cmc-unsignedData'/3,
'enc_cmc-statusInfoV2'/3,
'enc_cmc-trustedAnchors'/3,
'enc_cmc-authData'/3,
'enc_cmc-batchRequests'/3,
'enc_cmc-batchResponses'/3,
'enc_cmc-publishCert'/3,
'enc_cmc-modCertTemplate'/3,
'enc_cmc-controlProcessed'/3,
'enc_cmc-identityProofV2'/3,
'enc_cmc-popLinkWitnessV2'/3
]).

-export([
'dec_ct-PKIData'/3,
'dec_ct-PKIResponse'/3,
'dec_cmc-identityProof'/3,
'dec_cmc-dataReturn'/3,
'dec_cmc-regInfo'/3,
'dec_cmc-responseInfo'/3,
'dec_cmc-queryPending'/3,
'dec_cmc-popLinkRandom'/3,
'dec_cmc-popLinkWitness'/3,
'dec_cmc-identification'/3,
'dec_cmc-transactionId'/3,
'dec_cmc-senderNonce'/3,
'dec_cmc-recipientNonce'/3,
'dec_cmc-statusInfo'/3,
'dec_cmc-addExtensions'/3,
'dec_cmc-encryptedPOP'/3,
'dec_cmc-decryptedPOP'/3,
'dec_cmc-lraPOPWitness'/3,
'dec_cmc-getCert'/3,
'dec_cmc-getCRL'/3,
'dec_cmc-revokeRequest'/3,
'dec_cmc-confirmCertAcceptance'/3,
'dec_at-extension-req'/3,
'dec_sa-noSignature'/3,
'dec_aa-cmc-unsignedData'/3,
'dec_cmc-statusInfoV2'/3,
'dec_cmc-trustedAnchors'/3,
'dec_cmc-authData'/3,
'dec_cmc-batchRequests'/3,
'dec_cmc-batchResponses'/3,
'dec_cmc-publishCert'/3,
'dec_cmc-modCertTemplate'/3,
'dec_cmc-controlProcessed'/3,
'dec_cmc-identityProofV2'/3,
'dec_cmc-popLinkWitnessV2'/3
]).

-export([
'getenc_CMC-ContentTypes'/1,
getenc_SignatureAlgs/1,
'getenc_CMC-UnsignedAtts'/1,
'getenc_Cmc-Control-Set'/1,
getenc_OtherRequests/1,
getenc_AttributeList/1,
getenc_OtherMsgSet/1,
getenc_POPAlgs/1,
getenc_WitnessAlgs/1,
getenc_ExtendedFailures/1,
getenc_HashAlgorithms/1,
getenc_KeyDevAlgs/1,
getenc_internal_object_set_argument_8/1,
getenc_internal_object_set_argument_6/1,
getenc_internal_object_set_argument_5/1,
getenc_internal_object_set_argument_3/1,
getenc_internal_object_set_argument_2/1,
getenc_internal_object_set_argument_19/1,
getenc_internal_object_set_argument_17/1,
getenc_internal_object_set_argument_15/1,
getenc_internal_object_set_argument_13/1,
getenc_internal_object_set_argument_12/1,
getenc_internal_object_set_argument_10/1,
getenc_internal_object_set_argument_25/1,
getenc_internal_object_set_argument_23/1,
getenc_internal_object_set_argument_21/1
]).

-export([
'getdec_CMC-ContentTypes'/1,
getdec_SignatureAlgs/1,
'getdec_CMC-UnsignedAtts'/1,
'getdec_Cmc-Control-Set'/1,
getdec_OtherRequests/1,
getdec_AttributeList/1,
getdec_OtherMsgSet/1,
getdec_POPAlgs/1,
getdec_WitnessAlgs/1,
getdec_ExtendedFailures/1,
getdec_HashAlgorithms/1,
getdec_KeyDevAlgs/1,
getdec_internal_object_set_argument_8/1,
getdec_internal_object_set_argument_6/1,
getdec_internal_object_set_argument_5/1,
getdec_internal_object_set_argument_3/1,
getdec_internal_object_set_argument_2/1,
getdec_internal_object_set_argument_19/1,
getdec_internal_object_set_argument_17/1,
getdec_internal_object_set_argument_15/1,
getdec_internal_object_set_argument_13/1,
getdec_internal_object_set_argument_12/1,
getdec_internal_object_set_argument_10/1,
getdec_internal_object_set_argument_25/1,
getdec_internal_object_set_argument_23/1,
getdec_internal_object_set_argument_21/1
]).

-export([
'id-cmc'/0,
'id-cct'/0,
'id-cct-PKIData'/0,
'id-cct-PKIResponse'/0,
'id-cmc-identityProof'/0,
'id-cmc-dataReturn'/0,
'id-cmc-regInfo'/0,
'id-cmc-responseInfo'/0,
'id-cmc-queryPending'/0,
'id-cmc-popLinkRandom'/0,
'id-cmc-popLinkWitness'/0,
'id-cmc-identification'/0,
'id-cmc-transactionId'/0,
'id-cmc-senderNonce'/0,
'id-cmc-recipientNonce'/0,
'id-cmc-statusInfo'/0,
'id-cmc-addExtensions'/0,
'id-cmc-encryptedPOP'/0,
'id-cmc-decryptedPOP'/0,
'id-cmc-lraPOPWitness'/0,
'id-cmc-getCert'/0,
'id-cmc-getCRL'/0,
'id-cmc-revokeRequest'/0,
'id-cmc-confirmCertAcceptance'/0,
'id-ExtensionReq'/0,
'id-alg-noSignature'/0,
'id-aa'/0,
'id-aa-cmc-unsignedData'/0,
'id-cmc-statusInfoV2'/0,
'id-cmc-trustedAnchors'/0,
'id-cmc-authData'/0,
'id-cmc-batchRequests'/0,
'id-cmc-batchResponses'/0,
'id-cmc-publishCert'/0,
'id-cmc-modCertTemplate'/0,
'id-cmc-controlProcessed'/0,
'id-cmc-identityProofV2'/0,
'id-cmc-popLinkWitnessV2'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('PKIData', Data) -> enc_PKIData(Data);
encode_disp('BodyPartID', Data) -> enc_BodyPartID(Data);
encode_disp('TaggedAttribute', Data) -> enc_TaggedAttribute(Data);
encode_disp('TaggedRequest', Data) -> enc_TaggedRequest(Data);
encode_disp('TaggedCertificationRequest', Data) -> enc_TaggedCertificationRequest(Data);
encode_disp('CertificationRequest', Data) -> enc_CertificationRequest(Data);
encode_disp('TaggedContentInfo', Data) -> enc_TaggedContentInfo(Data);
encode_disp('OtherMsg', Data) -> enc_OtherMsg(Data);
encode_disp('ResponseBody', Data) -> enc_ResponseBody(Data);
encode_disp('PKIResponse', Data) -> enc_PKIResponse(Data);
encode_disp('CMCStatusInfo', Data) -> enc_CMCStatusInfo(Data);
encode_disp('PendInfo', Data) -> enc_PendInfo(Data);
encode_disp('CMCStatus', Data) -> enc_CMCStatus(Data);
encode_disp('CMCFailInfo', Data) -> enc_CMCFailInfo(Data);
encode_disp('AddExtensions', Data) -> enc_AddExtensions(Data);
encode_disp('EncryptedPOP', Data) -> enc_EncryptedPOP(Data);
encode_disp('DecryptedPOP', Data) -> enc_DecryptedPOP(Data);
encode_disp('LraPopWitness', Data) -> enc_LraPopWitness(Data);
encode_disp('GetCert', Data) -> enc_GetCert(Data);
encode_disp('GetCRL', Data) -> enc_GetCRL(Data);
encode_disp('RevokeRequest', Data) -> enc_RevokeRequest(Data);
encode_disp('CMCCertId', Data) -> enc_CMCCertId(Data);
encode_disp('ExtensionReq', Data) -> enc_ExtensionReq(Data);
encode_disp('NoSignatureValue', Data) -> enc_NoSignatureValue(Data);
encode_disp('CMCUnsignedData', Data) -> enc_CMCUnsignedData(Data);
encode_disp('CMCStatusInfoV2', Data) -> enc_CMCStatusInfoV2(Data);
encode_disp('BodyPartReference', Data) -> enc_BodyPartReference(Data);
encode_disp('BodyPartPath', Data) -> enc_BodyPartPath(Data);
encode_disp('PublishTrustAnchors', Data) -> enc_PublishTrustAnchors(Data);
encode_disp('AuthPublish', Data) -> enc_AuthPublish(Data);
encode_disp('BodyPartList', Data) -> enc_BodyPartList(Data);
encode_disp('CMCPublicationInfo', Data) -> enc_CMCPublicationInfo(Data);
encode_disp('ModCertTemplate', Data) -> enc_ModCertTemplate(Data);
encode_disp('ControlsProcessed', Data) -> enc_ControlsProcessed(Data);
encode_disp('IdentityProofV2', Data) -> enc_IdentityProofV2(Data);
encode_disp('PopLinkWitnessV2', Data) -> enc_PopLinkWitnessV2(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('PKIData', Data) -> dec_PKIData(Data);
decode_disp('BodyPartID', Data) -> dec_BodyPartID(Data);
decode_disp('TaggedAttribute', Data) -> dec_TaggedAttribute(Data);
decode_disp('TaggedRequest', Data) -> dec_TaggedRequest(Data);
decode_disp('TaggedCertificationRequest', Data) -> dec_TaggedCertificationRequest(Data);
decode_disp('CertificationRequest', Data) -> dec_CertificationRequest(Data);
decode_disp('TaggedContentInfo', Data) -> dec_TaggedContentInfo(Data);
decode_disp('OtherMsg', Data) -> dec_OtherMsg(Data);
decode_disp('ResponseBody', Data) -> dec_ResponseBody(Data);
decode_disp('PKIResponse', Data) -> dec_PKIResponse(Data);
decode_disp('CMCStatusInfo', Data) -> dec_CMCStatusInfo(Data);
decode_disp('PendInfo', Data) -> dec_PendInfo(Data);
decode_disp('CMCStatus', Data) -> dec_CMCStatus(Data);
decode_disp('CMCFailInfo', Data) -> dec_CMCFailInfo(Data);
decode_disp('AddExtensions', Data) -> dec_AddExtensions(Data);
decode_disp('EncryptedPOP', Data) -> dec_EncryptedPOP(Data);
decode_disp('DecryptedPOP', Data) -> dec_DecryptedPOP(Data);
decode_disp('LraPopWitness', Data) -> dec_LraPopWitness(Data);
decode_disp('GetCert', Data) -> dec_GetCert(Data);
decode_disp('GetCRL', Data) -> dec_GetCRL(Data);
decode_disp('RevokeRequest', Data) -> dec_RevokeRequest(Data);
decode_disp('CMCCertId', Data) -> dec_CMCCertId(Data);
decode_disp('ExtensionReq', Data) -> dec_ExtensionReq(Data);
decode_disp('NoSignatureValue', Data) -> dec_NoSignatureValue(Data);
decode_disp('CMCUnsignedData', Data) -> dec_CMCUnsignedData(Data);
decode_disp('CMCStatusInfoV2', Data) -> dec_CMCStatusInfoV2(Data);
decode_disp('BodyPartReference', Data) -> dec_BodyPartReference(Data);
decode_disp('BodyPartPath', Data) -> dec_BodyPartPath(Data);
decode_disp('PublishTrustAnchors', Data) -> dec_PublishTrustAnchors(Data);
decode_disp('AuthPublish', Data) -> dec_AuthPublish(Data);
decode_disp('BodyPartList', Data) -> dec_BodyPartList(Data);
decode_disp('CMCPublicationInfo', Data) -> dec_CMCPublicationInfo(Data);
decode_disp('ModCertTemplate', Data) -> dec_ModCertTemplate(Data);
decode_disp('ControlsProcessed', Data) -> dec_ControlsProcessed(Data);
decode_disp('IdentityProofV2', Data) -> dec_IdentityProofV2(Data);
decode_disp('PopLinkWitnessV2', Data) -> dec_PopLinkWitnessV2(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  PKIData
%%================================
enc_PKIData(Val) ->
    enc_PKIData(Val, [<<48>>]).

enc_PKIData(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute controlSequence(1) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PKIData_controlSequence'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute reqSequence(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PKIData_reqSequence'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute cmsSequence(3) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_PKIData_cmsSequence'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute otherMsgSequence(4) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_PKIData_otherMsgSequence'(Cindex4, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PKIData_controlSequence
%%================================
enc_PKIData_controlSequence(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PKIData_controlSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PKIData_controlSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PKIData_controlSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TaggedAttribute'(H, [<<48>>]),
   'enc_PKIData_controlSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  PKIData_reqSequence
%%================================
enc_PKIData_reqSequence(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PKIData_reqSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PKIData_reqSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PKIData_reqSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TaggedRequest'(H, []),
   'enc_PKIData_reqSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  PKIData_cmsSequence
%%================================
enc_PKIData_cmsSequence(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PKIData_cmsSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PKIData_cmsSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PKIData_cmsSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TaggedContentInfo'(H, [<<48>>]),
   'enc_PKIData_cmsSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  PKIData_otherMsgSequence
%%================================
enc_PKIData_otherMsgSequence(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PKIData_otherMsgSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PKIData_otherMsgSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PKIData_otherMsgSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_OtherMsg'(H, [<<48>>]),
   'enc_PKIData_otherMsgSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PKIData(Tlv) ->
   dec_PKIData(Tlv, [16]).

dec_PKIData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute controlSequence(1) with type SEQUENCE OF
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PKIData_controlSequence'(V1, [16]),

%%-------------------------------------------------
%% attribute reqSequence(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PKIData_reqSequence'(V2, [16]),

%%-------------------------------------------------
%% attribute cmsSequence(3) with type SEQUENCE OF
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_PKIData_cmsSequence'(V3, [16]),

%%-------------------------------------------------
%% attribute otherMsgSequence(4) with type SEQUENCE OF
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_PKIData_otherMsgSequence'(V4, [16]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'PKIData',Term1,Term2,Term3,Term4},
Res1.
'dec_PKIData_controlSequence'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TaggedAttribute'(V1, [16]) || V1 <- Tlv1].


'dec_PKIData_reqSequence'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TaggedRequest'(V1, []) || V1 <- Tlv1].


'dec_PKIData_cmsSequence'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TaggedContentInfo'(V1, [16]) || V1 <- Tlv1].


'dec_PKIData_otherMsgSequence'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_OtherMsg'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  BodyPartID
%%================================
enc_BodyPartID(Val) ->
    enc_BodyPartID(Val, [<<2>>]).

enc_BodyPartID(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_BodyPartID(Tlv) ->
   dec_BodyPartID(Tlv, [2]).

dec_BodyPartID(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  TaggedAttribute
%%================================
enc_TaggedAttribute(Val) ->
    enc_TaggedAttribute(Val, [<<48>>]).

enc_TaggedAttribute(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,
ObjattrType = 
   'EnrollmentMessageSyntax-2009':'getenc_Cmc-Control-Set'(                                   Cindex2),

%%-------------------------------------------------
%% attribute bodyPartID(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute attrType(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_object_identifier(Cindex2, [<<6>>]),

%%-------------------------------------------------
%% attribute attrValues(3) with type SET OF
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_TaggedAttribute_attrValues'(Cindex3, [<<49>>], ObjattrType),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TaggedAttribute_attrValues
%%================================
enc_TaggedAttribute_attrValues(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_TaggedAttribute_attrValues_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TaggedAttribute_attrValues_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_TaggedAttribute_attrValues_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_TaggedAttribute_attrValues_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_TaggedAttribute(Tlv) ->
   dec_TaggedAttribute(Tlv, [16]).

dec_TaggedAttribute(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute bodyPartID(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute attrType(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_object_identifier(V2, [6]),
ObjFun = 'EnrollmentMessageSyntax-2009':'getdec_Cmc-Control-Set'(Term2),

%%-------------------------------------------------
%% attribute attrValues(3) with type SET OF
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_TaggedAttribute_attrValues'(V3, [17], ObjFun),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'TaggedAttribute',Term1,Term2,Term3},
Res1.
'dec_TaggedAttribute_attrValues'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].




%%================================
%%  TaggedRequest
%%================================
enc_TaggedRequest(Val) ->
    enc_TaggedRequest(Val, []).

enc_TaggedRequest(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      tcr ->
         'enc_TaggedCertificationRequest'(element(2,Val), [<<160>>]);
      crm ->
         'PKIXCRMF-2009':'enc_CertReqMsg'(element(2,Val), [<<161>>]);
      orm ->
         'enc_TaggedRequest_orm'(element(2,Val), [<<162>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  TaggedRequest_orm
%%================================
enc_TaggedRequest_orm(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,
ObjrequestMessageType = 
   'EnrollmentMessageSyntax-2009':'getenc_OtherRequests'(                                   Cindex2),

%%-------------------------------------------------
%% attribute bodyPartID(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute requestMessageType(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_object_identifier(Cindex2, [<<6>>]),

%%-------------------------------------------------
%% attribute requestMessageValue(3) with type typefieldType
%%-------------------------------------------------
   {TmpBytes3,_} = ObjrequestMessageType('Type', Cindex3, []),
   {EncBytes3,EncLen3} = encode_open_type(TmpBytes3, [])
,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_TaggedRequest(Tlv) ->
   dec_TaggedRequest(Tlv, []).

dec_TaggedRequest(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'tcr'
    {131072, V1} -> 
        {tcr, 'dec_TaggedCertificationRequest'(V1, [])};


%% 'crm'
    {131073, V1} -> 
        {crm, 'PKIXCRMF-2009':'dec_CertReqMsg'(V1, [])};


%% 'orm'
    {131074, V1} -> 
        {orm, 'dec_TaggedRequest_orm'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_TaggedRequest_orm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute bodyPartID(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute requestMessageType(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_object_identifier(V2, [6]),

%%-------------------------------------------------
%% attribute requestMessageValue(3) with type typefieldType
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 

  Tmpterm1 = decode_open_type(V3, []),

DecObjrequestMessageTypeTerm2 =
   'EnrollmentMessageSyntax-2009':'getdec_OtherRequests'(Term2),
Term3 = 
   case (catch DecObjrequestMessageTypeTerm2('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'TaggedRequest_orm',Term1,Term2,Term3},
Res1.


%%================================
%%  TaggedCertificationRequest
%%================================
enc_TaggedCertificationRequest(Val) ->
    enc_TaggedCertificationRequest(Val, [<<48>>]).

enc_TaggedCertificationRequest(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute bodyPartID(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute certificationRequest(2)   External EnrollmentMessageSyntax-2009:CertificationRequest
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CertificationRequest'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_TaggedCertificationRequest(Tlv) ->
   dec_TaggedCertificationRequest(Tlv, [16]).

dec_TaggedCertificationRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute bodyPartID(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute certificationRequest(2)   External EnrollmentMessageSyntax-2009:CertificationRequest
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CertificationRequest'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'TaggedCertificationRequest',Term1,Term2},
Res1.


%%================================
%%  CertificationRequest
%%================================
enc_CertificationRequest(Val) ->
    enc_CertificationRequest(Val, [<<48>>]).

enc_CertificationRequest(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute certificationRequestInfo(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CertificationRequest_certificationRequestInfo'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CertificationRequest_signatureAlgorithm'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertificationRequest_certificationRequestInfo
%%================================
enc_CertificationRequest_certificationRequestInfo(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute subject(2)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'PKIX1Explicit-2009':'enc_Name'(Cindex2, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(3) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute attributes(4) with type SET OF
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_CertificationRequest_certificationRequestInfo_attributes'(Cindex4, [<<160>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo
%%================================
enc_CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute algorithm(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type BIT STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_unnamed_bit_string(Cindex2, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm
%%================================
enc_CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'EnrollmentMessageSyntax-2009':'getenc_internal_object_set_argument_2'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertificationRequest_certificationRequestInfo_attributes
%%================================
enc_CertificationRequest_certificationRequestInfo_attributes(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_CertificationRequest_certificationRequestInfo_attributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertificationRequest_certificationRequestInfo_attributes_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_CertificationRequest_certificationRequestInfo_attributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CertificationRequest_certificationRequestInfo_attributes_AttributeSet'(H, [<<48>>]),
   'enc_CertificationRequest_certificationRequestInfo_attributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  CertificationRequest_certificationRequestInfo_attributes_AttributeSet
%%================================
enc_CertificationRequest_certificationRequestInfo_attributes_AttributeSet(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'EnrollmentMessageSyntax-2009':'getenc_internal_object_set_argument_3'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CertificationRequest_certificationRequestInfo_attributes_AttributeSet_values'(Cindex2, [<<49>>], Objtype),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertificationRequest_certificationRequestInfo_attributes_AttributeSet_values
%%================================
enc_CertificationRequest_certificationRequestInfo_attributes_AttributeSet_values(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_CertificationRequest_certificationRequestInfo_attributes_AttributeSet_values_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertificationRequest_certificationRequestInfo_attributes_AttributeSet_values_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_CertificationRequest_certificationRequestInfo_attributes_AttributeSet_values_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_CertificationRequest_certificationRequestInfo_attributes_AttributeSet_values_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  CertificationRequest_signatureAlgorithm
%%================================
enc_CertificationRequest_signatureAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'EnrollmentMessageSyntax-2009':'getenc_internal_object_set_argument_5'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertificationRequest(Tlv) ->
   dec_CertificationRequest(Tlv, [16]).

dec_CertificationRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certificationRequestInfo(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CertificationRequest_certificationRequestInfo'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CertificationRequest_signatureAlgorithm'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CertificationRequest',Term1,Term2,Term3},
Res1.
'dec_CertificationRequest_certificationRequestInfo'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute subject(2)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'PKIX1Explicit-2009':'dec_Name'(V2, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(3) with type SEQUENCE
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo'(V3, [16]),

%%-------------------------------------------------
%% attribute attributes(4) with type SET OF
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_CertificationRequest_certificationRequestInfo_attributes'(V4, [131072]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'CertificationRequest_certificationRequestInfo',Term1,Term2,Term3,Term4},
Res1.
'dec_CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute subjectPublicKey(2) with type BIT STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_native_bit_string(V2, [3]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo',Term1,Term2},
Res1.
'dec_CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'EnrollmentMessageSyntax-2009':'getdec_internal_object_set_argument_2'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm',Term1,Term2},
Res1.
'dec_CertificationRequest_certificationRequestInfo_attributes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CertificationRequest_certificationRequestInfo_attributes_AttributeSet'(V1, [16]) || V1 <- Tlv1].


'dec_CertificationRequest_certificationRequestInfo_attributes_AttributeSet'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'EnrollmentMessageSyntax-2009':'getdec_internal_object_set_argument_3'(Term1),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CertificationRequest_certificationRequestInfo_attributes_AttributeSet_values'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributeSet',Term1,Term2},
Res1.
'dec_CertificationRequest_certificationRequestInfo_attributes_AttributeSet_values'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].


'dec_CertificationRequest_signatureAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'EnrollmentMessageSyntax-2009':'getdec_internal_object_set_argument_5'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CertificationRequest_signatureAlgorithm',Term1,Term2},
Res1.


%%================================
%%  TaggedContentInfo
%%================================
enc_TaggedContentInfo(Val) ->
    enc_TaggedContentInfo(Val, [<<48>>]).

enc_TaggedContentInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute bodyPartID(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute contentInfo(2)   External CryptographicMessageSyntax-2009:ContentInfo
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'CryptographicMessageSyntax-2009':'enc_ContentInfo'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_TaggedContentInfo(Tlv) ->
   dec_TaggedContentInfo(Tlv, [16]).

dec_TaggedContentInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute bodyPartID(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute contentInfo(2)   External CryptographicMessageSyntax-2009:ContentInfo
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'CryptographicMessageSyntax-2009':'dec_ContentInfo'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'TaggedContentInfo',Term1,Term2},
Res1.


%%================================
%%  OtherMsg
%%================================
enc_OtherMsg(Val) ->
    enc_OtherMsg(Val, [<<48>>]).

enc_OtherMsg(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,
ObjotherMsgType = 
   'EnrollmentMessageSyntax-2009':'getenc_OtherMsgSet'(                                   Cindex2),

%%-------------------------------------------------
%% attribute bodyPartID(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute otherMsgType(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_object_identifier(Cindex2, [<<6>>]),

%%-------------------------------------------------
%% attribute otherMsgValue(3) with type typefieldType
%%-------------------------------------------------
   {TmpBytes3,_} = ObjotherMsgType('Type', Cindex3, []),
   {EncBytes3,EncLen3} = encode_open_type(TmpBytes3, [])
,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OtherMsg(Tlv) ->
   dec_OtherMsg(Tlv, [16]).

dec_OtherMsg(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute bodyPartID(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute otherMsgType(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_object_identifier(V2, [6]),

%%-------------------------------------------------
%% attribute otherMsgValue(3) with type typefieldType
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 

  Tmpterm1 = decode_open_type(V3, []),

DecObjotherMsgTypeTerm2 =
   'EnrollmentMessageSyntax-2009':'getdec_OtherMsgSet'(Term2),
Term3 = 
   case (catch DecObjotherMsgTypeTerm2('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'OtherMsg',Term1,Term2,Term3},
Res1.


%%================================
%%  ResponseBody
%%================================
enc_ResponseBody(Val) ->
    enc_ResponseBody(Val, [<<48>>]).

enc_ResponseBody(Val, TagIn) ->
   enc_PKIResponse(Val, TagIn).


dec_ResponseBody(Tlv) ->
   dec_ResponseBody(Tlv, [16]).

dec_ResponseBody(Tlv, TagIn) ->
'dec_PKIResponse'(Tlv, TagIn).



%%================================
%%  PKIResponse
%%================================
enc_PKIResponse(Val) ->
    enc_PKIResponse(Val, [<<48>>]).

enc_PKIResponse(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute controlSequence(1) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PKIResponse_controlSequence'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute cmsSequence(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PKIResponse_cmsSequence'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute otherMsgSequence(3) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_PKIResponse_otherMsgSequence'(Cindex3, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PKIResponse_controlSequence
%%================================
enc_PKIResponse_controlSequence(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PKIResponse_controlSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PKIResponse_controlSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PKIResponse_controlSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TaggedAttribute'(H, [<<48>>]),
   'enc_PKIResponse_controlSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  PKIResponse_cmsSequence
%%================================
enc_PKIResponse_cmsSequence(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PKIResponse_cmsSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PKIResponse_cmsSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PKIResponse_cmsSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TaggedContentInfo'(H, [<<48>>]),
   'enc_PKIResponse_cmsSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  PKIResponse_otherMsgSequence
%%================================
enc_PKIResponse_otherMsgSequence(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PKIResponse_otherMsgSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PKIResponse_otherMsgSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PKIResponse_otherMsgSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_OtherMsg'(H, [<<48>>]),
   'enc_PKIResponse_otherMsgSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PKIResponse(Tlv) ->
   dec_PKIResponse(Tlv, [16]).

dec_PKIResponse(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute controlSequence(1) with type SEQUENCE OF
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PKIResponse_controlSequence'(V1, [16]),

%%-------------------------------------------------
%% attribute cmsSequence(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PKIResponse_cmsSequence'(V2, [16]),

%%-------------------------------------------------
%% attribute otherMsgSequence(3) with type SEQUENCE OF
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_PKIResponse_otherMsgSequence'(V3, [16]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'PKIResponse',Term1,Term2,Term3},
Res1.
'dec_PKIResponse_controlSequence'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TaggedAttribute'(V1, [16]) || V1 <- Tlv1].


'dec_PKIResponse_cmsSequence'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TaggedContentInfo'(V1, [16]) || V1 <- Tlv1].


'dec_PKIResponse_otherMsgSequence'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_OtherMsg'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  CMCStatusInfo
%%================================
enc_CMCStatusInfo(Val) ->
    enc_CMCStatusInfo(Val, [<<48>>]).

enc_CMCStatusInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute cMCStatus(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{success,0},{failed,2},{pending,3},{noSupport,4},{confirmRequired,5},{popRequired,6},{partial,7}], [<<2>>]),

%%-------------------------------------------------
%% attribute bodyList(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CMCStatusInfo_bodyList'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute statusString(3) with type UTF8String OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_UTF8_string(Cindex3, [<<12>>])
       end,

%%-------------------------------------------------
%% attribute otherInfo(4) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CMCStatusInfo_otherInfo'(Cindex4, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CMCStatusInfo_bodyList
%%================================
enc_CMCStatusInfo_bodyList(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_CMCStatusInfo_bodyList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CMCStatusInfo_bodyList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CMCStatusInfo_bodyList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_integer(H, [<<2>>]),
   'enc_CMCStatusInfo_bodyList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  CMCStatusInfo_otherInfo
%%================================
enc_CMCStatusInfo_otherInfo(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      failInfo ->
         encode_integer(element(2,Val), [{badAlg,0},{badMessageCheck,1},{badRequest,2},{badTime,3},{badCertId,4},{unsuportedExt,5},{mustArchiveKeys,6},{badIdentity,7},{popRequired,8},{popFailed,9},{noKeyReuse,10},{internalCAError,11},{tryLater,12},{authDataFail,13}], [<<2>>]);
      pendInfo ->
         'enc_PendInfo'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_CMCStatusInfo(Tlv) ->
   dec_CMCStatusInfo(Tlv, [16]).

dec_CMCStatusInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute cMCStatus(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{success,0},{failed,2},{pending,3},{noSupport,4},{confirmRequired,5},{popRequired,6},{partial,7}])
end
,

%%-------------------------------------------------
%% attribute bodyList(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CMCStatusInfo_bodyList'(V2, [16]),

%%-------------------------------------------------
%% attribute statusString(3) with type UTF8String OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{12,V3}|TempTlv4] ->
    {decode_UTF8_string(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute otherInfo(4) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[V4 = {2,_}|TempTlv5] ->
    {'dec_CMCStatusInfo_otherInfo'(V4, []), TempTlv5};
[V4 = {16,_}|TempTlv5] ->
    {'dec_CMCStatusInfo_otherInfo'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'CMCStatusInfo',Term1,Term2,Term3,Term4},
Res1.
'dec_CMCStatusInfo_bodyList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end || V1 <- Tlv1].


'dec_CMCStatusInfo_otherInfo'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'failInfo'
    {2, V1} -> 
        {failInfo, begin
Val1 = decode_integer(V1, []),
number2name(Val1, [{badAlg,0},{badMessageCheck,1},{badRequest,2},{badTime,3},{badCertId,4},{unsuportedExt,5},{mustArchiveKeys,6},{badIdentity,7},{popRequired,8},{popFailed,9},{noKeyReuse,10},{internalCAError,11},{tryLater,12},{authDataFail,13}])
end
};


%% 'pendInfo'
    {16, V1} -> 
        {pendInfo, 'dec_PendInfo'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  PendInfo
%%================================
enc_PendInfo(Val) ->
    enc_PendInfo(Val, [<<48>>]).

enc_PendInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute pendToken(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute pendTime(2) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<24>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PendInfo(Tlv) ->
   dec_PendInfo(Tlv, [16]).

dec_PendInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute pendToken(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_octet_string(V1, [4]),

%%-------------------------------------------------
%% attribute pendTime(2) with type GeneralizedTime
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
binary_to_list(decode_restricted_string(V2, [24]))
end
,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PendInfo',Term1,Term2},
Res1.


%%================================
%%  CMCStatus
%%================================
enc_CMCStatus(Val) ->
    enc_CMCStatus(Val, [<<2>>]).

enc_CMCStatus(Val, TagIn) ->
encode_integer(Val, [{success,0},{failed,2},{pending,3},{noSupport,4},{confirmRequired,5},{popRequired,6},{partial,7}], TagIn).


dec_CMCStatus(Tlv) ->
   dec_CMCStatus(Tlv, [2]).

dec_CMCStatus(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{success,0},{failed,2},{pending,3},{noSupport,4},{confirmRequired,5},{popRequired,6},{partial,7}])
end
.



%%================================
%%  CMCFailInfo
%%================================
enc_CMCFailInfo(Val) ->
    enc_CMCFailInfo(Val, [<<2>>]).

enc_CMCFailInfo(Val, TagIn) ->
encode_integer(Val, [{badAlg,0},{badMessageCheck,1},{badRequest,2},{badTime,3},{badCertId,4},{unsuportedExt,5},{mustArchiveKeys,6},{badIdentity,7},{popRequired,8},{popFailed,9},{noKeyReuse,10},{internalCAError,11},{tryLater,12},{authDataFail,13}], TagIn).


dec_CMCFailInfo(Tlv) ->
   dec_CMCFailInfo(Tlv, [2]).

dec_CMCFailInfo(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{badAlg,0},{badMessageCheck,1},{badRequest,2},{badTime,3},{badCertId,4},{unsuportedExt,5},{mustArchiveKeys,6},{badIdentity,7},{popRequired,8},{popFailed,9},{noKeyReuse,10},{internalCAError,11},{tryLater,12},{authDataFail,13}])
end
.



%%================================
%%  AddExtensions
%%================================
enc_AddExtensions(Val) ->
    enc_AddExtensions(Val, [<<48>>]).

enc_AddExtensions(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute pkiDataReference(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute certReferences(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AddExtensions_certReferences'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute extensions(3) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_AddExtensions_extensions'(Cindex3, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AddExtensions_certReferences
%%================================
enc_AddExtensions_certReferences(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_AddExtensions_certReferences_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AddExtensions_certReferences_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AddExtensions_certReferences_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_integer(H, [<<2>>]),
   'enc_AddExtensions_certReferences_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  AddExtensions_extensions
%%================================
enc_AddExtensions_extensions(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_AddExtensions_extensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AddExtensions_extensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AddExtensions_extensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AddExtensions_extensions_Extension'(H, [<<48>>]),
   'enc_AddExtensions_extensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  AddExtensions_extensions_Extension
%%================================
enc_AddExtensions_extensions_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_1(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AddExtensions(Tlv) ->
   dec_AddExtensions(Tlv, [16]).

dec_AddExtensions(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute pkiDataReference(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute certReferences(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AddExtensions_certReferences'(V2, [16]),

%%-------------------------------------------------
%% attribute extensions(3) with type SEQUENCE OF
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_AddExtensions_extensions'(V3, [16]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'AddExtensions',Term1,Term2,Term3},
Res1.
'dec_AddExtensions_certReferences'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end || V1 <- Tlv1].


'dec_AddExtensions_extensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AddExtensions_extensions_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_AddExtensions_extensions_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  EncryptedPOP
%%================================
enc_EncryptedPOP(Val) ->
    enc_EncryptedPOP(Val, [<<48>>]).

enc_EncryptedPOP(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5} = Val,

%%-------------------------------------------------
%% attribute request(1)   External EnrollmentMessageSyntax-2009:TaggedRequest
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TaggedRequest'(Cindex1, []),

%%-------------------------------------------------
%% attribute cms(2)   External CryptographicMessageSyntax-2009:ContentInfo
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'CryptographicMessageSyntax-2009':'enc_ContentInfo'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute thePOPAlgID(3) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_EncryptedPOP_thePOPAlgID'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute witnessAlgID(4) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_EncryptedPOP_witnessAlgID'(Cindex4, [<<48>>]),

%%-------------------------------------------------
%% attribute witness(5) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes5,EncLen5} = encode_restricted_string(Cindex5, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EncryptedPOP_thePOPAlgID
%%================================
enc_EncryptedPOP_thePOPAlgID(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'EnrollmentMessageSyntax-2009':'getenc_internal_object_set_argument_8'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EncryptedPOP_witnessAlgID
%%================================
enc_EncryptedPOP_witnessAlgID(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'EnrollmentMessageSyntax-2009':'getenc_internal_object_set_argument_10'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_EncryptedPOP(Tlv) ->
   dec_EncryptedPOP(Tlv, [16]).

dec_EncryptedPOP(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute request(1)   External EnrollmentMessageSyntax-2009:TaggedRequest
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TaggedRequest'(V1, []),

%%-------------------------------------------------
%% attribute cms(2)   External CryptographicMessageSyntax-2009:ContentInfo
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'CryptographicMessageSyntax-2009':'dec_ContentInfo'(V2, [16]),

%%-------------------------------------------------
%% attribute thePOPAlgID(3) with type SEQUENCE
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_EncryptedPOP_thePOPAlgID'(V3, [16]),

%%-------------------------------------------------
%% attribute witnessAlgID(4) with type SEQUENCE
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_EncryptedPOP_witnessAlgID'(V4, [16]),

%%-------------------------------------------------
%% attribute witness(5) with type OCTET STRING
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = decode_octet_string(V5, [4]),

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'EncryptedPOP',Term1,Term2,Term3,Term4,Term5},
Res1.
'dec_EncryptedPOP_thePOPAlgID'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'EnrollmentMessageSyntax-2009':'getdec_internal_object_set_argument_8'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'EncryptedPOP_thePOPAlgID',Term1,Term2},
Res1.
'dec_EncryptedPOP_witnessAlgID'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'EnrollmentMessageSyntax-2009':'getdec_internal_object_set_argument_10'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'EncryptedPOP_witnessAlgID',Term1,Term2},
Res1.


%%================================
%%  DecryptedPOP
%%================================
enc_DecryptedPOP(Val) ->
    enc_DecryptedPOP(Val, [<<48>>]).

enc_DecryptedPOP(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute bodyPartID(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute thePOPAlgID(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_DecryptedPOP_thePOPAlgID'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute thePOP(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  DecryptedPOP_thePOPAlgID
%%================================
enc_DecryptedPOP_thePOPAlgID(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'EnrollmentMessageSyntax-2009':'getenc_internal_object_set_argument_12'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DecryptedPOP(Tlv) ->
   dec_DecryptedPOP(Tlv, [16]).

dec_DecryptedPOP(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute bodyPartID(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute thePOPAlgID(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_DecryptedPOP_thePOPAlgID'(V2, [16]),

%%-------------------------------------------------
%% attribute thePOP(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'DecryptedPOP',Term1,Term2,Term3},
Res1.
'dec_DecryptedPOP_thePOPAlgID'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'EnrollmentMessageSyntax-2009':'getdec_internal_object_set_argument_12'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'DecryptedPOP_thePOPAlgID',Term1,Term2},
Res1.


%%================================
%%  LraPopWitness
%%================================
enc_LraPopWitness(Val) ->
    enc_LraPopWitness(Val, [<<48>>]).

enc_LraPopWitness(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute pkiDataBodyid(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute bodyIds(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_LraPopWitness_bodyIds'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  LraPopWitness_bodyIds
%%================================
enc_LraPopWitness_bodyIds(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_LraPopWitness_bodyIds_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_LraPopWitness_bodyIds_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_LraPopWitness_bodyIds_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_integer(H, [<<2>>]),
   'enc_LraPopWitness_bodyIds_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_LraPopWitness(Tlv) ->
   dec_LraPopWitness(Tlv, [16]).

dec_LraPopWitness(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute pkiDataBodyid(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute bodyIds(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_LraPopWitness_bodyIds'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'LraPopWitness',Term1,Term2},
Res1.
'dec_LraPopWitness_bodyIds'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end || V1 <- Tlv1].




%%================================
%%  GetCert
%%================================
enc_GetCert(Val) ->
    enc_GetCert(Val, [<<48>>]).

enc_GetCert(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute issuerName(1)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIX1Implicit-2009':'enc_GeneralName'(Cindex1, []),

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_GetCert(Tlv) ->
   dec_GetCert(Tlv, [16]).

dec_GetCert(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuerName(1)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIX1Implicit-2009':'dec_GeneralName'(V1, []),

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'GetCert',Term1,Term2},
Res1.


%%================================
%%  GetCRL
%%================================
enc_GetCRL(Val) ->
    enc_GetCRL(Val, [<<48>>]).

enc_GetCRL(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute issuerName(1)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIX1Explicit-2009':'enc_Name'(Cindex1, []),

%%-------------------------------------------------
%% attribute cRLName(2)   External PKIX1Implicit-2009:GeneralName OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit-2009':'enc_GeneralName'(Cindex2, [])
       end,

%%-------------------------------------------------
%% attribute time(3) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<24>>])
       end,

%%-------------------------------------------------
%% attribute reasons(4) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_named_bit_string(Cindex4, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], [<<3>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_GetCRL(Tlv) ->
   dec_GetCRL(Tlv, [16]).

dec_GetCRL(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuerName(1)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIX1Explicit-2009':'dec_Name'(V1, []),

%%-------------------------------------------------
%% attribute cRLName(2)   External PKIX1Implicit-2009:GeneralName OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2 = {131072,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131073,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131074,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131075,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131076,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131077,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131078,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131079,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131080,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute time(3) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{24,V3}|TempTlv4] ->
    {begin
binary_to_list(decode_restricted_string(V3, []))
end
, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute reasons(4) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{3,V4}|TempTlv5] ->
    {decode_named_bit_string(V4, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'GetCRL',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  RevokeRequest
%%================================
enc_RevokeRequest(Val) ->
    enc_RevokeRequest(Val, [<<48>>]).

enc_RevokeRequest(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6} = Val,

%%-------------------------------------------------
%% attribute issuerName(1)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIX1Explicit-2009':'enc_Name'(Cindex1, []),

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute reason(3) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes3,EncLen3} = case Cindex3 of
unspecified -> encode_tags([<<10>>], [0], 1);
keyCompromise -> encode_tags([<<10>>], [1], 1);
cACompromise -> encode_tags([<<10>>], [2], 1);
affiliationChanged -> encode_tags([<<10>>], [3], 1);
superseded -> encode_tags([<<10>>], [4], 1);
cessationOfOperation -> encode_tags([<<10>>], [5], 1);
certificateHold -> encode_tags([<<10>>], [6], 1);
removeFromCRL -> encode_tags([<<10>>], [8], 1);
privilegeWithdrawn -> encode_tags([<<10>>], [9], 1);
aACompromise -> encode_tags([<<10>>], [10], 1);
Enumval2 -> exit({error,{asn1, {enumerated_not_in_range,Enumval2}}})
end,

%%-------------------------------------------------
%% attribute invalidityDate(4) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex4, [<<24>>])
       end,

%%-------------------------------------------------
%% attribute passphrase(5) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex5, [<<4>>])
       end,

%%-------------------------------------------------
%% attribute comment(6) with type UTF8String OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_UTF8_string(Cindex6, [<<12>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RevokeRequest(Tlv) ->
   dec_RevokeRequest(Tlv, [16]).

dec_RevokeRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuerName(1)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIX1Explicit-2009':'dec_Name'(V1, []),

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute reason(3) with type ENUMERATED
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = case decode_integer(V3, [10]) of
0 -> unspecified;
1 -> keyCompromise;
2 -> cACompromise;
3 -> affiliationChanged;
4 -> superseded;
5 -> cessationOfOperation;
6 -> certificateHold;
8 -> removeFromCRL;
9 -> privilegeWithdrawn;
10 -> aACompromise;
Default1 -> exit({error,{asn1,{illegal_enumerated,Default1}}})
end,

%%-------------------------------------------------
%% attribute invalidityDate(4) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{24,V4}|TempTlv5] ->
    {begin
binary_to_list(decode_restricted_string(V4, []))
end
, TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute passphrase(5) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{4,V5}|TempTlv6] ->
    {decode_octet_string(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute comment(6) with type UTF8String OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{12,V6}|TempTlv7] ->
    {decode_UTF8_string(V6, []), TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

case Tlv7 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv7}}}) % extra fields not allowed
end,
Res1 = {'RevokeRequest',Term1,Term2,Term3,Term4,Term5,Term6},
Res1.


%%================================
%%  CMCCertId
%%================================
enc_CMCCertId(Val) ->
    enc_CMCCertId(Val, [<<48>>]).

enc_CMCCertId(Val, TagIn) ->
   'CryptographicMessageSyntax-2009':enc_IssuerAndSerialNumber(Val, TagIn).


dec_CMCCertId(Tlv) ->
   dec_CMCCertId(Tlv, [16]).

dec_CMCCertId(Tlv, TagIn) ->
'CryptographicMessageSyntax-2009':'dec_IssuerAndSerialNumber'(Tlv, TagIn).



%%================================
%%  ExtensionReq
%%================================
enc_ExtensionReq(Val) ->
    enc_ExtensionReq(Val, [<<48>>]).

enc_ExtensionReq(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ExtensionReq_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ExtensionReq_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ExtensionReq_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ExtensionReq_Extension'(H, [<<48>>]),
   'enc_ExtensionReq_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  ExtensionReq_Extension
%%================================
enc_ExtensionReq_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_1(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ExtensionReq(Tlv) ->
   dec_ExtensionReq(Tlv, [16]).

dec_ExtensionReq(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_ExtensionReq_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_ExtensionReq_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  NoSignatureValue
%%================================
enc_NoSignatureValue(Val) ->
    enc_NoSignatureValue(Val, [<<4>>]).

enc_NoSignatureValue(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_NoSignatureValue(Tlv) ->
   dec_NoSignatureValue(Tlv, [4]).

dec_NoSignatureValue(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  CMCUnsignedData
%%================================
enc_CMCUnsignedData(Val) ->
    enc_CMCUnsignedData(Val, [<<48>>]).

enc_CMCUnsignedData(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute bodyPartPath(1)   External EnrollmentMessageSyntax-2009:BodyPartPath
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_BodyPartPath'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute identifier(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_object_identifier(Cindex2, [<<6>>]),

%%-------------------------------------------------
%% attribute content(3) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_open_type(Cindex3, []),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CMCUnsignedData(Tlv) ->
   dec_CMCUnsignedData(Tlv, [16]).

dec_CMCUnsignedData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute bodyPartPath(1)   External EnrollmentMessageSyntax-2009:BodyPartPath
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_BodyPartPath'(V1, [16]),

%%-------------------------------------------------
%% attribute identifier(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_object_identifier(V2, [6]),

%%-------------------------------------------------
%% attribute content(3) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_open_type_as_binary(V3, []),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CMCUnsignedData',Term1,Term2,Term3},
Res1.


%%================================
%%  CMCStatusInfoV2
%%================================
enc_CMCStatusInfoV2(Val) ->
    enc_CMCStatusInfoV2(Val, [<<48>>]).

enc_CMCStatusInfoV2(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute cMCStatus(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{success,0},{failed,2},{pending,3},{noSupport,4},{confirmRequired,5},{popRequired,6},{partial,7}], [<<2>>]),

%%-------------------------------------------------
%% attribute bodyList(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CMCStatusInfoV2_bodyList'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute statusString(3) with type UTF8String OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_UTF8_string(Cindex3, [<<12>>])
       end,

%%-------------------------------------------------
%% attribute otherInfo(4) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CMCStatusInfoV2_otherInfo'(Cindex4, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CMCStatusInfoV2_bodyList
%%================================
enc_CMCStatusInfoV2_bodyList(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_CMCStatusInfoV2_bodyList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CMCStatusInfoV2_bodyList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CMCStatusInfoV2_bodyList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_BodyPartReference'(H, []),
   'enc_CMCStatusInfoV2_bodyList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  CMCStatusInfoV2_otherInfo
%%================================
enc_CMCStatusInfoV2_otherInfo(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      failInfo ->
         encode_integer(element(2,Val), [{badAlg,0},{badMessageCheck,1},{badRequest,2},{badTime,3},{badCertId,4},{unsuportedExt,5},{mustArchiveKeys,6},{badIdentity,7},{popRequired,8},{popFailed,9},{noKeyReuse,10},{internalCAError,11},{tryLater,12},{authDataFail,13}], [<<2>>]);
      pendInfo ->
         'enc_PendInfo'(element(2,Val), [<<48>>]);
      extendedFailInfo ->
         'enc_CMCStatusInfoV2_otherInfo_extendedFailInfo'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  CMCStatusInfoV2_otherInfo_extendedFailInfo
%%================================
enc_CMCStatusInfoV2_otherInfo_extendedFailInfo(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
ObjfailInfoOID = 
   'EnrollmentMessageSyntax-2009':'getenc_ExtendedFailures'(                                   Cindex1),

%%-------------------------------------------------
%% attribute failInfoOID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute failInfoValue(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = ObjfailInfoOID('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CMCStatusInfoV2(Tlv) ->
   dec_CMCStatusInfoV2(Tlv, [16]).

dec_CMCStatusInfoV2(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute cMCStatus(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{success,0},{failed,2},{pending,3},{noSupport,4},{confirmRequired,5},{popRequired,6},{partial,7}])
end
,

%%-------------------------------------------------
%% attribute bodyList(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CMCStatusInfoV2_bodyList'(V2, [16]),

%%-------------------------------------------------
%% attribute statusString(3) with type UTF8String OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{12,V3}|TempTlv4] ->
    {decode_UTF8_string(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute otherInfo(4) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[V4 = {2,_}|TempTlv5] ->
    {'dec_CMCStatusInfoV2_otherInfo'(V4, []), TempTlv5};
[V4 = {16,_}|TempTlv5] ->
    {'dec_CMCStatusInfoV2_otherInfo'(V4, []), TempTlv5};
[V4 = {131073,_}|TempTlv5] ->
    {'dec_CMCStatusInfoV2_otherInfo'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'CMCStatusInfoV2',Term1,Term2,Term3,Term4},
Res1.
'dec_CMCStatusInfoV2_bodyList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_BodyPartReference'(V1, []) || V1 <- Tlv1].


'dec_CMCStatusInfoV2_otherInfo'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'failInfo'
    {2, V1} -> 
        {failInfo, begin
Val1 = decode_integer(V1, []),
number2name(Val1, [{badAlg,0},{badMessageCheck,1},{badRequest,2},{badTime,3},{badCertId,4},{unsuportedExt,5},{mustArchiveKeys,6},{badIdentity,7},{popRequired,8},{popFailed,9},{noKeyReuse,10},{internalCAError,11},{tryLater,12},{authDataFail,13}])
end
};


%% 'pendInfo'
    {16, V1} -> 
        {pendInfo, 'dec_PendInfo'(V1, [])};


%% 'extendedFailInfo'
    {131073, V1} -> 
        {extendedFailInfo, 'dec_CMCStatusInfoV2_otherInfo_extendedFailInfo'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_CMCStatusInfoV2_otherInfo_extendedFailInfo'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute failInfoOID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute failInfoValue(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjfailInfoOIDTerm1 =
   'EnrollmentMessageSyntax-2009':'getdec_ExtendedFailures'(Term1),
Term2 = 
   case (catch DecObjfailInfoOIDTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CMCStatusInfoV2_otherInfo_extendedFailInfo',Term1,Term2},
Res1.


%%================================
%%  BodyPartReference
%%================================
enc_BodyPartReference(Val) ->
    enc_BodyPartReference(Val, []).

enc_BodyPartReference(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      bodyPartID ->
         encode_integer(element(2,Val), [<<2>>]);
      bodyPartPath ->
         'enc_BodyPartPath'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_BodyPartReference(Tlv) ->
   dec_BodyPartReference(Tlv, []).

dec_BodyPartReference(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'bodyPartID'
    {2, V1} -> 
        {bodyPartID, begin
Val1 = decode_integer(V1, []),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bodyPartPath'
    {16, V1} -> 
        {bodyPartPath, 'dec_BodyPartPath'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  BodyPartPath
%%================================
enc_BodyPartPath(Val) ->
    enc_BodyPartPath(Val, [<<48>>]).

enc_BodyPartPath(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_BodyPartPath_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_BodyPartPath_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_BodyPartPath_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_integer(H, [<<2>>]),
   'enc_BodyPartPath_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_BodyPartPath(Tlv) ->
   dec_BodyPartPath(Tlv, [16]).

dec_BodyPartPath(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end || V1 <- Tlv1].




%%================================
%%  PublishTrustAnchors
%%================================
enc_PublishTrustAnchors(Val) ->
    enc_PublishTrustAnchors(Val, [<<48>>]).

enc_PublishTrustAnchors(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute seqNumber(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute hashAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PublishTrustAnchors_hashAlgorithm'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute anchorHashes(3) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_PublishTrustAnchors_anchorHashes'(Cindex3, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PublishTrustAnchors_hashAlgorithm
%%================================
enc_PublishTrustAnchors_hashAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'EnrollmentMessageSyntax-2009':'getenc_internal_object_set_argument_15'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PublishTrustAnchors_anchorHashes
%%================================
enc_PublishTrustAnchors_anchorHashes(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PublishTrustAnchors_anchorHashes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PublishTrustAnchors_anchorHashes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PublishTrustAnchors_anchorHashes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<4>>]),
   'enc_PublishTrustAnchors_anchorHashes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PublishTrustAnchors(Tlv) ->
   dec_PublishTrustAnchors(Tlv, [16]).

dec_PublishTrustAnchors(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute seqNumber(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute hashAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PublishTrustAnchors_hashAlgorithm'(V2, [16]),

%%-------------------------------------------------
%% attribute anchorHashes(3) with type SEQUENCE OF
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_PublishTrustAnchors_anchorHashes'(V3, [16]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'PublishTrustAnchors',Term1,Term2,Term3},
Res1.
'dec_PublishTrustAnchors_hashAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'EnrollmentMessageSyntax-2009':'getdec_internal_object_set_argument_15'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PublishTrustAnchors_hashAlgorithm',Term1,Term2},
Res1.
'dec_PublishTrustAnchors_anchorHashes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_octet_string(V1, [4]) || V1 <- Tlv1].




%%================================
%%  AuthPublish
%%================================
enc_AuthPublish(Val) ->
    enc_AuthPublish(Val, [<<2>>]).

enc_AuthPublish(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_AuthPublish(Tlv) ->
   dec_AuthPublish(Tlv, [2]).

dec_AuthPublish(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  BodyPartList
%%================================
enc_BodyPartList(Val) ->
    enc_BodyPartList(Val, [<<48>>]).

enc_BodyPartList(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_BodyPartList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_BodyPartList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_BodyPartList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_integer(H, [<<2>>]),
   'enc_BodyPartList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_BodyPartList(Tlv) ->
   dec_BodyPartList(Tlv, [16]).

dec_BodyPartList(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end || V1 <- Tlv1].




%%================================
%%  CMCPublicationInfo
%%================================
enc_CMCPublicationInfo(Val) ->
    enc_CMCPublicationInfo(Val, [<<48>>]).

enc_CMCPublicationInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute hashAlg(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CMCPublicationInfo_hashAlg'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute certHashes(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CMCPublicationInfo_certHashes'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute pubInfo(3)   External PKIXCRMF-2009:PKIPublicationInfo
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'PKIXCRMF-2009':'enc_PKIPublicationInfo'(Cindex3, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CMCPublicationInfo_hashAlg
%%================================
enc_CMCPublicationInfo_hashAlg(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'EnrollmentMessageSyntax-2009':'getenc_internal_object_set_argument_17'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CMCPublicationInfo_certHashes
%%================================
enc_CMCPublicationInfo_certHashes(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_CMCPublicationInfo_certHashes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CMCPublicationInfo_certHashes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CMCPublicationInfo_certHashes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<4>>]),
   'enc_CMCPublicationInfo_certHashes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_CMCPublicationInfo(Tlv) ->
   dec_CMCPublicationInfo(Tlv, [16]).

dec_CMCPublicationInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute hashAlg(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CMCPublicationInfo_hashAlg'(V1, [16]),

%%-------------------------------------------------
%% attribute certHashes(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CMCPublicationInfo_certHashes'(V2, [16]),

%%-------------------------------------------------
%% attribute pubInfo(3)   External PKIXCRMF-2009:PKIPublicationInfo
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'PKIXCRMF-2009':'dec_PKIPublicationInfo'(V3, [16]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CMCPublicationInfo',Term1,Term2,Term3},
Res1.
'dec_CMCPublicationInfo_hashAlg'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'EnrollmentMessageSyntax-2009':'getdec_internal_object_set_argument_17'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CMCPublicationInfo_hashAlg',Term1,Term2},
Res1.
'dec_CMCPublicationInfo_certHashes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_octet_string(V1, [4]) || V1 <- Tlv1].




%%================================
%%  ModCertTemplate
%%================================
enc_ModCertTemplate(Val) ->
    enc_ModCertTemplate(Val, [<<48>>]).

enc_ModCertTemplate(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute pkiDataReference(1)   External EnrollmentMessageSyntax-2009:BodyPartPath
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_BodyPartPath'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute certReferences(2)   External EnrollmentMessageSyntax-2009:BodyPartList
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_BodyPartList'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute replace(3) with type BOOLEAN DEFAULT = true
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case is_default_2(Cindex3) of
true -> {[],0};
false ->
encode_boolean(Cindex3, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute certTemplate(4)   External PKIXCRMF-2009:CertTemplate
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'PKIXCRMF-2009':'enc_CertTemplate'(Cindex4, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ModCertTemplate(Tlv) ->
   dec_ModCertTemplate(Tlv, [16]).

dec_ModCertTemplate(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute pkiDataReference(1)   External EnrollmentMessageSyntax-2009:BodyPartPath
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_BodyPartPath'(V1, [16]),

%%-------------------------------------------------
%% attribute certReferences(2)   External EnrollmentMessageSyntax-2009:BodyPartList
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_BodyPartList'(V2, [16]),

%%-------------------------------------------------
%% attribute replace(3) with type BOOLEAN DEFAULT = true
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{1,V3}|TempTlv4] ->
    {decode_boolean(V3, []), TempTlv4};
    _ ->
        {true,Tlv3}
end,

%%-------------------------------------------------
%% attribute certTemplate(4)   External PKIXCRMF-2009:CertTemplate
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'PKIXCRMF-2009':'dec_CertTemplate'(V4, [16]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'ModCertTemplate',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  ControlsProcessed
%%================================
enc_ControlsProcessed(Val) ->
    enc_ControlsProcessed(Val, [<<48>>]).

enc_ControlsProcessed(Val, TagIn) ->
{_,Cindex1} = Val,

%%-------------------------------------------------
%% attribute bodyList(1) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_ControlsProcessed_bodyList'(Cindex1, [<<48>>]),

   BytesSoFar = [EncBytes1],
LenSoFar = EncLen1,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ControlsProcessed_bodyList
%%================================
enc_ControlsProcessed_bodyList(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ControlsProcessed_bodyList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ControlsProcessed_bodyList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ControlsProcessed_bodyList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_BodyPartReference'(H, []),
   'enc_ControlsProcessed_bodyList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_ControlsProcessed(Tlv) ->
   dec_ControlsProcessed(Tlv, [16]).

dec_ControlsProcessed(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute bodyList(1) with type SEQUENCE OF
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_ControlsProcessed_bodyList'(V1, [16]),

case Tlv2 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv2}}}) % extra fields not allowed
end,
Res1 = {'ControlsProcessed',Term1},
Res1.
'dec_ControlsProcessed_bodyList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_BodyPartReference'(V1, []) || V1 <- Tlv1].




%%================================
%%  IdentityProofV2
%%================================
enc_IdentityProofV2(Val) ->
    enc_IdentityProofV2(Val, [<<48>>]).

enc_IdentityProofV2(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute proofAlgID(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_IdentityProofV2_proofAlgID'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute macAlgId(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_IdentityProofV2_macAlgId'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute witness(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  IdentityProofV2_proofAlgID
%%================================
enc_IdentityProofV2_proofAlgID(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'EnrollmentMessageSyntax-2009':'getenc_internal_object_set_argument_19'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  IdentityProofV2_macAlgId
%%================================
enc_IdentityProofV2_macAlgId(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'EnrollmentMessageSyntax-2009':'getenc_internal_object_set_argument_21'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_IdentityProofV2(Tlv) ->
   dec_IdentityProofV2(Tlv, [16]).

dec_IdentityProofV2(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute proofAlgID(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_IdentityProofV2_proofAlgID'(V1, [16]),

%%-------------------------------------------------
%% attribute macAlgId(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_IdentityProofV2_macAlgId'(V2, [16]),

%%-------------------------------------------------
%% attribute witness(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'IdentityProofV2',Term1,Term2,Term3},
Res1.
'dec_IdentityProofV2_proofAlgID'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'EnrollmentMessageSyntax-2009':'getdec_internal_object_set_argument_19'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'IdentityProofV2_proofAlgID',Term1,Term2},
Res1.
'dec_IdentityProofV2_macAlgId'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'EnrollmentMessageSyntax-2009':'getdec_internal_object_set_argument_21'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'IdentityProofV2_macAlgId',Term1,Term2},
Res1.


%%================================
%%  PopLinkWitnessV2
%%================================
enc_PopLinkWitnessV2(Val) ->
    enc_PopLinkWitnessV2(Val, [<<48>>]).

enc_PopLinkWitnessV2(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute keyGenAlgorithm(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PopLinkWitnessV2_keyGenAlgorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute macAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PopLinkWitnessV2_macAlgorithm'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute witness(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PopLinkWitnessV2_keyGenAlgorithm
%%================================
enc_PopLinkWitnessV2_keyGenAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'EnrollmentMessageSyntax-2009':'getenc_internal_object_set_argument_23'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PopLinkWitnessV2_macAlgorithm
%%================================
enc_PopLinkWitnessV2_macAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'EnrollmentMessageSyntax-2009':'getenc_internal_object_set_argument_25'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PopLinkWitnessV2(Tlv) ->
   dec_PopLinkWitnessV2(Tlv, [16]).

dec_PopLinkWitnessV2(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute keyGenAlgorithm(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PopLinkWitnessV2_keyGenAlgorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute macAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PopLinkWitnessV2_macAlgorithm'(V2, [16]),

%%-------------------------------------------------
%% attribute witness(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'PopLinkWitnessV2',Term1,Term2,Term3},
Res1.
'dec_PopLinkWitnessV2_keyGenAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'EnrollmentMessageSyntax-2009':'getdec_internal_object_set_argument_23'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PopLinkWitnessV2_keyGenAlgorithm',Term1,Term2},
Res1.
'dec_PopLinkWitnessV2_macAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'EnrollmentMessageSyntax-2009':'getdec_internal_object_set_argument_25'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PopLinkWitnessV2_macAlgorithm',Term1,Term2},
Res1.
'id-cmc'() ->
{1,3,6,1,5,5,7,7}.

'id-cct'() ->
{1,3,6,1,5,5,7,12}.

'id-cct-PKIData'() ->
{1,3,6,1,5,5,7,12,2}.

'id-cct-PKIResponse'() ->
{1,3,6,1,5,5,7,12,3}.

'id-cmc-identityProof'() ->
{1,3,6,1,5,5,7,7,3}.

'id-cmc-dataReturn'() ->
{1,3,6,1,5,5,7,7,4}.

'id-cmc-regInfo'() ->
{1,3,6,1,5,5,7,7,18}.

'id-cmc-responseInfo'() ->
{1,3,6,1,5,5,7,7,19}.

'id-cmc-queryPending'() ->
{1,3,6,1,5,5,7,7,21}.

'id-cmc-popLinkRandom'() ->
{1,3,6,1,5,5,7,7,22}.

'id-cmc-popLinkWitness'() ->
{1,3,6,1,5,5,7,7,23}.

'id-cmc-identification'() ->
{1,3,6,1,5,5,7,7,2}.

'id-cmc-transactionId'() ->
{1,3,6,1,5,5,7,7,5}.

'id-cmc-senderNonce'() ->
{1,3,6,1,5,5,7,7,6}.

'id-cmc-recipientNonce'() ->
{1,3,6,1,5,5,7,7,7}.

'id-cmc-statusInfo'() ->
{1,3,6,1,5,5,7,7,1}.

'id-cmc-addExtensions'() ->
{1,3,6,1,5,5,7,7,8}.

'id-cmc-encryptedPOP'() ->
{1,3,6,1,5,5,7,7,9}.

'id-cmc-decryptedPOP'() ->
{1,3,6,1,5,5,7,7,10}.

'id-cmc-lraPOPWitness'() ->
{1,3,6,1,5,5,7,7,11}.

'id-cmc-getCert'() ->
{1,3,6,1,5,5,7,7,15}.

'id-cmc-getCRL'() ->
{1,3,6,1,5,5,7,7,16}.

'id-cmc-revokeRequest'() ->
{1,3,6,1,5,5,7,7,17}.

'id-cmc-confirmCertAcceptance'() ->
{1,3,6,1,5,5,7,7,24}.

'id-ExtensionReq'() ->
{1,2,840,113549,1,9,14}.

'id-alg-noSignature'() ->
{1,3,6,1,5,5,7,6,2}.

'id-aa'() ->
{1,2,840,113549,1,9,16,2}.

'id-aa-cmc-unsignedData'() ->
{1,2,840,113549,1,9,16,2,34}.

'id-cmc-statusInfoV2'() ->
{1,3,6,1,5,5,7,7,25}.

'id-cmc-trustedAnchors'() ->
{1,3,6,1,5,5,7,7,26}.

'id-cmc-authData'() ->
{1,3,6,1,5,5,7,7,27}.

'id-cmc-batchRequests'() ->
{1,3,6,1,5,5,7,7,28}.

'id-cmc-batchResponses'() ->
{1,3,6,1,5,5,7,7,29}.

'id-cmc-publishCert'() ->
{1,3,6,1,5,5,7,7,30}.

'id-cmc-modCertTemplate'() ->
{1,3,6,1,5,5,7,7,31}.

'id-cmc-controlProcessed'() ->
{1,3,6,1,5,5,7,7,32}.

'id-cmc-identityProofV2'() ->
{1,3,6,1,5,5,7,7,33}.

'id-cmc-popLinkWitnessV2'() ->
{1,3,6,1,5,5,7,7,34}.




%%================================
%%  ct-PKIData
%%================================
'enc_ct-PKIData'('Type', Val, _RestPrimFieldName) ->
   enc_PKIData(Val, [<<48>>]).


'dec_ct-PKIData'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PKIData(Tlv, [16]).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  ct-PKIResponse
%%================================
'enc_ct-PKIResponse'('Type', Val, _RestPrimFieldName) ->
   enc_PKIResponse(Val, [<<48>>]).


'dec_ct-PKIResponse'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PKIResponse(Tlv, [16]).




%%================================
%%  cmc-identityProof
%%================================
'enc_cmc-identityProof'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<4>>]).


'dec_cmc-identityProof'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_octet_string(Tlv, [4]).




%%================================
%%  cmc-dataReturn
%%================================
'enc_cmc-dataReturn'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<4>>]).


'dec_cmc-dataReturn'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_octet_string(Tlv, [4]).




%%================================
%%  cmc-regInfo
%%================================
'enc_cmc-regInfo'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<4>>]).


'dec_cmc-regInfo'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_octet_string(Tlv, [4]).




%%================================
%%  cmc-responseInfo
%%================================
'enc_cmc-responseInfo'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<4>>]).


'dec_cmc-responseInfo'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_octet_string(Tlv, [4]).




%%================================
%%  cmc-queryPending
%%================================
'enc_cmc-queryPending'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<4>>]).


'dec_cmc-queryPending'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_octet_string(Tlv, [4]).




%%================================
%%  cmc-popLinkRandom
%%================================
'enc_cmc-popLinkRandom'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<4>>]).


'dec_cmc-popLinkRandom'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_octet_string(Tlv, [4]).




%%================================
%%  cmc-popLinkWitness
%%================================
'enc_cmc-popLinkWitness'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<4>>]).


'dec_cmc-popLinkWitness'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_octet_string(Tlv, [4]).




%%================================
%%  cmc-identification
%%================================
'enc_cmc-identification'('Type', Val, _RestPrimFieldName) ->
encode_UTF8_string(Val, [<<12>>]).


'dec_cmc-identification'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_UTF8_string(Tlv, [12]).




%%================================
%%  cmc-transactionId
%%================================
'enc_cmc-transactionId'('Type', Val, _RestPrimFieldName) ->
encode_integer(Val, [<<2>>]).


'dec_cmc-transactionId'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_integer(Tlv, [2]).




%%================================
%%  cmc-senderNonce
%%================================
'enc_cmc-senderNonce'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<4>>]).


'dec_cmc-senderNonce'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_octet_string(Tlv, [4]).




%%================================
%%  cmc-recipientNonce
%%================================
'enc_cmc-recipientNonce'('Type', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<4>>]).


'dec_cmc-recipientNonce'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_octet_string(Tlv, [4]).




%%================================
%%  cmc-statusInfo
%%================================
'enc_cmc-statusInfo'('Type', Val, _RestPrimFieldName) ->
   enc_CMCStatusInfo(Val, [<<48>>]).


'dec_cmc-statusInfo'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CMCStatusInfo(Tlv, [16]).




%%================================
%%  cmc-addExtensions
%%================================
'enc_cmc-addExtensions'('Type', Val, _RestPrimFieldName) ->
   enc_AddExtensions(Val, [<<48>>]).


'dec_cmc-addExtensions'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_AddExtensions(Tlv, [16]).




%%================================
%%  cmc-encryptedPOP
%%================================
'enc_cmc-encryptedPOP'('Type', Val, _RestPrimFieldName) ->
   enc_EncryptedPOP(Val, [<<48>>]).


'dec_cmc-encryptedPOP'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_EncryptedPOP(Tlv, [16]).




%%================================
%%  cmc-decryptedPOP
%%================================
'enc_cmc-decryptedPOP'('Type', Val, _RestPrimFieldName) ->
   enc_DecryptedPOP(Val, [<<48>>]).


'dec_cmc-decryptedPOP'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DecryptedPOP(Tlv, [16]).




%%================================
%%  cmc-lraPOPWitness
%%================================
'enc_cmc-lraPOPWitness'('Type', Val, _RestPrimFieldName) ->
   enc_LraPopWitness(Val, [<<48>>]).


'dec_cmc-lraPOPWitness'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_LraPopWitness(Tlv, [16]).




%%================================
%%  cmc-getCert
%%================================
'enc_cmc-getCert'('Type', Val, _RestPrimFieldName) ->
   enc_GetCert(Val, [<<48>>]).


'dec_cmc-getCert'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_GetCert(Tlv, [16]).




%%================================
%%  cmc-getCRL
%%================================
'enc_cmc-getCRL'('Type', Val, _RestPrimFieldName) ->
   enc_GetCRL(Val, [<<48>>]).


'dec_cmc-getCRL'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_GetCRL(Tlv, [16]).




%%================================
%%  cmc-revokeRequest
%%================================
'enc_cmc-revokeRequest'('Type', Val, _RestPrimFieldName) ->
   enc_RevokeRequest(Val, [<<48>>]).


'dec_cmc-revokeRequest'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_RevokeRequest(Tlv, [16]).




%%================================
%%  cmc-confirmCertAcceptance
%%================================
'enc_cmc-confirmCertAcceptance'('Type', Val, _RestPrimFieldName) ->
   enc_CMCCertId(Val, [<<48>>]).


'dec_cmc-confirmCertAcceptance'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CMCCertId(Tlv, [16]).




%%================================
%%  at-extension-req
%%================================
'enc_at-extension-req'('Type', Val, _RestPrimFieldName) ->
   enc_ExtensionReq(Val, [<<48>>]);
'enc_at-extension-req'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_at-extension-req'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ExtensionReq(Tlv, [16]);
'dec_at-extension-req'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  sa-noSignature
%%================================
'enc_sa-noSignature'('Value', Val, _RestPrimFieldName) ->
   enc_NoSignatureValue(Val, [<<4>>]);
'enc_sa-noSignature'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-noSignature'(smimeCaps, _,_) ->
  exit({error,{'use of missing field in object', smimeCaps}}).


'dec_sa-noSignature'('Value', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_NoSignatureValue(Tlv, [4]);
'dec_sa-noSignature'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-noSignature'(smimeCaps, _,_) ->
  exit({error,{'illegal use of missing field in object', smimeCaps}}).




%%================================
%%  aa-cmc-unsignedData
%%================================
'enc_aa-cmc-unsignedData'('Type', Val, _RestPrimFieldName) ->
   enc_CMCUnsignedData(Val, [<<48>>]);
'enc_aa-cmc-unsignedData'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_aa-cmc-unsignedData'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CMCUnsignedData(Tlv, [16]);
'dec_aa-cmc-unsignedData'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  cmc-statusInfoV2
%%================================
'enc_cmc-statusInfoV2'('Type', Val, _RestPrimFieldName) ->
   enc_CMCStatusInfoV2(Val, [<<48>>]).


'dec_cmc-statusInfoV2'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CMCStatusInfoV2(Tlv, [16]).




%%================================
%%  cmc-trustedAnchors
%%================================
'enc_cmc-trustedAnchors'('Type', Val, _RestPrimFieldName) ->
   enc_PublishTrustAnchors(Val, [<<48>>]).


'dec_cmc-trustedAnchors'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PublishTrustAnchors(Tlv, [16]).




%%================================
%%  cmc-authData
%%================================
'enc_cmc-authData'('Type', Val, _RestPrimFieldName) ->
   enc_AuthPublish(Val, [<<2>>]).


'dec_cmc-authData'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_AuthPublish(Tlv, [2]).




%%================================
%%  cmc-batchRequests
%%================================
'enc_cmc-batchRequests'('Type', Val, _RestPrimFieldName) ->
   enc_BodyPartList(Val, [<<48>>]).


'dec_cmc-batchRequests'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_BodyPartList(Tlv, [16]).




%%================================
%%  cmc-batchResponses
%%================================
'enc_cmc-batchResponses'('Type', Val, _RestPrimFieldName) ->
   enc_BodyPartList(Val, [<<48>>]).


'dec_cmc-batchResponses'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_BodyPartList(Tlv, [16]).




%%================================
%%  cmc-publishCert
%%================================
'enc_cmc-publishCert'('Type', Val, _RestPrimFieldName) ->
   enc_CMCPublicationInfo(Val, [<<48>>]).


'dec_cmc-publishCert'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CMCPublicationInfo(Tlv, [16]).




%%================================
%%  cmc-modCertTemplate
%%================================
'enc_cmc-modCertTemplate'('Type', Val, _RestPrimFieldName) ->
   enc_ModCertTemplate(Val, [<<48>>]).


'dec_cmc-modCertTemplate'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ModCertTemplate(Tlv, [16]).




%%================================
%%  cmc-controlProcessed
%%================================
'enc_cmc-controlProcessed'('Type', Val, _RestPrimFieldName) ->
   enc_ControlsProcessed(Val, [<<48>>]).


'dec_cmc-controlProcessed'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ControlsProcessed(Tlv, [16]).




%%================================
%%  cmc-identityProofV2
%%================================
'enc_cmc-identityProofV2'('Type', Val, _RestPrimFieldName) ->
   enc_IdentityProofV2(Val, [<<48>>]).


'dec_cmc-identityProofV2'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_IdentityProofV2(Tlv, [16]).




%%================================
%%  cmc-popLinkWitnessV2
%%================================
'enc_cmc-popLinkWitnessV2'('Type', Val, _RestPrimFieldName) ->
   enc_PopLinkWitnessV2(Val, [<<48>>]).


'dec_cmc-popLinkWitnessV2'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PopLinkWitnessV2(Tlv, [16]).




%%================================
%%  CMC-ContentTypes
%%================================
'getenc_CMC-ContentTypes'(Id) when Id =:= {1,3,6,1,5,5,7,12,2} ->
    fun 'enc_ct-PKIData'/3;
'getenc_CMC-ContentTypes'(Id) when Id =:= {1,3,6,1,5,5,7,12,3} ->
    fun 'enc_ct-PKIResponse'/3;
'getenc_CMC-ContentTypes'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_CMC-ContentTypes'(Id) when Id =:= {1,3,6,1,5,5,7,12,2} ->
    fun 'dec_ct-PKIData'/3;
'getdec_CMC-ContentTypes'(Id) when Id =:= {1,3,6,1,5,5,7,12,3} ->
    fun 'dec_ct-PKIResponse'/3;
'getdec_CMC-ContentTypes'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SignatureAlgs
%%================================
getenc_SignatureAlgs(Id) when Id =:= {1,3,6,1,5,5,7,6,2} ->
    fun 'enc_sa-noSignature'/3;
getenc_SignatureAlgs(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

getdec_SignatureAlgs(Id) when Id =:= {1,3,6,1,5,5,7,6,2} ->
    fun 'dec_sa-noSignature'/3;
'getdec_SignatureAlgs'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  CMC-UnsignedAtts
%%================================
'getenc_CMC-UnsignedAtts'(Id) when Id =:= {1,2,840,113549,1,9,16,2,34} ->
    fun 'enc_aa-cmc-unsignedData'/3;
'getenc_CMC-UnsignedAtts'(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

'getdec_CMC-UnsignedAtts'(Id) when Id =:= {1,2,840,113549,1,9,16,2,34} ->
    fun 'dec_aa-cmc-unsignedData'/3;
'getdec_CMC-UnsignedAtts'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  Cmc-Control-Set
%%================================
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,1} ->
    fun 'enc_cmc-statusInfo'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,2} ->
    fun 'enc_cmc-identification'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,3} ->
    fun 'enc_cmc-identityProof'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,4} ->
    fun 'enc_cmc-dataReturn'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,5} ->
    fun 'enc_cmc-transactionId'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,6} ->
    fun 'enc_cmc-senderNonce'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,7} ->
    fun 'enc_cmc-recipientNonce'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,8} ->
    fun 'enc_cmc-addExtensions'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,9} ->
    fun 'enc_cmc-encryptedPOP'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,10} ->
    fun 'enc_cmc-decryptedPOP'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,11} ->
    fun 'enc_cmc-lraPOPWitness'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,15} ->
    fun 'enc_cmc-getCert'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,16} ->
    fun 'enc_cmc-getCRL'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,17} ->
    fun 'enc_cmc-revokeRequest'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,18} ->
    fun 'enc_cmc-regInfo'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,19} ->
    fun 'enc_cmc-responseInfo'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,21} ->
    fun 'enc_cmc-queryPending'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,22} ->
    fun 'enc_cmc-popLinkRandom'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,23} ->
    fun 'enc_cmc-popLinkWitness'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,24} ->
    fun 'enc_cmc-confirmCertAcceptance'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,25} ->
    fun 'enc_cmc-statusInfoV2'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,26} ->
    fun 'enc_cmc-trustedAnchors'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,27} ->
    fun 'enc_cmc-authData'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,28} ->
    fun 'enc_cmc-batchRequests'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,29} ->
    fun 'enc_cmc-batchResponses'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,30} ->
    fun 'enc_cmc-publishCert'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,31} ->
    fun 'enc_cmc-modCertTemplate'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,32} ->
    fun 'enc_cmc-controlProcessed'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,33} ->
    fun 'enc_cmc-identityProofV2'/3;
'getenc_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,34} ->
    fun 'enc_cmc-popLinkWitnessV2'/3;
'getenc_Cmc-Control-Set'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,1} ->
    fun 'dec_cmc-statusInfo'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,2} ->
    fun 'dec_cmc-identification'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,3} ->
    fun 'dec_cmc-identityProof'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,4} ->
    fun 'dec_cmc-dataReturn'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,5} ->
    fun 'dec_cmc-transactionId'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,6} ->
    fun 'dec_cmc-senderNonce'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,7} ->
    fun 'dec_cmc-recipientNonce'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,8} ->
    fun 'dec_cmc-addExtensions'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,9} ->
    fun 'dec_cmc-encryptedPOP'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,10} ->
    fun 'dec_cmc-decryptedPOP'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,11} ->
    fun 'dec_cmc-lraPOPWitness'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,15} ->
    fun 'dec_cmc-getCert'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,16} ->
    fun 'dec_cmc-getCRL'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,17} ->
    fun 'dec_cmc-revokeRequest'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,18} ->
    fun 'dec_cmc-regInfo'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,19} ->
    fun 'dec_cmc-responseInfo'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,21} ->
    fun 'dec_cmc-queryPending'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,22} ->
    fun 'dec_cmc-popLinkRandom'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,23} ->
    fun 'dec_cmc-popLinkWitness'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,24} ->
    fun 'dec_cmc-confirmCertAcceptance'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,25} ->
    fun 'dec_cmc-statusInfoV2'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,26} ->
    fun 'dec_cmc-trustedAnchors'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,27} ->
    fun 'dec_cmc-authData'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,28} ->
    fun 'dec_cmc-batchRequests'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,29} ->
    fun 'dec_cmc-batchResponses'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,30} ->
    fun 'dec_cmc-publishCert'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,31} ->
    fun 'dec_cmc-modCertTemplate'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,32} ->
    fun 'dec_cmc-controlProcessed'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,33} ->
    fun 'dec_cmc-identityProofV2'/3;
'getdec_Cmc-Control-Set'(Id) when Id =:= {1,3,6,1,5,5,7,7,34} ->
    fun 'dec_cmc-popLinkWitnessV2'/3;
'getdec_Cmc-Control-Set'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  OtherRequests
%%================================
getenc_OtherRequests(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_OtherRequests(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  AttributeList
%%================================
getenc_AttributeList(Id) when Id =:= {1,2,840,113549,1,9,14} ->
    fun 'enc_at-extension-req'/3;
getenc_AttributeList(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_AttributeList(Id) when Id =:= {1,2,840,113549,1,9,14} ->
    fun 'dec_at-extension-req'/3;
getdec_AttributeList(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  OtherMsgSet
%%================================
getenc_OtherMsgSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_OtherMsgSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  POPAlgs
%%================================
getenc_POPAlgs(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_maca-hMAC-SHA1'(T,V,O) end;
getenc_POPAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_POPAlgs(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_maca-hMAC-SHA1'(T,V,O) end;
getdec_POPAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  WitnessAlgs
%%================================
getenc_WitnessAlgs(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_mda-sha1'(T,V,O) end;
getenc_WitnessAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_WitnessAlgs(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_mda-sha1'(T,V,O) end;
getdec_WitnessAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  ExtendedFailures
%%================================
getenc_ExtendedFailures(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_ExtendedFailures(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  HashAlgorithms
%%================================
getenc_HashAlgorithms(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_mda-sha1'(T,V,O) end;
getenc_HashAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,2,1} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_mda-sha256'(T,V,O) end;
getenc_HashAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_HashAlgorithms(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_mda-sha1'(T,V,O) end;
getdec_HashAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,2,1} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_mda-sha256'(T,V,O) end;
getdec_HashAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  KeyDevAlgs
%%================================
getenc_KeyDevAlgs(Id) when Id =:= {1,2,840,113549,1,5,12} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_kda-PBKDF2'(T,V,O) end;
getenc_KeyDevAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_KeyDevAlgs(Id) when Id =:= {1,2,840,113549,1,5,12} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_kda-PBKDF2'(T,V,O) end;
getdec_KeyDevAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_8
%%================================
getenc_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_maca-hMAC-SHA1'(T,V,O) end;
getenc_internal_object_set_argument_8(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_maca-hMAC-SHA1'(T,V,O) end;
getdec_internal_object_set_argument_8(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_6
%%================================
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectDirectoryAttributes'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-KeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectAltName'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-IssuerAltName'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-BasicConstraints'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-NameConstraints'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLDistributionPoints'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CertificatePolicies'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyMappings'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyConstraints'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-ExtKeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-FreshestCRL'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-InhibitAnyPolicy'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityInfoAccess'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getenc_internal_object_set_argument_6(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectDirectoryAttributes'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-KeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectAltName'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-IssuerAltName'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-BasicConstraints'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-NameConstraints'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLDistributionPoints'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CertificatePolicies'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyMappings'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyConstraints'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-ExtKeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-FreshestCRL'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-InhibitAnyPolicy'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityInfoAccess'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getdec_internal_object_set_argument_6(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_5
%%================================
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA384'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA512'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD2'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD5'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_sa-rsaSSA-PSS'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_5(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_5(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA384'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA512'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD2'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD5'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_sa-rsaSSA-PSS'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_5(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_5(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_3
%%================================
getenc_internal_object_set_argument_3(Id) when Id =:= {1,2,840,113549,1,9,14} ->
    fun 'enc_at-extension-req'/3;
getenc_internal_object_set_argument_3(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_3(Id) when Id =:= {1,2,840,113549,1,9,14} ->
    fun 'dec_at-extension-req'/3;
getdec_internal_object_set_argument_3(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2(Id) when Id =:= {1,3,132,1,12} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-ecDH'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,3,132,1,13} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-ecMQV'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10040,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-dsa'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-ec'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10046,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-dh'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-rsa'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,7} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_pk-rsaES-OAEP'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_pk-rsaSSA-PSS'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,2,1,1,22} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-kea'(T,V,O) end;
getenc_internal_object_set_argument_2(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_2(Id) when Id =:= {1,3,132,1,12} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-ecDH'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,3,132,1,13} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-ecMQV'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10040,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-dsa'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-ec'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10046,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-dh'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-rsa'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,7} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_pk-rsaES-OAEP'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_pk-rsaSSA-PSS'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,2,1,1,22} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-kea'(T,V,O) end;
getdec_internal_object_set_argument_2(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_19
%%================================
getenc_internal_object_set_argument_19(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_mda-sha1'(T,V,O) end;
getenc_internal_object_set_argument_19(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_19(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_mda-sha1'(T,V,O) end;
getdec_internal_object_set_argument_19(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_17
%%================================
getenc_internal_object_set_argument_17(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_mda-sha1'(T,V,O) end;
getenc_internal_object_set_argument_17(Id) when Id =:= {2,16,840,1,101,3,4,2,1} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_mda-sha256'(T,V,O) end;
getenc_internal_object_set_argument_17(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_17(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_mda-sha1'(T,V,O) end;
getdec_internal_object_set_argument_17(Id) when Id =:= {2,16,840,1,101,3,4,2,1} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_mda-sha256'(T,V,O) end;
getdec_internal_object_set_argument_17(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_15
%%================================
getenc_internal_object_set_argument_15(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_mda-sha1'(T,V,O) end;
getenc_internal_object_set_argument_15(Id) when Id =:= {2,16,840,1,101,3,4,2,1} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_mda-sha256'(T,V,O) end;
getenc_internal_object_set_argument_15(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_15(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_mda-sha1'(T,V,O) end;
getdec_internal_object_set_argument_15(Id) when Id =:= {2,16,840,1,101,3,4,2,1} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_mda-sha256'(T,V,O) end;
getdec_internal_object_set_argument_15(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_13
%%================================
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectDirectoryAttributes'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-KeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectAltName'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-IssuerAltName'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-BasicConstraints'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-NameConstraints'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLDistributionPoints'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CertificatePolicies'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyMappings'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyConstraints'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-ExtKeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-FreshestCRL'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-InhibitAnyPolicy'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityInfoAccess'(T,V,O) end;
getenc_internal_object_set_argument_13(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getenc_internal_object_set_argument_13(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectDirectoryAttributes'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-KeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectAltName'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-IssuerAltName'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-BasicConstraints'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-NameConstraints'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLDistributionPoints'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CertificatePolicies'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyMappings'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyConstraints'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-ExtKeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-FreshestCRL'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-InhibitAnyPolicy'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityInfoAccess'(T,V,O) end;
getdec_internal_object_set_argument_13(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getdec_internal_object_set_argument_13(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_12
%%================================
getenc_internal_object_set_argument_12(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_maca-hMAC-SHA1'(T,V,O) end;
getenc_internal_object_set_argument_12(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_12(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_maca-hMAC-SHA1'(T,V,O) end;
getdec_internal_object_set_argument_12(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_10
%%================================
getenc_internal_object_set_argument_10(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_mda-sha1'(T,V,O) end;
getenc_internal_object_set_argument_10(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_10(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_mda-sha1'(T,V,O) end;
getdec_internal_object_set_argument_10(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_25
%%================================
getenc_internal_object_set_argument_25(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_maca-hMAC-SHA1'(T,V,O) end;
getenc_internal_object_set_argument_25(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_25(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_maca-hMAC-SHA1'(T,V,O) end;
getdec_internal_object_set_argument_25(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_23
%%================================
getenc_internal_object_set_argument_23(Id) when Id =:= {1,2,840,113549,1,5,12} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_kda-PBKDF2'(T,V,O) end;
getenc_internal_object_set_argument_23(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_23(Id) when Id =:= {1,2,840,113549,1,5,12} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_kda-PBKDF2'(T,V,O) end;
getdec_internal_object_set_argument_23(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_21
%%================================
getenc_internal_object_set_argument_21(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_maca-hMAC-SHA1'(T,V,O) end;
getenc_internal_object_set_argument_21(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_21(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_maca-hMAC-SHA1'(T,V,O) end;
getdec_internal_object_set_argument_21(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Def) when Def =:= false ->
true;
is_default_1(_) ->
false.


is_default_2(asn1_DEFAULT) ->
true;
is_default_2(Def) when Def =:= true ->
true;
is_default_2(_) ->
false.


ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_UTF8_string(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin ->
            Bin
    end.

decode_bitstring2(1, Unused,
                  <<B7:1,B6:1,B5:1,B4:1,B3:1,B2:1,B1:1,B0:1,_/binary>>) ->
    lists:sublist([B7, B6, B5, B4, B3, B2, B1, B0], 8 - Unused);
decode_bitstring2(Len, Unused,
                  <<B7:1,
                    B6:1,
                    B5:1,
                    B4:1,
                    B3:1,
                    B2:1,
                    B1:1,
                    B0:1,
                    Buffer/binary>>) ->
    [B7, B6, B5, B4, B3, B2, B1, B0 |
     decode_bitstring2(Len - 1, Unused, Buffer)].

decode_bitstring_NNL(BitList, NamedNumberList) ->
    decode_bitstring_NNL(BitList, NamedNumberList, 0, []).

decode_bitstring_NNL([], _, _No, Result) ->
    lists:reverse(Result);
decode_bitstring_NNL([B | BitList],
                     [{Name, No} | NamedNumberList],
                     No, Result) ->
    if
        B =:= 0 ->
            decode_bitstring_NNL(BitList, NamedNumberList,
                                 No + 1,
                                 Result);
        true ->
            decode_bitstring_NNL(BitList, NamedNumberList,
                                 No + 1,
                                 [Name | Result])
    end;
decode_bitstring_NNL([1 | BitList], NamedNumberList, No, Result) ->
    decode_bitstring_NNL(BitList, NamedNumberList,
                         No + 1,
                         [{bit, No} | Result]);
decode_bitstring_NNL([0 | BitList], NamedNumberList, No, Result) ->
    decode_bitstring_NNL(BitList, NamedNumberList, No + 1, Result).

decode_boolean(Tlv, TagIn) ->
    Val = match_tags(Tlv, TagIn),
    case Val of
        <<0:8>> ->
            false;
        <<_:8>> ->
            true;
        _ ->
            exit({error, {asn1, {decode_boolean, Val}}})
    end.

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_named_bit_string(Buffer, NamedNumberList, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            [];
        <<Unused,Bits/binary>> ->
            BitString = decode_bitstring2(byte_size(Bits), Unused, Bits),
            decode_bitstring_NNL(BitString, NamedNumberList)
    end.

decode_native_bit_string(Buffer, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            <<>>;
        <<Unused,Bits/binary>> ->
            Size = bit_size(Bits) - Unused,
            <<Val:Size/bitstring,_:Unused/bitstring>> = Bits,
            Val
    end.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error, {asn1, {decode_null, Val}}})
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

decode_open_type_as_binary(Tlv, TagIn) ->
    ber_encode(match_tags(Tlv, TagIn)).

decode_restricted_string(Tlv, TagsIn) ->
    match_and_collect(Tlv, TagsIn).

do_encode_named_bit_string([FirstVal | RestVal], NamedBitList, TagIn) ->
    ToSetPos = get_all_bitposes([FirstVal | RestVal], NamedBitList, []),
    Size = lists:max(ToSetPos) + 1,
    BitList = make_and_set_list(Size, ToSetPos, 0),
    {Len, Unused, OctetList} = encode_bitstring(BitList),
    encode_tags(TagIn, [Unused | OctetList], Len + 1).

dynamicsort_SETOF(ListOfEncVal) ->
    BinL =
        lists:map(fun(L) when is_list(L) ->
                         list_to_binary(L);
                     (B) ->
                         B
                  end,
                  ListOfEncVal),
    lists:sort(BinL).

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_UTF8_string(UTF8String, TagIn) when is_binary(UTF8String) ->
    encode_tags(TagIn, UTF8String, byte_size(UTF8String));
encode_UTF8_string(UTF8String, TagIn) ->
    encode_tags(TagIn, UTF8String, length(UTF8String)).

encode_bitstring([B8, B7, B6, B5, B4, B3, B2, B1 | Rest]) ->
    Val =
        B8 bsl 7 bor (B7 bsl 6) bor (B6 bsl 5) bor (B5 bsl 4)
        bor
        (B4 bsl 3)
        bor
        (B3 bsl 2)
        bor
        (B2 bsl 1)
        bor
        B1,
    encode_bitstring(Rest, [Val], 1);
encode_bitstring(Val) ->
    {Unused, Octet} = unused_bitlist(Val, 7, 0),
    {1, Unused, [Octet]}.

encode_bitstring([B8, B7, B6, B5, B4, B3, B2, B1 | Rest], Ack, Len) ->
    Val =
        B8 bsl 7 bor (B7 bsl 6) bor (B6 bsl 5) bor (B5 bsl 4)
        bor
        (B4 bsl 3)
        bor
        (B3 bsl 2)
        bor
        (B2 bsl 1)
        bor
        B1,
    encode_bitstring(Rest, [Ack, Val], Len + 1);
encode_bitstring([], Ack, Len) ->
    {Len, 0, Ack};
encode_bitstring(Rest, Ack, Len) ->
    {Unused, Val} = unused_bitlist(Rest, 7, 0),
    {Len + 1, Unused, [Ack, Val]}.

encode_boolean(true, TagIn) ->
    encode_tags(TagIn, [255], 1);
encode_boolean(false, TagIn) ->
    encode_tags(TagIn, [0], 1);
encode_boolean(X, _) ->
    exit({error, {asn1, {encode_boolean, X}}}).

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, NamedNumberList, Tag) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedNumberList) of
        {_, NewVal} ->
            encode_tags(Tag, encode_integer(NewVal));
        _ ->
            exit({error, {asn1, {encode_integer_namednumber, Val}}})
    end;
encode_integer(Val, _NamedNumberList, Tag) ->
    encode_tags(Tag, encode_integer(Val)).

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_named_bit_string([H | _] = Bits, NamedBitList, TagIn)
    when is_atom(H) ->
    do_encode_named_bit_string(Bits, NamedBitList, TagIn);
encode_named_bit_string([{bit, _} | _] = Bits, NamedBitList, TagIn) ->
    do_encode_named_bit_string(Bits, NamedBitList, TagIn);
encode_named_bit_string([], _NamedBitList, TagIn) ->
    encode_unnamed_bit_string(<<>>, TagIn);
encode_named_bit_string(Bits, _NamedBitList, TagIn)
    when is_bitstring(Bits) ->
    encode_unnamed_bit_string(Bits, TagIn).

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

encode_unnamed_bit_string(Bits, TagIn) ->
    Unused = (8 - bit_size(Bits) band 7) band 7,
    Bin = <<Unused,Bits/bitstring,0:Unused>>,
    encode_tags(TagIn, Bin, byte_size(Bin)).

get_all_bitposes([{bit, ValPos} | Rest], NamedBitList, Ack) ->
    get_all_bitposes(Rest, NamedBitList, [ValPos | Ack]);
get_all_bitposes([Val | Rest], NamedBitList, Ack) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedBitList) of
        {_ValName, ValPos} ->
            get_all_bitposes(Rest, NamedBitList, [ValPos | Ack]);
        _ ->
            exit({error, {asn1, {bitstring_namedbit, Val}}})
    end;
get_all_bitposes([], _NamedBitList, Ack) ->
    lists:sort(Ack).

make_and_set_list(0, [], _) ->
    [];
make_and_set_list(0, _, _) ->
    exit({error, {asn1, bitstring_sizeconstraint}});
make_and_set_list(Len, [XPos | SetPos], XPos) ->
    [1 | make_and_set_list(Len - 1, SetPos, XPos + 1)];
make_and_set_list(Len, [Pos | SetPos], XPos) ->
    [0 | make_and_set_list(Len - 1, [Pos | SetPos], XPos + 1)];
make_and_set_list(Len, [], XPos) ->
    [0 | make_and_set_list(Len - 1, [], XPos + 1)].

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

number2name(Int, NamedNumberList) ->
    case lists:keyfind(Int, 2, NamedNumberList) of
        {NamedVal, _} ->
            NamedVal;
        _ ->
            Int
    end.

unused_bitlist([], Trail, Ack) ->
    {Trail + 1, Ack};
unused_bitlist([Bit | Rest], Trail, Ack) ->
    unused_bitlist(Rest, Trail - 1, Bit bsl Trail bor Ack).
