/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.Challenge;
import com.plantuml.ubrex.ChallengeResult;
import com.plantuml.ubrex.CompositeList;
import com.plantuml.ubrex.TextNavigator;
import com.plantuml.ubrex.UMatcher;
import java.util.List;

public interface UnicodeBracketedExpression {
    default public UMatcher match(String string) {
        return this.match(TextNavigator.build(string), 0);
    }

    default public UMatcher match(TextNavigator string) {
        return this.match(string, 0);
    }

    public UMatcher match(TextNavigator var1, int var2);

    public static UnicodeBracketedExpression build(String ubrex) {
        return UnicodeBracketedExpression.from(CompositeList.parseAndBuild(ubrex));
    }

    public static UnicodeBracketedExpression from(final Challenge challenge) {
        return new UnicodeBracketedExpression(){

            @Override
            public UMatcher match(final TextNavigator string, final int position) {
                final ChallengeResult shallWePass = challenge.runChallenge(string, position);
                final CharSequence acceptepMatch = shallWePass.getFullCaptureLength() < 0 ? "" : string.subSequence(position, position + shallWePass.getFullCaptureLength());
                return new UMatcher(){

                    public String toString() {
                        return String.valueOf(acceptepMatch) + " " + shallWePass.toString();
                    }

                    @Override
                    public boolean exactMatch() {
                        if (!this.startMatch()) {
                            return false;
                        }
                        return position + shallWePass.getFullCaptureLength() == string.length();
                    }

                    @Override
                    public String getAcceptedMatch() {
                        return acceptepMatch.toString();
                    }

                    @Override
                    public boolean startMatch() {
                        return shallWePass.getFullCaptureLength() >= 0;
                    }

                    @Override
                    public List<String> getCapture(String path) {
                        return shallWePass.findValuesByKey(path);
                    }

                    @Override
                    public List<String> getKeysToBeRefactored() {
                        return shallWePass.getKeysToBeRefactored();
                    }
                };
            }
        };
    }
}

