/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.asciiart.Wcwidth;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.Log;

public class StringUtils {
    public static final char USER_NEWLINE = '\uee00';
    public static final char USER_TAB = '\uee01';
    public static final char HR_SIMPLE = '\ueeff';
    public static final char HR_DOUBLE = '\ueefe';
    public static final char HR_DOTTED = '\ueefd';
    public static final char HR_BOLD = '\ueefc';
    public static final char PRIVATE_FIELD = '\ueefb';
    public static final char PROTECTED_FIELD = '\ueefa';
    public static final char PACKAGE_PRIVATE_FIELD = '\ueef9';
    public static final char PUBLIC_FIELD = '\ueef8';
    public static final char PRIVATE_METHOD = '\ueef7';
    public static final char PROTECTED_METHOD = '\ueef6';
    public static final char PACKAGE_PRIVATE_METHOD = '\ueef5';
    public static final char PUBLIC_METHOD = '\ueef4';
    public static final char IE_MANDATORY = '\ueef3';
    public static final char BOLD_START = '\ueef2';
    public static final char BOLD_END = '\ueef1';
    public static final char PRIVATE_BLOCK = '\ue000';
    public static final char INTERNAL_BOLD = '\ue100';
    private static final Pattern2 SPLIT_COMMA = Pattern2.cmpile("([%pLN_.]+|[%g][^%g]+[%g])");
    private static final Pattern UNICODE = Pattern.compile("\\<U\\+([0-9a-fA-F]{4,5})\\>");
    private static final Pattern AMP_HASH = Pattern.compile("\\&#([0-9]+);");

    public static String goUpperCase(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }

    public static String goLowerCase(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    public static String eventuallyRemoveStartingAndEndingDoubleQuote(String s, String format) {
        if (s == null) {
            return null;
        }
        if (format.contains("\"") && s.length() > 1 && StringUtils.isDoubleQuote(s.charAt(0)) && StringUtils.isDoubleQuote(s.charAt(s.length() - 1))) {
            return s.substring(1, s.length() - 1);
        }
        if (format.contains("(") && s.startsWith("(") && s.endsWith(")")) {
            return s.substring(1, s.length() - 1);
        }
        if (format.contains("[") && s.startsWith("[") && s.endsWith("]")) {
            return s.substring(1, s.length() - 1);
        }
        if (format.contains(":") && s.startsWith(":") && s.endsWith(":")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String eventuallyRemoveStartingAndEndingDoubleQuote(String s) {
        if (s == null) {
            return s;
        }
        return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s, "\"([:");
    }

    private static boolean isDoubleQuote(char c) {
        return c == '\"' || c == '\u201c' || c == '\u201d' || c == '\u00ab' || c == '\u00bb';
    }

    public static String toInternalBoldNumber(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                sb.append(Character.toChars(57600 + c - 48));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void appendInternalToRealBoldNumber(StringBuilder sb, char c) {
        if (c >= '\ue100' && c <= '\ue109') {
            sb.append(Character.toChars(120782 + c - 57600));
        } else {
            sb.append(c);
        }
    }

    public static void appendInternalToPlainNumber(StringBuilder sb, char c) {
        if (c >= '\ue100' && c <= '\ue109') {
            sb.append(Character.toChars(48 + c - 57600));
        } else {
            sb.append(c);
        }
    }

    public static final List<String> getSplit(Pattern2 pattern, String line) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= m.groupCount(); ++i) {
            result.add(m.group(i));
        }
        return result;
    }

    public static boolean isNotEmpty(CharSequence s) {
        return !StringUtils.isEmpty(s);
    }

    public static boolean isNotEmpty(List<? extends CharSequence> input) {
        return input != null && input.size() > 0;
    }

    public static boolean isEmpty(CharSequence s) {
        if (s == null) {
            return true;
        }
        int length = s.length();
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (StringUtils.isSpaceOrTabOrNull(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String manageHtml(String s) {
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        return s;
    }

    public static String unicode(String s) {
        StringBuilder result = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c > '\u007f' || c == '&' || c == '|') {
                char i = c;
                result.append("&#" + i + ";");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String unicodeForHtml(String s) {
        StringBuilder result = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c > '\u007f' || c == '&' || c == '|' || c == '<' || c == '>') {
                char i = c;
                result.append("&#" + i + ";");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String unicodeForHtml(Display display) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < display.size(); ++i) {
            result.append(StringUtils.unicodeForHtml(display.get(i).toString()));
            if (i >= display.size() - 1) continue;
            result.append("<br>");
        }
        return result.toString();
    }

    public static String manageArrowForSequence(String s) {
        s = s.replace('=', '-').toLowerCase();
        return s;
    }

    public static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static char goUpperCase(char c) {
        return StringUtils.goUpperCase("" + c).charAt(0);
    }

    public static char goLowerCase(char c) {
        return StringUtils.goLowerCase("" + c).charAt(0);
    }

    public static String manageArrowForCuca(String s) {
        Direction dir = StringUtils.getArrowDirection(s);
        s = s.replace('=', '-');
        s = s.replaceAll("\\w*", "");
        if (dir == Direction.LEFT || dir == Direction.RIGHT) {
            s = s.replaceAll("-+", "-");
        }
        if (s.length() == 2 && (dir == Direction.UP || dir == Direction.DOWN)) {
            s = s.replaceFirst("-", "--");
        }
        return s;
    }

    public static String manageQueueForCuca(String s) {
        Direction dir = StringUtils.getQueueDirection(s);
        s = s.replace('=', '-');
        s = s.replaceAll("\\w*", "");
        if (dir == Direction.LEFT || dir == Direction.RIGHT) {
            s = s.replaceAll("-+", "-");
        }
        if (s.length() == 1 && (dir == Direction.UP || dir == Direction.DOWN)) {
            s = s.replaceFirst("-", "--");
        }
        return s;
    }

    public static Direction getArrowDirection(String s) {
        if (s.endsWith(">")) {
            return StringUtils.getQueueDirection(s.substring(0, s.length() - 1));
        }
        if (s.startsWith("<")) {
            if (s.length() == 2) {
                return Direction.LEFT;
            }
            return Direction.UP;
        }
        throw new IllegalArgumentException(s);
    }

    public static Direction getQueueDirection(String s) {
        if (s.indexOf(60) != -1 || s.indexOf(62) != -1) {
            throw new IllegalArgumentException(s);
        }
        if ((s = s.toLowerCase()).contains("left")) {
            return Direction.LEFT;
        }
        if (s.contains("right")) {
            return Direction.RIGHT;
        }
        if (s.contains("up")) {
            return Direction.UP;
        }
        if (s.contains("down")) {
            return Direction.DOWN;
        }
        if (s.contains("l")) {
            return Direction.LEFT;
        }
        if (s.contains("r")) {
            return Direction.RIGHT;
        }
        if (s.contains("u")) {
            return Direction.UP;
        }
        if (s.contains("d")) {
            return Direction.DOWN;
        }
        if (s.length() == 1) {
            return Direction.RIGHT;
        }
        return Direction.DOWN;
    }

    public static boolean isCJK(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        Log.println("block=" + String.valueOf(block));
        return false;
    }

    public static char hiddenLesserThan() {
        return '\u0005';
    }

    public static char hiddenBiggerThan() {
        return '\u0006';
    }

    public static String hideComparatorCharacters(String s) {
        s = s.replace('<', StringUtils.hiddenLesserThan());
        s = s.replace('>', StringUtils.hiddenBiggerThan());
        return s;
    }

    public static String showComparatorCharacters(String s) {
        s = s.replace(StringUtils.hiddenLesserThan(), '<');
        s = s.replace(StringUtils.hiddenBiggerThan(), '>');
        return s;
    }

    public static int getHeight(List<? extends CharSequence> stringsToDisplay) {
        return stringsToDisplay.size();
    }

    public static int getHeight(Display stringsToDisplay) {
        return stringsToDisplay.size();
    }

    public static boolean isDiagramCacheable(String uml) {
        return uml.length() >= 35;
    }

    public static int getPragmaRevision(String uml) {
        int x1;
        int x2;
        uml = uml.toLowerCase();
        String header = "@startuml\n!pragma revision ";
        if (!uml.startsWith("@startuml\n!pragma revision ")) {
            return -1;
        }
        for (x2 = x1 = "@startuml\n!pragma revision ".length(); x2 < uml.length() && Character.isDigit(uml.charAt(x2)); ++x2) {
        }
        if (x1 == x2) {
            return -1;
        }
        return Integer.parseInt(uml.substring(x1, x2));
    }

    public static List<String> splitComma(String s) {
        s = StringUtils.trin(s);
        ArrayList<String> result = new ArrayList<String>();
        Matcher2 m = SPLIT_COMMA.matcher(s);
        while (m.find()) {
            result.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(m.group(0)));
        }
        return Collections.unmodifiableList(result);
    }

    public static String getUid(String uid1, int uid2) {
        return uid1 + String.format("%04d", uid2);
    }

    public static <O> List<O> merge(List<O> l1, List<O> l2) {
        ArrayList<O> result = new ArrayList<O>(l1);
        result.addAll(l2);
        return Collections.unmodifiableList(result);
    }

    public static boolean endsWithBackslash(String s) {
        return s.endsWith("\\") && !s.endsWith("\\\\");
    }

    public static String rot(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'm' || c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z' || c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            } else if (c > '~') {
                throw new IllegalArgumentException(s);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String manageUnicodeNotationUplus(String s) {
        Matcher matcher = UNICODE.matcher(s);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String num = matcher.group(1);
            int value = Integer.parseInt(num, 16);
            String replace = new String(Character.toChars(value));
            matcher.appendReplacement(result, Matcher.quoteReplacement(replace));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String manageAmpDiese(String s) {
        Matcher matcher = AMP_HASH.matcher(s);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            int codePoint = Integer.parseInt(matcher.group(1));
            String unicode = new String(Character.toChars(codePoint));
            matcher.appendReplacement(result, unicode);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String manageTildeArobaseStart(String s) {
        s = s.replaceAll("~@start", "@start");
        return s;
    }

    public static String manageEscapedTabs(String s) {
        return s.replace("\\t", "\t");
    }

    public static long seed(String string) {
        long h = 1125899906842597L;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            h = 31L * h + (long)string.charAt(i);
        }
        return h;
    }

    public static String trin(String arg) {
        int len = arg.length();
        if (len == 0) {
            return "";
        }
        int start = 0;
        int end = len - 1;
        while (start <= end) {
            char cStart = arg.charAt(start);
            if (cStart == ' ' || cStart == '\t' || cStart == '\r' || cStart == '\n' || cStart == '\u0000') {
                ++start;
                continue;
            }
            char cEnd = arg.charAt(end);
            if (cEnd != ' ' && cEnd != '\t' && cEnd != '\r' && cEnd != '\n' && cEnd != '\u0000') break;
            --end;
        }
        if (start == 0 && end == len - 1) {
            return arg;
        }
        if (start > end) {
            return "";
        }
        return arg.substring(start, end + 1);
    }

    public static String trinNoTrace(CharSequence s) {
        return s.toString().trim();
    }

    private static boolean isSpaceOrTabOrNull(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000';
    }

    public static int getWcWidth(Display stringsToDisplay) {
        int result = 1;
        for (CharSequence s : stringsToDisplay) {
            int length;
            if (s == null || result >= (length = Wcwidth.length(s))) continue;
            result = length;
        }
        return result;
    }
}

