/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Annotated;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.PSystemUtils;
import net.sourceforge.plantuml.Previous;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.WithSprite;
import net.sourceforge.plantuml.abel.DisplayPositioned;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.crash.CrashReportHandler;
import net.sourceforge.plantuml.dot.UnparsableGraphvizException;
import net.sourceforge.plantuml.file.SuggestedFile;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.pdf.PdfConverter;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.svek.EmptySvgException;
import net.sourceforge.plantuml.teavm.TeaVM;
import net.sourceforge.plantuml.version.Version;

public abstract class UmlDiagram
extends TitledDiagram
implements Diagram,
Annotated,
WithSprite {
    private boolean rotation;
    private int minwidth = Integer.MAX_VALUE;
    private XDimension2D lastInfo;
    private static final Pattern DIGITS = Pattern.compile("\\d+");

    public UmlDiagram(UmlSource source, UmlDiagramType type, Previous previous, PreprocessingArtifact preprocessing) {
        super(source, type, previous, preprocessing);
    }

    public final int getMinwidth() {
        return this.minwidth;
    }

    public final void setMinwidth(int minwidth) {
        this.minwidth = minwidth;
    }

    public final boolean isRotation() {
        return this.rotation;
    }

    public final void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public final DisplayPositioned getFooterOrHeaderTeoz(FontParam param) {
        if (param == FontParam.FOOTER) {
            return this.getFooter();
        }
        if (param == FontParam.HEADER) {
            return this.getHeader();
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        fileFormatOption = fileFormatOption.withTikzFontDistortion(this.getSkinParam().getTikzFontDistortion());
        fileFormatOption.getTikzFontDistortion().updateFromPragma(this.getPragma());
        if (!TeaVM.isTeaVM() && fileFormatOption.getFileFormat() == FileFormat.PDF) {
            return this.exportDiagramInternalPdf(os, index);
        }
        try {
            ImageData imageData = this.exportDiagramInternal(os, index, fileFormatOption);
            this.lastInfo = new XDimension2D(imageData.getWidth(), imageData.getHeight());
            return imageData;
        }
        catch (NoStyleAvailableException e) {
            Logme.error(e);
            CrashReportHandler report = new CrashReportHandler(null, this.getMetadata(), this.getFlashData());
            report.add("There is an issue with your plantuml.jar file:");
            report.add("We cannot load any style from it!");
            report.checkOldVersionWarning();
            report.addProperties();
            report.addEmptyLine();
            report.exportDiagramError(fileFormatOption, this.seed(), os);
            return ImageDataSimple.error(e);
        }
        catch (UnparsableGraphvizException e) {
            Logme.error(e);
            CrashReportHandler report = new CrashReportHandler(e.getCause(), this.getMetadata(), this.getFlashData());
            report.anErrorHasOccured(e.getCause(), this.getFlashData());
            report.add("PlantUML (" + Version.versionString() + ") cannot parse result from dot/GraphViz.");
            if (e.getCause() instanceof EmptySvgException) {
                report.add("Because dot/GraphViz returns an empty string.");
            }
            if (e.getGraphvizVersion() != null) {
                report.addEmptyLine();
                report.add("GraphViz version used : " + e.getGraphvizVersion());
            }
            report.pleaseCheckYourGraphVizVersion();
            report.addProperties();
            report.addEmptyLine();
            report.thisMayBeCaused();
            report.addEmptyLine();
            report.youShouldSendThisDiagram();
            report.addEmptyLine();
            report.exportDiagramError(fileFormatOption, this.seed(), os);
            return ImageDataSimple.error(e);
        }
        catch (Throwable e) {
            Logme.error(e);
            CrashReportHandler report = new CrashReportHandler(e, this.getMetadata(), this.getFlashData());
            report.anErrorHasOccured(e, this.getFlashData());
            report.addProperties();
            report.addEmptyLine();
            report.youShouldSendThisDiagram();
            report.addEmptyLine();
            report.exportDiagramError(fileFormatOption, this.seed(), os);
            return ImageDataSimple.error(e);
        }
    }

    private ImageData exportDiagramInternalPdf(OutputStream os, int index) throws IOException {
        ImageData result;
        File svg = FileUtils.createTempFileLegacy("pdf", ".svf");
        File pdfFile = FileUtils.createTempFileLegacy("pdf", ".pdf");
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(svg));){
            result = this.exportDiagram(fos, index, new FileFormatOption(FileFormat.SVG));
        }
        PdfConverter.convert(svg, pdfFile);
        FileUtils.copyToStream(pdfFile, os);
        return result;
    }

    protected final void exportCmap(SuggestedFile suggestedFile, int index, ImageData cmapdata) throws FileNotFoundException {
        String name = UmlDiagram.changeName(suggestedFile.getFile(index).getAbsolutePath());
        SFile cmapFile = new SFile(name);
        try (PrintWriter pw = cmapFile.createPrintWriter();){
            if (!PSystemUtils.canFileBeWritten(cmapFile)) {
                return;
            }
            pw.print(cmapdata.getCMapData(cmapFile.getName().substring(0, cmapFile.getName().length() - 6)));
        }
    }

    static String changeName(String name) {
        return name.replaceAll("(?i)\\.\\w{3}$", ".cmapx");
    }

    protected abstract ImageData exportDiagramInternal(OutputStream var1, int var2, FileFormatOption var3) throws IOException;

    @Override
    public String getWarningOrError() {
        if (this.lastInfo == null) {
            return null;
        }
        double actualWidth = this.lastInfo.getWidth();
        if (actualWidth == 0.0) {
            return null;
        }
        String value = this.getSkinParam().getValue("widthwarning");
        if (value == null) {
            return null;
        }
        if (!DIGITS.matcher(value).matches()) {
            return null;
        }
        int widthwarning = Integer.parseInt(value);
        if (actualWidth > (double)widthwarning) {
            return "The image is " + (int)actualWidth + " pixel width. (Warning limit is " + widthwarning + ")";
        }
        return null;
    }

    public void setHideEmptyDescription(boolean hideEmptyDescription) {
    }

    public Previous getPrevious() {
        return Previous.createFrom(this.getSkinParam().values());
    }
}

