/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileHeightFixedCentered;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileHeightFixedMarged;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public abstract class AbstractParallelFtilesBuilder {
    protected final double barHeight = 6.0;
    private final Rose rose = new Rose();
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;
    protected final List<Ftile> list99 = new ArrayList<Ftile>();
    protected final Colors colors;

    public StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public final StyleSignatureBasic getStyleSignatureArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    public AbstractParallelFtilesBuilder(ISkinParam skinParam, StringBounder stringBounder, List<Ftile> all, Colors colors) {
        this.skinParam = skinParam;
        this.stringBounder = stringBounder;
        this.list99.addAll(this.decorateAllTiles(all));
        this.colors = colors;
    }

    private List<Ftile> decorateAllTiles(List<Ftile> all) {
        double maxHeight = this.computeMaxHeight(all);
        double ymargin1 = this.getSuppSpace1(all, this.getStringBounder());
        double ymargin2 = this.getSuppSpace2(all, this.getStringBounder());
        ArrayList<Ftile> result = new ArrayList<Ftile>();
        for (Ftile ftile : all) {
            Ftile newFtile = this.computeNewFtile(ftile, maxHeight, ymargin1, ymargin2);
            result.add(newFtile);
        }
        return result;
    }

    private double getSuppSpace1(List<Ftile> all, StringBounder stringBounder) {
        double result = 0.0;
        for (Ftile child : all) {
            TextBlock text = this.getTextBlock(child.getInLinkRendering().getDisplay());
            if (text == null) continue;
            XDimension2D dim = text.calculateDimension(stringBounder);
            result = Math.max(result, dim.getHeight());
        }
        return result;
    }

    private double getSuppSpace2(List<Ftile> all, StringBounder stringBounder) {
        double result = 0.0;
        for (Ftile child : all) {
            TextBlock text = this.getTextBlock(child.getOutLinkRendering().getDisplay());
            if (text == null) continue;
            XDimension2D dim = text.calculateDimension(stringBounder);
            result = Math.max(result, dim.getHeight());
        }
        return result;
    }

    private Ftile computeNewFtile(Ftile ftile, double maxHeight, double ymargin1, double ymargin2) {
        double spaceArroundBlackBar = 20.0;
        double xMargin = 14.0;
        Ftile tmp = FtileUtils.addHorizontalMargin(ftile, 14.0, 14.0 + this.getSuppForIncomingArrow(ftile));
        tmp = new FtileHeightFixedCentered(tmp, maxHeight + 40.0);
        tmp = new FtileHeightFixedMarged(ymargin1, tmp, ymargin2);
        return tmp;
    }

    private double getSuppForIncomingArrow(Ftile ftile) {
        double x1 = this.getXSuppForDisplay(ftile, ftile.getInLinkRendering().getDisplay());
        double x2 = this.getXSuppForDisplay(ftile, ftile.getOutLinkRendering().getDisplay());
        return Math.max(x1, x2);
    }

    private double getXSuppForDisplay(Ftile ftile, Display label) {
        TextBlock text = this.getTextBlock(label);
        if (text == null) {
            return 0.0;
        }
        double textWidth = text.calculateDimension(this.getStringBounder()).getWidth();
        FtileGeometry ftileDim = ftile.calculateDimension(this.getStringBounder());
        double pos2 = ftileDim.getLeft() + textWidth;
        if (pos2 > ftileDim.getWidth()) {
            return pos2 - ftileDim.getWidth();
        }
        return 0.0;
    }

    protected final double computeMaxHeight(List<Ftile> all) {
        double height = 0.0;
        for (Ftile tmp : all) {
            height = Math.max(height, tmp.calculateDimension(this.getStringBounder()).getHeight());
        }
        return height;
    }

    public final Ftile build(Ftile inner) {
        Ftile step1 = this.doStep1(inner);
        return this.doStep2(inner, step1);
    }

    protected abstract Ftile doStep1(Ftile var1);

    protected abstract Ftile doStep2(Ftile var1, Ftile var2);

    protected StringBounder getStringBounder() {
        return this.stringBounder;
    }

    protected Rose getRose() {
        return this.rose;
    }

    protected ISkinParam skinParam() {
        return this.skinParam;
    }

    protected final TextBlock getTextBlock(Display display) {
        if (Display.isNull(display)) {
            return null;
        }
        Style style = this.getStyleSignatureArrow().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
        FontConfiguration fontConfiguration = style.getFontConfiguration(this.skinParam().getIHtmlColorSet());
        return display.create7(fontConfiguration, HorizontalAlignment.LEFT, this.skinParam(), CreoleMode.SIMPLE_LINE);
    }

    protected TextBlock getTextBlock(LinkRendering linkRendering) {
        Display display = linkRendering.getDisplay();
        return this.getTextBlock(display);
    }

    protected final double getHeightOfMiddle(Ftile middle) {
        return middle.calculateDimension(this.getStringBounder()).getHeight();
    }

    protected Swimlane swimlaneOutForStep2() {
        return this.list99.get(this.list99.size() - 1).getSwimlaneOut();
    }
}

