/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleEmoji;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.utils.PatchUtils;

public class FtileBoxEmoji
extends AbstractFtile {
    private static final int MARGIN = 5;
    private final TextBlock emoji;
    private final TextBlock name;
    private final LinkRendering inRendering;
    private final Swimlane swimlane;

    public static StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public static StyleSignatureBasic getStyleSignatureArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    public final LinkRendering getInLinkRendering() {
        return this.inRendering;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return PatchUtils.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    public static FtileBoxEmoji create(ISkinParam skinParam, Display label, Swimlane swimlane, Stereotype stereotype, StyleBuilder styleBuilder) {
        if (styleBuilder == null) {
            styleBuilder = skinParam.getCurrentStyleBuilder();
        }
        Style style = FtileBoxEmoji.getStyleSignature().withTOBECHANGED(stereotype).getMergedStyle(styleBuilder);
        Style styleArrow = FtileBoxEmoji.getStyleSignatureArrow().getMergedStyle(styleBuilder);
        return new FtileBoxEmoji(skinParam, label, swimlane, style, styleArrow);
    }

    private FtileBoxEmoji(ISkinParam skinParam, Display label, Swimlane swimlane, Style style, Style styleArrow) {
        super(skinParam);
        this.swimlane = swimlane;
        this.inRendering = LinkRendering.create(Rainbow.build(styleArrow, this.getIHtmlColorSet()));
        FontConfiguration fc = style.getFontConfiguration(this.getIHtmlColorSet());
        Command commandCreoleEmoji = CommandCreoleEmoji.create();
        String s = label.get(0).toString();
        int tmp = commandCreoleEmoji.matchingSize(s);
        if (tmp == 0) {
            this.emoji = label.create(fc, HorizontalAlignment.LEFT, skinParam);
            this.name = TextBlockUtils.EMPTY_TEXT_BLOCK;
        } else {
            String remaining = commandCreoleEmoji.executeAndGetRemaining(s, null);
            int position = s.length() - remaining.length();
            String part1 = s.substring(0, position);
            String part2 = s.substring(position);
            this.emoji = Display.create(this.eventuallyHackSize(part1, "2")).create(fc, HorizontalAlignment.LEFT, skinParam);
            this.name = Display.create(part2).create(fc, HorizontalAlignment.LEFT, skinParam);
        }
    }

    private CharSequence eventuallyHackSize(String part1, String size) {
        if (part1.contains("*")) {
            return part1;
        }
        return part1.replace(":>", ":*" + size + ">");
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.name == TextBlockUtils.EMPTY_TEXT_BLOCK) {
            this.emoji.drawU(ug);
        } else {
            XDimension2D dimEmoji = this.emoji.calculateDimension(ug.getStringBounder());
            XDimension2D dimName = this.name.calculateDimension(ug.getStringBounder());
            double deltaX = dimEmoji.getWidth() + 5.0;
            double deltaY = (dimEmoji.getHeight() - dimName.getHeight()) / 2.0;
            if (deltaY > 0.0) {
                this.emoji.drawU(ug);
                this.name.drawU(ug.apply(new UTranslate(deltaX, deltaY)));
            } else {
                this.emoji.drawU(ug.apply(UTranslate.dy(-deltaY)));
                this.name.drawU(ug.apply(UTranslate.dx(deltaX)));
            }
        }
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        XDimension2D dimEmoji = this.emoji.calculateDimension(stringBounder);
        XDimension2D dimName = this.name.calculateDimension(stringBounder);
        double width = dimEmoji.getWidth() + 5.0 + dimName.getWidth();
        double height = Math.max(dimEmoji.getHeight(), dimName.getHeight());
        double deltaY = (dimEmoji.getHeight() - dimName.getHeight()) / 2.0;
        if (deltaY > 0.0) {
            return new FtileGeometry(width, height, dimEmoji.getWidth() / 2.0, 0.0, dimEmoji.getHeight());
        }
        return new FtileGeometry(width, height, dimEmoji.getWidth() / 2.0, -deltaY, dimEmoji.getHeight() - deltaY);
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }
}

