/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.utils.MathUtils;

public class GtileColumns
extends AbstractGtile {
    protected final List<Gtile> gtiles;
    private double margin;
    private double dy;

    protected final UTranslate getPosition(int pos) {
        double dx = 0.0;
        for (int i = 0; i < pos; ++i) {
            XDimension2D dim = this.gtiles.get(i).calculateDimension(this.getStringBounder());
            dx += dim.getWidth() + this.margin;
        }
        return new UTranslate(dx, this.dy);
    }

    protected final void setMargin(double margin) {
        if (margin < 0.0) {
            throw new IllegalArgumentException("margin=" + margin);
        }
        this.margin = margin;
    }

    protected final void pushDown(double height) {
        this.dy += height;
    }

    public String toString() {
        return "GtileIfSimple " + String.valueOf(this.gtiles);
    }

    public Gtile first() {
        return this.gtiles.get(0);
    }

    public GtileColumns(List<Gtile> gtiles, Swimlane singleSwimlane, double margin) {
        super(gtiles.get(0).getStringBounder(), gtiles.get(0).skinParam(), singleSwimlane);
        this.gtiles = gtiles;
        this.margin = margin;
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        for (int i = 0; i < this.gtiles.size(); ++i) {
            Gtile tile = this.gtiles.get(i);
            UTranslate pos = this.getPosition(i);
            ug.apply(pos).draw(tile);
        }
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D result = new XDimension2D(0.0, 0.0);
        for (int i = 0; i < this.gtiles.size(); ++i) {
            XDimension2D dim = this.gtiles.get(i).calculateDimension(stringBounder);
            UTranslate pos = this.getPosition(i);
            XDimension2D corner = dim.applyTranslate(pos);
            result = MathUtils.maxDim(result, corner);
        }
        return result;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        for (Gtile tile : this.gtiles) {
            result.addAll(tile.getSwimlanes());
        }
        return Collections.unmodifiableSet(result);
    }
}

