/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.api;

import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.prefs.Preferences;
import net.sourceforge.plantuml.api.INumberAnalyzed;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.utils.Log;

public class NumberAnalyzed2
implements INumberAnalyzed {
    private static final int SLIDING_WINDOW = 512;
    private final AtomicLong nb = new AtomicLong();
    private final AtomicLong sum = new AtomicLong();
    private final AtomicLong min = new AtomicLong();
    private final AtomicLong max = new AtomicLong();
    private final AtomicLong sumOfSquare = new AtomicLong();
    private final AtomicLong sliddingSum = new AtomicLong();
    private final String name;

    public NumberAnalyzed2(String name) {
        this.name = name;
    }

    public void reset() {
        this.nb.set(0L);
        this.sum.set(0L);
        this.min.set(0L);
        this.max.set(0L);
        this.sumOfSquare.set(0L);
        this.sliddingSum.set(0L);
    }

    public NumberAnalyzed2() {
        this("");
    }

    public final void save(Preferences prefs) {
        if (this.name.length() == 0) {
            throw new UnsupportedOperationException();
        }
        prefs.put(this.name + ".saved", this.getSavedString());
    }

    protected String getSavedString() {
        String value = this.longToString(this.nb) + ";" + this.longToString(this.sum) + ";" + this.longToString(this.min) + ";" + this.longToString(this.max) + ";" + this.longToString(this.sumOfSquare) + ";" + this.longToString(this.sliddingSum);
        return value;
    }

    protected final String longToString(AtomicLong val) {
        return Long.toString(val.get(), 36);
    }

    public static NumberAnalyzed2 load(String name, Preferences prefs) {
        String value = prefs.get(name + ".saved", "");
        if (value.length() == 0) {
            System.err.println("Cannot load " + name);
            return null;
        }
        try {
            StringTokenizer st = new StringTokenizer(value, ";");
            return new NumberAnalyzed2(name, Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36));
        }
        catch (Exception e) {
            Logme.error(e);
            Log.info(() -> "Error reading " + value);
            return null;
        }
    }

    public String toString() {
        return "sum=" + String.valueOf(this.sum) + " nb=" + String.valueOf(this.nb) + " min=" + String.valueOf(this.min) + " max=" + String.valueOf(this.max) + " mean=" + this.getMean();
    }

    protected NumberAnalyzed2(String name, long nb, long sum, long min, long max, long sumOfSquare, long sliddingSum) {
        this(name);
        this.nb.set(nb);
        this.sum.set(sum);
        this.min.set(min);
        this.max.set(max);
        this.sumOfSquare.set(sumOfSquare);
        this.sliddingSum.set(sliddingSum);
    }

    public INumberAnalyzed getCopyImmutable() {
        NumberAnalyzed2 copy = new NumberAnalyzed2(this.name, this.nb.get(), this.sum.get(), this.min.get(), this.max.get(), this.sumOfSquare.get(), this.sliddingSum.get());
        return copy;
    }

    public void addValue(long v) {
        this.nb.incrementAndGet();
        if (this.nb.get() == 1L) {
            this.min.set(v);
            this.max.set(v);
        } else if (v > this.max.get()) {
            this.max.set(v);
        } else if (v < this.min.get()) {
            this.min.set(v);
        }
        this.sum.addAndGet(v);
        this.sumOfSquare.addAndGet(v * v);
        this.sliddingSum.set(this.sliddingSum.get() * 511L / 512L + v);
    }

    public void add(NumberAnalyzed2 other) {
        this.sum.addAndGet(other.sum.get());
        this.nb.addAndGet(other.nb.get());
        this.min.set(Math.min(this.min.get(), other.min.get()));
        this.max.set(Math.max(this.max.get(), other.max.get()));
    }

    @Override
    public final long getNb() {
        return this.nb.get();
    }

    @Override
    public final long getSum() {
        return this.sum.get();
    }

    @Override
    public final long getMin() {
        return this.min.get();
    }

    @Override
    public final long getMax() {
        return this.max.get();
    }

    @Override
    public final long getMean() {
        if (this.nb.get() == 0L) {
            return 0L;
        }
        return this.sum.get() / this.nb.get();
    }

    @Override
    public final long getSliddingMean() {
        if (this.nb.get() == 0L) {
            return 0L;
        }
        if (this.nb.get() < 512L) {
            return this.sum.get() / this.nb.get();
        }
        return this.sliddingSum.get() / this.nb.get();
    }

    public final String getName() {
        return this.name;
    }
}

