/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.api.v2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.api.v2.DiagramReturn;
import net.sourceforge.plantuml.api.v2.DiagramReturnError;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.security.SImageIO;

public abstract class DiagramUtils {
    public static DiagramReturn exportDiagram(String ... source) throws IOException {
        StringReader reader = new StringReader(String.join((CharSequence)"\n", source));
        BlockUmlBuilder builder = new BlockUmlBuilder(Collections.emptyList(), StandardCharsets.UTF_8, Defines.createEmpty(), reader, FileSystem.getInstance().getCurrentDir(), "string");
        List<BlockUml> blocks = builder.getBlockUmls();
        if (blocks.size() == 0) {
            return new DiagramReturnError("No @start/@end found");
        }
        BlockUml blockUml = blocks.get(0);
        final Diagram diagram = blockUml.getDiagram();
        return new DiagramReturn(){

            @Override
            public Diagram getDiagram() {
                return diagram;
            }

            @Override
            public String error() {
                if (diagram instanceof PSystemError) {
                    PSystemError diagramError = (PSystemError)diagram;
                    ErrorUml error = diagramError.getFirstError();
                    return error.getError();
                }
                return null;
            }

            @Override
            public Optional<Integer> getErrorLine() {
                if (diagram instanceof PSystemError) {
                    PSystemError diagramError = (PSystemError)diagram;
                    ErrorUml error = diagramError.getFirstError();
                    return Optional.of(error.getLineLocation().getPosition());
                }
                return Optional.empty();
            }

            @Override
            public PortableImage asImage() throws IOException {
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    FileFormatOption fileFormatOption = new FileFormatOption(FileFormat.PNG);
                    ImageData imageData = diagram.exportDiagram(os, 0, fileFormatOption);
                    PortableImage portableImage = SImageIO.read(os.toByteArray());
                    return portableImage;
                }
            }

            @Override
            public Throwable getRootCause() {
                Throwable throwable;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    FileFormatOption fileFormatOption = new FileFormatOption(FileFormat.PNG);
                    ImageData imageData = diagram.exportDiagram(os, 0, fileFormatOption);
                    throwable = imageData.getRootCause();
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return e;
                    }
                }
                os.close();
                return throwable;
            }
        };
    }
}

