/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.board;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.plantuml.board.BNode;

public class BArray
implements Iterable<BNode> {
    private final Map<String, BNode> data = new HashMap<String, BNode>();
    private int maxX;
    private int maxY;

    public void put(BNode node) {
        String key = this.getKey(node.getX(), node.getStage());
        if (this.data.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        this.data.put(key, node);
        this.maxX = Math.max(this.maxX, node.getX());
        this.maxY = Math.max(this.maxY, node.getStage());
    }

    public BNode getCell(int x, int y) {
        String key = this.getKey(x, y);
        return this.data.get(key);
    }

    private String getKey(int x, int y) {
        return x + ";" + y;
    }

    @Override
    public Iterator<BNode> iterator() {
        return Collections.unmodifiableCollection(this.data.values()).iterator();
    }

    public final int getMaxX() {
        return this.maxX;
    }

    public final int getMaxY() {
        return this.maxY;
    }
}

