/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cli;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.Run;
import net.sourceforge.plantuml.cli.Arity;
import net.sourceforge.plantuml.cli.CliAction;
import net.sourceforge.plantuml.cli.CliDefaultValue;
import net.sourceforge.plantuml.cli.CliFlagDoc;
import net.sourceforge.plantuml.cli.GlobalConfig;
import net.sourceforge.plantuml.cli.GlobalConfigKey;
import net.sourceforge.plantuml.cli.HelpPrint;
import net.sourceforge.plantuml.cli.OptionPrint;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.stats.StatsUtils;
import net.sourceforge.plantuml.swing.ClipboardLoop;

public enum CliFlag {
    HELP("--help", CliFlag.aliases("-h", "-?", CliFlag.DEPRECATED("-help")), Arity.UNARY_IMMEDIATE_ACTION, HelpPrint::printHelp),
    HELP_MORE("--help-more", CliFlag.aliases(CliFlag.DEPRECATED("-h:more"), CliFlag.DEPRECATED("-help:more")), Arity.UNARY_IMMEDIATE_ACTION, HelpPrint::printHelpMore),
    VERSION("--version", CliFlag.aliases(CliFlag.DEPRECATED("-version")), Arity.UNARY_IMMEDIATE_ACTION, OptionPrint::printVersion),
    AUTHOR("--author", CliFlag.aliases("--about", CliFlag.DEPRECATED("-authors"), CliFlag.DEPRECATED("-about")), Arity.UNARY_IMMEDIATE_ACTION, OptionPrint::printAbout),
    GUI("--gui", CliFlag.aliases(CliFlag.DEPRECATED("-gui")), Arity.UNARY_BOOLEAN, () -> GlobalConfig.getInstance().put(GlobalConfigKey.GUI, true)),
    DARK_MODE("--dark-mode", CliFlag.aliases(CliFlag.DEPRECATED("-darkmode")), Arity.UNARY_BOOLEAN),
    VERBOSE("--verbose", CliFlag.aliases(CliFlag.DEPRECATED("-v"), CliFlag.DEPRECATED("-verbose")), Arity.UNARY_BOOLEAN, () -> GlobalConfig.getInstance().put(GlobalConfigKey.VERBOSE, true)),
    DURATION("--duration", CliFlag.aliases(CliFlag.DEPRECATED("-duration")), Arity.UNARY_BOOLEAN),
    PROGRESS("--progress-bar", CliFlag.aliases(CliFlag.DEPRECATED("-progress")), Arity.UNARY_BOOLEAN),
    SPLASH("--splash-screen", CliFlag.aliases(CliFlag.DEPRECATED("-splash")), Arity.UNARY_BOOLEAN),
    TEST_DOT("--check-graphviz", CliFlag.aliases(CliFlag.DEPRECATED("-testdot")), Arity.UNARY_IMMEDIATE_ACTION, OptionPrint::printCheckGraphviz),
    PICOWEB("--http-server", CliFlag.aliases(CliFlag.DEPRECATED("-picoweb")), Arity.UNARY_OPTIONAL_COLON),
    EXCLUDE("--exclude", CliFlag.aliases("-x", CliFlag.DEPRECATED("-exclude")), Arity.BINARY_NEXT_ARGUMENT_VALUE),
    PIPE("--pipe", CliFlag.aliases("-p", CliFlag.DEPRECATED("-pipe")), Arity.UNARY_BOOLEAN),
    PIPEMAP("-pipemap", Arity.UNARY_BOOLEAN),
    PIPEDELIMITOR("-pipedelimitor", Arity.BINARY_NEXT_ARGUMENT_VALUE),
    PIPENOSTDERR("-pipenostderr", Arity.UNARY_BOOLEAN),
    PIPE_IMAGE_INDEX("--pipe-image-index", CliFlag.aliases(CliFlag.DEPRECATED("-pipeimageindex")), Arity.BINARY_NEXT_ARGUMENT_VALUE),
    DEFINE("-D", Arity.UNARY_INLINE_KEY_OR_KEY_VALUE),
    DEFINE_LONG("--define", Arity.BINARY_NEXT_ARGUMENT_VALUE),
    INCLUDE("-I", Arity.UNARY_INLINE_KEY_OR_KEY_VALUE),
    INCLUDE_LONG("--include", Arity.BINARY_NEXT_ARGUMENT_VALUE),
    PRAGMA("-P", Arity.UNARY_INLINE_KEY_OR_KEY_VALUE),
    PRAGMA_LONG("--pragma", Arity.BINARY_NEXT_ARGUMENT_VALUE),
    SKINPARAM("-S", Arity.UNARY_INLINE_KEY_OR_KEY_VALUE),
    SKINPARAM_LONG("--skinparam", Arity.BINARY_NEXT_ARGUMENT_VALUE),
    THEME("--theme", CliFlag.aliases(CliFlag.DEPRECATED("-theme")), Arity.BINARY_NEXT_ARGUMENT_VALUE),
    CONFIG("--config", CliFlag.aliases(CliFlag.DEPRECATED("-config")), Arity.BINARY_NEXT_ARGUMENT_VALUE),
    CHARSET("--charset", CliFlag.aliases(CliFlag.DEPRECATED("-charset")), Arity.BINARY_NEXT_ARGUMENT_VALUE),
    CHECK_ONLY("--check-syntax", CliFlag.aliases("--syntax-check", CliFlag.DEPRECATED("-checkonly")), Arity.UNARY_BOOLEAN),
    FAIL_FAST("--stop-on-error", CliFlag.aliases(CliFlag.DEPRECATED("-failfast")), Arity.UNARY_BOOLEAN),
    FAIL_FAST2("--check-before-run", CliFlag.aliases(CliFlag.DEPRECATED("-failfast2")), Arity.UNARY_BOOLEAN),
    NO_ERROR_IMAGE("--no-error-image", CliFlag.aliases(CliFlag.DEPRECATED("-noerror")), Arity.UNARY_BOOLEAN),
    TIMEOUT("--graphviz-timeout", CliFlag.aliases(CliFlag.DEPRECATED("-timeout")), Arity.BINARY_NEXT_ARGUMENT_VALUE),
    IGNORE_STARTUML_FILENAME("--ignore-startuml-filename", Arity.UNARY_BOOLEAN),
    NB_THREAD("--threads", CliFlag.aliases(CliFlag.DEPRECATED("-nbthread")), Arity.BINARY_NEXT_ARGUMENT_VALUE),
    RETRIEVE_METADATA("--extract-source", CliFlag.aliases(CliFlag.DEPRECATED("-metadata")), Arity.UNARY_BOOLEAN),
    NO_METADATA("--disable-metadata", CliFlag.aliases(CliFlag.DEPRECATED("-nometadata")), Arity.UNARY_BOOLEAN),
    CHECK_METADATA("--skip-fresh", CliFlag.aliases(CliFlag.DEPRECATED("-checkmetadata")), Arity.UNARY_BOOLEAN),
    ENCODE_SPRITE("--encode-sprite", CliFlag.aliases(CliFlag.DEPRECATED("-sprite"), CliFlag.DEPRECATED("-encodesprite")), Arity.UNARY_BOOLEAN),
    COMPUTE_URL("--encode-url", CliFlag.aliases("--compute-url", CliFlag.DEPRECATED("-computeurl"), CliFlag.DEPRECATED("-encodeurl")), Arity.UNARY_BOOLEAN),
    DECODE_URL("--decode-url", CliFlag.aliases(CliFlag.DEPRECATED("-decodeurl")), Arity.UNARY_BOOLEAN),
    LANGUAGE("--list-keywords", CliFlag.aliases(CliFlag.DEPRECATED("-language")), Arity.UNARY_IMMEDIATE_ACTION, OptionPrint::printListKeywords),
    GRAPHVIZ_DOT("--dot-path", CliFlag.aliases(CliFlag.DEPRECATED("-graphvizdot"), CliFlag.DEPRECATED("-graphviz_dot")), Arity.BINARY_NEXT_ARGUMENT_VALUE),
    FTP("--ftp-server", CliFlag.aliases(CliFlag.DEPRECATED("-ftp")), Arity.UNARY_OPTIONAL_COLON),
    OUTPUT_DIR("--output-dir", CliFlag.aliases("-o", CliFlag.DEPRECATED("output_dir"), CliFlag.DEPRECATED("-output"), CliFlag.DEPRECATED("-odir")), Arity.BINARY_NEXT_ARGUMENT_VALUE),
    OVERWRITE("--overwrite", CliFlag.aliases("--force-overwrite", CliFlag.DEPRECATED("-overwrite")), Arity.UNARY_BOOLEAN, () -> GlobalConfig.getInstance().put(GlobalConfigKey.OVERWRITE, true)),
    CLIPBOARD("--clipboard", Arity.UNARY_IMMEDIATE_ACTION, ClipboardLoop::runOnce),
    CLIPBOARDLOOP("--clipboardloop", Arity.UNARY_IMMEDIATE_ACTION, ClipboardLoop::runLoop),
    DEBUG_SVEK("-debugsvek", CliFlag.aliases("-debug_svek"), Arity.UNARY_BOOLEAN),
    FILE_DIR("-filedir", Arity.BINARY_NEXT_ARGUMENT_VALUE),
    FILENAME("-filename", Arity.BINARY_NEXT_ARGUMENT_VALUE),
    HEADLESS("-headless", Arity.UNARY_BOOLEAN, () -> System.setProperty("java.awt.headless", "true")),
    PRINT_FONTS("-printfonts", Arity.UNARY_IMMEDIATE_ACTION, Run::printFonts),
    STD_LIB("-stdlib", Arity.UNARY_IMMEDIATE_ACTION, Stdlib::printStdLib),
    STDRPT("-stdrpt", Arity.UNARY_OPTIONAL_COLON),
    SYNTAX("-syntax", Arity.UNARY_BOOLEAN),
    LICENSE("-license", CliFlag.aliases("-licence"), Arity.UNARY_IMMEDIATE_ACTION, OptionPrint::printLicense),
    WORD("-word", Arity.UNARY_BOOLEAN, () -> GlobalConfig.getInstance().put(GlobalConfigKey.WORD, true)),
    USE_SEPARATOR_MINUS("-useseparatorminus", Arity.UNARY_BOOLEAN, () -> GlobalConfig.getInstance().put(GlobalConfigKey.FILE_SEPARATOR, "-")),
    FORMAT("--format", CliFlag.aliases("-f"), Arity.BINARY_NEXT_ARGUMENT_VALUE),
    T_EPS("--eps", CliFlag.aliases(CliFlag.DEPRECATED("-teps"), CliFlag.DEPRECATED("-eps")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.EPS)),
    T_EPS_TEXT("--teps:text", CliFlag.aliases(CliFlag.DEPRECATED("-teps:text"), CliFlag.DEPRECATED("-eps:text")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.EPS_TEXT)),
    T_HTML("--html", CliFlag.aliases(CliFlag.DEPRECATED("-thtml"), CliFlag.DEPRECATED("-html")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.HTML)),
    T_LATEX("--latex", CliFlag.aliases(CliFlag.DEPRECATED("-tlatex"), CliFlag.DEPRECATED("-latex")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.LATEX)),
    T_LATEX_NOPREAMBLE("--latex-nopreamble", CliFlag.aliases(CliFlag.DEPRECATED("-tlatex:nopreamble"), CliFlag.DEPRECATED("-latex:nopreamble")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.LATEX_NO_PREAMBLE)),
    OBFUSCATE("--obfuscate", CliFlag.aliases(CliFlag.DEPRECATED("-cypher")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.OBFUSCATE)),
    T_PDF("--pdf", CliFlag.aliases(CliFlag.DEPRECATED("-tpdf"), CliFlag.DEPRECATED("-pdf")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.PDF)),
    T_PNG("--png", CliFlag.aliases(CliFlag.DEPRECATED("-tpng"), CliFlag.DEPRECATED("-png")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.PNG)),
    PREPROCESS("--preproc", CliFlag.aliases(CliFlag.DEPRECATED("-preproc")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.PREPROC)),
    T_SCXML("--scxml", CliFlag.aliases(CliFlag.DEPRECATED("-tscxml")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.SCXML)),
    T_SVG("--svg", CliFlag.aliases(CliFlag.DEPRECATED("-tsvg"), CliFlag.DEPRECATED("-svg")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.SVG)),
    T_TXT("--txt", CliFlag.aliases(CliFlag.DEPRECATED("-ttxt"), CliFlag.DEPRECATED("-txt")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.ATXT)),
    T_UTXT("--utxt", CliFlag.aliases(CliFlag.DEPRECATED("-tutxt"), CliFlag.DEPRECATED("-utxt")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.UTXT)),
    T_VDX("--vdx", CliFlag.aliases(CliFlag.DEPRECATED("-tvdx"), CliFlag.DEPRECATED("-vdx")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.VDX)),
    T_XMI("--xmi", CliFlag.aliases(CliFlag.DEPRECATED("-txmi"), CliFlag.DEPRECATED("-xmi")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.XMI_STANDARD)),
    T_XMI_ARGO("--txmi:argo", CliFlag.aliases(CliFlag.DEPRECATED("-xmi:argo")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.XMI_ARGO)),
    T_XMI_CUSTOM("--txmi:custom", CliFlag.aliases(CliFlag.DEPRECATED("-xmi:custom")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.XMI_CUSTOM)),
    T_XMI_SCRIPT("--txmi:script", CliFlag.aliases(CliFlag.DEPRECATED("-xmi:script")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.XMI_SCRIPT)),
    T_XMI_STAR("--txmi:star", CliFlag.aliases(CliFlag.DEPRECATED("-xmi:star")), Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.XMI_STAR)),
    T_BASE64("--tbase64", Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.BASE64)),
    T_BRAILLE("--tbraille", Arity.UNARY_BOOLEAN, (Object)((Object)FileFormat.BRAILLE_PNG)),
    DISABLE_STATS("--disable-stats", CliFlag.aliases(CliFlag.DEPRECATED("-disablestats")), Arity.UNARY_BOOLEAN, () -> GlobalConfig.getInstance().put(GlobalConfigKey.ENABLE_STATS, false)),
    ENABLE_STATS("--enable-stats", CliFlag.aliases(CliFlag.DEPRECATED("-enablestats")), Arity.UNARY_BOOLEAN, () -> GlobalConfig.getInstance().put(GlobalConfigKey.ENABLE_STATS, true)),
    DUMPHTMLSTATS("--export-stats-html", Arity.UNARY_IMMEDIATE_ACTION, StatsUtils::outHtml),
    DUMPSTATS("--export-stats", Arity.UNARY_IMMEDIATE_ACTION, StatsUtils::dumpStats),
    HTML_STATS("--html-stats", CliFlag.aliases(CliFlag.DEPRECATED("-htmlstats")), Arity.UNARY_BOOLEAN, () -> StatsUtils.setHtmlStats(true)),
    XML_STATS("--xml-stats", CliFlag.aliases(CliFlag.DEPRECATED("-xmlstats")), Arity.UNARY_BOOLEAN, () -> StatsUtils.setXmlStats(true)),
    REALTIME_STATS("--realtime-stats", CliFlag.aliases(CliFlag.DEPRECATED("-realtimestats")), Arity.UNARY_BOOLEAN, () -> StatsUtils.setRealTimeStats(true)),
    LOOP_STATS("--loop-stats", CliFlag.aliases(CliFlag.DEPRECATED("-loopstats")), Arity.UNARY_IMMEDIATE_ACTION, StatsUtils::loopStats);

    private final String flag;
    private final List<String> aliases;
    private final Arity type;
    private final Object foo;

    private CliFlag(String flag2, Arity type) {
        this(flag2, Collections.emptyList(), type, null);
    }

    private CliFlag(String flag2, List<String> aliases, Arity type) {
        this(flag2, aliases, type, null);
    }

    private CliFlag(String flag2, Arity type, CliAction foo) {
        this(flag2, Collections.emptyList(), type, foo);
    }

    private CliFlag(String flag2, Arity type, Object foo) {
        this(flag2, Collections.emptyList(), type, foo);
    }

    private CliFlag(String flag2, List<String> aliases, Arity type, Object foo) {
        this.type = type;
        this.flag = flag2;
        this.aliases = aliases;
        this.foo = foo;
    }

    private CliFlag(String flag2, List<String> aliases, Arity type, CliAction foo) {
        this.type = type;
        this.flag = flag2;
        this.aliases = aliases;
        this.foo = foo;
    }

    private static List<String> aliases(String ... names) {
        return Arrays.asList(names);
    }

    private static String DEPRECATED(String option) {
        return option;
    }

    public String getFlag() {
        return this.flag;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public Arity getType() {
        return this.type;
    }

    boolean match(String tmp) {
        if (this.type == Arity.UNARY_INLINE_KEY_OR_KEY_VALUE || this.type == Arity.UNARY_OPTIONAL_COLON) {
            for (String alias : this.aliases) {
                if (!tmp.startsWith(alias)) continue;
                return true;
            }
            return tmp.startsWith(this.flag);
        }
        for (String alias : this.aliases) {
            if (!tmp.equals(alias)) continue;
            return true;
        }
        return tmp.equals(this.flag);
    }

    public String getFlagDoc() {
        try {
            CliFlagDoc annotation = CliFlag.class.getField(this.name()).getAnnotation(CliFlagDoc.class);
            if (annotation != null && !annotation.value().isEmpty()) {
                return annotation.value();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    public String getNewgroup() {
        try {
            CliFlagDoc annotation = CliFlag.class.getField(this.name()).getAnnotation(CliFlagDoc.class);
            if (annotation != null && !annotation.value().isEmpty()) {
                return annotation.newGroup();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return "";
    }

    public String getUsage() {
        try {
            CliFlagDoc annotation = CliFlag.class.getField(this.name()).getAnnotation(CliFlagDoc.class);
            if (annotation != null && !annotation.usage().isEmpty()) {
                String usage = annotation.usage();
                if (usage.startsWith("--")) {
                    return "     " + usage;
                }
                return " " + usage;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        for (String alias : this.aliases) {
            if (alias.length() != 2) continue;
            return " " + alias + ", " + this.getFlag();
        }
        return "     " + this.getFlag();
    }

    public int getFlagLevel() {
        try {
            CliFlagDoc annotation = CliFlag.class.getField(this.name()).getAnnotation(CliFlagDoc.class);
            if (annotation != null) {
                return annotation.level();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return -1;
    }

    public String getDefaultValue() {
        try {
            CliDefaultValue annotation = CliFlag.class.getField(this.name()).getAnnotation(CliDefaultValue.class);
            if (annotation != null && !annotation.value().isEmpty()) {
                return annotation.value();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    public Object getFoo() {
        return this.foo;
    }
}

