/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jsondiagram;

import gen.lib.cgraph.attr__c;
import gen.lib.cgraph.edge__c;
import gen.lib.cgraph.graph__c;
import gen.lib.cgraph.node__c;
import gen.lib.gvc.gvc__c;
import gen.lib.gvc.gvlayout__c;
import h.ST_Agedge_s;
import h.ST_Agedgeinfo_t;
import h.ST_Agnode_s;
import h.ST_Agnodeinfo_t;
import h.ST_Agraph_s;
import h.ST_GVC_s;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.jsondiagram.JsonCurve;
import net.sourceforge.plantuml.jsondiagram.Mirror;
import net.sourceforge.plantuml.jsondiagram.TextBlockJson;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.yaml.Highlighted;
import smetana.core.CString;
import smetana.core.Globals;

public class SmetanaForJson {
    private static int NUM = 0;
    private static final boolean printFirst = false;
    private static final boolean exitAfterFirst = false;
    private final UGraphic ug;
    private final ISkinParam skinParam;
    private int num;
    private ST_Agraph_s g;
    private StringBounder stringBounder;
    private final List<InternalNode> nodes = new ArrayList<InternalNode>();
    private final List<ST_Agedge_s> edges = new ArrayList<ST_Agedge_s>();
    private Mirror xMirror;

    public SmetanaForJson(UGraphic ug, ISkinParam skinParam) {
        this.stringBounder = ug.getStringBounder();
        this.skinParam = skinParam;
        this.ug = ug;
    }

    private SName getDiagramType() {
        if (this.skinParam.getUmlDiagramType() == UmlDiagramType.JSON) {
            return SName.jsonDiagram;
        }
        return SName.yamlDiagram;
    }

    private Style getStyleArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.getDiagramType(), SName.arrow).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private Style getStyleNode() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.getDiagramType(), SName.node).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private ST_Agnode_s manageOneNode(Globals zz, JsonValue current, List<Highlighted> highlighted) {
        TextBlockJson block = new TextBlockJson(this.skinParam, current, highlighted);
        ST_Agnode_s node1 = this.createNode(zz, block.calculateDimension(this.stringBounder), current.isArray(), block.getWidthColA(this.stringBounder), block.getWidthColB(this.stringBounder), block.getAllHeights(this.stringBounder));
        this.nodes.add(new InternalNode(block, node1));
        List<JsonValue> children = block.children();
        List<String> keys = block.keys();
        for (int i = 0; i < children.size(); ++i) {
            JsonValue tmp = children.get(i);
            if (tmp == null) continue;
            ST_Agnode_s childBloc = this.manageOneNode(zz, tmp, this.upOneLevel(keys.get(i), highlighted));
            ST_Agedge_s edge = this.createEdge(zz, node1, childBloc, i);
            this.edges.add(edge);
        }
        return node1;
    }

    private List<Highlighted> upOneLevel(String key, List<Highlighted> list) {
        ArrayList<Highlighted> result = new ArrayList<Highlighted>();
        for (Highlighted tmp : list) {
            Highlighted parent = tmp.upOneLevel(key);
            if (parent == null) continue;
            result.add(parent);
        }
        return Collections.unmodifiableList(result);
    }

    public void drawMe(JsonValue root, List<Highlighted> highlighted) {
        this.initGraph(root, highlighted);
        double max = 0.0;
        for (InternalNode node : this.nodes) {
            max = Math.max(max, node.getMaxX());
        }
        this.xMirror = new Mirror(max);
        for (InternalNode node : this.nodes) {
            node.block.drawU(this.getStyleNode().applyStrokeAndLineColor(this.ug, this.skinParam.getIHtmlColorSet()).apply(this.getPosition(node.node)));
        }
        HColor color = this.getStyleArrow().value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        for (ST_Agedge_s edge : this.edges) {
            JsonCurve curve = this.getCurve(edge, 13.0);
            curve.drawCurve(color, this.getStyleArrow().applyStrokeAndLineColor(this.ug, this.skinParam.getIHtmlColorSet()));
            curve.drawSpot(this.getStyleArrow().applyStrokeAndLineColor(this.ug, this.skinParam.getIHtmlColorSet()).apply(color.bg()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGraph(JsonValue root, List<Highlighted> highlighted) {
        if (this.g != null) {
            return;
        }
        Globals zz = Globals.open();
        try {
            this.g = graph__c.agopen(zz, new CString("g"), zz.Agdirected, null);
            this.manageOneNode(zz, root, highlighted);
            ST_GVC_s gvc = gvc__c.gvContext(zz, new Object[0]);
            gvlayout__c.gvLayoutJobs(zz, gvc, this.g);
        }
        finally {
            Globals.close();
            ++NUM;
        }
    }

    private UTranslate getPosition(ST_Agnode_s node) {
        ST_Agnodeinfo_t data = (ST_Agnodeinfo_t)node.data;
        double width = data.width * 72.0;
        double height = data.height * 72.0;
        double x = data.coord.x;
        double y = data.coord.y;
        return new UTranslate(x - width / 2.0, this.xMirror.inv(y + height / 2.0)).sym();
    }

    private JsonCurve getCurve(ST_Agedge_s e, double veryFirstLine) {
        ST_Agedgeinfo_t data = (ST_Agedgeinfo_t)e.data;
        return new JsonCurve(data, this.xMirror, veryFirstLine);
    }

    private ST_Agedge_s createEdge(Globals zz, ST_Agnode_s a0, ST_Agnode_s a1, int num) {
        ST_Agedge_s edge = edge__c.agedge(zz, this.g, a0, a1, null, true);
        edge.NAME = a0.NAME + "-" + a1.NAME;
        attr__c.agsafeset(zz, edge, new CString("arrowsize"), new CString(".75"), new CString(""));
        attr__c.agsafeset(zz, edge, new CString("arrowtail"), new CString("none"), new CString(""));
        attr__c.agsafeset(zz, edge, new CString("arrowhead"), new CString("normal"), new CString(""));
        attr__c.agsafeset(zz, edge, new CString("tailport"), new CString("P" + num), new CString(""));
        return edge;
    }

    private ST_Agnode_s createNode(Globals zz, XDimension2D dim, boolean isArray, double colAwidth, double colBwidth, double[] lineHeights) {
        String width = "" + dim.getWidth() / 72.0;
        String height = "" + dim.getHeight() / 72.0;
        ST_Agnode_s node = node__c.agnode(zz, this.g, new CString("N" + this.num), true);
        node.NAME = "N " + this.num;
        ++this.num;
        attr__c.agsafeset(zz, node, new CString("shape"), new CString("record"), new CString(""));
        attr__c.agsafeset(zz, node, new CString("height"), new CString(width), new CString(""));
        attr__c.agsafeset(zz, node, new CString("width"), new CString(height), new CString(""));
        int size = lineHeights.length;
        String dotLabel = isArray ? this.getDotLabelArray(colAwidth - 8.0, colBwidth - 8.0, lineHeights) : this.getDotLabelMap(colAwidth - 8.0, colBwidth - 8.0, lineHeights);
        if (size > 0) {
            attr__c.agsafeset(zz, node, new CString("label"), new CString(dotLabel), new CString(""));
        }
        return node;
    }

    private String getDotLabelArray(double widthA, double widthB, double[] lineHeights) {
        int size = lineHeights.length;
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < size; ++i) {
            sb.append("<P" + i + ">");
            sb.append("_dim_" + lineHeights[i] + "_" + widthA + "_");
            if (i >= size - 1) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    private String getDotLabelMap(double widthA, double widthB, double[] lineHeights) {
        int size = lineHeights.length;
        double height = 0.0;
        for (double h : lineHeights) {
            height += h;
        }
        StringBuilder sb = new StringBuilder("");
        sb.append("{_dim_" + height + "_" + widthA + "_|{");
        for (int i = 0; i < size; ++i) {
            sb.append("<P" + i + ">");
            sb.append("_dim_" + lineHeights[i] + "_" + widthB + "_");
            if (i >= size - 1) continue;
            sb.append("|");
        }
        sb.append("}}");
        return sb.toString();
    }

    static class InternalNode {
        private final TextBlockJson block;
        private final ST_Agnode_s node;

        public InternalNode(TextBlockJson block, ST_Agnode_s node) {
            this.block = block;
            this.node = node;
        }

        double getMaxX() {
            ST_Agnodeinfo_t data = (ST_Agnodeinfo_t)this.node.data;
            double height = data.height * 72.0;
            double y = data.coord.y;
            return y + height / 2.0;
        }
    }
}

