/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.awt;

import java.awt.geom.AffineTransform;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class XAffineTransform {
    private double m00;
    private double m10;
    private double m01;
    private double m11;
    private double m02;
    private double m12;

    public XAffineTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
    }

    public XAffineTransform(XAffineTransform other) {
        this.m00 = other.m00;
        this.m10 = other.m10;
        this.m01 = other.m01;
        this.m11 = other.m11;
        this.m02 = other.m02;
        this.m12 = other.m12;
    }

    public XAffineTransform(double[] flatMatrix) {
        this.m00 = flatMatrix[0];
        this.m10 = flatMatrix[1];
        this.m01 = flatMatrix[2];
        this.m11 = flatMatrix[3];
        this.m02 = flatMatrix[4];
        this.m12 = flatMatrix[5];
    }

    public XAffineTransform() {
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = 1.0;
        this.m02 = 0.0;
        this.m12 = 0.0;
    }

    public static XAffineTransform getRotateInstance(double thetaRadians) {
        double cos = Math.cos(thetaRadians);
        double sin = Math.sin(thetaRadians);
        return new XAffineTransform(cos, sin, -sin, cos, 0.0, 0.0);
    }

    public static XAffineTransform getTranslateInstance(double tx, double ty) {
        return new XAffineTransform(1.0, 0.0, 0.0, 1.0, tx, ty);
    }

    public static XAffineTransform getScaleInstance(double sx, double sy) {
        return new XAffineTransform(sx, 0.0, 0.0, sy, 0.0, 0.0);
    }

    public double getScaleX() {
        return this.m00;
    }

    public double getScaleY() {
        return this.m11;
    }

    public double getTranslateX() {
        return this.m02;
    }

    public double getTranslateY() {
        return this.m12;
    }

    public void scale(double sx, double sy) {
        this.m00 *= sx;
        this.m01 *= sx;
        this.m02 *= sx;
        this.m10 *= sy;
        this.m11 *= sy;
        this.m12 *= sy;
    }

    public XPoint2D transform(XPoint2D src) {
        double x = this.m00 * src.x + this.m01 * src.y + this.m02;
        double y = this.m10 * src.x + this.m11 * src.y + this.m12;
        return new XPoint2D(x, y);
    }

    public void concatenate(XAffineTransform other) {
        double n00 = this.m00 * other.m00 + this.m01 * other.m10;
        double n01 = this.m00 * other.m01 + this.m01 * other.m11;
        double n02 = this.m00 * other.m02 + this.m01 * other.m12 + this.m02;
        double n10 = this.m10 * other.m00 + this.m11 * other.m10;
        double n11 = this.m10 * other.m01 + this.m11 * other.m11;
        double n12 = this.m10 * other.m02 + this.m11 * other.m12 + this.m12;
        this.m00 = n00;
        this.m01 = n01;
        this.m02 = n02;
        this.m10 = n10;
        this.m11 = n11;
        this.m12 = n12;
    }

    public void translate(double tx, double ty) {
        this.m02 += this.m00 * tx + this.m01 * ty;
        this.m12 += this.m10 * tx + this.m11 * ty;
    }

    public void rotate(double thetaRadians, double anchorX, double anchorY) {
        this.translate(anchorX, anchorY);
        double cos = Math.cos(thetaRadians);
        double sin = Math.sin(thetaRadians);
        double n00 = this.m00 * cos + this.m01 * sin;
        double n01 = this.m00 * -sin + this.m01 * cos;
        double n10 = this.m10 * cos + this.m11 * sin;
        double n11 = this.m10 * -sin + this.m11 * cos;
        this.m00 = n00;
        this.m01 = n01;
        this.m10 = n10;
        this.m11 = n11;
        this.translate(-anchorX, -anchorY);
    }

    public AffineTransform toAffineTransform() {
        return new AffineTransform(this.m00, this.m10, this.m01, this.m11, this.m02, this.m12);
    }

    public String toString() {
        return "XAffineTransform[[" + this.m00 + ", " + this.m01 + ", " + this.m02 + "], [" + this.m10 + ", " + this.m11 + ", " + this.m12 + "]]";
    }
}

