/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.color;

import net.sourceforge.plantuml.klimt.UBackground;
import net.sourceforge.plantuml.klimt.UChange;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.color.Back;
import net.sourceforge.plantuml.klimt.color.ColorMapper;

public abstract class HColor
implements UChange {
    public UBackground bg() {
        return new Back(this);
    }

    public XColor toColor(ColorMapper mapper) {
        throw new UnsupportedOperationException();
    }

    public final String toRGB(ColorMapper mapper) {
        XColor color = this.toColor(mapper);
        return XColor.toHexRGBColor(color.getRGB());
    }

    public final String toSvg(ColorMapper mapper) {
        if (this.isTransparent()) {
            return "#00000000";
        }
        XColor color = this.toColor(mapper);
        return color.toSvg();
    }

    public HColor lighten(int ratio) {
        return this;
    }

    public HColor darken(int ratio) {
        return this;
    }

    public HColor reverseHsluv() {
        return this;
    }

    public HColor reverse() {
        return this;
    }

    public boolean isDark() {
        return true;
    }

    public TransparentFillBehavior transparentFillBehavior() {
        return TransparentFillBehavior.WITH_FILL_NONE;
    }

    public String asString() {
        return "?" + this.getClass().getSimpleName();
    }

    public HColor darkSchemeTheme() {
        return this;
    }

    public HColor getAppropriateColor(HColor back) {
        return this;
    }

    public HColor withDark(HColor dark) {
        throw new UnsupportedOperationException();
    }

    public HColor withTransparentFillBehavior(TransparentFillBehavior transparentFillBehavior) {
        throw new UnsupportedOperationException();
    }

    public HColor opposite() {
        throw new UnsupportedOperationException();
    }

    public boolean isTransparent() {
        return false;
    }

    public static enum TransparentFillBehavior {
        WITH_FILL_NONE,
        WITH_FILL_OPACITY;

    }
}

