/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole;

import net.sourceforge.plantuml.klimt.creole.NeutronType;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.creole.legacy.AtomText;
import net.sourceforge.plantuml.klimt.font.StringBounder;

public class Neutron {
    private static final Neutron ZWSP = new Neutron(null, NeutronType.ZWSP_SEPARATOR, null);
    private final String data;
    private final NeutronType type;
    private final Atom asAtom;

    private Neutron(String data, NeutronType type, Atom asAtom) {
        this.data = data;
        this.type = type;
        this.asAtom = asAtom;
    }

    public static Neutron create(Atom atom) {
        if (atom instanceof AtomText) {
            String text = ((AtomText)atom).getText();
            return new Neutron(text, Neutron.getNeutronTypeFromChar(text.charAt(0)), atom);
        }
        return new Neutron(null, NeutronType.UNKNOWN, atom);
    }

    public static Neutron zwspSeparator() {
        return ZWSP;
    }

    public String toString() {
        if (this.type == NeutronType.ZWSP_SEPARATOR) {
            return "ZWSP";
        }
        return String.valueOf((Object)this.type) + "(" + this.data + ")";
    }

    public Atom asAtom() {
        return this.asAtom;
    }

    public NeutronType getType() {
        return this.type;
    }

    private static boolean isCjkOrJapanese(char ch) {
        if (ch >= '\u4e00' && ch <= '\u9fff') {
            return true;
        }
        if (ch >= '\u3040' && ch <= '\u309f') {
            return true;
        }
        if (ch >= '\u30a0' && ch <= '\u30ff') {
            return true;
        }
        if (ch >= '\u3000' && ch <= '\u303f') {
            return true;
        }
        return ch >= '\uff65' && ch <= '\uff9f';
    }

    public double getWidth(StringBounder stringBounder) {
        if (this.type == NeutronType.ZWSP_SEPARATOR) {
            return 0.0;
        }
        return this.asAtom.calculateDimension(stringBounder).getWidth();
    }

    public static NeutronType getNeutronTypeFromChar(char ch) {
        if (Character.isWhitespace(ch)) {
            return NeutronType.WHITESPACE;
        }
        if (Neutron.isCjkOrJapanese(ch)) {
            return NeutronType.CJK_IDEOGRAPH;
        }
        return NeutronType.UNBREAKABLE;
    }
}

