/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.eps;

import net.sourceforge.plantuml.klimt.awt.XColor;

public class ShadowManager {
    private final int c1;
    private final int c2;

    public ShadowManager(int c1, int c2) {
        this.c1 = c1;
        this.c2 = c2;
    }

    public double[] getShadowDeltaPoints(double deltaShadow, double diff, double[] points) {
        assert (points.length % 2 == 0);
        double cx = 0.0;
        double cy = 0.0;
        for (int i = 0; i < points.length; i += 2) {
            cx += points[i];
            cy += points[i + 1];
        }
        int nbPoints = points.length / 2;
        cx /= (double)nbPoints;
        cy /= (double)nbPoints;
        double[] result = new double[points.length];
        for (int i = 0; i < result.length; i += 2) {
            double diffx = points[i] > cx ? -diff : diff;
            double diffy = points[i + 1] > cy ? -diff : diff;
            result[i] = points[i] + diffx + deltaShadow;
            result[i + 1] = points[i + 1] + diffy + deltaShadow;
        }
        return result;
    }

    public XColor getColor(double delta, double total) {
        int c = (int)((double)this.c2 + 1.0 * delta / total * (double)(this.c1 - this.c2));
        return new XColor(c, c, c);
    }
}

