/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.geom;

import net.sourceforge.plantuml.klimt.geom.EnsureVisible;

public class BasicEnsureVisible
implements EnsureVisible {
    private double minX = Double.MAX_VALUE;
    private double maxX = -1.7976931348623157E308;
    private double minY = Double.MAX_VALUE;
    private double maxY = -1.7976931348623157E308;

    @Override
    public void ensureVisible(double x, double y) {
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (x < this.minX) {
            this.minX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (y < this.minY) {
            this.minY = y;
        }
    }

    public boolean hasData() {
        return this.minX != Double.MAX_VALUE;
    }

    public String getCoords(double scale) {
        if (this.minX == Double.MAX_VALUE) {
            return "0,0,0,0";
        }
        int x1 = (int)(this.minX * scale);
        int y1 = (int)(this.minY * scale);
        int x2 = (int)(this.maxX * scale);
        int y2 = (int)(this.maxY * scale);
        return x1 + "," + y1 + "," + x2 + "," + y2;
    }

    public double getSurface() {
        if (this.minX == Double.MAX_VALUE) {
            return 0.0;
        }
        return (this.maxX - this.minX) * (this.maxY - this.minY);
    }
}

