/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.utils.SignatureUtils;

public class UImageSvg
implements UShape {
    private final String svg;
    private final double scale;
    private static final Pattern BACKGROUND = Pattern.compile("background:([^;]+)");
    private static final Pattern STYLE = Pattern.compile("(?i)\\<svg[^>]+style=\"([^\">]+)\"");
    private static final Pattern VIEWBOX = Pattern.compile("viewBox[= \"']+([0-9.]+)[\\s,]+([0-9.]+)[\\s,]+([0-9.]+)[\\s,]+([0-9.]+)");

    public UImageSvg(String svg, double scale) {
        this.svg = Objects.requireNonNull(svg);
        this.scale = scale;
    }

    public String getMD5Hex() {
        return SignatureUtils.getMD5Hex(this.svg);
    }

    public boolean containsXlink() {
        return this.svg.contains("xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
    }

    public String getSvg(boolean raw) {
        String background;
        String style;
        int idx;
        Object result = this.svg;
        if (raw) {
            return result;
        }
        if (((String)result).startsWith("<?xml")) {
            idx = ((String)result).indexOf("<svg");
            result = ((String)result).substring(idx);
        }
        if (((String)result).startsWith("<svg")) {
            idx = ((String)result).indexOf(">");
            result = "<svg>" + ((String)result).substring(idx + 1);
        }
        if ((style = this.extractSvgStyle()) != null && (background = this.extractBackground(style)) != null) {
            int width = this.getData("width");
            int height = this.getData("height");
            result = ((String)result).replaceFirst("<g>", "<g><rect fill=\"" + background + "\" style=\"" + style + "\" width=\"" + width + "\" height=\"" + height + "\"/> ");
        }
        if (!((String)result).startsWith("<svg>")) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private String extractBackground(String style) {
        Matcher m = BACKGROUND.matcher(style);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private String extractSvgStyle() {
        Matcher m = STYLE.matcher(this.svg);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public int getData(String name) {
        Pattern p;
        Matcher m;
        Matcher m2 = VIEWBOX.matcher(this.svg);
        if (m2.find()) {
            if ("width".equals(name)) {
                String s = m2.group(3);
                int width = (int)Double.parseDouble(s);
                return width;
            }
            if ("height".equals(name)) {
                String s = m2.group(4);
                int result = (int)Double.parseDouble(s);
                return result;
            }
        }
        if ((m = (p = Pattern.compile("(?i)<svg[^>]+" + name + "\\W+(\\d+)")).matcher(this.svg)).find()) {
            String s = m.group(1);
            return Integer.parseInt(s);
        }
        throw new IllegalStateException("Cannot find " + name);
    }

    public double getHeight() {
        return (double)this.getData("height") * this.scale;
    }

    public double getWidth() {
        return (double)this.getData("width") * this.scale;
    }

    public double getScale() {
        return this.scale;
    }
}

