/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.math;

import java.awt.Graphics2D;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import net.sourceforge.plantuml.klimt.MutableImage;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.awt.PortableImageFactory;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UImageSvg;
import net.sourceforge.plantuml.math.ConverterSvg;
import net.sourceforge.plantuml.math.ScientificEquation;
import net.sourceforge.plantuml.math.TeXIconBuilder;

public class LatexBuilder
implements ScientificEquation {
    private final String tex;
    private XDimension2D dimension;

    public LatexBuilder(String tex) {
        this.tex = tex;
    }

    @Override
    public XDimension2D getDimension() {
        return this.dimension;
    }

    private Icon buildIcon(XColor foregroundColor) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return new TeXIconBuilder(this.tex, foregroundColor).getIcon();
    }

    @Override
    public UImageSvg getSvg(double scale, XColor foregroundColor, XColor backgroundColor) throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InstantiationException, IOException {
        Icon icon = this.buildIcon(foregroundColor);
        ConverterSvg converterSvg = new ConverterSvg(icon);
        String svg = converterSvg.getSvg(scale, true, backgroundColor);
        this.dimension = converterSvg.getDimension();
        return new UImageSvg(svg, scale);
    }

    @Override
    public MutableImage getImage(XColor foregroundColor, XColor backgroundColor) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Icon icon = this.buildIcon(foregroundColor);
        return new LatexImage(icon, 1.0, foregroundColor, backgroundColor);
    }

    @Override
    public String getSource() {
        return this.tex;
    }

    class LatexImage
    implements MutableImage {
        private final double scale;
        private final Icon icon;
        private final XColor foregroundColor;
        private final XColor backgroundColor;
        private PortableImage cache = null;

        public LatexImage(Icon icon, double scale, XColor foregroundColor, XColor backgroundColor) {
            this.scale = scale;
            this.foregroundColor = foregroundColor;
            this.backgroundColor = backgroundColor;
            this.icon = icon;
        }

        @Override
        public PortableImage getImage() {
            if (this.cache == null) {
                this.cache = PortableImageFactory.build((int)((double)this.icon.getIconWidth() * this.scale), (int)((double)this.icon.getIconHeight() * this.scale), 2);
                Graphics2D g2 = this.cache.createGraphics();
                g2.scale(this.scale, this.scale);
                if (this.backgroundColor != null) {
                    g2.setColor(this.backgroundColor.toAwtColor());
                    g2.fillRect(0, 0, this.icon.getIconWidth(), this.icon.getIconHeight());
                }
                this.icon.paintIcon(null, g2, 0, 0);
            }
            return this.cache;
        }

        @Override
        public MutableImage withScale(double scale) {
            return new LatexImage(this.icon, this.scale * scale, this.foregroundColor, this.backgroundColor);
        }

        @Override
        public MutableImage muteColor(XColor newColor) {
            return this;
        }

        @Override
        public MutableImage muteTransparentColor(XColor newColor) {
            return this;
        }

        @Override
        public MutableImage monochrome() {
            return this;
        }

        @Override
        public double getScale() {
            return this.scale;
        }
    }
}

