/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.packetdiag;

import java.util.Collections;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.nwdiag.VerticalLine;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.Style;

public class PacketIndicator
extends AbstractTextBlock {
    public static final double V_LINE_FULL = 32.0;
    public static final double V_LINE_SHORT = 16.0;
    private final boolean full;
    private final boolean numbered;
    private final String bitNumber;
    private final Style style;
    private final ISkinParam skinParam;

    public PacketIndicator(boolean full, boolean numbered, int bitNumber, Style style, ISkinParam skinParam) {
        this.full = full;
        this.numbered = numbered;
        this.style = style;
        this.bitNumber = "" + bitNumber;
        this.skinParam = skinParam;
    }

    @Override
    public void drawU(UGraphic ug) {
        double lineLength;
        TextBlock numberTb = this.numberTb();
        XDimension2D numberDim = numberTb.calculateDimension(ug.getStringBounder());
        double lineOffsetY = this.full ? 0.0 : 16.0;
        double d = lineLength = this.full ? 32.0 : 16.0;
        if (this.numbered) {
            double numberYOffset = this.full ? 0.0 : 16.0;
            numberTb.drawU(ug.apply(new UTranslate(-numberDim.getWidth() / 2.0, numberYOffset)));
        }
        TextBlock vLineTb = this.vLineTb(lineOffsetY, lineLength);
        vLineTb.drawU(ug.apply(UTranslate.dy(numberDim.getHeight())));
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D numberDim = this.numberTb().calculateDimension(stringBounder);
        double vLineHeight = this.full ? 32.0 : 16.0;
        return numberDim.mergeTB(new XDimension2D(0.0, vLineHeight));
    }

    TextBlock numberTb() {
        FontConfiguration fg = this.style.getFontConfiguration(this.skinParam.getIHtmlColorSet());
        return PacketIndicator.createNumberTextBlock(fg, this.skinParam, this.bitNumber);
    }

    TextBlock vLineTb(double y, double height) {
        return PacketIndicator.createVLineTextBlock(this.style, this.skinParam, y, height);
    }

    public static TextBlock createNumberTextBlock(FontConfiguration fg, ISkinParam skinParam, CharSequence ... s) {
        return Display.create(s).create8(fg, HorizontalAlignment.LEFT, skinParam, CreoleMode.NO_CREOLE, LineBreakStrategy.NONE);
    }

    public static TextBlock createVLineTextBlock(Style style, ISkinParam skinParam, final double y, final double height) {
        final HColor lineColor = style.getSymbolContext(skinParam.getIHtmlColorSet()).getForeColor();
        final UStroke stroke = style.getStroke();
        return new AbstractTextBlock(){

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(stroke.getThickness(), height);
            }

            @Override
            public void drawU(UGraphic ug) {
                ug = ug.apply(lineColor).apply(stroke);
                VerticalLine vLine = new VerticalLine(y, y + height, Collections.emptySet());
                vLine.drawU(ug);
            }
        };
    }
}

