/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.project.GArrows;
import net.sourceforge.plantuml.project.core.GArrowType;
import net.sourceforge.plantuml.project.core.GSide;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskInstant;
import net.sourceforge.plantuml.project.data.TaskDrawRegistryData;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class GanttArrow
implements UDrawable {
    private final TimeScale timeScale;
    private final GSide atStart;
    private final TaskInstant source;
    private final GSide atEnd;
    private final TaskInstant dest;
    private final HColorSet colorSet;
    private final Style style;
    private final TaskDrawRegistryData toTaskDraw;
    private final StyleBuilder styleBuilder;

    public GanttArrow(HColorSet colorSet, Style style, TimeScale timeScale, TaskInstant source, TaskInstant dest, TaskDrawRegistryData toTaskDraw, StyleBuilder styleBuilder) {
        this.styleBuilder = styleBuilder;
        this.toTaskDraw = toTaskDraw;
        this.style = style;
        this.colorSet = colorSet;
        this.timeScale = timeScale;
        this.source = source;
        this.dest = dest;
        if (source.getAttribute() == TaskAttribute.END && dest.getAttribute() == TaskAttribute.START) {
            this.atStart = source.sameRowAs(dest) ? GSide.RIGHT : GSide.BOTTOM_RIGHT;
            this.atEnd = GSide.LEFT;
        } else if (source.getAttribute() == TaskAttribute.END && dest.getAttribute() == TaskAttribute.END) {
            this.atStart = GSide.RIGHT;
            this.atEnd = GSide.RIGHT;
        } else if (source.getAttribute() == TaskAttribute.START && dest.getAttribute() == TaskAttribute.START) {
            this.atStart = GSide.LEFT;
            this.atEnd = GSide.LEFT;
        } else if (source.getAttribute() == TaskAttribute.START && dest.getAttribute() == TaskAttribute.END) {
            this.atStart = source.sameRowAs(dest) ? GSide.LEFT : GSide.BOTTOM_LEFT;
            this.atEnd = GSide.RIGHT;
        } else {
            throw new IllegalArgumentException();
        }
    }

    private TaskDraw getSource() {
        if (this.source.getMoment() instanceof Task) {
            return this.toTaskDraw.getTaskDraw((Task)this.source.getMoment());
        }
        return null;
    }

    private TaskDraw getDestination() {
        if (this.dest.getMoment() instanceof Task) {
            return this.toTaskDraw.getTaskDraw((Task)this.dest.getMoment());
        }
        return null;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = this.style.applyStrokeAndLineColor(ug, this.colorSet);
        TaskDraw start = this.getSource();
        TaskDraw end = this.getDestination();
        if (start == null || end == null) {
            return;
        }
        StringBounder stringBounder = ug.getStringBounder();
        double x1 = start.getX(stringBounder, this.atStart, GArrowType.OUTGOING);
        double y1 = start.getY(stringBounder, this.atStart);
        double x2 = end.getX(stringBounder, this.atEnd, GArrowType.INCOMING);
        double y2 = end.getY(stringBounder, this.atEnd);
        if (this.atStart.isBottom() && y2 < y1) {
            y1 = start.getY(stringBounder, this.atStart.reverseBottomTop());
        }
        double minimalWidth = 6.0;
        GArrows arrows = new GArrows(this.atEnd, this.style.value(PName.LineColor).asColor(this.colorSet));
        if (this.atStart.isBottom() && this.atEnd == GSide.LEFT) {
            if (x2 > x1 + 6.0) {
                arrows.addPoint(x1, y1);
                arrows.addPoint(x1, y2);
                arrows.addPoint(x2, y2);
            } else {
                x1 = start.getX(stringBounder, GSide.RIGHT, GArrowType.OUTGOING);
                y1 = start.getY(stringBounder, GSide.RIGHT);
                double y1b = end.getY(stringBounder).getCurrentValue();
                arrows.addPoint(x1, y1);
                arrows.addPoint(x1 + 6.0, y1);
                arrows.addPoint(x1 + 6.0, y1b);
                arrows.addPoint(x2 - 8.0, y1b);
                arrows.addPoint(x2 - 8.0, y2);
                arrows.addPoint(x2, y2);
            }
        } else if (this.atStart == GSide.RIGHT && this.atEnd == GSide.RIGHT) {
            double xmax = Math.max(x1, x2) + 8.0;
            arrows.addPoint(x1, y1);
            arrows.addPoint(xmax, y1);
            arrows.addPoint(xmax, y2);
            arrows.addPoint(x2, y2);
        } else if (this.atStart == GSide.LEFT && this.atEnd == GSide.LEFT) {
            double xmin = Math.min(x1, x2) - 8.0;
            arrows.addPoint(x1, y1);
            arrows.addPoint(xmin, y1);
            arrows.addPoint(xmin, y2);
            arrows.addPoint(x2, y2);
        } else {
            arrows.addPoint(x1, y1);
            arrows.addPoint(x1, y2);
            arrows.addPoint(x2, y2);
        }
        arrows.drawU(ug);
    }

    private StyleSignatureBasic getStyleSignatureTask() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.task);
    }
}

