/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskGroup;
import net.sourceforge.plantuml.project.core.TaskImpl;
import net.sourceforge.plantuml.project.core.TaskSeparator;
import net.sourceforge.plantuml.project.data.DisplayConfigData;
import net.sourceforge.plantuml.project.data.GanttModelData;
import net.sourceforge.plantuml.project.data.TimeBoundsData;
import net.sourceforge.plantuml.project.data.TimelineStyleData;
import net.sourceforge.plantuml.project.draw.FingerPrint;
import net.sourceforge.plantuml.project.draw.ResourceDrawNumbers;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.draw.TaskDrawDiamond;
import net.sourceforge.plantuml.project.draw.TaskDrawGroup;
import net.sourceforge.plantuml.project.draw.TaskDrawRegular;
import net.sourceforge.plantuml.project.draw.TaskDrawSeparator;
import net.sourceforge.plantuml.project.draw.header.TimeHeader;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealOrigin;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.style.ISkinParam;

public class TaskDrawRegistryData {
    private final RealOrigin origin = RealUtils.createOrigin();
    private final Map<Task, TaskDraw> draws = new LinkedHashMap<Task, TaskDraw>();
    private double totalHeightWithoutFooter;

    public double getTotalHeightWithoutFooter() {
        return this.totalHeightWithoutFooter;
    }

    public RealOrigin getOrigin() {
        return this.origin;
    }

    public TaskDraw getTaskDraw(Task task) {
        return this.draws.get(task);
    }

    public void putTaskDraw(Task task, TaskDraw draw) {
        this.draws.put(task, draw);
    }

    private double computeBottomY(StringBounder stringBounder) {
        double result = 0.0;
        for (TaskDraw td : this.draws.values()) {
            result = Math.max(result, td.getY(stringBounder).getCurrentValue() + td.getHeightMax(stringBounder));
        }
        return result;
    }

    private void resolveNoteOverlaps(StringBounder stringBounder) {
        ArrayList<TaskDraw> notes = new ArrayList<TaskDraw>();
        for (TaskDraw td : this.draws.values()) {
            FingerPrint taskPrint = td.getFingerPrint(stringBounder);
            FingerPrint fingerPrintNote = td.getFingerPrintNote(stringBounder);
            if (td.getTrueRow() == null) {
                for (TaskDraw note : notes) {
                    FingerPrint otherNote = note.getFingerPrintNote(stringBounder);
                    double deltaY = otherNote.overlap(taskPrint);
                    if (!(deltaY > 0.0)) continue;
                    Real bottom = note.getY(stringBounder).addAtLeast(note.getHeightMax(stringBounder));
                    td.getY(stringBounder).ensureBiggerThan(bottom);
                    this.getOrigin().compileNow();
                }
            }
            if (fingerPrintNote == null) continue;
            notes.add(td);
        }
    }

    private TaskDraw createRegularTaskDraw(GanttModelData modelData, TimeBoundsData timeBounds, TimelineStyleData timelineStyle, TimeScale timeScale, Real y, Task task, String display) {
        boolean oddEnd;
        boolean oddStart;
        TimePoint startForDrawing = timeBounds.getStartForDrawing(task);
        TimePoint endForDrawing = timeBounds.getEndForDrawing(task);
        if (timeBounds.getPrintStart() != null) {
            oddStart = TimePoint.ofStartOfDay(timeBounds.getMinDay()).compareTo(startForDrawing) == 0;
            oddEnd = TimePoint.ofStartOfDay(timeBounds.getMaxDay().plusDays(1L)).compareTo(endForDrawing) == 0;
        } else {
            oddStart = false;
            oddEnd = false;
        }
        return new TaskDrawRegular(timelineStyle.getColorSet(), timeScale, y, display, startForDrawing, endForDrawing, oddStart, oddEnd, timelineStyle.getSkinParam(), task, this, modelData.getConstraintsForTask(task), task.getStyleBuilder());
    }

    public void buildTaskAndResourceDraws(StringBounder stringBounder, TimeHeader timeHeader, GanttModelData modelData, DisplayConfigData displayConfig, TimeBoundsData timeBounds, TimelineStyleData timelineStyle) {
        TimeScale timeScale = timeHeader.getTimeScale();
        double headerTotalHeight = timeHeader.getFullHeaderHeight(stringBounder);
        ISkinParam skinParam = timelineStyle.getSkinParam();
        Real y = this.getOrigin().addFixed(headerTotalHeight);
        for (Task task : modelData.getTasks()) {
            TaskDraw draw;
            if (task instanceof TaskSeparator) {
                TaskSeparator taskSeparator = (TaskSeparator)task;
                draw = new TaskDrawSeparator(taskSeparator.getName(), timeScale, y, timeBounds.getMinDay(), timeBounds.getMaxDay(), task.getStyleBuilder(), skinParam);
            } else if (task instanceof TaskGroup) {
                TaskGroup taskGroup = (TaskGroup)task;
                draw = new TaskDrawGroup(timelineStyle.getColorSet(), timeScale, y, taskGroup.getCode().getDisplay(), timeBounds.getStartForDrawing(taskGroup), timeBounds.getEndForDrawing(taskGroup), task, this, task.getStyleBuilder(), skinParam);
            } else {
                TaskImpl taskImpl = (TaskImpl)task;
                String taskLabel = displayConfig.isHideResourceName() ? taskImpl.getCode().getDisplay() : taskImpl.getPrettyDisplay();
                draw = taskImpl.isDiamond() ? new TaskDrawDiamond(timelineStyle.getColorSet(), timeScale, y, taskLabel, timeBounds.getStartForDrawing(taskImpl), taskImpl, this, task.getStyleBuilder(), skinParam) : this.createRegularTaskDraw(modelData, timeBounds, timelineStyle, timeScale, y, taskImpl, taskLabel);
                draw.setColorsAndCompletion(taskImpl.getColors(), taskImpl.getCompletion(), taskImpl.getUrl(), taskImpl.getNote(), taskImpl.getNoteStereotype());
            }
            if (task.getRow() == null) {
                y = y.addAtLeast(draw.getFullHeightTask(stringBounder));
            }
            this.putTaskDraw(task, draw);
        }
        this.getOrigin().compileNow();
        this.resolveNoteOverlaps(stringBounder);
        this.buildResourceDraws(stringBounder, timeScale, modelData, displayConfig, timeBounds, timelineStyle, headerTotalHeight);
    }

    private void buildResourceDraws(StringBounder stringBounder, TimeScale timeScale, GanttModelData modelData, DisplayConfigData displayConfig, TimeBoundsData timeBounds, TimelineStyleData timelineStyle, double fullHeaderHeight) {
        double yy = this.computeBottomY(stringBounder);
        if (yy == 0.0) {
            yy = fullHeaderHeight;
        } else if (!displayConfig.isHideResourceFootbox()) {
            for (Resource res : modelData.getResources()) {
                ResourceDrawNumbers draw = new ResourceDrawNumbers(modelData, timelineStyle, res, timeScale, yy, TimePoint.ofStartOfDay(timeBounds.getMinDay()), TimePoint.ofEndOfDayMinusOneSecond(timeBounds.getMaxDay()));
                res.setTaskDraw(draw);
                yy += draw.getHeight(stringBounder);
            }
        }
        this.totalHeightWithoutFooter = yy;
    }
}

