/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.data;

import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.project.GanttStyle;
import net.sourceforge.plantuml.skin.Pragma;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;

public class TimelineStyleData {
    private final GanttStyle ganttStyle;
    private final HColorSet colorSet;
    private final ISkinParam skinParam;

    public TimelineStyleData(ISkinParam skinParam, GanttStyle ganttStyle, HColorSet colorSet) {
        this.skinParam = skinParam;
        this.ganttStyle = ganttStyle;
        this.colorSet = colorSet;
    }

    public ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public Pragma getPragma() {
        return this.skinParam.getPragma();
    }

    public double getFontSizeDay() {
        return this.getStyleDay().value(PName.FontSize).asDouble();
    }

    public double getFontSizeMonth() {
        return this.ganttStyle.getStyle(SName.timeline, SName.month).value(PName.FontSize).asDouble();
    }

    public double getFontSizeYear() {
        return this.ganttStyle.getStyle(SName.timeline, SName.year).value(PName.FontSize).asDouble();
    }

    public UFont getFont(SName param) {
        return this.ganttStyle.getStyle(SName.timeline, param).getUFont();
    }

    public HColor getClosedBackgroundColor() {
        return this.ganttStyle.getStyle(SName.closed).value(PName.BackGroundColor).asColor(this.colorSet);
    }

    public HColor getClosedFontColor() {
        return this.ganttStyle.getStyle(SName.closed).value(PName.FontColor).asColor(this.colorSet);
    }

    public HColor getOpenFontColor() {
        return this.ganttStyle.getStyle(SName.timeline).value(PName.FontColor).asColor(this.colorSet);
    }

    public HColor getLineColor() {
        return this.ganttStyle.getStyle(SName.timeline).value(PName.LineColor).asColor(this.colorSet);
    }

    public HColorSet getColorSet() {
        return this.colorSet;
    }

    public UGraphic applyVerticalSeparatorStyle(UGraphic ug) {
        Style style = this.ganttStyle.getStyle(SName.verticalSeparator);
        HColor color = style.value(PName.LineColor).asColor(this.colorSet);
        UStroke stroke = style.getStroke();
        return ug.apply(color).apply(stroke);
    }

    public double getCellWidth() {
        double w = this.getStyleDay().value(PName.FontSize).asDouble();
        return w * 1.6;
    }

    private Style getStyleDay() {
        return this.ganttStyle.getStyle(SName.timeline, SName.day);
    }
}

