/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw.header;

import java.time.LocalDate;
import java.util.Locale;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.data.DayCalendarData;
import net.sourceforge.plantuml.project.data.TimeBoundsData;
import net.sourceforge.plantuml.project.data.TimeScaleConfigData;
import net.sourceforge.plantuml.project.data.TimelineStyleData;
import net.sourceforge.plantuml.project.data.WeekConfigData;
import net.sourceforge.plantuml.project.draw.header.TimeHeader;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstantUtils;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.SName;

abstract class TimeHeaderCalendar
extends TimeHeader {
    public TimeHeaderCalendar(WeekConfigData weekConfigData, DayCalendarData dayCalendar, TimeBoundsData timeBounds, TimeScaleConfigData scaleConfig, TimelineStyleData timelineStyle, TimeScale timeScale) {
        super(timeScale, weekConfigData, dayCalendar, timeBounds, scaleConfig, timelineStyle);
    }

    protected final Locale locale() {
        return this.weekConfigData.getLocale();
    }

    protected final int getLoadAt(TimePoint instant) {
        if (PiecewiseConstantUtils.isZeroOnDay(this.dayCalendar.getOpenClose().asPiecewiseConstant(), instant.toDay())) {
            return 0;
        }
        return 100;
    }

    @Override
    public final void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawColorsBackground(ug, totalHeightWithoutFooter);
        this.drawTimeHeaderInternal(ug, totalHeightWithoutFooter);
    }

    public abstract void drawTimeHeaderInternal(UGraphic var1, double var2);

    private final void drawColorsBackground(UGraphic ug, double totalHeightWithoutFooter) {
        double height = totalHeightWithoutFooter - this.getFullHeaderHeight(ug.getStringBounder());
        TimeHeader.Pending pending = null;
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) <= 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            double x1 = this.getTimeScale().getPosition(wink);
            double x2 = this.getTimeScale().getPosition(wink) + this.getTimeScale().getWidth(wink);
            HColor back = this.getColor(wink);
            HColor backDoW = this.getColor(wink.toDayOfWeek());
            if (backDoW != null) {
                back = backDoW;
            }
            if (back == null && this.getLoadAt(wink) == 0) {
                back = this.closedBackgroundColor();
            }
            if (back == null) {
                if (pending != null) {
                    pending.draw(ug, height);
                }
                pending = null;
            } else {
                if (pending != null && !pending.color.equals(back)) {
                    pending.draw(ug, height);
                    pending = null;
                }
                if (pending == null) {
                    pending = new TimeHeader.Pending(back, x1, x2);
                } else {
                    pending.x2 = x2;
                }
            }
            day = day.plusDays(1L);
        }
        if (pending != null) {
            pending.draw(ug, height);
        }
    }

    protected final void printNamedDays(UGraphic ug) {
        if (this.dayCalendar.getNameDays().size() > 0) {
            String last = null;
            LocalDate day = this.getMinDay();
            while (day.compareTo(this.getMaxDay()) <= 0) {
                TimePoint wink = TimePoint.ofStartOfDay(day);
                String name = this.dayCalendar.getDayName(wink);
                if (name != null && !name.equals(last)) {
                    double x1 = this.getTimeScale().getPosition(wink);
                    TextBlock label = this.getTextBlock(SName.month, name, false, this.openFontColor());
                    double position = this.getTimeHeaderHeight(ug.getStringBounder());
                    label.drawU(ug.apply(new UTranslate(x1, position)));
                }
                last = name;
                day = day.plusDays(1L);
            }
        }
    }
}

