/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw.header;

import java.time.LocalDate;
import java.time.YearMonth;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.data.DayCalendarData;
import net.sourceforge.plantuml.project.data.TimeBoundsData;
import net.sourceforge.plantuml.project.data.TimeScaleConfigData;
import net.sourceforge.plantuml.project.data.TimelineStyleData;
import net.sourceforge.plantuml.project.data.WeekConfigData;
import net.sourceforge.plantuml.project.draw.header.TimeHeaderCalendar;
import net.sourceforge.plantuml.project.time.DayOfWeekUtils;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.time.YearMonthUtils;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.SName;

class TimeHeaderDaily
extends TimeHeaderCalendar {
    public TimeHeaderDaily(TimeScale timeScale, WeekConfigData weekConfigData, DayCalendarData dayCalendar, TimeBoundsData timeBounds, TimeScaleConfigData scaleConfig, TimelineStyleData timelineStyle) {
        super(weekConfigData, dayCalendar, timeBounds, scaleConfig, timelineStyle, timeScale);
    }

    private double getH1(StringBounder stringBounder) {
        double h = this.timelineStyle.getFontSizeMonth() + 2.0;
        return h;
    }

    private double getH2(StringBounder stringBounder) {
        double h = this.timelineStyle.getFontSizeDay() + 2.0;
        return this.getH1(stringBounder) + h;
    }

    private double getH3(StringBounder stringBounder) {
        double h = this.timelineStyle.getFontSizeDay() + 3.0;
        return this.getH2(stringBounder) + h;
    }

    @Override
    public double getTimeHeaderHeight(StringBounder stringBounder) {
        return this.getH3(stringBounder);
    }

    @Override
    public double getTimeFooterHeight(StringBounder stringBounder) {
        double h1 = this.timelineStyle.getFontSizeDay();
        double h2 = this.timelineStyle.getFontSizeDay();
        double h3 = this.timelineStyle.getFontSizeMonth();
        return h1 + h2 + h3 + 8.0;
    }

    private double getHeaderNameDayHeight() {
        if (this.dayCalendar.getNameDays().size() > 0) {
            double h = this.timelineStyle.getFontSizeDay() + 6.0;
            return h;
        }
        return 0.0;
    }

    @Override
    public double getFullHeaderHeight(StringBounder stringBounder) {
        return this.getTimeHeaderHeight(stringBounder) + this.getHeaderNameDayHeight();
    }

    @Override
    public void drawTimeHeaderInternal(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsDayOfWeek(ug.apply(UTranslate.dy(this.getH1(ug.getStringBounder()))));
        this.drawTextDayOfMonth(ug.apply(UTranslate.dy(this.getH2(ug.getStringBounder()))));
        this.drawMonths(ug);
        this.printVerticalSeparators(ug, totalHeightWithoutFooter);
        this.printNamedDays(ug);
        this.drawHline(ug, this.getFullHeaderHeight(ug.getStringBounder()));
        this.drawHline(ug, totalHeightWithoutFooter);
    }

    @Override
    protected void printVerticalSeparators(UGraphic ug, double totalHeightWithoutFooter) {
        UGraphic ugVerticalSeparator = this.timelineStyle.applyVerticalSeparatorStyle(ug);
        UGraphic ugLineColor = ug.apply(this.getLineColor());
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) <= 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            if (this.isBold(day) || this.getTimeScale().getWidth(wink.decrement()) == 0.0) {
                this.drawVline(ugVerticalSeparator, this.getTimeScale().getPosition(wink), this.getFullHeaderHeight(ug.getStringBounder()), totalHeightWithoutFooter);
            } else {
                this.drawVline(ugLineColor, this.getTimeScale().getPosition(wink), this.getFullHeaderHeight(ug.getStringBounder()), totalHeightWithoutFooter);
            }
            day = day.plusDays(1L);
        }
        double end = this.getTimeScale().getPosition(TimePoint.ofStartOfDay(this.getMaxDay().plusDays(1L)));
        this.drawVline(ugLineColor, end, this.getFullHeaderHeight(ug.getStringBounder()), totalHeightWithoutFooter);
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        double h = this.timelineStyle.getFontSizeDay() + 2.0;
        this.drawTextsDayOfWeek(ug);
        this.drawTextDayOfMonth(ug.apply(UTranslate.dy(h + 2.0)));
        this.drawMonths(ug.apply(UTranslate.dy(2.0 * h + 3.0)));
    }

    private void drawTextsDayOfWeek(UGraphic ug) {
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) <= 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            if (!this.isHidden(wink)) {
                double x1 = this.getTimeScale().getPosition(wink);
                double x2 = this.getTimeScale().getPosition(wink.increment());
                HColor textColor = this.getTextBackColor(wink);
                this.printCentered(ug, this.getTextBlock(SName.day, DayOfWeekUtils.shortName(wink.toDayOfWeek(), this.locale()), false, textColor), x1, x2);
            }
            day = day.plusDays(1L);
        }
    }

    private void drawTextDayOfMonth(UGraphic ug) {
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) <= 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            if (!this.isHidden(wink)) {
                double x1 = this.getTimeScale().getPosition(wink);
                double x2 = this.getTimeScale().getPosition(wink.increment());
                HColor textColor = this.getTextBackColor(wink);
                this.printCentered(ug, this.getTextBlock(SName.day, "" + wink.getDayOfMonth(), false, textColor), x1, x2);
            }
            day = day.plusDays(1L);
        }
    }

    private boolean isHidden(TimePoint wink) {
        return this.scaleConfig.isHideClosed() && this.dayCalendar.getOpenClose().isClosed(wink.toDay());
    }

    private HColor getTextBackColor(TimePoint wink) {
        if (this.getLoadAt(wink) <= 0) {
            return this.closedFontColor();
        }
        return this.openFontColor();
    }

    private void drawMonths(UGraphic ug) {
        YearMonth last = null;
        double lastChangeMonth = -1.0;
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) <= 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            if (!this.isHidden(wink)) {
                double x1 = this.getTimeScale().getPosition(wink);
                if (!wink.monthYear().equals(last)) {
                    if (last != null) {
                        this.printMonth(ug, last, lastChangeMonth, x1);
                    }
                    lastChangeMonth = x1;
                    last = wink.monthYear();
                }
            }
            day = day.plusDays(1L);
        }
        double x1 = this.getTimeScale().getPosition(TimePoint.ofStartOfDay(this.getMaxDay().plusDays(1L)));
        if (x1 > lastChangeMonth) {
            this.printMonth(ug, last, lastChangeMonth, x1);
        }
    }

    private void printMonth(UGraphic ug, YearMonth monthYear, double start, double end) {
        TextBlock tiny = this.getTextBlock(SName.month, YearMonthUtils.shortName(monthYear, this.locale()), true, this.openFontColor());
        TextBlock small = this.getTextBlock(SName.month, YearMonthUtils.longName(monthYear, this.locale()), true, this.openFontColor());
        TextBlock big = this.getTextBlock(SName.month, YearMonthUtils.longNameYYYY(monthYear, this.locale()), true, this.openFontColor());
        this.printCentered(ug, false, start, end, tiny, small, big);
    }
}

