/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw.header;

import java.time.LocalDate;
import java.time.YearMonth;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.data.DayCalendarData;
import net.sourceforge.plantuml.project.data.TimeBoundsData;
import net.sourceforge.plantuml.project.data.TimeScaleConfigData;
import net.sourceforge.plantuml.project.data.TimelineStyleData;
import net.sourceforge.plantuml.project.data.WeekConfigData;
import net.sourceforge.plantuml.project.draw.header.TimeHeaderCalendar;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.time.YearMonthUtils;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.SName;

class TimeHeaderMonthly
extends TimeHeaderCalendar {
    public TimeHeaderMonthly(TimeScale timeScale, WeekConfigData weekConfigData, DayCalendarData dayCalendar, TimeBoundsData timeBounds, TimeScaleConfigData scaleConfig, TimelineStyleData timelineStyle) {
        super(weekConfigData, dayCalendar, timeBounds, scaleConfig, timelineStyle, timeScale);
    }

    private double getH1(StringBounder stringBounder) {
        double h = this.timelineStyle.getFontSizeYear() + 2.0;
        return h;
    }

    private double getH2(StringBounder stringBounder) {
        double h = this.timelineStyle.getFontSizeMonth() + 2.0;
        return this.getH1(stringBounder) + h;
    }

    @Override
    public double getTimeHeaderHeight(StringBounder stringBounder) {
        return this.getH2(stringBounder);
    }

    @Override
    public double getTimeFooterHeight(StringBounder stringBounder) {
        double h1 = this.timelineStyle.getFontSizeYear();
        double h2 = this.timelineStyle.getFontSizeMonth();
        return h1 + h2 + 5.0;
    }

    @Override
    public double getFullHeaderHeight(StringBounder stringBounder) {
        return this.getTimeHeaderHeight(stringBounder) + this.getHeaderNameDayHeight();
    }

    @Override
    public void drawTimeHeaderInternal(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawYears(ug);
        double h1 = this.getH1(ug.getStringBounder());
        double h2 = this.getH2(ug.getStringBounder());
        this.drawMonths(ug.apply(UTranslate.dy(h1)));
        this.printVerticalSeparators(ug, totalHeightWithoutFooter);
        this.printNamedDays(ug);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, h1);
        this.drawHline(ug, h2);
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        double h1 = this.timelineStyle.getFontSizeYear();
        double h2 = this.timelineStyle.getFontSizeMonth();
        this.drawMonths(ug);
        this.drawYears(ug.apply(UTranslate.dy(h2 + 2.0)));
        this.drawHline(ug, 0.0);
        this.drawHline(ug, h2 + 2.0);
        this.drawHline(ug, h1 + 2.0 + h2 + 2.0);
    }

    private void drawYears(UGraphic ug) {
        double h1 = this.timelineStyle.getFontSizeYear();
        YearMonth last = null;
        double lastChange = -1.0;
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) < 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            double x1 = this.getTimeScale().getPosition(wink);
            if (last == null || wink.monthYear().getYear() != last.getYear()) {
                this.drawVline(ug.apply(this.getLineColor()), x1, 0.0, h1 + 2.0);
                if (last != null) {
                    this.printYear(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = wink.monthYear();
            }
            day = day.plusDays(1L);
        }
        double x1 = this.getTimeScale().getPosition(TimePoint.ofStartOfDay(this.getMaxDay().plusDays(1L)));
        if (x1 > lastChange) {
            this.printYear(ug, last, lastChange, x1);
        }
        double end = x1;
        this.drawVline(ug.apply(this.getLineColor()), end, 0.0, h1 + 2.0);
    }

    private void drawMonths(UGraphic ug) {
        double h2 = this.timelineStyle.getFontSizeMonth();
        YearMonth last = null;
        double lastChange = -1.0;
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) < 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            double x1 = this.getTimeScale().getPosition(wink);
            if (!wink.monthYear().equals(last)) {
                this.drawVline(ug.apply(this.getLineColor()), x1, 0.0, h2 + 2.0);
                if (last != null) {
                    this.printMonth(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = wink.monthYear();
            }
            day = day.plusDays(1L);
        }
        double x1 = this.getTimeScale().getPosition(TimePoint.ofStartOfDay(this.getMaxDay().plusDays(1L)));
        if (x1 > lastChange) {
            this.printMonth(ug, last, lastChange, x1);
        }
        double end = x1;
        this.drawVline(ug.apply(this.getLineColor()), end, 0.0, h2 + 2.0);
    }

    private void printYear(UGraphic ug, YearMonth monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(SName.month, "" + monthYear.getYear(), true, this.openFontColor());
        this.printCentered(ug, false, start, end, small);
    }

    private void printMonth(UGraphic ug, YearMonth monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(SName.day, YearMonthUtils.shortName(monthYear, this.locale()), false, this.openFontColor());
        TextBlock big = this.getTextBlock(SName.day, YearMonthUtils.longName(monthYear, this.locale()), false, this.openFontColor());
        this.printCentered(ug, false, start, end, small, big);
    }

    private double getHeaderNameDayHeight() {
        if (this.dayCalendar.getNameDays().size() > 0) {
            double h = this.timelineStyle.getFontSizeDay() + 6.0;
            return h;
        }
        return 0.0;
    }
}

