/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw.header;

import java.time.LocalDate;
import java.time.YearMonth;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.data.DayCalendarData;
import net.sourceforge.plantuml.project.data.TimeBoundsData;
import net.sourceforge.plantuml.project.data.TimeScaleConfigData;
import net.sourceforge.plantuml.project.data.TimelineStyleData;
import net.sourceforge.plantuml.project.data.WeekConfigData;
import net.sourceforge.plantuml.project.draw.header.TimeHeaderCalendar;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.SName;

class TimeHeaderQuarterly
extends TimeHeaderCalendar {
    public TimeHeaderQuarterly(TimeScale timeScale, WeekConfigData weekConfigData, DayCalendarData dayCalendar, TimeBoundsData timeBounds, TimeScaleConfigData scaleConfig, TimelineStyleData timelineStyle) {
        super(weekConfigData, dayCalendar, timeBounds, scaleConfig, timelineStyle, timeScale);
    }

    @Override
    public double getTimeHeaderHeight(StringBounder stringBounder) {
        double h1 = this.timelineStyle.getFontSizeYear();
        double h2 = this.timelineStyle.getFontSizeMonth();
        return h1 + h2 + 5.0;
    }

    @Override
    public double getTimeFooterHeight(StringBounder stringBounder) {
        double h1 = this.timelineStyle.getFontSizeYear();
        double h2 = this.timelineStyle.getFontSizeMonth();
        return h1 + h2 + 5.0;
    }

    @Override
    public double getFullHeaderHeight(StringBounder stringBounder) {
        return this.getTimeHeaderHeight(stringBounder);
    }

    @Override
    public void drawTimeHeaderInternal(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawYears(ug);
        double h1 = this.timelineStyle.getFontSizeYear();
        double h2 = this.timelineStyle.getFontSizeMonth();
        this.drawQuarters(ug.apply(UTranslate.dy(h1 + 2.0)));
        this.printVerticalSeparators(ug, totalHeightWithoutFooter);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, h1 + 2.0);
        this.drawHline(ug, h1 + 2.0 + h2 + 2.0);
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        double h1 = this.timelineStyle.getFontSizeYear();
        double h2 = this.timelineStyle.getFontSizeMonth();
        this.drawQuarters(ug);
        this.drawYears(ug.apply(UTranslate.dy(h2 + 2.0)));
        this.drawHline(ug, 0.0);
        this.drawHline(ug, h2 + 2.0);
        this.drawHline(ug, h1 + 2.0 + h2 + 2.0);
    }

    private void drawYears(UGraphic ug) {
        double h1 = this.timelineStyle.getFontSizeYear();
        YearMonth last = null;
        double lastChange = -1.0;
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) < 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            double x1 = this.getTimeScale().getPosition(wink);
            if (last == null || wink.monthYear().getYear() != last.getYear()) {
                this.drawVline(ug.apply(this.getLineColor()), x1, 0.0, h1 + 2.0);
                if (last != null) {
                    this.printYear(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = wink.monthYear();
            }
            day = day.plusDays(1L);
        }
        double x1 = this.getTimeScale().getPosition(TimePoint.ofStartOfDay(this.getMaxDay().plusDays(1L)));
        if (x1 > lastChange) {
            this.printYear(ug, last, lastChange, x1);
        }
        double end = x1;
        this.drawVline(ug.apply(this.getLineColor()), end, 0.0, h1 + 2.0);
    }

    private void drawQuarters(UGraphic ug) {
        double h2 = this.timelineStyle.getFontSizeMonth();
        String last = null;
        double lastChange = -1.0;
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) < 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            double x1 = this.getTimeScale().getPosition(wink);
            if (!this.quarter(wink).equals(last)) {
                this.drawVline(ug.apply(this.getLineColor()), x1, 0.0, h2 + 2.0);
                if (last != null) {
                    this.printQuarter(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = this.quarter(wink);
            }
            day = day.plusDays(1L);
        }
        double x1 = this.getTimeScale().getPosition(TimePoint.ofStartOfDay(this.getMaxDay().plusDays(1L)));
        if (x1 > lastChange) {
            this.printQuarter(ug, last, lastChange, x1);
        }
        double end = x1;
        this.drawVline(ug.apply(this.getLineColor()), end, 0.0, h2 + 2.0);
    }

    private String quarter(TimePoint day) {
        return "Q" + (day.month().ordinal() + 3) / 3;
    }

    private void printYear(UGraphic ug, YearMonth monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(SName.month, "" + monthYear.getYear(), true, this.openFontColor());
        this.printCentered(ug, false, start, end, small);
    }

    private void printQuarter(UGraphic ug, String quarter, double start, double end) {
        TextBlock small = this.getTextBlock(SName.day, quarter, false, this.openFontColor());
        this.printCentered(ug, false, start, end, small);
    }

    private void printLeft(UGraphic ug, TextBlock text, double start) {
        text.drawU(ug.apply(UTranslate.dx(start)));
    }
}

