/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw.header;

import java.time.LocalDate;
import java.time.YearMonth;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.data.DayCalendarData;
import net.sourceforge.plantuml.project.data.TimeBoundsData;
import net.sourceforge.plantuml.project.data.TimeScaleConfigData;
import net.sourceforge.plantuml.project.data.TimelineStyleData;
import net.sourceforge.plantuml.project.data.WeekConfigData;
import net.sourceforge.plantuml.project.draw.WeeklyHeaderStrategy;
import net.sourceforge.plantuml.project.draw.header.TimeHeaderCalendar;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.time.YearMonthUtils;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.SName;

class TimeHeaderWeekly
extends TimeHeaderCalendar {
    public TimeHeaderWeekly(TimeScale timeScale, WeekConfigData weekConfigData, DayCalendarData dayCalendar, TimeBoundsData timeBounds, TimeScaleConfigData scaleConfig, TimelineStyleData timelineStyle) {
        super(weekConfigData, dayCalendar, timeBounds, scaleConfig, timelineStyle, timeScale);
    }

    private double getH1(StringBounder stringBounder) {
        double h = this.timelineStyle.getFontSizeMonth() + 4.0;
        return h;
    }

    private double getH2(StringBounder stringBounder) {
        double h = this.timelineStyle.getFontSizeDay() + 1.0;
        return this.getH1(stringBounder) + h;
    }

    @Override
    public double getTimeHeaderHeight(StringBounder stringBounder) {
        return this.getH2(stringBounder);
    }

    @Override
    public double getTimeFooterHeight(StringBounder stringBounder) {
        double h = this.timelineStyle.getFontSizeMonth() + 4.0;
        return h;
    }

    private double getHeaderNameDayHeight() {
        if (this.dayCalendar.getNameDays().size() > 0) {
            double h = this.timelineStyle.getFontSizeDay() + 6.0;
            return h;
        }
        return 0.0;
    }

    @Override
    public double getFullHeaderHeight(StringBounder stringBounder) {
        return this.getTimeHeaderHeight(stringBounder) + this.getHeaderNameDayHeight();
    }

    @Override
    public void drawTimeHeaderInternal(UGraphic ug, double totalHeightWithoutFooter) {
        this.printDaysOfMonth(ug);
        this.printVerticalSeparators(ug, totalHeightWithoutFooter);
        this.printMonths(ug);
        this.printNamedDays(ug);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.getH1(ug.getStringBounder()));
        this.drawHline(ug, this.getFullHeaderHeight(ug.getStringBounder()));
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        this.drawHline(ug, 0.0);
        this.printMonths(ug);
        this.drawHline(ug, this.getTimeFooterHeight(ug.getStringBounder()));
    }

    private void printMonths(UGraphic ug) {
        double x1;
        YearMonth last = null;
        double lastChangeMonth = -1.0;
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) <= 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            x1 = this.getTimeScale().getPosition(wink);
            if (!wink.monthYear().equals(last)) {
                this.drawVline(ug.apply(this.getLineColor()), x1, 0.0, this.getH1(ug.getStringBounder()));
                if (last != null) {
                    this.printMonth(ug, last, lastChangeMonth, x1);
                }
                lastChangeMonth = x1;
                last = wink.monthYear();
            }
            day = day.plusDays(1L);
        }
        double end = this.getTimeScale().getPosition(TimePoint.ofStartOfDay(this.getMaxDay().plusDays(1L)));
        this.drawVline(ug.apply(this.getLineColor()), end, 0.0, this.getH1(ug.getStringBounder()));
        x1 = end;
        if (last != null && x1 > lastChangeMonth) {
            this.printMonth(ug, last, lastChangeMonth, x1);
        }
    }

    @Override
    protected void printVerticalSeparators(UGraphic ug, double totalHeightWithoutFooter) {
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) <= 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            if (wink.toDayOfWeek() == this.weekConfigData.getWeekNumberStrategy().getFirstDayOfWeek()) {
                this.drawVline(ug.apply(this.getLineColor()), this.getTimeScale().getPosition(wink), this.getH1(ug.getStringBounder()), totalHeightWithoutFooter);
            }
            day = day.plusDays(1L);
        }
        double end = this.getTimeScale().getPosition(TimePoint.ofStartOfDay(this.getMaxDay().plusDays(1L)));
        this.drawVline(ug.apply(this.getLineColor()), end, this.getH1(ug.getStringBounder()), totalHeightWithoutFooter);
        super.printVerticalSeparators(ug, totalHeightWithoutFooter);
    }

    private void printDaysOfMonth(UGraphic ug) {
        int counter = this.weekConfigData.getWeekStartingNumber();
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay().plusDays(-1L)) < 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            if (wink.toDayOfWeek() == this.weekConfigData.getWeekNumberStrategy().getFirstDayOfWeek()) {
                String num = this.weekConfigData.getWeeklyHeaderStrategy() == WeeklyHeaderStrategy.FROM_N ? "" + counter++ : (this.weekConfigData.getWeeklyHeaderStrategy() == WeeklyHeaderStrategy.DAY_OF_MONTH ? "" + wink.getDayOfMonth() : "" + wink.getWeekOfYear(this.weekConfigData.getWeekNumberStrategy()));
                TextBlock textBlock = this.getTextBlock(SName.day, num, false, this.openFontColor());
                this.printLeft(ug.apply(UTranslate.dy(this.getH1(ug.getStringBounder()))), textBlock, this.getTimeScale().getPosition(wink) + 5.0);
            }
            day = day.plusDays(1L);
        }
    }

    private void printMonth(UGraphic ug, YearMonth monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(SName.month, YearMonthUtils.shortName(monthYear, this.locale()), true, this.openFontColor());
        TextBlock big = this.getTextBlock(SName.month, YearMonthUtils.shortNameYYYY(monthYear, this.locale()), true, this.openFontColor());
        this.printCentered(ug, false, start, end, small, big);
    }

    private void printLeft(UGraphic ug, TextBlock text, double start) {
        text.drawU(ug.apply(UTranslate.dx(start)));
    }
}

