/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw.header;

import java.time.LocalDate;
import java.time.YearMonth;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.data.DayCalendarData;
import net.sourceforge.plantuml.project.data.TimeBoundsData;
import net.sourceforge.plantuml.project.data.TimeScaleConfigData;
import net.sourceforge.plantuml.project.data.TimelineStyleData;
import net.sourceforge.plantuml.project.data.WeekConfigData;
import net.sourceforge.plantuml.project.draw.header.TimeHeaderCalendar;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.SName;

class TimeHeaderYearly
extends TimeHeaderCalendar {
    public TimeHeaderYearly(TimeScale timeScale, WeekConfigData weekConfigData, DayCalendarData dayCalendar, TimeBoundsData timeBounds, TimeScaleConfigData scaleConfig, TimelineStyleData timelineStyle) {
        super(weekConfigData, dayCalendar, timeBounds, scaleConfig, timelineStyle, timeScale);
    }

    @Override
    public double getTimeHeaderHeight(StringBounder stringBounder) {
        double h1 = this.timelineStyle.getFontSizeYear();
        return h1 + 3.0;
    }

    @Override
    public double getTimeFooterHeight(StringBounder stringBounder) {
        double h1 = this.timelineStyle.getFontSizeYear();
        return h1 + 3.0;
    }

    @Override
    public double getFullHeaderHeight(StringBounder stringBounder) {
        return this.getTimeHeaderHeight(stringBounder);
    }

    @Override
    public void drawTimeHeaderInternal(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawYears(ug);
        this.printVerticalSeparators(ug, totalHeightWithoutFooter);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.getFullHeaderHeight(ug.getStringBounder()));
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        this.drawYears(ug);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.getTimeFooterHeight(ug.getStringBounder()));
    }

    private void drawYears(UGraphic ug) {
        double h1 = this.timelineStyle.getFontSizeYear();
        YearMonth last = null;
        double lastChange = -1.0;
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) <= 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            double x1 = this.getTimeScale().getPosition(wink);
            if (last == null || wink.monthYear().getYear() != last.getYear()) {
                this.drawVline(ug.apply(this.getLineColor()), x1, 0.0, h1 + 2.0);
                if (last != null) {
                    this.printYear(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = wink.monthYear();
            }
            day = day.plusDays(1L);
        }
        double x1 = this.getTimeScale().getPosition(TimePoint.ofStartOfDay(this.getMaxDay().plusDays(1L)));
        if (x1 > lastChange) {
            this.printYear(ug, last, lastChange, x1);
        }
        double end = x1;
        this.drawVline(ug.apply(this.getLineColor()), end, 0.0, h1 + 2.0);
    }

    private void printYear(UGraphic ug, YearMonth monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(SName.year, "" + monthYear.getYear(), true, this.openFontColor());
        this.printCentered(ug, true, start, end, small);
    }
}

