/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.ngm.math;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.sourceforge.plantuml.project.ngm.math.AbstractPiecewiseConstant;
import net.sourceforge.plantuml.project.ngm.math.Fraction;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstant;
import net.sourceforge.plantuml.project.ngm.math.Segment;
import net.sourceforge.plantuml.project.ngm.math.TimeDirection;

public class Combiner
extends AbstractPiecewiseConstant {
    private final List<PiecewiseConstant> elements;
    private final BiFunction<Fraction, Fraction, Fraction> operation;

    private Combiner(BiFunction<Fraction, Fraction, Fraction> operation, PiecewiseConstant ... elements) {
        this.elements = Arrays.asList(elements);
        this.operation = operation;
    }

    public static PiecewiseConstant sum(PiecewiseConstant ... elements) {
        if (elements.length == 1) {
            return elements[0];
        }
        return new Combiner(Fraction.SUM, elements);
    }

    public static PiecewiseConstant min(PiecewiseConstant ... elements) {
        if (elements.length == 1) {
            return elements[0];
        }
        return new Combiner(Fraction.MIN, elements);
    }

    public static PiecewiseConstant max(PiecewiseConstant ... elements) {
        if (elements.length == 1) {
            return elements[0];
        }
        return new Combiner(Fraction.MAX, elements);
    }

    public static PiecewiseConstant product(PiecewiseConstant ... elements) {
        if (elements.length == 1) {
            return elements[0];
        }
        return new Combiner(Fraction.PRODUCT, elements);
    }

    @Override
    public Segment segmentAt(LocalDateTime instant, TimeDirection direction) {
        if (this.elements.size() < 2) {
            throw new IllegalStateException("At least two functions are required for combination");
        }
        List<Segment> segments = this.elements.stream().map(f -> f.segmentAt(instant, direction)).collect(Collectors.toList());
        return Segment.intersection(segments, this.operation);
    }
}

