/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.timescale;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.project.OpenClose;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;

public final class TimeScaleDailyHideClosed
implements TimeScale {
    private final double cellWidth;
    private final TimePoint startingDay;
    private TimePoint biggest;
    private final OpenClose openClose;
    private final Map<TimePoint, Integer> startingInt = new HashMap<TimePoint, Integer>();

    public TimeScaleDailyHideClosed(double size, TimePoint startingDay, double scale, OpenClose openClose) {
        this.cellWidth = size * scale;
        this.startingDay = startingDay;
        this.biggest = startingDay;
        this.openClose = openClose;
        this.startingInt.put(startingDay, 0);
    }

    @Override
    public double getPosition(TimePoint instant) {
        if (instant.compareTo(this.startingDay) < 0) {
            throw new IllegalArgumentException();
        }
        this.computeUpTo(instant);
        return (double)this.startingInt.get(instant).intValue() * this.cellWidth;
    }

    private void computeUpTo(TimePoint dest) {
        if (dest.compareTo(this.biggest) <= 0) {
            return;
        }
        TimePoint i = this.biggest;
        int current = this.startingInt.get(i);
        do {
            if (this.getWidth(i) > 0.0) {
                ++current;
            }
            i = i.increment();
            this.startingInt.put(i, current);
        } while (i.compareTo(dest) < 0);
    }

    @Override
    public double getWidth(TimePoint instant) {
        if (this.openClose.isClosed(instant.toDay())) {
            return 0.0;
        }
        return this.cellWidth;
    }

    @Override
    public boolean isBreaking(TimePoint instant) {
        return true;
    }
}

