/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.factory;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontFactory;
import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementRadioCheckbox;
import net.sourceforge.plantuml.salt.factory.ElementFactory;
import net.sourceforge.plantuml.style.ISkinSimple;

public class ElementFactoryRadioOn
implements ElementFactory {
    private final DataSource dataSource;
    private final ISkinSimple spriteContainer;

    public ElementFactoryRadioOn(DataSource dataSource, ISkinSimple spriteContainer) {
        this.dataSource = dataSource;
        this.spriteContainer = spriteContainer;
    }

    @Override
    public Terminated<Element> create() {
        if (!this.ready()) {
            throw new IllegalStateException();
        }
        Terminated next = (Terminated)this.dataSource.next();
        String text = (String)next.getElement();
        UFont font = UFontFactory.byDefault(12);
        return new Terminated<Element>(new ElementRadioCheckbox(this.extracted(text), font, true, true, this.spriteContainer), next.getTerminator());
    }

    private List<String> extracted(String text) {
        int x = text.indexOf(41);
        return Arrays.asList(StringUtils.trin(text.substring(x + 1)));
    }

    @Override
    public boolean ready() {
        String text = this.dataSource.peek(0).getElement();
        return text.startsWith("(X)");
    }
}

