/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSimple;

public class SplitParam {
    private final HColor borderColor;
    private final HColor externalColor;
    private final int externalMargin;

    private static SplitParam empty() {
        return new SplitParam(null, null, 0);
    }

    public SplitParam(HColor borderColor, HColor externalColor, int externalMargin) {
        if (borderColor != null && externalMargin == 0) {
            externalMargin = 1;
        }
        this.borderColor = borderColor;
        this.externalColor = externalColor;
        this.externalMargin = externalMargin;
    }

    public boolean isSet() {
        return this.externalMargin > 0;
    }

    public int getExternalMargin() {
        return this.externalMargin;
    }

    public XColor getBorderColor() {
        if (this.borderColor == null) {
            return null;
        }
        return ((HColorSimple)this.borderColor).getAwtColor();
    }

    public XColor getExternalColor() {
        if (this.externalColor == null) {
            return null;
        }
        return ((HColorSimple)this.externalColor).getAwtColor();
    }
}

