/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.regex.Pattern;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class ClockwiseTopRightBottomLeft {
    private final double top;
    private final double right;
    private final double bottom;
    private final double left;
    private static final Pattern NUMBERS_ONLY = Pattern.compile("[0-9 ]+");

    public static ClockwiseTopRightBottomLeft same(double value) {
        return new ClockwiseTopRightBottomLeft(value, value, value, value);
    }

    public static ClockwiseTopRightBottomLeft none() {
        return new ClockwiseTopRightBottomLeft(0.0, 0.0, 0.0, 0.0);
    }

    private static boolean isOnlyNumbersAndSpaces(String value) {
        return NUMBERS_ONLY.matcher(value).matches();
    }

    public static ClockwiseTopRightBottomLeft read(String value) {
        if (!ClockwiseTopRightBottomLeft.isOnlyNumbersAndSpaces(value)) {
            return ClockwiseTopRightBottomLeft.none();
        }
        String[] split = value.trim().split(" +");
        try {
            switch (split.length) {
                case 1: {
                    double v = Integer.parseInt(split[0]);
                    return new ClockwiseTopRightBottomLeft(v, v, v, v);
                }
                case 2: {
                    double a = Integer.parseInt(split[0]);
                    double b = Integer.parseInt(split[1]);
                    return new ClockwiseTopRightBottomLeft(a, b, a, b);
                }
                case 3: {
                    double a = Integer.parseInt(split[0]);
                    double b = Integer.parseInt(split[1]);
                    double c = Integer.parseInt(split[2]);
                    return new ClockwiseTopRightBottomLeft(a, b, c, b);
                }
                case 4: {
                    double a = Integer.parseInt(split[0]);
                    double b = Integer.parseInt(split[1]);
                    double c = Integer.parseInt(split[2]);
                    double d = Integer.parseInt(split[3]);
                    return new ClockwiseTopRightBottomLeft(a, b, c, d);
                }
            }
            return ClockwiseTopRightBottomLeft.none();
        }
        catch (NumberFormatException e) {
            return ClockwiseTopRightBottomLeft.none();
        }
    }

    public static ClockwiseTopRightBottomLeft margin1margin2(double margin1, double margin2) {
        return ClockwiseTopRightBottomLeft.topRightBottomLeft(margin1, margin2, margin1, margin2);
    }

    public static ClockwiseTopRightBottomLeft topRightBottomLeft(double top, double right, double bottom, double left) {
        return new ClockwiseTopRightBottomLeft(top, right, bottom, left);
    }

    private ClockwiseTopRightBottomLeft(double top, double right, double bottom, double left) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public ClockwiseTopRightBottomLeft incTop(double delta) {
        return new ClockwiseTopRightBottomLeft(this.top + delta, this.right, this.bottom, this.left);
    }

    public String toString() {
        return this.top + ":" + this.right + ":" + this.bottom + ":" + this.left;
    }

    public final double getTop() {
        return this.top;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getLeft() {
        return this.left;
    }

    public static ClockwiseTopRightBottomLeft marginForDocument(StyleBuilder styleBuilder) {
        Style style = StyleSignatureBasic.of(SName.root, SName.document).getMergedStyle(styleBuilder);
        return style.getMargin();
    }

    public UTranslate getTranslate() {
        return new UTranslate(this.left, this.top);
    }

    public XDimension2D apply(XDimension2D dim) {
        return new XDimension2D(this.left + dim.getWidth() + this.right, this.top + dim.getHeight() + this.bottom);
    }
}

