/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.teavm;

import net.sourceforge.plantuml.klimt.shape.UImageSvg;
import org.teavm.jso.JSBody;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.xml.Document;
import org.teavm.jso.dom.xml.Element;
import org.teavm.jso.dom.xml.Node;

public class SvgGraphicsTeaVM {
    private static final String SVG_NS = "http://www.w3.org/2000/svg";
    private final Element svgRoot;
    private final Element defs;
    private final Element mainGroup;
    private final Document document = HTMLDocument.current();
    private String fillColor = "#000000";
    private String strokeColor = "#000000";
    private double strokeWidth = 1.0;
    private double[] strokeDasharray = null;

    public SvgGraphicsTeaVM(int width, int height) {
        this.svgRoot = SvgGraphicsTeaVM.createSvgElement("svg");
        this.svgRoot.setAttribute("xmlns", SVG_NS);
        this.svgRoot.setAttribute("version", "1.1");
        this.svgRoot.setAttribute("width", String.valueOf(width));
        this.svgRoot.setAttribute("height", String.valueOf(height));
        this.svgRoot.setAttribute("viewBox", "0 0 " + width + " " + height);
        this.defs = SvgGraphicsTeaVM.createSvgElement("defs");
        this.svgRoot.appendChild((Node)this.defs);
        this.mainGroup = SvgGraphicsTeaVM.createSvgElement("g");
        this.svgRoot.appendChild((Node)this.mainGroup);
    }

    @JSBody(params={"tagName"}, script="return document.createElementNS('http://www.w3.org/2000/svg', tagName);")
    private static native Element createSvgElement(String var0);

    public Element getSvgRoot() {
        return this.svgRoot;
    }

    public void setFillColor(String color) {
        this.fillColor = color != null ? color : "none";
    }

    public void setStrokeColor(String color) {
        this.strokeColor = color != null ? color : "none";
    }

    public void setStrokeWidth(double width) {
        this.strokeWidth = width;
        this.strokeDasharray = null;
    }

    public void setStrokeWidth(double width, double[] dasharray) {
        this.strokeWidth = width;
        this.strokeDasharray = dasharray;
    }

    public void drawRectangle(double x, double y, double width, double height) {
        this.drawRectangle(x, y, width, height, 0.0, 0.0);
    }

    public void drawRectangle(double x, double y, double width, double height, double rx, double ry) {
        Element rect = SvgGraphicsTeaVM.createSvgElement("rect");
        rect.setAttribute("x", this.format(x));
        rect.setAttribute("y", this.format(y));
        rect.setAttribute("width", this.format(width));
        rect.setAttribute("height", this.format(height));
        if (rx > 0.0) {
            rect.setAttribute("rx", this.format(rx));
        }
        if (ry > 0.0) {
            rect.setAttribute("ry", this.format(ry));
        }
        this.applyStyles(rect);
        this.mainGroup.appendChild((Node)rect);
    }

    public void drawCircle(double cx, double cy, double r) {
        Element circle = SvgGraphicsTeaVM.createSvgElement("circle");
        circle.setAttribute("cx", this.format(cx));
        circle.setAttribute("cy", this.format(cy));
        circle.setAttribute("r", this.format(r));
        this.applyStyles(circle);
        this.mainGroup.appendChild((Node)circle);
    }

    public void drawEllipse(double cx, double cy, double rx, double ry) {
        Element ellipse = SvgGraphicsTeaVM.createSvgElement("ellipse");
        ellipse.setAttribute("cx", this.format(cx));
        ellipse.setAttribute("cy", this.format(cy));
        ellipse.setAttribute("rx", this.format(rx));
        ellipse.setAttribute("ry", this.format(ry));
        this.applyStyles(ellipse);
        this.mainGroup.appendChild((Node)ellipse);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        Element line = SvgGraphicsTeaVM.createSvgElement("line");
        line.setAttribute("x1", this.format(x1));
        line.setAttribute("y1", this.format(y1));
        line.setAttribute("x2", this.format(x2));
        line.setAttribute("y2", this.format(y2));
        this.applyStrokeStyle(line);
        this.mainGroup.appendChild((Node)line);
    }

    public void drawPolyline(double ... points) {
        Element polyline = SvgGraphicsTeaVM.createSvgElement("polyline");
        polyline.setAttribute("points", this.formatPoints(points));
        polyline.setAttribute("fill", "none");
        this.applyStrokeStyle(polyline);
        this.mainGroup.appendChild((Node)polyline);
    }

    public void drawPolygon(double ... points) {
        Element polygon = SvgGraphicsTeaVM.createSvgElement("polygon");
        polygon.setAttribute("points", this.formatPoints(points));
        this.applyStyles(polygon);
        this.mainGroup.appendChild((Node)polygon);
    }

    public void drawPath(String pathData) {
        Element path = SvgGraphicsTeaVM.createSvgElement("path");
        path.setAttribute("d", pathData);
        this.applyStyles(path);
        this.mainGroup.appendChild((Node)path);
    }

    public void drawText(String text, double x, double y, String fontFamily, int fontSize) {
        this.drawText(text, x, y, fontFamily, fontSize, null, null, null, null);
    }

    public void drawText(String text, double x, double y, String fontFamily, int fontSize, String fontWeight, String fontStyle, String textDecoration, String backColor) {
        if (backColor != null) {
            double[] metrics = SvgGraphicsTeaVM.measureTextCanvas(text, fontFamily, fontSize, fontWeight != null ? fontWeight : "normal");
            double width = metrics[0];
            double height = metrics[1];
            Element rect = SvgGraphicsTeaVM.createSvgElement("rect");
            rect.setAttribute("x", this.format(x));
            rect.setAttribute("y", this.format(y - height + 2.0));
            rect.setAttribute("width", this.format(width));
            rect.setAttribute("height", this.format(height));
            rect.setAttribute("fill", backColor);
            rect.setAttribute("stroke", "none");
            this.mainGroup.appendChild((Node)rect);
        }
        Element textElem = SvgGraphicsTeaVM.createSvgElement("text");
        textElem.setAttribute("x", this.format(x));
        textElem.setAttribute("y", this.format(y));
        textElem.setAttribute("font-size", String.valueOf(fontSize));
        textElem.setAttribute("fill", this.fillColor);
        textElem.setAttribute("xml:space", "preserve");
        textElem.setAttribute("style", "white-space: pre");
        if (fontWeight != null) {
            textElem.setAttribute("font-weight", fontWeight);
        }
        if (fontStyle != null) {
            textElem.setAttribute("font-style", fontStyle);
        }
        if (textDecoration != null) {
            textElem.setAttribute("text-decoration", textDecoration);
        }
        if (fontFamily != null) {
            textElem.setAttribute("font-family", fontFamily);
        }
        textElem.setTextContent(text);
        this.mainGroup.appendChild((Node)textElem);
    }

    public Element createGroup() {
        Element group = SvgGraphicsTeaVM.createSvgElement("g");
        this.mainGroup.appendChild((Node)group);
        return group;
    }

    public String createLinearGradient(String id, String color1, String color2, boolean horizontal) {
        Element gradient = SvgGraphicsTeaVM.createSvgElement("linearGradient");
        gradient.setAttribute("id", id);
        if (horizontal) {
            gradient.setAttribute("x1", "0%");
            gradient.setAttribute("y1", "0%");
            gradient.setAttribute("x2", "100%");
            gradient.setAttribute("y2", "0%");
        } else {
            gradient.setAttribute("x1", "0%");
            gradient.setAttribute("y1", "0%");
            gradient.setAttribute("x2", "0%");
            gradient.setAttribute("y2", "100%");
        }
        Element stop1 = SvgGraphicsTeaVM.createSvgElement("stop");
        stop1.setAttribute("offset", "0%");
        stop1.setAttribute("stop-color", color1);
        gradient.appendChild((Node)stop1);
        Element stop2 = SvgGraphicsTeaVM.createSvgElement("stop");
        stop2.setAttribute("offset", "100%");
        stop2.setAttribute("stop-color", color2);
        gradient.appendChild((Node)stop2);
        this.defs.appendChild((Node)gradient);
        return "url(#" + id + ")";
    }

    private void applyStyles(Element element) {
        element.setAttribute("fill", this.fillColor);
        this.applyStrokeStyle(element);
    }

    private void applyStrokeStyle(Element element) {
        element.setAttribute("stroke", this.strokeColor);
        element.setAttribute("stroke-width", this.format(this.strokeWidth));
        if (this.strokeDasharray != null && this.strokeDasharray.length >= 2) {
            element.setAttribute("stroke-dasharray", this.format(this.strokeDasharray[0]) + "," + this.format(this.strokeDasharray[1]));
        }
    }

    private String format(double value) {
        if (value == (double)((int)value)) {
            return String.valueOf((int)value);
        }
        return String.format("%.2f", value).replace(',', '.');
    }

    private String formatPoints(double ... points) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < points.length; i += 2) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(this.format(points[i])).append(",").append(this.format(points[i + 1]));
        }
        return sb.toString();
    }

    @JSBody(params={"element"}, script="return new XMLSerializer().serializeToString(element);")
    public static native String serializeToString(Element var0);

    public String toSvgString() {
        return SvgGraphicsTeaVM.serializeToString(this.svgRoot);
    }

    @JSBody(script="if (!window._measureCanvas) {  window._measureCanvas = document.createElement('canvas');  window._measureCtx = window._measureCanvas.getContext('2d');}")
    public static native void initMeasureCanvas();

    @JSBody(params={"text", "fontFamily", "fontSize", "fontWeight"}, script="if (!window._measureCtx) {  window._measureCanvas = document.createElement('canvas');  window._measureCtx = window._measureCanvas.getContext('2d');}var ctx = window._measureCtx;ctx.font = fontWeight + ' ' + fontSize + 'px ' + fontFamily;var metrics = ctx.measureText(text);var width = metrics.width;var height = metrics.actualBoundingBoxAscent + metrics.actualBoundingBoxDescent;if (!height) height = fontSize * 1.2;return [width, height];")
    public static native double[] measureTextCanvas(String var0, String var1, int var2, String var3);

    @JSBody(params={"text", "fontFamily", "fontSize", "fontWeight"}, script="var canvas = document.createElement('canvas');var ctx = canvas.getContext('2d');ctx.font = fontWeight + ' ' + fontSize + 'px ' + fontFamily;var metrics = ctx.measureText(text);var width = metrics.width;var height = metrics.actualBoundingBoxAscent + metrics.actualBoundingBoxDescent;if (!height) height = fontSize * 1.2;return [width, height];")
    public static native double[] measureTextCanvasNoCache(String var0, String var1, int var2, String var3);

    public static double[] measureText(String text, String fontFamily, int fontSize) {
        return SvgGraphicsTeaVM.measureTextCanvas(text, fontFamily, fontSize, "normal");
    }

    public static double getTextWidth(String text, String fontFamily, int fontSize) {
        return SvgGraphicsTeaVM.measureText(text, fontFamily, fontSize)[0];
    }

    public static double getTextHeight(String text, String fontFamily, int fontSize) {
        return SvgGraphicsTeaVM.measureText(text, fontFamily, fontSize)[1];
    }

    @JSBody(params={"text", "fontFamily", "fontSize"}, script="var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');svg.style.position = 'absolute';svg.style.visibility = 'hidden';document.body.appendChild(svg);var textEl = document.createElementNS('http://www.w3.org/2000/svg', 'text');textEl.setAttribute('font-family', fontFamily);textEl.setAttribute('font-size', fontSize);textEl.textContent = text;svg.appendChild(textEl);var bbox = textEl.getBBox();var result = [bbox.width, bbox.height, bbox.x, bbox.y];document.body.removeChild(svg);return result;")
    public static native double[] measureTextSvgBBox(String var0, String var1, int var2);

    @JSBody(params={"text", "fontFamily", "fontSize", "fontWeight"}, script="var canvas = document.createElement('canvas');var ctx = canvas.getContext('2d');ctx.font = fontWeight + ' ' + fontSize + 'px ' + fontFamily;var m = ctx.measureText(text);return [  m.width,  m.actualBoundingBoxAscent || fontSize * 0.8,  m.actualBoundingBoxDescent || fontSize * 0.2,  m.fontBoundingBoxAscent || fontSize * 0.8,  m.fontBoundingBoxDescent || fontSize * 0.2];")
    public static native double[] getDetailedTextMetrics(String var0, String var1, int var2, String var3);

    public void drawCenteredCharacter(char c, double x, double y, String fontFamily, int fontSize) {
        Element textElem = SvgGraphicsTeaVM.createSvgElement("text");
        textElem.setAttribute("x", this.format(x));
        textElem.setAttribute("y", this.format(y));
        textElem.setAttribute("font-family", fontFamily);
        textElem.setAttribute("font-size", String.valueOf(fontSize));
        textElem.setAttribute("fill", this.fillColor);
        textElem.setAttribute("text-anchor", "middle");
        textElem.setAttribute("dominant-baseline", "central");
        textElem.setTextContent(String.valueOf(c));
        this.mainGroup.appendChild((Node)textElem);
    }

    public void drawImage(String dataUrl, double x, double y, int width, int height) {
        Element image = SvgGraphicsTeaVM.createSvgElement("image");
        image.setAttribute("x", this.format(x));
        image.setAttribute("y", this.format(y));
        image.setAttribute("width", String.valueOf(width));
        image.setAttribute("height", String.valueOf(height));
        image.setAttribute("href", dataUrl);
        SvgGraphicsTeaVM.setXlinkHref(image, dataUrl);
        this.mainGroup.appendChild((Node)image);
    }

    @JSBody(params={"element", "href"}, script="element.setAttributeNS('http://www.w3.org/1999/xlink', 'xlink:href', href);")
    private static native void setXlinkHref(Element var0, String var1);

    public void drawSvgImage(UImageSvg image, double x, double y) {
        double svgScale = image.getScale();
        String svg = image.getSvg(false);
        if (svgScale != 1.0) {
            svg = this.wrapWithScaleTransform(svg, svgScale);
        }
        Element wrapper = SvgGraphicsTeaVM.createSvgElement("g");
        wrapper.setAttribute("transform", "translate(" + this.format(x) + "," + this.format(y) + ")");
        SvgGraphicsTeaVM.insertSvgContent(wrapper, svg);
        this.mainGroup.appendChild((Node)wrapper);
    }

    private String wrapWithScaleTransform(String svg, double scale) {
        String svg2 = svg.replace('\n', ' ').replace('\r', ' ');
        if (!svg2.contains("<g ") && !svg2.contains("<g>")) {
            svg = svg.replaceFirst("\\<svg\\>", "<svg><g>");
            svg = svg.replaceFirst("\\</svg\\>", "</g></svg>");
        }
        String factor = this.format(scale);
        svg = svg.replaceFirst("\\<g\\b", "<g transform=\"scale(" + factor + "," + factor + ")\" ");
        return svg;
    }

    @JSBody(params={"parent", "svgContent"}, script="var parser = new DOMParser();var doc = parser.parseFromString(svgContent, 'image/svg+xml');var svgElem = doc.documentElement;if (svgElem && svgElem.tagName.toLowerCase() === 'svg') {  var imported = document.importNode(svgElem, true);  parent.appendChild(imported);}")
    private static native void insertSvgContent(Element var0, String var1);
}

