/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

final class DeduceFormat {
    private final boolean forceSign;
    private final char groupingSep;
    private final char decimalSep;
    private final int minFractionDigits;
    private final int maxFractionDigits;

    private DeduceFormat(boolean forceSign, char groupingSep, char decimalSep, int minFractionDigits, int maxFractionDigits) {
        this.forceSign = forceSign;
        this.groupingSep = groupingSep;
        this.decimalSep = decimalSep;
        this.minFractionDigits = minFractionDigits;
        this.maxFractionDigits = maxFractionDigits;
    }

    public DeduceFormat mergeWith(DeduceFormat other) {
        char mergedDecimal;
        if (other == null) {
            return this;
        }
        boolean mergedForceSign = this.forceSign || other.forceSign;
        char c = mergedDecimal = this.decimalSep != '\u0000' ? this.decimalSep : other.decimalSep;
        char mergedGrouping = this.groupingSep == '\u0000' ? other.groupingSep : (other.groupingSep == '\u0000' ? this.groupingSep : (this.groupingSep == other.groupingSep ? this.groupingSep : (char)'\u0000'));
        int mergedMinFrac = Math.min(this.minFractionDigits, other.minFractionDigits);
        int mergedMaxFrac = Math.max(this.maxFractionDigits, other.maxFractionDigits);
        if (mergedGrouping != '\u0000' && mergedDecimal != '\u0000' && mergedGrouping == mergedDecimal) {
            mergedGrouping = '\u0000';
        }
        return new DeduceFormat(mergedForceSign, mergedGrouping, mergedDecimal, mergedMinFrac, mergedMaxFrac);
    }

    public DecimalFormat getDecimalFormat() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        if (this.decimalSep != '\u0000') {
            symbols.setDecimalSeparator(this.decimalSep);
        }
        if (this.groupingSep != '\u0000') {
            symbols.setGroupingSeparator(this.groupingSep);
        }
        StringBuilder pattern = new StringBuilder();
        if (this.forceSign) {
            pattern.append("+");
        }
        if (this.groupingSep != '\u0000') {
            pattern.append("#,##0");
        } else {
            pattern.append("0");
        }
        if (this.minFractionDigits > 0) {
            pattern.append(".");
            for (int i = 0; i < this.minFractionDigits; ++i) {
                pattern.append("0");
            }
        }
        DecimalFormat df = new DecimalFormat(pattern.toString(), symbols);
        df.setGroupingUsed(this.groupingSep != '\u0000');
        df.setMinimumFractionDigits(this.minFractionDigits);
        df.setMaximumFractionDigits(this.maxFractionDigits);
        return df;
    }

    public static DeduceFormat from(String number) {
        CharCount nonDigit1 = new CharCount();
        CharCount nonDigit2 = new CharCount();
        char sign = '\u0000';
        if (number.charAt(0) == '+' || number.charAt(0) == '-') {
            sign = number.charAt(0);
            number = number.substring(1);
        }
        int fractionDigits = 0;
        for (int i = 0; i < number.length(); ++i) {
            char ch = number.charAt(i);
            if (Character.isDigit(ch)) {
                if (nonDigit1.count <= 0) continue;
                ++fractionDigits;
                continue;
            }
            if (nonDigit1.count == 0) {
                nonDigit1.init(ch);
                fractionDigits = 0;
                continue;
            }
            if (nonDigit1.ch == ch) {
                ++nonDigit1.count;
                continue;
            }
            if (nonDigit2.count == 0) {
                nonDigit2.init(ch);
                fractionDigits = 0;
                continue;
            }
            if (nonDigit2.ch == ch) {
                ++nonDigit2.count;
                continue;
            }
            return null;
        }
        if (nonDigit1.count > 0 && nonDigit2.count > 0) {
            return new DeduceFormat(sign == '+', nonDigit1.ch, nonDigit2.ch, fractionDigits, fractionDigits);
        }
        return new DeduceFormat(sign == '+', '\u0000', nonDigit1.ch, fractionDigits, fractionDigits);
    }

    public String toString() {
        if (this.minFractionDigits == this.maxFractionDigits) {
            return "DeduceFormat{forceSign=" + this.forceSign + ", groupingSep=" + (String)(this.groupingSep == '\u0000' ? "none" : "'" + this.groupingSep + "'") + ", decimalSep=" + (String)(this.decimalSep == '\u0000' ? "none" : "'" + this.decimalSep + "'") + ", fractionDigits=" + this.minFractionDigits + "}";
        }
        return "DeduceFormat{forceSign=" + this.forceSign + ", groupingSep=" + (String)(this.groupingSep == '\u0000' ? "none" : "'" + this.groupingSep + "'") + ", decimalSep=" + (String)(this.decimalSep == '\u0000' ? "none" : "'" + this.decimalSep + "'") + ", minFractionDigits=" + this.minFractionDigits + ", maxFractionDigits=" + this.maxFractionDigits + "}";
    }

    static class CharCount {
        char ch;
        int count;

        CharCount() {
        }

        public void init(char newOne) {
            this.ch = newOne;
            this.count = 1;
        }
    }
}

