/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.utils;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.text.StringLocated;

public class StartUtils {
    public static final Pattern2 patternFilename = Pattern2.cmpile("^[@\\\\]start[^%s{}%g]+[%s{][%s%g]*([^%g]*?)[%s}%g]*$");
    public static final String PAUSE_PATTERN = "((?:\\W|\\<[^<>]*\\>)*)[@\\\\]unpause";
    public static final String START_PATTERN = "((?:[^\\w~]|\\<[^<>]*\\>)*)[@\\\\]start";
    private static final Pattern2 append = Pattern2.cmpile("^\\W*[@\\\\](append|a)\\b");

    public static boolean isArobaseStartDiagram(String s) {
        return DiagramType.getTypeFromArobaseStart(s) != DiagramType.UNKNOWN;
    }

    public static String beforeStartUml(String s) {
        int n = s.length();
        boolean inside = false;
        for (int i = 0; i < n; ++i) {
            if (StartUtils.startsWithSymbolAndAt(s, i, "start")) {
                return s.substring(0, i);
            }
            char c = s.charAt(i);
            if (inside) {
                if (c != '>') continue;
                inside = false;
                continue;
            }
            if (c == '<') {
                inside = true;
                continue;
            }
            if (!StartUtils.isWordOrTilde(c)) continue;
            return null;
        }
        return null;
    }

    private static boolean isWordOrTilde(char c) {
        return c == '~' || Character.isLetterOrDigit(c) || c == '_';
    }

    private static boolean startsWithSymbolAndAt(String text, int from, String keyword) {
        int n = text.length();
        for (int i = from; i < n; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                continue;
            }
            if (c != '@' && c != '\\') {
                return false;
            }
            int start = i + 1;
            int kwLen = keyword.length();
            if (start + kwLen > n) {
                return false;
            }
            return text.regionMatches(start, keyword, 0, kwLen);
        }
        return false;
    }

    public static boolean isArobaseEndDiagram(String s) {
        return StartUtils.startsWithSymbolAndAt(s, 0, "end");
    }

    public static boolean isArobasePauseDiagram(String s) {
        return StartUtils.startsWithSymbolAndAt(s, 0, "pause");
    }

    public static boolean isArobaseUnpauseDiagram(String s) {
        return StartUtils.startsWithSymbolAndAt(s, 0, "unpause");
    }

    public static boolean isExit(CharSequence s) {
        int start;
        int len = s.length();
        int end = len - 1;
        for (start = 0; start < len && Character.isWhitespace(s.charAt(start)); ++start) {
        }
        while (end >= start && Character.isWhitespace(s.charAt(end))) {
            --end;
        }
        if (end - start + 1 != 5) {
            return false;
        }
        return s.charAt(start) == '!' && s.charAt(start + 1) == 'e' && s.charAt(start + 2) == 'x' && s.charAt(start + 3) == 'i' && s.charAt(start + 4) == 't';
    }

    public static StringLocated getPossibleAppend(StringLocated cs) {
        String s = cs.getString();
        Matcher2 m = append.matcher(s);
        if (m.find()) {
            String tmp = s.substring(m.group(0).length(), s.length());
            return new StringLocated(StringUtils.trin(tmp), cs.getLocation(), cs.getPreprocessorError());
        }
        return null;
    }
}

