/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.atmp.PixelImage;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.AffineTransformType;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.GraphicStrings;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.LicenseInfo;

public class PSystemLicense
extends PlainDiagram
implements UDrawable {
    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) {
        return this;
    }

    public static PSystemLicense create(UmlSource source, PreprocessingArtifact preprocessing) throws IOException {
        return new PSystemLicense(source, preprocessing);
    }

    public PSystemLicense(UmlSource source, PreprocessingArtifact preprocessing) {
        super(source, preprocessing);
    }

    private TextBlock getGraphicStrings(List<String> strings) {
        return GraphicStrings.createBlackOnWhite(strings);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(License)");
    }

    @Override
    public void exportDiagramGraphic(UGraphic ug, FileFormatOption fileFormatOption) {
        LicenseInfo licenseInfo = LicenseInfo.retrieveQuick();
        this.getTextBlock(licenseInfo).drawU(ug);
    }

    @Override
    public void drawU(UGraphic ug) {
        LicenseInfo licenseInfo = LicenseInfo.retrieveQuick();
        PortableImage logo = LicenseInfo.retrieveDistributorImage(licenseInfo);
        if (logo == null) {
            this.getTextBlock(licenseInfo).drawU(ug);
        } else {
            ArrayList<String> strings1 = new ArrayList<String>();
            ArrayList<String> strings2 = new ArrayList<String>();
            strings1.addAll(License.getCurrent().getText1(licenseInfo));
            strings2.addAll(License.getCurrent().getText2(licenseInfo));
            TextBlock result1 = this.getGraphicStrings(strings1);
            result1.drawU(ug);
            ug = ug.apply(UTranslate.dy(4.0 + result1.calculateDimension(ug.getStringBounder()).getHeight()));
            UImage im = new UImage(new PixelImage(logo, AffineTransformType.TYPE_BILINEAR));
            ug.apply(UTranslate.dx(20.0)).draw(im);
            ug = ug.apply(UTranslate.dy(im.getHeight()));
            TextBlock result2 = this.getGraphicStrings(strings2);
            result2.drawU(ug);
        }
    }

    protected TextBlock getTextBlock(LicenseInfo licenseInfo) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.addAll(License.getCurrent().getText1(licenseInfo));
        strings.addAll(License.getCurrent().getText2(licenseInfo));
        return this.getGraphicStrings(strings);
    }
}

