/*
 * Decompiled with CFR 0.152.
 */
package com.virtuslab.using_directives.custom;

import com.virtuslab.using_directives.custom.CustomCharArrayReader;
import com.virtuslab.using_directives.custom.TokenData;
import com.virtuslab.using_directives.custom.Tokens;
import com.virtuslab.using_directives.custom.utils.Chars;
import com.virtuslab.using_directives.custom.utils.Source;
import com.virtuslab.using_directives.custom.utils.TokenUtils;
import com.virtuslab.using_directives.reporter.Reporter;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Scanner {
    private final Reporter reporter;
    private Source source;
    private boolean debug = false;
    public boolean allowLeadingInfixOperators = true;
    public TokenData td = this.newTokenData();
    private final CustomCharArrayReader reader;
    private final Deque<Character> litBuf = new LinkedList<Character>();
    public TokenData next = this.newTokenData();
    public TokenData prev = this.newTokenData();

    public Scanner(Source source, int startFrom, Reporter reporter) {
        this.source = source;
        this.reporter = reporter;
        this.reader = new CustomCharArrayReader(source.getContent(), this::errorButContinue);
        this.reader.startFrom = startFrom;
        this.reader.nextChar();
        this.nextToken();
    }

    public Scanner(Source source, int startFrom, Reporter reporter, boolean debug) {
        this(source, startFrom, reporter);
        this.debug = debug;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    private void error(String msg, int offset) {
        this.reporter.error(this.source.getPositionFromOffset(offset), msg);
    }

    private void error(String msg) {
        this.error(msg, this.td.offset);
    }

    private void warn(String msg) {
        this.reporter.warning(this.source.getPositionFromOffset(this.td.offset), msg);
    }

    private void errorButContinue(String msg, int offset) {
        this.reporter.error(this.source.getPositionFromOffset(offset), msg);
    }

    private String getLitBufString() {
        return this.litBuf.stream().map(Object::toString).collect(Collectors.joining());
    }

    private void putChar(char c) {
        this.litBuf.addLast(Character.valueOf(c));
    }

    private void finishNamed(Tokens idtoken, TokenData target) {
        Tokens converted;
        target.name = this.getLitBufString();
        this.litBuf.clear();
        target.token = idtoken;
        if (idtoken == Tokens.IDENTIFIER && TokenUtils.keywordMap.containsKey(target.name) && ((converted = TokenUtils.keywordMap.get(target.name)) != Tokens.END || target == this.td)) {
            target.token = converted;
        }
    }

    private void setStrVal() {
        this.td.strVal = this.getLitBufString();
        this.litBuf.clear();
    }

    private TokenData newTokenData() {
        return new TokenData();
    }

    public void nextToken() {
        if (this.next.token == Tokens.EMPTY) {
            this.td.lastOffset = this.reader.lastCharOffset;
            this.fetchToken();
        } else {
            this.td.copyFrom(this.next);
            this.next.token = Tokens.EMPTY;
        }
        this.printState();
    }

    public void printState() {
        if (this.debug) {
            System.out.println(this.show());
        }
    }

    public boolean isContinuing(Tokens lastToken) {
        return TokenUtils.openParensTokens.contains((Object)this.td.token) && !this.pastBlankLine();
    }

    public void lookAhead() {
        this.prev.copyFrom(this.td);
        this.td.lastOffset = this.reader.lastCharOffset;
        this.fetchToken();
    }

    public void reset() {
        this.next.copyFrom(this.td);
        this.td.copyFrom(this.prev);
    }

    private boolean pastBlankLineRecur(int idx, boolean isBlank, int end) {
        Supplier<Boolean> expr1 = () -> {
            char ch = this.reader.buf[idx];
            if (ch == '\n' || ch == '\f') {
                return isBlank || this.pastBlankLineRecur(idx + 1, true, end);
            }
            return this.pastBlankLineRecur(idx + 1, isBlank && ch <= ' ', end);
        };
        return idx < end && expr1.get() != false;
    }

    private boolean pastBlankLine() {
        int end = this.td.offset;
        return this.pastBlankLineRecur(this.td.lastOffset, false, end);
    }

    private void fetchToken() {
        while (this.doFetchToken()) {
        }
    }

    private boolean doFetchToken() {
        block19: {
            Character ch;
            block25: {
                block27: {
                    block26: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block18: {
                                                ch = null;
                                                do {
                                                    if (ch != null) {
                                                        this.reader.nextChar();
                                                    }
                                                    this.td.offset = this.reader.charOffset - 1;
                                                    this.td.lineOffset = this.td.lastOffset < this.reader.lineStartOffset ? this.reader.lineStartOffset : -1;
                                                    this.td.name = null;
                                                } while ((ch = Character.valueOf(this.reader.ch)).charValue() == ' ' || ch.charValue() == '\t' || ch.charValue() == '\r' || ch.charValue() == '\n' || ch.charValue() == '\f');
                                                if (!(ch.charValue() >= 'A' && ch.charValue() <= 'Z' || ch.charValue() >= 'a' && ch.charValue() <= 'z' || ch.charValue() == '$') && ch.charValue() != '_') break block18;
                                                this.putChar(ch.charValue());
                                                this.reader.nextChar();
                                                this.getIdentRest();
                                                if (this.reader.ch == '\"' && this.td.token == Tokens.IDENTIFIER) {
                                                    this.td.token = Tokens.INTERPOLATIONID;
                                                }
                                                break block19;
                                            }
                                            if (ch.charValue() != '<') break block20;
                                            this.putChar('<');
                                            this.reader.nextChar();
                                            this.getOperatorRest();
                                            break block19;
                                        }
                                        if (ch.charValue() != '~' && ch.charValue() != '!' && ch.charValue() != '@' && ch.charValue() != '#' && ch.charValue() != '%' && ch.charValue() != '^' && ch.charValue() != '*' && ch.charValue() != '+' && ch.charValue() != '-' && ch.charValue() != '>' && ch.charValue() != '?' && ch.charValue() != ':' && ch.charValue() != '=' && ch.charValue() != '&' && ch.charValue() != '|' && ch.charValue() != '\\') break block21;
                                        this.putChar(ch.charValue());
                                        this.reader.nextChar();
                                        this.getOperatorRest();
                                        break block19;
                                    }
                                    if (ch.charValue() != '/') break block22;
                                    if (this.skipLine()) {
                                        return true;
                                    }
                                    this.putChar('/');
                                    this.getOperatorRest();
                                    break block19;
                                }
                                if (ch.charValue() != '`') break block23;
                                this.getBackquotedIdent();
                                break block19;
                            }
                            if (ch.charValue() != '\"') break block24;
                            Runnable fetchDoubleQuote = () -> {
                                this.reader.nextChar();
                                if (this.reader.ch == '\"') {
                                    this.reader.nextChar();
                                    this.td.token = Tokens.STRINGLIT;
                                    this.td.strVal = "";
                                } else {
                                    this.getStringLit();
                                }
                            };
                            fetchDoubleQuote.run();
                            break block19;
                        }
                        if (ch.charValue() != '\'') break block25;
                        this.reader.nextChar();
                        if (!Chars.isIdentifierStart(this.reader.ch)) break block26;
                        this.charLitOr(() -> {
                            this.getIdentRest();
                            return Tokens.QUOTEID;
                        });
                        break block19;
                    }
                    if (!Chars.isIdentifierPart(this.reader.ch) || this.reader.ch == '\\') break block27;
                    this.charLitOr(() -> {
                        this.getOperatorRest();
                        return Tokens.QUOTEID;
                    });
                    break block19;
                }
                switch (this.reader.ch) {
                    case '\t': 
                    case ' ': 
                    case '[': 
                    case '{': {
                        if (this.reader.lookaheadChar() != '\'') {
                            this.td.token = Tokens.QUOTE;
                            break;
                        }
                        break block19;
                    }
                    default: {
                        if (this.reader.isAtEnd() && (this.reader.ch != '\u001a' && this.reader.ch != '\r' && this.reader.ch != '\n' || this.reader.isUnicodeEscape())) {
                            boolean isEmptyCharLit = this.reader.ch == '\'';
                            this.getLitChar();
                            if (this.reader.ch == '\'') {
                                if (isEmptyCharLit) {
                                    this.error("empty character literal (use '\\'' for single quote)");
                                    break;
                                }
                                this.finishCharLit();
                                break;
                            }
                            if (isEmptyCharLit) {
                                this.error("empty character literal");
                                break;
                            }
                            this.error("unclosed character literal");
                            break;
                        }
                        this.error("unclosed character literal");
                        break;
                    }
                }
                break block19;
            }
            if (ch.charValue() == ',' && Character.isWhitespace(this.reader.lookaheadChar())) {
                this.warn("Use of commas as separators is deprecated. Only whitespace is neccessary.");
                this.reader.nextChar();
                this.td.token = Tokens.COMMA;
            } else if (ch.charValue() == '\u001a') {
                if (this.reader.isAtEnd()) {
                    this.td.token = Tokens.EOF;
                } else {
                    this.error("illegal character");
                    this.reader.nextChar();
                    this.td.token = Tokens.ERROR;
                }
            } else {
                this.putChar(ch.charValue());
                this.reader.nextChar();
                this.getOperatorRest();
            }
        }
        return false;
    }

    private boolean skipLine() {
        Runnable skipLine = () -> {
            this.reader.nextChar();
            while (this.reader.ch != '\r' && this.reader.ch != '\n' && this.reader.ch != '\u001a') {
                this.reader.nextChar();
            }
        };
        this.reader.nextChar();
        if (this.reader.ch == '/') {
            skipLine.run();
            return true;
        }
        return false;
    }

    public TokenData lookahead() {
        if (this.next.token == Tokens.EMPTY) {
            this.lookAhead();
            this.reset();
        }
        return this.next;
    }

    public void getBackquotedIdent() {
        this.reader.nextChar();
        this.getLitChars('`');
        if (this.reader.ch == '`') {
            this.reader.nextChar();
            this.finishNamed(Tokens.IDENTIFIER, this.td);
            if (this.td.name.length() == 0) {
                this.error("empty quoted identifier");
            } else if (this.td.name.contains("_")) {
                this.error("wildcard invalid as backquoted identifier");
            }
        } else {
            this.error("unclosed quoted identifier");
        }
    }

    public void getIdentRest() {
        if (!(Character.isWhitespace(this.reader.ch) || this.reader.isAtEnd() || this.reader.ch == ',' && Character.isWhitespace(this.reader.lookaheadChar()))) {
            this.putChar(this.reader.ch);
            this.reader.nextChar();
            this.getIdentRest();
        } else {
            this.finishNamed(Tokens.IDENTIFIER, this.td);
        }
    }

    public void getOperatorRest() {
        switch (this.reader.ch) {
            case '!': 
            case '#': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '^': 
            case '|': 
            case '~': {
                this.putChar(this.reader.ch);
                this.reader.nextChar();
                this.getOperatorRest();
                break;
            }
            case '/': {
                char nxch = this.reader.lookaheadChar();
                if (nxch == '/') {
                    this.finishNamed(Tokens.IDENTIFIER, this.td);
                    break;
                }
                this.putChar(this.reader.ch);
                this.reader.nextChar();
                this.getOperatorRest();
                break;
            }
            default: {
                if (Chars.isSpecial(this.reader.ch)) {
                    this.putChar(this.reader.ch);
                    this.reader.nextChar();
                    this.getOperatorRest();
                    break;
                }
                this.getIdentRest();
            }
        }
    }

    public void getIdentOrOperatorRest() {
        if (Chars.isIdentifierPart(this.reader.ch)) {
            this.getIdentRest();
        } else {
            switch (this.reader.ch) {
                case '!': 
                case '#': 
                case '%': 
                case '&': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '\\': 
                case '^': 
                case '|': 
                case '~': {
                    this.getOperatorRest();
                    break;
                }
                default: {
                    if (Chars.isSpecial(this.reader.ch)) {
                        this.getOperatorRest();
                        break;
                    }
                    this.getIdentRest();
                }
            }
        }
    }

    public Set<Tokens> canStartStatTokens() {
        return TokenUtils.canStartStatTokens3;
    }

    public Set<Tokens> canStartExprTokens() {
        return TokenUtils.canStartExprTokens3;
    }

    public void getStringLit() {
        this.getLitChars('\"');
        if (this.reader.ch == '\"') {
            this.setStrVal();
            this.reader.nextChar();
            this.td.token = Tokens.STRINGLIT;
        } else {
            this.setStrVal();
            this.td.token = Tokens.STRINGLIT;
            this.error("unclosed string literal");
        }
    }

    public void getLitChar() {
        Runnable invalidUnicodeEscape = () -> {
            this.error("invalid character in unicode escape sequence", this.reader.charOffset - 1);
            this.putChar(this.reader.ch);
        };
        Runnable putUnicode = () -> {
            while (this.reader.ch == 'u' || this.reader.ch == 'U') {
                this.reader.nextChar();
            }
            int cp = 0;
            for (int i = 0; i < 4; ++i) {
                int shift = (3 - i) * 4;
                int d = Chars.digitToInt(this.reader.ch, 16);
                if (d < 0) {
                    invalidUnicodeEscape.run();
                    return;
                }
                cp += d << shift;
                this.reader.nextChar();
            }
            this.putChar((char)cp);
        };
        if (this.reader.ch == '\\') {
            this.reader.nextChar();
            if ('0' <= this.reader.ch && this.reader.ch <= '7') {
                char leadch = this.reader.ch;
                int oct = Chars.digitToInt(this.reader.ch, 8);
                this.reader.nextChar();
                if ('0' <= this.reader.ch && this.reader.ch <= '7') {
                    oct = oct * 8 + Chars.digitToInt(this.reader.ch, 8);
                    this.reader.nextChar();
                    if (leadch <= '3' && '0' <= this.reader.ch && this.reader.ch <= '7') {
                        oct = oct * 8 + Chars.digitToInt(this.reader.ch, 8);
                        this.reader.nextChar();
                    }
                }
                String alt = oct == 10 ? "\\n" : String.format("\\u%04x", oct);
                this.error(String.format("octal escape literals are unsupported: use %s instead", alt));
                this.putChar((char)oct);
            } else if (this.reader.ch == 'u' || this.reader.ch == 'U') {
                putUnicode.run();
            } else {
                switch (this.reader.ch) {
                    case 'b': {
                        this.putChar('\b');
                        break;
                    }
                    case 't': {
                        this.putChar('\t');
                        break;
                    }
                    case 'n': {
                        this.putChar('\n');
                        break;
                    }
                    case 'f': {
                        this.putChar('\f');
                        break;
                    }
                    case 'r': {
                        this.putChar('\r');
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        break;
                    }
                    case '\\': {
                        this.putChar('\\');
                        break;
                    }
                    default: {
                        this.invalidEscape();
                    }
                }
                this.reader.nextChar();
            }
        } else {
            this.putChar(this.reader.ch);
            this.reader.nextChar();
        }
    }

    public void invalidEscape() {
        this.error("invalid escape character", this.reader.charOffset - 1);
        this.putChar(this.reader.ch);
    }

    public void getLitChars(char delimiter) {
        while (this.reader.ch != delimiter && !this.reader.isAtEnd() && (this.reader.ch != '\u001a' && this.reader.ch != '\r' && this.reader.ch != '\n' || this.reader.isUnicodeEscape())) {
            this.getLitChar();
        }
    }

    public void finishCharLit() {
        this.reader.nextChar();
        this.td.token = Tokens.CHARLIT;
        this.setStrVal();
    }

    public void charLitOr(Supplier<Tokens> op) {
        this.putChar(this.reader.ch);
        this.reader.nextChar();
        if (this.reader.ch == '\'') {
            this.finishCharLit();
        } else {
            this.td.token = op.get();
            this.td.strVal = this.td.name;
            this.litBuf.clear();
        }
    }

    public String toString() {
        String s1 = this.td.token.showTokenDetailed();
        String s2 = TokenUtils.identifierTokens.contains((Object)this.td.token) ? String.format(" %s", this.td.name) : (TokenUtils.literalTokens.contains((Object)this.td.token) ? String.format(" %s", this.td.strVal) : "");
        return s1 + s2;
    }

    public String show() {
        switch (this.td.token) {
            case IDENTIFIER: 
            case BACKQUOTED_IDENT: {
                return String.format("id(%s)", this.td.name);
            }
            case CHARLIT: {
                return String.format("char(%s)", this.td.strVal);
            }
            case INTLIT: {
                return String.format("int(%s, base=%d)", this.td.strVal, this.td.base);
            }
            case LONGLIT: {
                return String.format("long(%s, base=%d)", this.td.strVal, this.td.base);
            }
            case FLOATLIT: {
                return String.format("float(%s)", this.td.strVal);
            }
            case DOUBLELIT: {
                return String.format("double(%s)", this.td.strVal);
            }
            case STRINGLIT: {
                return String.format("string(%s)", this.td.strVal);
            }
            case STRINGPART: {
                return String.format("stringpart(%s)", this.td.strVal);
            }
            case INTERPOLATIONID: {
                return String.format("interpolationid(%s)", this.td.name);
            }
            case SEMI: 
            case NEWLINE: {
                return ";";
            }
            case NEWLINES: {
                return ";;";
            }
            case COMMA: {
                return ",";
            }
        }
        return this.td.token.showToken();
    }

    class LookaheadScanner
    extends Scanner {
        public LookaheadScanner() {
            super(Scanner.this.source, ((Scanner)Scanner.this).reader.startFrom, Scanner.this.reporter);
        }
    }
}

