/**
 * Copyright (C) 2011-2020 Aratelia Limited - Juan A. Rubio and contributors and contributors
 *
 * This file is part of Tizonia
 *
 * Tizonia is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * Tizonia is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Tizonia.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @file   tizplatform.h
 * @author Juan A. Rubio <juan.rubio@aratelia.com>
 *
 * @brief  Tizonia Platform - Main platform include file
 *
 *
 */

#ifndef TIZPLATFORM_H
#define TIZPLATFORM_H

/**
 * @defgroup libtizplatform 'libtizplatform' : OS abstraction wrapers and utilities
 *
 * @{
 *
 */

#include "tizmacros.h"
#include "tizlog.h"
#include "tizmem.h"
#include "tizqueue.h"
#include "tizpqueue.h"
#include "tizbuffer.h"
#include "tizvector.h"
#include "tizsync.h"
#include "tizthread.h"
#include "tizuuid.h"
#include "tizomxutils.h"
#include "tizrc.h"
#include "tizsoa.h"
#include "tizev.h"
#include "tizhttp.h"
#include "tizmap.h"
#include "tizlimits.h"
#include "tizprintf.h"
#include "tizshufflelst.h"
#include "tizurltransfer.h"

/** @} */

#endif /* TIZPLATFORM_H */
