%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.2
%% Purpose: Encoding and decoding of the types in PKCS-1.

-module('PKCS-1').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("PKCS-1.hrl").
-asn1_info([{vsn,'5.4.2'},
            {module,'PKCS-1'},
            {options,[{i,"/home/builder/.termux-build/erlang/src/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/home/builder/.termux-build/erlang/src/lib/public_key/asn1"},
 {outdir,"/home/builder/.termux-build/erlang/src/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/home/builder/.termux-build/erlang/src/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_HashAlgorithm/2,
enc_SHA1Parameters/2,
enc_MaskGenAlgorithm/2,
enc_EncodingParameters/2,
enc_PSourceAlgorithm/2,
enc_RSAPrivateKey/2,
'enc_PKCS1-Version'/2,
enc_OtherPrimeInfos/2,
enc_OtherPrimeInfo/2,
'enc_RSAES-OAEP-params'/2,
'enc_RSAES-AlgorithmIdentifier'/2,
'enc_RSASSA-PSS-params'/2,
enc_TrailerField/2,
'enc_RSASSA-AlgorithmIdentifier'/2,
enc_DigestInfo/2,
enc_DigestAlgorithm/2
]).

-export([
dec_HashAlgorithm/2,
dec_SHA1Parameters/2,
dec_MaskGenAlgorithm/2,
dec_EncodingParameters/2,
dec_PSourceAlgorithm/2,
dec_RSAPrivateKey/2,
'dec_PKCS1-Version'/2,
dec_OtherPrimeInfos/2,
dec_OtherPrimeInfo/2,
'dec_RSAES-OAEP-params'/2,
'dec_RSAES-AlgorithmIdentifier'/2,
'dec_RSASSA-PSS-params'/2,
dec_TrailerField/2,
'dec_RSASSA-AlgorithmIdentifier'/2,
dec_DigestInfo/2,
dec_DigestAlgorithm/2
]).

-export([
'getenc_OAEP-PSSDigestAlgorithms'/1,
'getenc_PKCS1-v1-5DigestAlgorithms'/1,
getenc_PKCS1MGFAlgorithms/1,
getenc_PKCS1PSourceAlgorithms/1,
getenc_PKCS1Algorithms/1,
getenc_internal_object_set_argument_6/1,
getenc_internal_object_set_argument_5/1,
getenc_internal_object_set_argument_4/1,
getenc_internal_object_set_argument_3/1,
getenc_internal_object_set_argument_2/1,
getenc_internal_object_set_argument_1/1
]).

-export([
'getdec_OAEP-PSSDigestAlgorithms'/1,
'getdec_PKCS1-v1-5DigestAlgorithms'/1,
getdec_PKCS1MGFAlgorithms/1,
getdec_PKCS1PSourceAlgorithms/1,
getdec_PKCS1Algorithms/1,
getdec_internal_object_set_argument_6/1,
getdec_internal_object_set_argument_5/1,
getdec_internal_object_set_argument_4/1,
getdec_internal_object_set_argument_3/1,
getdec_internal_object_set_argument_2/1,
getdec_internal_object_set_argument_1/1
]).

-export([
'pkcs-1'/0,
rsaEncryption/0,
'id-RSAES-OAEP'/0,
'id-pSpecified'/0,
'id-RSASSA-PSS'/0,
md2WithRSAEncryption/0,
md5WithRSAEncryption/0,
sha1WithRSAEncryption/0,
sha224WithRSAEncryption/0,
sha256WithRSAEncryption/0,
sha384WithRSAEncryption/0,
sha512WithRSAEncryption/0,
'sha512-224WithRSAEncryption'/0,
'sha512-256WithRSAEncryption'/0,
'sha-1WithRSAEncryption'/0,
'id-sha1'/0,
'id-md2'/0,
'id-md5'/0,
'id-hmacWithSHA224'/0,
'id-hmacWithSHA256'/0,
'id-hmacWithSHA384'/0,
'id-hmacWithSHA512'/0,
'id-sha224'/0,
'id-sha256'/0,
'id-sha384'/0,
'id-sha512'/0,
'id-mgf1'/0,
sha1/0,
mgf1SHA1/0,
pSpecifiedEmpty/0,
emptyString/0,
'rSAES-OAEP-Default-Identifier'/0,
'rSASSA-PSS-Default-Identifier'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('HashAlgorithm', Data) -> enc_HashAlgorithm(Data);
encode_disp('SHA1Parameters', Data) -> enc_SHA1Parameters(Data);
encode_disp('MaskGenAlgorithm', Data) -> enc_MaskGenAlgorithm(Data);
encode_disp('EncodingParameters', Data) -> enc_EncodingParameters(Data);
encode_disp('PSourceAlgorithm', Data) -> enc_PSourceAlgorithm(Data);
encode_disp('RSAPrivateKey', Data) -> enc_RSAPrivateKey(Data);
encode_disp('PKCS1-Version', Data) -> 'enc_PKCS1-Version'(Data);
encode_disp('OtherPrimeInfos', Data) -> enc_OtherPrimeInfos(Data);
encode_disp('OtherPrimeInfo', Data) -> enc_OtherPrimeInfo(Data);
encode_disp('RSAES-OAEP-params', Data) -> 'enc_RSAES-OAEP-params'(Data);
encode_disp('RSAES-AlgorithmIdentifier', Data) -> 'enc_RSAES-AlgorithmIdentifier'(Data);
encode_disp('RSASSA-PSS-params', Data) -> 'enc_RSASSA-PSS-params'(Data);
encode_disp('TrailerField', Data) -> enc_TrailerField(Data);
encode_disp('RSASSA-AlgorithmIdentifier', Data) -> 'enc_RSASSA-AlgorithmIdentifier'(Data);
encode_disp('DigestInfo', Data) -> enc_DigestInfo(Data);
encode_disp('DigestAlgorithm', Data) -> enc_DigestAlgorithm(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('HashAlgorithm', Data) -> dec_HashAlgorithm(Data);
decode_disp('SHA1Parameters', Data) -> dec_SHA1Parameters(Data);
decode_disp('MaskGenAlgorithm', Data) -> dec_MaskGenAlgorithm(Data);
decode_disp('EncodingParameters', Data) -> dec_EncodingParameters(Data);
decode_disp('PSourceAlgorithm', Data) -> dec_PSourceAlgorithm(Data);
decode_disp('RSAPrivateKey', Data) -> dec_RSAPrivateKey(Data);
decode_disp('PKCS1-Version', Data) -> 'dec_PKCS1-Version'(Data);
decode_disp('OtherPrimeInfos', Data) -> dec_OtherPrimeInfos(Data);
decode_disp('OtherPrimeInfo', Data) -> dec_OtherPrimeInfo(Data);
decode_disp('RSAES-OAEP-params', Data) -> 'dec_RSAES-OAEP-params'(Data);
decode_disp('RSAES-AlgorithmIdentifier', Data) -> 'dec_RSAES-AlgorithmIdentifier'(Data);
decode_disp('RSASSA-PSS-params', Data) -> 'dec_RSASSA-PSS-params'(Data);
decode_disp('TrailerField', Data) -> dec_TrailerField(Data);
decode_disp('RSASSA-AlgorithmIdentifier', Data) -> 'dec_RSASSA-AlgorithmIdentifier'(Data);
decode_disp('DigestInfo', Data) -> dec_DigestInfo(Data);
decode_disp('DigestAlgorithm', Data) -> dec_DigestAlgorithm(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  HashAlgorithm
%%================================
enc_HashAlgorithm(Val) ->
    enc_HashAlgorithm(Val, [<<48>>]).

enc_HashAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-1':'getenc_internal_object_set_argument_1'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_HashAlgorithm(Tlv) ->
   dec_HashAlgorithm(Tlv, [16]).

dec_HashAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-1':'getdec_internal_object_set_argument_1'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'HashAlgorithm',Term1,Term2},
Res1.


%%================================
%%  SHA1Parameters
%%================================
enc_SHA1Parameters(Val) ->
    enc_SHA1Parameters(Val, [<<5>>]).

enc_SHA1Parameters(Val, TagIn) ->
encode_null(Val, TagIn).


dec_SHA1Parameters(Tlv) ->
   dec_SHA1Parameters(Tlv, [5]).

dec_SHA1Parameters(Tlv, TagIn) ->
decode_null(Tlv, TagIn).



%%================================
%%  MaskGenAlgorithm
%%================================
enc_MaskGenAlgorithm(Val) ->
    enc_MaskGenAlgorithm(Val, [<<48>>]).

enc_MaskGenAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-1':'getenc_internal_object_set_argument_2'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_MaskGenAlgorithm(Tlv) ->
   dec_MaskGenAlgorithm(Tlv, [16]).

dec_MaskGenAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-1':'getdec_internal_object_set_argument_2'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'MaskGenAlgorithm',Term1,Term2},
Res1.


%%================================
%%  EncodingParameters
%%================================
enc_EncodingParameters(Val) ->
    enc_EncodingParameters(Val, [<<4>>]).

enc_EncodingParameters(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_EncodingParameters(Tlv) ->
   dec_EncodingParameters(Tlv, [4]).

dec_EncodingParameters(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  PSourceAlgorithm
%%================================
enc_PSourceAlgorithm(Val) ->
    enc_PSourceAlgorithm(Val, [<<48>>]).

enc_PSourceAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-1':'getenc_internal_object_set_argument_3'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PSourceAlgorithm(Tlv) ->
   dec_PSourceAlgorithm(Tlv, [16]).

dec_PSourceAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-1':'getdec_internal_object_set_argument_3'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PSourceAlgorithm',Term1,Term2},
Res1.


%%================================
%%  RSAPrivateKey
%%================================
enc_RSAPrivateKey(Val) ->
    enc_RSAPrivateKey(Val, [<<48>>]).

enc_RSAPrivateKey(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9,Cindex10} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{'two-prime',0},{multi,1}], [<<2>>]),

%%-------------------------------------------------
%% attribute modulus(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute publicExponent(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

%%-------------------------------------------------
%% attribute privateExponent(4) with type INTEGER
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_integer(Cindex4, [<<2>>]),

%%-------------------------------------------------
%% attribute prime1(5) with type INTEGER
%%-------------------------------------------------
   {EncBytes5,EncLen5} = encode_integer(Cindex5, [<<2>>]),

%%-------------------------------------------------
%% attribute prime2(6) with type INTEGER
%%-------------------------------------------------
   {EncBytes6,EncLen6} = encode_integer(Cindex6, [<<2>>]),

%%-------------------------------------------------
%% attribute exponent1(7) with type INTEGER
%%-------------------------------------------------
   {EncBytes7,EncLen7} = encode_integer(Cindex7, [<<2>>]),

%%-------------------------------------------------
%% attribute exponent2(8) with type INTEGER
%%-------------------------------------------------
   {EncBytes8,EncLen8} = encode_integer(Cindex8, [<<2>>]),

%%-------------------------------------------------
%% attribute coefficient(9) with type INTEGER
%%-------------------------------------------------
   {EncBytes9,EncLen9} = encode_integer(Cindex9, [<<2>>]),

%%-------------------------------------------------
%% attribute otherPrimeInfos(10)   External PKCS-1:OtherPrimeInfos OPTIONAL
%%-------------------------------------------------
   {EncBytes10,EncLen10} =  case Cindex10 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OtherPrimeInfos'(Cindex10, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9, EncBytes10],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9 + EncLen10,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RSAPrivateKey(Tlv) ->
   dec_RSAPrivateKey(Tlv, [16]).

dec_RSAPrivateKey(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{'two-prime',0},{multi,1}])
end
,

%%-------------------------------------------------
%% attribute modulus(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute publicExponent(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_integer(V3, [2]),

%%-------------------------------------------------
%% attribute privateExponent(4) with type INTEGER
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_integer(V4, [2]),

%%-------------------------------------------------
%% attribute prime1(5) with type INTEGER
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = decode_integer(V5, [2]),

%%-------------------------------------------------
%% attribute prime2(6) with type INTEGER
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = decode_integer(V6, [2]),

%%-------------------------------------------------
%% attribute exponent1(7) with type INTEGER
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = decode_integer(V7, [2]),

%%-------------------------------------------------
%% attribute exponent2(8) with type INTEGER
%%-------------------------------------------------
[V8|Tlv9] = Tlv8, 
Term8 = decode_integer(V8, [2]),

%%-------------------------------------------------
%% attribute coefficient(9) with type INTEGER
%%-------------------------------------------------
[V9|Tlv10] = Tlv9, 
Term9 = decode_integer(V9, [2]),

%%-------------------------------------------------
%% attribute otherPrimeInfos(10)   External PKCS-1:OtherPrimeInfos OPTIONAL
%%-------------------------------------------------
{Term10,Tlv11} = case Tlv10 of
[{16,V10}|TempTlv11] ->
    {'dec_OtherPrimeInfos'(V10, []), TempTlv11};
    _ ->
        { asn1_NOVALUE, Tlv10}
end,

case Tlv11 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv11}}}) % extra fields not allowed
end,
Res1 = {'RSAPrivateKey',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9,Term10},
Res1.


%%================================
%%  PKCS1-Version
%%================================
'enc_PKCS1-Version'(Val) ->
    'enc_PKCS1-Version'(Val, [<<2>>]).

'enc_PKCS1-Version'(Val, TagIn) ->
encode_integer(Val, [{'two-prime',0},{multi,1}], TagIn).


'dec_PKCS1-Version'(Tlv) ->
   'dec_PKCS1-Version'(Tlv, [2]).

'dec_PKCS1-Version'(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{'two-prime',0},{multi,1}])
end
.



%%================================
%%  OtherPrimeInfos
%%================================
enc_OtherPrimeInfos(Val) ->
    enc_OtherPrimeInfos(Val, [<<48>>]).

enc_OtherPrimeInfos(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_OtherPrimeInfos_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_OtherPrimeInfos_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_OtherPrimeInfos_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_OtherPrimeInfo'(H, [<<48>>]),
   'enc_OtherPrimeInfos_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_OtherPrimeInfos(Tlv) ->
   dec_OtherPrimeInfos(Tlv, [16]).

dec_OtherPrimeInfos(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_OtherPrimeInfo'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  OtherPrimeInfo
%%================================
enc_OtherPrimeInfo(Val) ->
    enc_OtherPrimeInfo(Val, [<<48>>]).

enc_OtherPrimeInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute prime(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute exponent(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute coefficient(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OtherPrimeInfo(Tlv) ->
   dec_OtherPrimeInfo(Tlv, [16]).

dec_OtherPrimeInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute prime(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute exponent(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute coefficient(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_integer(V3, [2]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'OtherPrimeInfo',Term1,Term2,Term3},
Res1.


%%================================
%%  RSAES-OAEP-params
%%================================
'enc_RSAES-OAEP-params'(Val) ->
    'enc_RSAES-OAEP-params'(Val, [<<48>>]).

'enc_RSAES-OAEP-params'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute hashAlgorithm(1)   External PKCS-1:HashAlgorithm DEFAULT = {'HashAlgorithm',{1,3,14,3,2,26},'NULL'}
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_1(Cindex1) of
true -> {[],0};
false ->
'enc_HashAlgorithm'(Cindex1, [<<48>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute maskGenAlgorithm(2)   External PKCS-1:MaskGenAlgorithm DEFAULT = {'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}}
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
'enc_MaskGenAlgorithm'(Cindex2, [<<48>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute pSourceAlgorithm(3)   External PKCS-1:PSourceAlgorithm DEFAULT = {'PSourceAlgorithm',{1,2,840,113549,1,1,9},<<>>}
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case is_default_3(Cindex3) of
true -> {[],0};
false ->
'enc_PSourceAlgorithm'(Cindex3, [<<48>>,<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RSAES-OAEP-params'(Tlv) ->
   'dec_RSAES-OAEP-params'(Tlv, [16]).

'dec_RSAES-OAEP-params'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute hashAlgorithm(1)   External PKCS-1:HashAlgorithm DEFAULT = {'HashAlgorithm',{1,3,14,3,2,26},'NULL'}
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_HashAlgorithm'(V1, [16]), TempTlv2};
    _ ->
        {{'HashAlgorithm',{1,3,14,3,2,26},'NULL'},Tlv1}
end,

%%-------------------------------------------------
%% attribute maskGenAlgorithm(2)   External PKCS-1:MaskGenAlgorithm DEFAULT = {'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}}
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_MaskGenAlgorithm'(V2, [16]), TempTlv3};
    _ ->
        {{'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}},Tlv2}
end,

%%-------------------------------------------------
%% attribute pSourceAlgorithm(3)   External PKCS-1:PSourceAlgorithm DEFAULT = {'PSourceAlgorithm',{1,2,840,113549,1,1,9},<<>>}
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_PSourceAlgorithm'(V3, [16]), TempTlv4};
    _ ->
        {{'PSourceAlgorithm',{1,2,840,113549,1,1,9},<<>>},Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'RSAES-OAEP-params',Term1,Term2,Term3},
Res1.


%%================================
%%  RSAES-AlgorithmIdentifier
%%================================
'enc_RSAES-AlgorithmIdentifier'(Val) ->
    'enc_RSAES-AlgorithmIdentifier'(Val, [<<48>>]).

'enc_RSAES-AlgorithmIdentifier'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-1':'getenc_internal_object_set_argument_4'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RSAES-AlgorithmIdentifier'(Tlv) ->
   'dec_RSAES-AlgorithmIdentifier'(Tlv, [16]).

'dec_RSAES-AlgorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-1':'getdec_internal_object_set_argument_4'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RSAES-AlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  RSASSA-PSS-params
%%================================
'enc_RSASSA-PSS-params'(Val) ->
    'enc_RSASSA-PSS-params'(Val, [<<48>>]).

'enc_RSASSA-PSS-params'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute hashAlgorithm(1)   External PKCS-1:HashAlgorithm DEFAULT = {'HashAlgorithm',{1,3,14,3,2,26},'NULL'}
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_4(Cindex1) of
true -> {[],0};
false ->
'enc_HashAlgorithm'(Cindex1, [<<48>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute maskGenAlgorithm(2)   External PKCS-1:MaskGenAlgorithm DEFAULT = {'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}}
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_5(Cindex2) of
true -> {[],0};
false ->
'enc_MaskGenAlgorithm'(Cindex2, [<<48>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute saltLength(3) with type INTEGER DEFAULT = 20
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case is_default_6(Cindex3) of
true -> {[],0};
false ->
encode_integer(Cindex3, [<<2>>,<<162>>])
       end,

%%-------------------------------------------------
%% attribute trailerField(4) with type INTEGER DEFAULT = 1
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case is_default_7(Cindex4) of
true -> {[],0};
false ->
encode_integer(Cindex4, [{trailerFieldBC,1}], [<<2>>,<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RSASSA-PSS-params'(Tlv) ->
   'dec_RSASSA-PSS-params'(Tlv, [16]).

'dec_RSASSA-PSS-params'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute hashAlgorithm(1)   External PKCS-1:HashAlgorithm DEFAULT = {'HashAlgorithm',{1,3,14,3,2,26},'NULL'}
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_HashAlgorithm'(V1, [16]), TempTlv2};
    _ ->
        {{'HashAlgorithm',{1,3,14,3,2,26},'NULL'},Tlv1}
end,

%%-------------------------------------------------
%% attribute maskGenAlgorithm(2)   External PKCS-1:MaskGenAlgorithm DEFAULT = {'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}}
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_MaskGenAlgorithm'(V2, [16]), TempTlv3};
    _ ->
        {{'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}},Tlv2}
end,

%%-------------------------------------------------
%% attribute saltLength(3) with type INTEGER DEFAULT = 20
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_integer(V3, [2]), TempTlv4};
    _ ->
        {20,Tlv3}
end,

%%-------------------------------------------------
%% attribute trailerField(4) with type INTEGER DEFAULT = 1
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {begin
Val1 = decode_integer(V4, [2]),
number2name(Val1, [{trailerFieldBC,1}])
end
, TempTlv5};
    _ ->
        {1,Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'RSASSA-PSS-params',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  TrailerField
%%================================
enc_TrailerField(Val) ->
    enc_TrailerField(Val, [<<2>>]).

enc_TrailerField(Val, TagIn) ->
encode_integer(Val, [{trailerFieldBC,1}], TagIn).


dec_TrailerField(Tlv) ->
   dec_TrailerField(Tlv, [2]).

dec_TrailerField(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{trailerFieldBC,1}])
end
.



%%================================
%%  RSASSA-AlgorithmIdentifier
%%================================
'enc_RSASSA-AlgorithmIdentifier'(Val) ->
    'enc_RSASSA-AlgorithmIdentifier'(Val, [<<48>>]).

'enc_RSASSA-AlgorithmIdentifier'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-1':'getenc_internal_object_set_argument_5'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RSASSA-AlgorithmIdentifier'(Tlv) ->
   'dec_RSASSA-AlgorithmIdentifier'(Tlv, [16]).

'dec_RSASSA-AlgorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-1':'getdec_internal_object_set_argument_5'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RSASSA-AlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  DigestInfo
%%================================
enc_DigestInfo(Val) ->
    enc_DigestInfo(Val, [<<48>>]).

enc_DigestInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute digestAlgorithm(1)   External PKCS-1:DigestAlgorithm
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_DigestAlgorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute digest(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DigestInfo(Tlv) ->
   dec_DigestInfo(Tlv, [16]).

dec_DigestInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute digestAlgorithm(1)   External PKCS-1:DigestAlgorithm
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_DigestAlgorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute digest(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'DigestInfo',Term1,Term2},
Res1.


%%================================
%%  DigestAlgorithm
%%================================
enc_DigestAlgorithm(Val) ->
    enc_DigestAlgorithm(Val, [<<48>>]).

enc_DigestAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKCS-1':'getenc_internal_object_set_argument_6'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DigestAlgorithm(Tlv) ->
   dec_DigestAlgorithm(Tlv, [16]).

dec_DigestAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKCS-1':'getdec_internal_object_set_argument_6'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'DigestAlgorithm',Term1,Term2},
Res1.
'pkcs-1'() ->
{1,2,840,113549,1,1}.

rsaEncryption() ->
{1,2,840,113549,1,1,1}.

'id-RSAES-OAEP'() ->
{1,2,840,113549,1,1,7}.

'id-pSpecified'() ->
{1,2,840,113549,1,1,9}.

'id-RSASSA-PSS'() ->
{1,2,840,113549,1,1,10}.

md2WithRSAEncryption() ->
{1,2,840,113549,1,1,2}.

md5WithRSAEncryption() ->
{1,2,840,113549,1,1,4}.

sha1WithRSAEncryption() ->
{1,2,840,113549,1,1,5}.

sha224WithRSAEncryption() ->
{1,2,840,113549,1,1,14}.

sha256WithRSAEncryption() ->
{1,2,840,113549,1,1,11}.

sha384WithRSAEncryption() ->
{1,2,840,113549,1,1,12}.

sha512WithRSAEncryption() ->
{1,2,840,113549,1,1,13}.

'sha512-224WithRSAEncryption'() ->
{1,2,840,113549,1,1,15}.

'sha512-256WithRSAEncryption'() ->
{1,2,840,113549,1,1,16}.

'sha-1WithRSAEncryption'() ->
{1,3,14,3,2,29}.

'id-sha1'() ->
{1,3,14,3,2,26}.

'id-md2'() ->
{1,2,840,113549,2,2}.

'id-md5'() ->
{1,2,840,113549,2,5}.

'id-hmacWithSHA224'() ->
{1,2,840,113549,2,8}.

'id-hmacWithSHA256'() ->
{1,2,840,113549,2,9}.

'id-hmacWithSHA384'() ->
{1,2,840,113549,2,10}.

'id-hmacWithSHA512'() ->
{1,2,840,113549,2,11}.

'id-sha224'() ->
{2,16,840,1,101,3,4,2,4}.

'id-sha256'() ->
{2,16,840,1,101,3,4,2,1}.

'id-sha384'() ->
{2,16,840,1,101,3,4,2,2}.

'id-sha512'() ->
{2,16,840,1,101,3,4,2,3}.

'id-mgf1'() ->
{1,2,840,113549,1,1,8}.

sha1() ->
{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}.

mgf1SHA1() ->
{'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'Externalvaluereference',255,'PKCS-1',sha1}}.

pSpecifiedEmpty() ->
{'PSourceAlgorithm',{1,2,840,113549,1,1,9},<<>>}.

emptyString() ->
<<>>.

'rSAES-OAEP-Default-Identifier'() ->
{'RSAES-AlgorithmIdentifier',{1,2,840,113549,1,1,7},{'RSAES-OAEP-params',{'Externalvaluereference',354,'PKCS-1',sha1},{'Externalvaluereference',355,'PKCS-1',mgf1SHA1},{'Externalvaluereference',356,'PKCS-1',pSpecifiedEmpty}}}.

'rSASSA-PSS-Default-Identifier'() ->
{'RSASSA-AlgorithmIdentifier',{1,2,840,113549,1,1,10},{'RSASSA-PSS-params',{'Externalvaluereference',389,'PKCS-1',sha1},{'Externalvaluereference',390,'PKCS-1',mgf1SHA1},20,1}}.




%%================================
%%  OAEP-PSSDigestAlgorithms
%%================================
'getenc_OAEP-PSSDigestAlgorithms'({1,3,14,3,2,26}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_OAEP-PSSDigestAlgorithms'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_OAEP-PSSDigestAlgorithms'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_OAEP-PSSDigestAlgorithms'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_OAEP-PSSDigestAlgorithms'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_OAEP-PSSDigestAlgorithms'({1,3,14,3,2,26}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_OAEP-PSSDigestAlgorithms'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_OAEP-PSSDigestAlgorithms'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_OAEP-PSSDigestAlgorithms'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_OAEP-PSSDigestAlgorithms'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PKCS1-v1-5DigestAlgorithms
%%================================
'getenc_PKCS1-v1-5DigestAlgorithms'({1,2,840,113549,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_PKCS1-v1-5DigestAlgorithms'({1,2,840,113549,2,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_PKCS1-v1-5DigestAlgorithms'({1,3,14,3,2,26}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_PKCS1-v1-5DigestAlgorithms'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_PKCS1-v1-5DigestAlgorithms'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_PKCS1-v1-5DigestAlgorithms'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
'getenc_PKCS1-v1-5DigestAlgorithms'(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

'getdec_PKCS1-v1-5DigestAlgorithms'({1,2,840,113549,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1-v1-5DigestAlgorithms'({1,2,840,113549,2,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1-v1-5DigestAlgorithms'({1,3,14,3,2,26}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1-v1-5DigestAlgorithms'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1-v1-5DigestAlgorithms'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1-v1-5DigestAlgorithms'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1-v1-5DigestAlgorithms'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  PKCS1MGFAlgorithms
%%================================
getenc_PKCS1MGFAlgorithms({1,2,840,113549,1,1,8}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_HashAlgorithm'(Val)
      end
   end;
getenc_PKCS1MGFAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PKCS1MGFAlgorithms'({1,2,840,113549,1,1,8}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_HashAlgorithm'(Bytes)
      end
   end;
getdec_PKCS1MGFAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PKCS1PSourceAlgorithms
%%================================
getenc_PKCS1PSourceAlgorithms({1,2,840,113549,1,1,9}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_EncodingParameters'(Val)
      end
   end;
getenc_PKCS1PSourceAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PKCS1PSourceAlgorithms'({1,2,840,113549,1,1,9}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_EncodingParameters'(Bytes)
      end
   end;
getdec_PKCS1PSourceAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PKCS1Algorithms
%%================================
getenc_PKCS1Algorithms({1,2,840,113549,1,1,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RSAES-OAEP-params'(Val)
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,9}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_EncodingParameters'(Val)
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RSASSA-PSS-params'(Val)
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,11}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,12}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms({1,2,840,113549,1,1,13}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_PKCS1Algorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RSAES-OAEP-params'(Bytes)
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,9}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_EncodingParameters'(Bytes)
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RSASSA-PSS-params'(Bytes)
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,11}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,12}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_PKCS1Algorithms'({1,2,840,113549,1,1,13}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
getdec_PKCS1Algorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_6
%%================================
getenc_internal_object_set_argument_6({1,2,840,113549,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_6({1,2,840,113549,2,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_6({1,3,14,3,2,26}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_6({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_6({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_6({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_6(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

'getdec_internal_object_set_argument_6'({1,2,840,113549,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_6'({1,2,840,113549,2,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_6'({1,3,14,3,2,26}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_6'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_6'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_6'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_6'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  internal_object_set_argument_5
%%================================
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RSAES-OAEP-params'(Val)
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,9}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_EncodingParameters'(Val)
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RSASSA-PSS-params'(Val)
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,11}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,12}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5({1,2,840,113549,1,1,13}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_5(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RSAES-OAEP-params'(Bytes)
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,9}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_EncodingParameters'(Bytes)
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RSASSA-PSS-params'(Bytes)
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,11}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,12}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_5'({1,2,840,113549,1,1,13}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
getdec_internal_object_set_argument_5(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_4
%%================================
getenc_internal_object_set_argument_4({1,2,840,113549,1,1,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_4({1,2,840,113549,1,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_4({1,2,840,113549,1,1,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_4({1,2,840,113549,1,1,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_4({1,2,840,113549,1,1,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RSAES-OAEP-params'(Val)
      end
   end;
getenc_internal_object_set_argument_4({1,2,840,113549,1,1,9}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_EncodingParameters'(Val)
      end
   end;
getenc_internal_object_set_argument_4({1,2,840,113549,1,1,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RSASSA-PSS-params'(Val)
      end
   end;
getenc_internal_object_set_argument_4({1,2,840,113549,1,1,11}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_4({1,2,840,113549,1,1,12}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_4({1,2,840,113549,1,1,13}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_4(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_4'({1,2,840,113549,1,1,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_4'({1,2,840,113549,1,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_4'({1,2,840,113549,1,1,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_4'({1,2,840,113549,1,1,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_4'({1,2,840,113549,1,1,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RSAES-OAEP-params'(Bytes)
      end
   end;
'getdec_internal_object_set_argument_4'({1,2,840,113549,1,1,9}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_EncodingParameters'(Bytes)
      end
   end;
'getdec_internal_object_set_argument_4'({1,2,840,113549,1,1,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RSASSA-PSS-params'(Bytes)
      end
   end;
'getdec_internal_object_set_argument_4'({1,2,840,113549,1,1,11}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_4'({1,2,840,113549,1,1,12}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_4'({1,2,840,113549,1,1,13}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
getdec_internal_object_set_argument_4(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_3
%%================================
getenc_internal_object_set_argument_3({1,2,840,113549,1,1,9}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_EncodingParameters'(Val)
      end
   end;
getenc_internal_object_set_argument_3(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_3'({1,2,840,113549,1,1,9}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_EncodingParameters'(Bytes)
      end
   end;
getdec_internal_object_set_argument_3(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,8}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_HashAlgorithm'(Val)
      end
   end;
getenc_internal_object_set_argument_2(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,8}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_HashAlgorithm'(Bytes)
      end
   end;
getdec_internal_object_set_argument_2(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_1
%%================================
getenc_internal_object_set_argument_1({1,3,14,3,2,26}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_1({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_1({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_1({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_1(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_1'({1,3,14,3,2,26}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_1'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_1'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_1'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            decode_null(Bytes, [5])
      end
   end;
getdec_internal_object_set_argument_1(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Value) ->
try is_default_cs_8(Value) of
_ -> true
catch throw:false -> false
end.


is_default_2(asn1_DEFAULT) ->
true;
is_default_2(Value) ->
try is_default_cs_9(Value) of
_ -> true
catch throw:false -> false
end.


is_default_3(asn1_DEFAULT) ->
true;
is_default_3(Value) ->
try is_default_cs_10(Value) of
_ -> true
catch throw:false -> false
end.


is_default_4(asn1_DEFAULT) ->
true;
is_default_4(Value) ->
try is_default_cs_8(Value) of
_ -> true
catch throw:false -> false
end.


is_default_5(asn1_DEFAULT) ->
true;
is_default_5(Value) ->
try is_default_cs_9(Value) of
_ -> true
catch throw:false -> false
end.


is_default_6(asn1_DEFAULT) ->
true;
is_default_6(Def) when Def =:= 20 ->
true;
is_default_6(_) ->
false.


is_default_7(asn1_DEFAULT) ->
true;
is_default_7(Value) ->
try check_int(Value, 1, [{trailerFieldBC,1}]) of
_ -> true
catch throw:false -> false
end.


is_default_cs_10(Value) ->
case Value of
{'PSourceAlgorithm',
E1,
<<>>} ->
check_objectidentifier(E1, {[[1,iso],[2,'member-body']],[840,113549,1,1,9]});
_ ->
throw(false)
end.

is_default_cs_8(Value) ->
case Value of
{'HashAlgorithm',
E1,
'NULL'} ->
check_objectidentifier(E1, {[[1,iso],[3,'identified-organization']],[14,3,2,26]});
_ ->
throw(false)
end.

is_default_cs_9(Value) ->
case Value of
{'MaskGenAlgorithm',
E1,
{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}} ->
check_objectidentifier(E1, {[[1,iso],[2,'member-body']],[840,113549,1,1,8]});
_ ->
throw(false)
end.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

check_int(Value, Value, _) when is_integer(Value) ->
    true;
check_int(Value, DefValue, NNL) when is_atom(Value) ->
    case lists:keyfind(Value, 1, NNL) of
        {_, DefValue} ->
            true;
        _ ->
            throw(false)
    end;
check_int(_, _, _) ->
    throw(false).

check_objectidentifier(Value, {Prefix, Tail}) when is_tuple(Value) ->
    check_oid(tuple_to_list(Value), Prefix, Tail);
check_objectidentifier(_, _) ->
    throw(false).

check_oid([H | T], [K | Ks], Tail) ->
    case lists:member(H, K) of
        false ->
            throw(false);
        true ->
            check_oid(T, Ks, Tail)
    end;
check_oid(Tail, [], Tail) ->
    true;
check_oid(_, _, _) ->
    throw(false).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error, {asn1, {decode_null, Val}}})
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, NamedNumberList, Tag) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedNumberList) of
        {_, NewVal} ->
            encode_tags(Tag, encode_integer(NewVal));
        _ ->
            exit({error, {asn1, {encode_integer_namednumber, Val}}})
    end;
encode_integer(Val, _NamedNumberList, Tag) ->
    encode_tags(Tag, encode_integer(Val)).

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

number2name(Int, NamedNumberList) ->
    case lists:keyfind(Int, 2, NamedNumberList) of
        {NamedVal, _} ->
            NamedVal;
        _ ->
            Int
    end.
