/**
 * PANDA 3D SOFTWARE
 * Copyright (c) Carnegie Mellon University.  All rights reserved.
 *
 * All use of this software is subject to the terms of the revised BSD
 * license.  You should have received a copy of this license along
 * with this source code in a file named "LICENSE."
 *
 * @file transparencyAttrib.I
 * @author drose
 * @date 2002-02-28
 */

/**
 * Use TransparencyAttrib::make() to construct a new TransparencyAttrib
 * object.
 */
INLINE TransparencyAttrib::
TransparencyAttrib(TransparencyAttrib::Mode mode) :
  _mode(mode)
{
}

/**
 * Returns the transparency mode.
 */
INLINE TransparencyAttrib::Mode TransparencyAttrib::
get_mode() const {
  return _mode;
}
