/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.Serializable;
import java.util.Objects;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.TikzFontDistortion;
import net.sourceforge.plantuml.klimt.awt.XAffineTransform;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.text.SvgCharSizeHack;
import net.sourceforge.plantuml.utils.Log;

public final class FileFormatOption
implements Serializable {
    private final FileFormat fileFormat;
    private boolean withMetadata;
    private final boolean useRedForError;
    private final String svgLinkTarget;
    private final String hoverColor;
    private final TikzFontDistortion tikzFontDistortion;
    private final double scale;
    private final String preserveAspectRatio;
    private final String watermark;
    private final ColorMapper colorMapper;
    private boolean debugsvek = false;

    public double getScaleCoef() {
        return this.scale;
    }

    public FileFormatOption(FileFormat fileFormat) {
        this(fileFormat, true, false, null, false, null, TikzFontDistortion.getDefault(), 1.0, null, null, ColorMapper.IDENTITY);
    }

    public FileFormatOption(FileFormat fileFormat, boolean withMetadata) {
        this(fileFormat, withMetadata, false, null, false, null, TikzFontDistortion.getDefault(), 1.0, null, null, ColorMapper.IDENTITY);
    }

    private FileFormatOption(FileFormat fileFormat, boolean withMetadata, boolean useRedForError, String svgLinkTarget, boolean debugsvek, String hoverColor, TikzFontDistortion tikzFontDistortion, double scale, String preserveAspectRatio, String watermark, ColorMapper colorMapper) {
        this.hoverColor = hoverColor;
        this.watermark = watermark;
        this.fileFormat = fileFormat;
        this.withMetadata = withMetadata;
        this.useRedForError = useRedForError;
        this.svgLinkTarget = svgLinkTarget;
        this.debugsvek = debugsvek;
        this.tikzFontDistortion = Objects.requireNonNull(tikzFontDistortion);
        this.scale = scale;
        this.preserveAspectRatio = preserveAspectRatio;
        this.colorMapper = colorMapper;
    }

    public StringBounder getDefaultStringBounder(SvgCharSizeHack charSizeHack) {
        return this.fileFormat.getDefaultStringBounder(this.tikzFontDistortion, charSizeHack);
    }

    public String getSvgLinkTarget() {
        return this.svgLinkTarget;
    }

    public final boolean isWithMetadata() {
        return this.withMetadata;
    }

    public final String getPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    public FileFormatOption withUseRedForError() {
        return new FileFormatOption(this.fileFormat, this.withMetadata, true, this.svgLinkTarget, this.debugsvek, this.hoverColor, this.tikzFontDistortion, this.scale, this.preserveAspectRatio, this.watermark, this.colorMapper);
    }

    public FileFormatOption withTikzFontDistortion(TikzFontDistortion tikzFontDistortion) {
        return new FileFormatOption(this.fileFormat, this.withMetadata, true, this.svgLinkTarget, this.debugsvek, this.hoverColor, tikzFontDistortion, this.scale, this.preserveAspectRatio, this.watermark, this.colorMapper);
    }

    public FileFormatOption withSvgLinkTarget(String svgLinkTarget) {
        return new FileFormatOption(this.fileFormat, this.withMetadata, this.useRedForError, svgLinkTarget, this.debugsvek, this.hoverColor, this.tikzFontDistortion, this.scale, this.preserveAspectRatio, this.watermark, this.colorMapper);
    }

    public FileFormatOption withPreserveAspectRatio(String preserveAspectRatio) {
        return new FileFormatOption(this.fileFormat, this.withMetadata, this.useRedForError, this.svgLinkTarget, this.debugsvek, this.hoverColor, this.tikzFontDistortion, this.scale, preserveAspectRatio, this.watermark, this.colorMapper);
    }

    public FileFormatOption withHoverColor(String hoverColor) {
        return new FileFormatOption(this.fileFormat, this.withMetadata, this.useRedForError, this.svgLinkTarget, this.debugsvek, hoverColor, this.tikzFontDistortion, this.scale, this.preserveAspectRatio, this.watermark, this.colorMapper);
    }

    public FileFormatOption withScale(double scale) {
        return new FileFormatOption(this.fileFormat, this.withMetadata, this.useRedForError, this.svgLinkTarget, this.debugsvek, this.hoverColor, this.tikzFontDistortion, scale, this.preserveAspectRatio, this.watermark, this.colorMapper);
    }

    public FileFormatOption withWartermark(String watermark) {
        return new FileFormatOption(this.fileFormat, this.withMetadata, this.useRedForError, this.svgLinkTarget, this.debugsvek, this.hoverColor, this.tikzFontDistortion, this.scale, this.preserveAspectRatio, watermark, this.colorMapper);
    }

    public FileFormatOption withColorMapper(ColorMapper colorMapper) {
        return new FileFormatOption(this.fileFormat, this.withMetadata, this.useRedForError, this.svgLinkTarget, this.debugsvek, this.hoverColor, this.tikzFontDistortion, this.scale, this.preserveAspectRatio, this.watermark, colorMapper);
    }

    public String toString() {
        return this.fileFormat.toString();
    }

    public final FileFormat getFileFormat() {
        return this.fileFormat;
    }

    @Deprecated
    public XAffineTransform getAffineTransform() {
        return null;
    }

    public final boolean isUseRedForError() {
        return this.useRedForError;
    }

    public void setDebugSvek(boolean debugsvek) {
        Log.info(() -> "setDebugSvek: " + debugsvek);
        this.debugsvek = debugsvek;
    }

    public boolean isDebugSvek() {
        return this.debugsvek;
    }

    public final String getHoverColor() {
        return this.hoverColor;
    }

    public void hideMetadata() {
        this.withMetadata = false;
    }

    public final TikzFontDistortion getTikzFontDistortion() {
        return this.tikzFontDistortion;
    }

    public final String getWatermark() {
        return this.watermark;
    }

    public ColorMapper getColorMapper() {
        return this.colorMapper;
    }
}

