/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.SourceFileReaderAbstract;
import net.sourceforge.plantuml.file.SuggestedFile;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.utils.Log;

public class SourceFileReader
extends SourceFileReaderAbstract
implements ISourceFileReader {
    private File outputDirectory;

    public SourceFileReader(boolean ignoreSuggestedName, File file) throws IOException {
        this(ignoreSuggestedName, file, file.getAbsoluteFile().getParentFile());
    }

    public SourceFileReader(boolean ignoreSuggestedName, File file, File outputDirectory, String charset) throws IOException {
        this(ignoreSuggestedName, Defines.createWithFileName(file), file, outputDirectory, Collections.emptyList(), charset, new FileFormatOption(FileFormat.PNG));
    }

    public SourceFileReader(boolean ignoreSuggestedName, File file, File outputDirectory) throws IOException {
        this(ignoreSuggestedName, Defines.createWithFileName(file), file, outputDirectory, Collections.emptyList(), null, new FileFormatOption(FileFormat.PNG));
    }

    public SourceFileReader(boolean ignoreSuggestedName, File file, File outputDirectory, FileFormatOption fileFormatOption) throws IOException {
        this(ignoreSuggestedName, Defines.createWithFileName(file), file, outputDirectory, Collections.emptyList(), null, fileFormatOption);
    }

    public SourceFileReader(boolean ignoreSuggestedName, Defines defines, File file, File outputDirectory, List<String> config, String charset, FileFormatOption fileFormatOption) throws IOException {
        super(ignoreSuggestedName, file, fileFormatOption, defines, config, charset);
        FileSystem.getInstance().setCurrentDir(SFile.fromFile(file.getAbsoluteFile().getParentFile()));
        if (outputDirectory == null) {
            outputDirectory = file.getAbsoluteFile().getParentFile();
        } else if (!outputDirectory.isAbsolute()) {
            outputDirectory = FileSystem.getInstance().getFile(outputDirectory.getPath()).conv();
        }
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        this.outputDirectory = outputDirectory;
    }

    private File getDirIfDirectory(String newName) throws FileNotFoundException {
        File f;
        String newName2 = newName;
        Log.info(() -> "Checking=" + newName2);
        if (this.endsWithSlashOrAntislash(newName)) {
            File f2;
            Log.info(() -> "It ends with / so it looks like a directory");
            newName = newName.substring(0, newName.length() - 1);
            File f22 = f2 = new File(newName);
            Log.info(() -> "f=" + String.valueOf(f22));
            if (!f2.isAbsolute()) {
                Log.info(() -> "It's relative, so let's change it");
                File f3 = f2 = new File(this.outputDirectory, newName);
                Log.info(() -> "f=" + String.valueOf(f3));
            }
            if (!f2.exists()) {
                Log.info(() -> "It does not exist: let's create it");
                try {
                    f2.mkdirs();
                }
                catch (Exception e) {
                    Log.info(() -> "Error " + String.valueOf(e));
                }
                if (f2.exists() && f2.isDirectory()) {
                    Log.info(() -> "Creation ok");
                    return f2;
                }
                Log.info(() -> "We cannot create it");
            } else if (!f2.isDirectory()) {
                Log.info(() -> "It exists, but is not a directory: we ignore it");
                return null;
            }
            return f2;
        }
        File f4 = f = new File(newName);
        Log.info(() -> "f=" + String.valueOf(f4));
        if (!f.isAbsolute()) {
            Log.info(() -> "Relative, so let's change it");
            File f5 = f = new File(this.outputDirectory, newName);
            Log.info(() -> "f=" + String.valueOf(f5));
        }
        if (f.exists() && f.isDirectory()) {
            Log.info(() -> "It's an existing directory");
            return f;
        }
        Log.info(() -> "It's not a directory");
        return null;
    }

    @Override
    protected SuggestedFile getSuggestedFile(BlockUml blockUml) throws FileNotFoundException {
        SuggestedFile suggested;
        String newName;
        String string = newName = this.ignoreSuggestedName ? null : blockUml.getFileOrDirname();
        if (newName == null) {
            suggested = this.getSuggestedFile(this.outputDirectory, this.getFileName());
        } else {
            Log.info(() -> "name from block=" + newName);
            File dir = this.getDirIfDirectory(newName);
            if (dir == null) {
                Log.info(() -> newName + " is not taken as a directory");
                suggested = SuggestedFile.fromOutputFile(new File(this.outputDirectory, newName), this.getFileFormatOption().getFileFormat(), 0);
            } else {
                Log.info(() -> "We are going to create files in directory " + String.valueOf(dir));
                suggested = SuggestedFile.fromOutputFile(new File(dir, this.getFileName()), this.getFileFormatOption().getFileFormat(), 0);
            }
        }
        Log.info(() -> "We are going to put data in " + String.valueOf(suggested));
        suggested.getParentFile().mkdirs();
        return suggested;
    }
}

