/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines3;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereogroup;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.warning.Warning;

public class CommandActivityLong3
extends CommandMultilines3<ActivityDiagram3> {
    private static final IRegex END = new RegexConcat(new RegexLeaf(1, "TEXT", "(.*)"), new RegexLeaf(";"), RegexLeaf.spaceZeroOrMore(), Stereogroup.optionalStereogroup(), RegexLeaf.end());

    public CommandActivityLong3() {
        super(CommandActivityLong3.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.NONE, END);
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandActivityLong3.class.getName(), RegexLeaf.start(), CommandActivityLong3.color().getRegex(), new RegexLeaf(":"), new RegexLeaf(1, "DATA", "(.*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(ActivityDiagram3 diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.removeEmptyColumns();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        RegexResult lineLast = this.getEndingPattern().matcher(lines.getLast().getString());
        if (line0.get("COLOR", 0) != null) {
            diagram.addWarning(new Warning("This syntax is deprecated, you must add <<" + line0.get("COLOR", 0) + ">> at the end of the line, after the ';'"));
        }
        Stereogroup stereogroup = Stereogroup.build(lineLast);
        Stereotype stereotype = stereogroup.buildStereotype();
        Colors colors = stereogroup.getColors(diagram.getSkinParam().getIHtmlColorSet());
        BoxStyle style = stereogroup.getBoxStyle();
        lines = lines.removeStartingAndEnding(line0.get("DATA", 0), 0);
        lines = lines.overrideLastLine(lineLast.get("TEXT", 0));
        return diagram.addActivity(lines.toDisplay(), style, null, colors, stereotype);
    }
}

