/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Sheet;
import net.sourceforge.plantuml.klimt.creole.SheetBlock1;
import net.sourceforge.plantuml.klimt.creole.SheetBlock2;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.skin.SkinParamColors;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.utils.PatchUtils;

public class FtileBoxOld
extends AbstractFtile {
    private final TextBlock tb;
    private double roundCorner = 25.0;
    private final double shadowing;
    private final HorizontalAlignment horizontalAlignment;
    private double minimumWidth = 0.0;
    private final LinkRendering inRendering;
    private final Swimlane swimlane;
    private final BoxStyle boxStyle;
    private final HColor borderColor;
    private final HColor backColor;
    private final Style style;
    private final String print;

    public static StyleSignatureBasic getDefaultStyleDefinitionActivity() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public static StyleSignatureBasic getDefaultStyleDefinitionArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    public final LinkRendering getInLinkRendering() {
        return this.inRendering;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return PatchUtils.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    public static TextBlock createWbs(Style style, ISkinParam skinParam, Display label) {
        Style styleArrow = style;
        return new FtileBoxOld(skinParam, label, null, BoxStyle.PLAIN, style, styleArrow);
    }

    public static TextBlock createMindMap(Style style, ISkinParam skinParam, Display label) {
        return new FtileBoxOld(skinParam, label, null, BoxStyle.PLAIN, style, style);
    }

    private FtileBoxOld(ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle, Style style, Style styleArrow) {
        super(skinParam);
        Colors specBack = null;
        if (skinParam instanceof SkinParamColors) {
            specBack = ((SkinParamColors)skinParam).getColors();
        }
        this.style = style = style.eventuallyOverride(specBack);
        this.boxStyle = boxStyle;
        this.swimlane = swimlane;
        this.inRendering = LinkRendering.create(Rainbow.build(styleArrow, this.getIHtmlColorSet()));
        this.borderColor = style.value(PName.LineColor).asColor(this.getIHtmlColorSet());
        this.backColor = style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
        FontConfiguration fc = style.getFontConfiguration(this.getIHtmlColorSet());
        this.horizontalAlignment = style.getHorizontalAlignment();
        this.roundCorner = style.value(PName.RoundCorner).asDouble();
        this.shadowing = style.getShadowing();
        LineBreakStrategy wrapWidth = style.wrapWidth();
        this.minimumWidth = style.value(PName.MinimumWidth).asDouble();
        Sheet sheet = skinParam.sheet(fc, this.horizontalAlignment, CreoleMode.FULL).createSheet(label);
        this.tb = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, style), new MyStencil(), UStroke.withThickness(1.0));
        this.print = label.toString();
    }

    public String toString() {
        return this.print;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        UStroke thickness = this.style.getStroke();
        ug = this.borderColor == null ? ug.apply(HColors.none()) : ug.apply(this.borderColor);
        ug = this.backColor == null ? ug.apply(HColors.none().bg()) : ug.apply(this.backColor.bg());
        ug = ug.apply(thickness);
        this.boxStyle.drawMe(ug, widthTotal, heightTotal, this.shadowing, this.roundCorner);
        if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
            this.tb.drawU(ug);
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            this.tb.drawU(ug.apply(new UTranslate(dimTotal.getWidth() - this.tbWidth(stringBounder), 0.0)));
        } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
            this.tb.drawU(ug.apply(new UTranslate((dimTotal.getWidth() - this.tbWidth(stringBounder)) / 2.0, 0.0)));
        }
    }

    private double tbWidth(StringBounder stringBounder) {
        return Math.max(this.minimumWidth, this.tb.calculateDimension(stringBounder).getWidth());
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        XDimension2D dimRaw = this.tb.calculateDimension(stringBounder);
        dimRaw = dimRaw.atLeast(this.minimumWidth, 0.0);
        return new FtileGeometry(dimRaw.getWidth() + this.boxStyle.getShield(), dimRaw.getHeight(), dimRaw.getWidth() / 2.0, 0.0, dimRaw.getHeight());
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    class MyStencil
    implements Stencil {
        MyStencil() {
        }

        @Override
        public double getStartingX(StringBounder stringBounder, double y) {
            return 0.0;
        }

        @Override
        public double getEndingX(StringBounder stringBounder, double y) {
            FtileGeometry dim = FtileBoxOld.this.calculateDimension(stringBounder);
            return dim.getWidth();
        }
    }
}

