/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.utils.PatchUtils;

public class FtileCircleEndCross
extends AbstractFtile {
    private static final int SIZE = 20;
    private final HColor lineColor;
    private final HColor backColor;
    private final Swimlane swimlane;
    private final Style style;
    private double shadowing;

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    public FtileCircleEndCross(ISkinParam skinParam, Swimlane swimlane, Style style, Colors colors) {
        super(skinParam);
        this.swimlane = swimlane;
        this.style = style;
        this.shadowing = style.getShadowing();
        this.backColor = colors.getColor(style, PName.BackGroundColor, skinParam.getIHtmlColorSet());
        this.lineColor = colors.getColor(style, PName.LineColor, skinParam.getIHtmlColorSet());
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return PatchUtils.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        double xTheoricalPosition = 0.0;
        double yTheoricalPosition = 0.0;
        xTheoricalPosition = Math.round(xTheoricalPosition);
        yTheoricalPosition = Math.round(yTheoricalPosition);
        UEllipse circle = UEllipse.build(20.0, 20.0);
        circle.setDeltaShadow(this.shadowing);
        ug = ug.apply(this.lineColor).apply(HColors.transparent().bg());
        ug.apply(this.style.getStroke()).apply(new UTranslate(xTheoricalPosition, yTheoricalPosition)).draw(circle);
        ug = ug.apply(this.backColor.bg());
        double thickness = 2.5;
        double size2 = 17.5 / Math.sqrt(2.0);
        double delta = (20.0 - size2) / 2.0;
        ug = ug.apply(UStroke.withThickness(2.5));
        ug.apply(new UTranslate(delta, delta)).draw(new ULine(size2, size2));
        ug.apply(new UTranslate(delta, 20.0 - delta)).draw(new ULine(size2, -size2));
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        return new FtileGeometry(20.0, 20.0, 10.0, 0.0);
    }
}

